/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.Message;
import net.minecraft.server.jsonrpc.methods.PlayerService;
import net.minecraft.server.level.ServerPlayer;

public class ServerStateService {
    public static ServerState status(MinecraftApi api) {
        return !api.serverStateService().isReady() ? ServerState.NOT_STARTED : new ServerState(true, PlayerService.get(api), ServerStatus.Version.current());
    }

    public static boolean save(MinecraftApi api, boolean flush, ClientInfo client) {
        return api.serverStateService().saveEverything(true, flush, true, client);
    }

    public static boolean stop(MinecraftApi api, ClientInfo client) {
        api.submit(() -> api.serverStateService().halt(false, client));
        return true;
    }

    public static boolean systemMessage(MinecraftApi api, SystemMessage message, ClientInfo client) {
        Component component = message.message().asComponent().orElse(null);
        if (component == null) {
            return false;
        }
        if (message.receivingPlayers().isPresent()) {
            if (message.receivingPlayers().get().isEmpty()) {
                return false;
            }
            for (PlayerDto playerDto : message.receivingPlayers().get()) {
                ServerPlayer player;
                if (playerDto.id().isPresent()) {
                    player = api.playerListService().getPlayer(playerDto.id().get());
                } else {
                    if (!playerDto.name().isPresent()) continue;
                    player = api.playerListService().getPlayerByName(playerDto.name().get());
                }
                if (player == null) continue;
                player.sendSystemMessage(component, message.overlay());
            }
        } else {
            api.serverStateService().broadcastSystemMessage(component, message.overlay(), client);
        }
        return true;
    }

    public record ServerState(boolean started, List<PlayerDto> players, ServerStatus.Version version) {
        public static final Codec<ServerState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("started").forGetter(ServerState::started), (App)PlayerDto.CODEC.codec().listOf().lenientOptionalFieldOf("players", List.of()).forGetter(ServerState::players), (App)ServerStatus.Version.CODEC.fieldOf("version").forGetter(ServerState::version)).apply((Applicative)instance, ServerState::new));
        public static final ServerState NOT_STARTED = new ServerState(false, List.of(), ServerStatus.Version.current());
    }

    public record SystemMessage(Message message, boolean overlay, Optional<List<PlayerDto>> receivingPlayers) {
        public static final Codec<SystemMessage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Message.CODEC.fieldOf("message").forGetter(SystemMessage::message), (App)Codec.BOOL.fieldOf("overlay").forGetter(SystemMessage::overlay), (App)PlayerDto.CODEC.codec().listOf().lenientOptionalFieldOf("receivingPlayers").forGetter(SystemMessage::receivingPlayers)).apply((Applicative)instance, SystemMessage::new));
    }
}

