/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network.config;

import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.MoonriseChunkLoadCounter;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.papermc.paper.connection.PaperConfigurationTask;
import io.papermc.paper.connection.PlayerConfigurationConnection;
import io.papermc.paper.event.player.AsyncPlayerSpawnLocationEvent;
import io.papermc.paper.math.Position;
import io.papermc.paper.util.MCUtil;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLoadCounter;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public class PrepareSpawnTask
implements ConfigurationTask {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type("prepare_spawn");
    public static final int PREPARE_CHUNK_RADIUS = 3;
    final MinecraftServer server;
    final NameAndId nameAndId;
    final LevelLoadListener loadListener;
    @Nullable
    private State state;
    private final GameProfile profile;
    private final ServerConfigurationPacketListenerImpl listener;
    private boolean newPlayer;

    public PrepareSpawnTask(MinecraftServer server, GameProfile profile, ServerConfigurationPacketListenerImpl listener) {
        this.profile = profile;
        this.listener = listener;
        this.server = server;
        this.nameAndId = new NameAndId(profile);
        this.loadListener = LevelLoadListener.noop();
    }

    @Override
    public void start(Consumer<Packet<?>> task) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(LOGGER);){
            ServerLevel serverLevel1;
            ServerLevel vanillaDefaultLevel;
            ResourceKey<Level> resourceKey;
            Optional<ValueInput> optional;
            block16: {
                World bWorld;
                block18: {
                    Optional<String> worldName;
                    block17: {
                        optional = this.server.getPlayerList().loadPlayerData(this.nameAndId).map(compoundTag -> TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)this.server.registryAccess(), compoundTag));
                        this.newPlayer = optional.isEmpty();
                        resourceKey = null;
                        boolean[] invalidPlayerWorld = new boolean[]{false};
                        if (!optional.isPresent()) break block16;
                        ValueInput playerData = optional.get();
                        Optional<Long> worldUUIDMost = playerData.getLong("WorldUUIDMost");
                        Optional<Long> worldUUIDLeast = playerData.getLong("WorldUUIDLeast");
                        worldName = playerData.getString("world");
                        if (!worldUUIDMost.isPresent() || !worldUUIDLeast.isPresent()) break block17;
                        bWorld = Bukkit.getServer().getWorld(new UUID(worldUUIDMost.get(), worldUUIDLeast.get()));
                        break block18;
                    }
                    if (!worldName.isPresent()) break block16;
                    bWorld = Bukkit.getServer().getWorld(worldName.get());
                }
                if (bWorld != null) {
                    resourceKey = ((CraftWorld)bWorld).getHandle().dimension();
                } else {
                    resourceKey = Level.OVERWORLD;
                    invalidPlayerWorld[0] = true;
                }
            }
            ServerPlayer.SavedPosition savedPosition = optional.flatMap(valueInput -> valueInput.read(ServerPlayer.SavedPosition.MAP_CODEC)).orElse(ServerPlayer.SavedPosition.EMPTY);
            LevelData.RespawnData respawnData = this.server.getWorldData().overworldData().getRespawnData();
            if (resourceKey == null) {
                resourceKey = savedPosition.dimension().orElse(null);
            }
            if ((vanillaDefaultLevel = this.server.getLevel(respawnData.dimension())) == null) {
                vanillaDefaultLevel = this.server.overworld();
            }
            if (resourceKey == null) {
                serverLevel1 = vanillaDefaultLevel;
            } else {
                serverLevel1 = this.server.getLevel(resourceKey);
                if (serverLevel1 == null) {
                    LOGGER.warn("Unknown respawn dimension {}, defaulting to overworld", resourceKey);
                    serverLevel1 = vanillaDefaultLevel;
                }
            }
            ServerLevel serverLevel = serverLevel1;
            CompletableFuture completableFuture = savedPosition.position().map(CompletableFuture::completedFuture).orElseGet(() -> PlayerSpawnFinder.findSpawn(serverLevel, respawnData.pos()));
            Vec2 vec2 = savedPosition.rotation().orElse(new Vec2(respawnData.yaw(), respawnData.pitch()));
            this.state = new Preparing(serverLevel, completableFuture, vec2);
        }
    }

    @Override
    public boolean tick() {
        State state = this.state;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Preparing.class, Ready.class}, (Object)state, n)) {
            case -1 -> false;
            case 0 -> {
                Preparing preparing = (Preparing)state;
                Ready ready = preparing.tick();
                if (ready != null) {
                    this.state = ready;
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                Ready ready = (Ready)state;
                yield true;
            }
            default -> throw new MatchException(null, null);
        };
    }

    public ServerPlayer spawnPlayer(Connection connection, CommonListenerCookie cookie) {
        State state = this.state;
        if (state instanceof Ready) {
            Ready ready = (Ready)state;
            return ready.spawn(connection, cookie);
        }
        throw new IllegalStateException("Player spawn was not ready");
    }

    public void keepAlive() {
        State state = this.state;
        if (state instanceof Ready) {
            Ready ready = (Ready)state;
            ready.keepAlive();
        }
    }

    public void close() {
        State state = this.state;
        if (state instanceof Preparing) {
            Preparing preparing = (Preparing)state;
            preparing.cancel();
        }
        this.state = null;
    }

    @Override
    public ConfigurationTask.Type type() {
        return TYPE;
    }

    final class Preparing
    implements State {
        private ServerLevel spawnLevel;
        private CompletableFuture<Vec3> spawnPosition;
        private Vec2 spawnAngle;
        @Nullable
        private CompletableFuture<?> chunkLoadFuture;
        @Nullable
        private CompletableFuture<Location> eventFuture;
        private final ChunkLoadCounter chunkLoadCounter = new MoonriseChunkLoadCounter();

        Preparing(ServerLevel spawnLevel, CompletableFuture<Vec3> spawnPosition, Vec2 spawnAngle) {
            this.spawnLevel = spawnLevel;
            this.spawnPosition = spawnPosition;
            this.spawnAngle = spawnAngle;
        }

        public void cancel() {
            this.spawnPosition.cancel(false);
        }

        @Nullable
        public Ready tick() {
            if (!this.spawnPosition.isDone()) {
                return null;
            }
            Vec3 vec3 = this.spawnPosition.join();
            if (this.chunkLoadFuture == null) {
                if (this.eventFuture == null && PlayerSpawnLocationEvent.getHandlerList().getRegisteredListeners().length != 0) {
                    ServerPlayer serverPlayer;
                    if (PrepareSpawnTask.this.listener.connection.savedPlayerForLegacyEvents != null) {
                        serverPlayer = PrepareSpawnTask.this.listener.connection.savedPlayerForLegacyEvents;
                    } else {
                        PrepareSpawnTask.this.listener.connection.savedPlayerForLegacyEvents = serverPlayer = new ServerPlayer(PrepareSpawnTask.this.server, PrepareSpawnTask.this.server.overworld(), PrepareSpawnTask.this.profile, ClientInformation.createDefault());
                    }
                    PlayerSpawnLocationEvent ev = new PlayerSpawnLocationEvent((Player)serverPlayer.getBukkitEntity(), CraftLocation.toBukkit(vec3, (Level)this.spawnLevel, this.spawnAngle.x, this.spawnAngle.y));
                    ev.callEvent();
                    vec3 = MCUtil.toVec3((Position)ev.getSpawnLocation());
                    this.spawnLevel = ((CraftWorld)ev.getSpawnLocation().getWorld()).getHandle();
                    this.spawnPosition = CompletableFuture.completedFuture(vec3);
                    this.spawnAngle = new Vec2(ev.getSpawnLocation().getYaw(), ev.getSpawnLocation().getPitch());
                }
                if (this.eventFuture == null && AsyncPlayerSpawnLocationEvent.getHandlerList().getRegisteredListeners().length != 0) {
                    Vec3 vec3final = vec3;
                    this.eventFuture = CompletableFuture.supplyAsync(() -> {
                        AsyncPlayerSpawnLocationEvent ev = new AsyncPlayerSpawnLocationEvent((PlayerConfigurationConnection)PrepareSpawnTask.this.listener.paperConnection, CraftLocation.toBukkit(vec3final, (Level)this.spawnLevel, this.spawnAngle.x, this.spawnAngle.y), PrepareSpawnTask.this.newPlayer);
                        ev.callEvent();
                        return ev.getSpawnLocation();
                    }, PaperConfigurationTask.CONFIGURATION_POOL);
                }
                if (this.eventFuture != null) {
                    if (!this.eventFuture.isDone()) {
                        return null;
                    }
                    Location location = this.eventFuture.join();
                    vec3 = MCUtil.toVec3((Position)location);
                    this.spawnLevel = ((CraftWorld)location.getWorld()).getHandle();
                    this.spawnPosition = CompletableFuture.completedFuture(vec3);
                    this.spawnAngle = new Vec2(location.getYaw(), location.getPitch());
                }
                ChunkPos chunkPos = new ChunkPos(BlockPos.containing(vec3));
                this.chunkLoadFuture = ((MoonriseChunkLoadCounter)this.chunkLoadCounter).trackLoadWithRadius(this.spawnLevel, chunkPos, 3, ChunkStatus.FULL, Priority.HIGH, () -> this.spawnLevel.getChunkSource().addTicketWithRadius(TicketType.PLAYER_SPAWN, chunkPos, 3));
                PrepareSpawnTask.this.loadListener.start(LevelLoadListener.Stage.LOAD_PLAYER_CHUNKS, this.chunkLoadCounter.totalChunks());
                PrepareSpawnTask.this.loadListener.updateFocus(this.spawnLevel.dimension(), chunkPos);
            }
            PrepareSpawnTask.this.loadListener.update(LevelLoadListener.Stage.LOAD_PLAYER_CHUNKS, this.chunkLoadCounter.readyChunks(), this.chunkLoadCounter.totalChunks());
            if (!this.chunkLoadFuture.isDone()) {
                return null;
            }
            PrepareSpawnTask.this.loadListener.finish(LevelLoadListener.Stage.LOAD_PLAYER_CHUNKS);
            PrepareSpawnTask prepareSpawnTask = PrepareSpawnTask.this;
            Objects.requireNonNull(prepareSpawnTask);
            return prepareSpawnTask.new Ready(this.spawnLevel, vec3, this.spawnAngle);
        }
    }

    static sealed interface State
    permits Preparing, Ready {
    }

    final class Ready
    implements State {
        private final ServerLevel spawnLevel;
        private final Vec3 spawnPosition;
        private final Vec2 spawnAngle;

        Ready(ServerLevel spawnLevel, Vec3 spawnPosition, Vec2 spawnAngle) {
            this.spawnLevel = spawnLevel;
            this.spawnPosition = spawnPosition;
            this.spawnAngle = spawnAngle;
        }

        public void keepAlive() {
            this.spawnLevel.getChunkSource().addTicketWithRadius(TicketType.PLAYER_SPAWN, new ChunkPos(BlockPos.containing(this.spawnPosition)), 3);
        }

        public ServerPlayer spawn(Connection connection, CommonListenerCookie cookie) {
            ServerPlayer var7;
            ServerPlayer serverPlayer;
            ChunkPos chunkPos = new ChunkPos(BlockPos.containing(this.spawnPosition));
            this.spawnLevel.waitForEntities(chunkPos, 3);
            if (connection.savedPlayerForLegacyEvents != null) {
                serverPlayer = connection.savedPlayerForLegacyEvents;
                connection.savedPlayerForLegacyEvents = null;
                serverPlayer.gameProfile = cookie.gameProfile();
                serverPlayer.updateOptionsNoEvents(cookie.clientInformation());
                serverPlayer.setServerLevel(this.spawnLevel);
            } else {
                serverPlayer = new ServerPlayer(PrepareSpawnTask.this.server, this.spawnLevel, cookie.gameProfile(), cookie.clientInformation());
            }
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(serverPlayer.problemPath(), LOGGER);){
                Optional<ValueInput> optional = PrepareSpawnTask.this.server.getPlayerList().loadPlayerData(PrepareSpawnTask.this.nameAndId).map(tag -> {
                    CraftPlayer craftPlayer = serverPlayer.getBukkitEntity();
                    long modified = new File(PrepareSpawnTask.this.server.playerDataStorage.getPlayerDir(), serverPlayer.getStringUUID() + ".dat").lastModified();
                    if (modified < craftPlayer.getFirstPlayed()) {
                        craftPlayer.setFirstPlayed(modified);
                    }
                    return tag;
                }).map(compoundTag -> TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)PrepareSpawnTask.this.server.registryAccess(), compoundTag));
                optional.ifPresent(serverPlayer::load);
                if (optional.isPresent()) {
                    serverPlayer.lastKnownName = optional.flatMap(t -> t.child("bukkit")).flatMap(t -> t.getString("lastKnownName")).orElse(null);
                }
                if (optional.isEmpty()) {
                    serverPlayer.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
                }
                serverPlayer.snapTo(this.spawnPosition, this.spawnAngle.x, this.spawnAngle.y);
                PrepareSpawnTask.this.server.getPlayerList().placeNewPlayer(connection, serverPlayer, cookie);
                optional.ifPresent(valueInput -> {
                    serverPlayer.loadAndSpawnEnderPearls((ValueInput)valueInput);
                    serverPlayer.loadAndSpawnParentVehicle((ValueInput)valueInput);
                });
                var7 = serverPlayer;
            }
            return var7;
        }
    }
}

