/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.function.UnaryOperator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    public static final StreamCodec<FriendlyByteBuf, RecipeBookSettings> STREAM_CODEC = StreamCodec.composite(TypeSettings.STREAM_CODEC, settings -> settings.crafting, TypeSettings.STREAM_CODEC, settings -> settings.furnace, TypeSettings.STREAM_CODEC, settings -> settings.blastFurnace, TypeSettings.STREAM_CODEC, settings -> settings.smoker, RecipeBookSettings::new);
    public static final MapCodec<RecipeBookSettings> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TypeSettings.CRAFTING_MAP_CODEC.forGetter(settings -> settings.crafting), (App)TypeSettings.FURNACE_MAP_CODEC.forGetter(settings -> settings.furnace), (App)TypeSettings.BLAST_FURNACE_MAP_CODEC.forGetter(settings -> settings.blastFurnace), (App)TypeSettings.SMOKER_MAP_CODEC.forGetter(settings -> settings.smoker)).apply((Applicative)instance, RecipeBookSettings::new));
    private TypeSettings crafting;
    private TypeSettings furnace;
    private TypeSettings blastFurnace;
    private TypeSettings smoker;

    public RecipeBookSettings() {
        this(TypeSettings.DEFAULT, TypeSettings.DEFAULT, TypeSettings.DEFAULT, TypeSettings.DEFAULT);
    }

    private RecipeBookSettings(TypeSettings crafting, TypeSettings furnace, TypeSettings blastFurnace, TypeSettings smoker) {
        this.crafting = crafting;
        this.furnace = furnace;
        this.blastFurnace = blastFurnace;
        this.smoker = smoker;
    }

    @VisibleForTesting
    public TypeSettings getSettings(RecipeBookType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case RecipeBookType.CRAFTING -> this.crafting;
            case RecipeBookType.FURNACE -> this.furnace;
            case RecipeBookType.BLAST_FURNACE -> this.blastFurnace;
            case RecipeBookType.SMOKER -> this.smoker;
        };
    }

    private void updateSettings(RecipeBookType type, UnaryOperator<TypeSettings> updater) {
        switch (type) {
            case CRAFTING: {
                this.crafting = (TypeSettings)updater.apply(this.crafting);
                break;
            }
            case FURNACE: {
                this.furnace = (TypeSettings)updater.apply(this.furnace);
                break;
            }
            case BLAST_FURNACE: {
                this.blastFurnace = (TypeSettings)updater.apply(this.blastFurnace);
                break;
            }
            case SMOKER: {
                this.smoker = (TypeSettings)updater.apply(this.smoker);
            }
        }
    }

    public boolean isOpen(RecipeBookType bookType) {
        return this.getSettings((RecipeBookType)bookType).open;
    }

    public void setOpen(RecipeBookType bookType, boolean _open) {
        this.updateSettings(bookType, settings -> settings.setOpen(_open));
    }

    public boolean isFiltering(RecipeBookType bookType) {
        return this.getSettings((RecipeBookType)bookType).filtering;
    }

    public void setFiltering(RecipeBookType bookType, boolean filtering) {
        this.updateSettings(bookType, settings -> settings.setFiltering(filtering));
    }

    public RecipeBookSettings copy() {
        return new RecipeBookSettings(this.crafting, this.furnace, this.blastFurnace, this.smoker);
    }

    public void replaceFrom(RecipeBookSettings other) {
        this.crafting = other.crafting;
        this.furnace = other.furnace;
        this.blastFurnace = other.blastFurnace;
        this.smoker = other.smoker;
    }

    public record TypeSettings(boolean open, boolean filtering) {
        public static final TypeSettings DEFAULT = new TypeSettings(false, false);
        public static final MapCodec<TypeSettings> CRAFTING_MAP_CODEC = TypeSettings.codec("isGuiOpen", "isFilteringCraftable");
        public static final MapCodec<TypeSettings> FURNACE_MAP_CODEC = TypeSettings.codec("isFurnaceGuiOpen", "isFurnaceFilteringCraftable");
        public static final MapCodec<TypeSettings> BLAST_FURNACE_MAP_CODEC = TypeSettings.codec("isBlastingFurnaceGuiOpen", "isBlastingFurnaceFilteringCraftable");
        public static final MapCodec<TypeSettings> SMOKER_MAP_CODEC = TypeSettings.codec("isSmokerGuiOpen", "isSmokerFilteringCraftable");
        public static final StreamCodec<ByteBuf, TypeSettings> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.BOOL, TypeSettings::open, ByteBufCodecs.BOOL, TypeSettings::filtering, TypeSettings::new);

        @Override
        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }

        public TypeSettings setOpen(boolean _open) {
            return new TypeSettings(_open, this.filtering);
        }

        public TypeSettings setFiltering(boolean filtering) {
            return new TypeSettings(this.open, filtering);
        }

        private static MapCodec<TypeSettings> codec(String openKey, String filteringKey) {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf(openKey, (Object)false).forGetter(TypeSettings::open), (App)Codec.BOOL.optionalFieldOf(filteringKey, (Object)false).forGetter(TypeSettings::filtering)).apply((Applicative)instance, TypeSettings::new));
        }
    }
}

