/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatsCounter
extends StatsCounter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Map<Stat<?>, Integer>> STATS_CODEC = Codec.dispatchedMap(BuiltInRegistries.STAT_TYPE.byNameCodec(), Util.memoize(ServerStatsCounter::createTypedStatsCodec)).xmap(map -> {
        HashMap map1 = new HashMap();
        map.forEach((statType, map2) -> map1.putAll(map2));
        return map1;
    }, map -> map.entrySet().stream().collect(Collectors.groupingBy(entry -> ((Stat)entry.getKey()).getType(), Util.toMap())));
    private final MinecraftServer server;
    private final File file;
    private final Set<Stat<?>> dirty = Sets.newHashSet();

    private static <T> Codec<Map<Stat<?>, Integer>> createTypedStatsCodec(StatType<T> type) {
        Codec<T> codec = type.getRegistry().byNameCodec();
        Codec codec1 = codec.flatComapMap(type::get, stat -> stat.getType() == type ? DataResult.success(stat.getValue()) : DataResult.error(() -> "Expected type " + String.valueOf(type) + ", but got " + String.valueOf(stat.getType())));
        return Codec.unboundedMap((Codec)codec1, (Codec)Codec.INT);
    }

    public ServerStatsCounter(MinecraftServer server, File file) {
        this.server = server;
        this.file = file;
        if (file.isFile()) {
            try {
                this.parseLocal(server.getFixerUpper(), FileUtils.readFileToString((File)file));
            }
            catch (IOException var4) {
                LOGGER.error("Couldn't read statistics file {}", (Object)file, (Object)var4);
            }
            catch (JsonParseException var5) {
                LOGGER.error("Couldn't parse statistics file {}", (Object)file, (Object)var5);
            }
        }
        for (Map.Entry<ResourceLocation, Integer> entry : SpigotConfig.forcedStats.entrySet()) {
            Stat<ResourceLocation> wrapper = Stats.CUSTOM.get(Objects.requireNonNull(BuiltInRegistries.CUSTOM_STAT.getValue(entry.getKey())));
            this.stats.put(wrapper, entry.getValue().intValue());
        }
    }

    public void save() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtils.writeStringToFile((File)this.file, (String)this.toJson());
        }
        catch (IOException var2) {
            LOGGER.error("Couldn't save stats", (Throwable)var2);
        }
    }

    @Override
    public void setValue(Player player, Stat<?> stat, int value) {
        ResourceLocation key;
        Object obj;
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        if (stat.getType() == Stats.CUSTOM && (obj = stat.getValue()) instanceof ResourceLocation && SpigotConfig.forcedStats.get(key = (ResourceLocation)obj) != null) {
            return;
        }
        super.setValue(player, stat, value);
        this.dirty.add(stat);
    }

    private Set<Stat<?>> getDirty() {
        HashSet set = Sets.newHashSet(this.dirty);
        this.dirty.clear();
        return set;
    }

    public void parseLocal(DataFixer fixerUpper, String json) {
        try {
            JsonElement jsonElement = StrictJsonParser.parse(json);
            if (jsonElement.isJsonNull()) {
                LOGGER.error("Unable to parse Stat data from {}", (Object)this.file);
                return;
            }
            Dynamic<JsonElement> dynamic = new Dynamic<JsonElement>((DynamicOps<JsonElement>)JsonOps.INSTANCE, jsonElement);
            dynamic = DataFixTypes.STATS.updateToCurrentVersion(fixerUpper, dynamic, NbtUtils.getDataVersion(dynamic, 1343));
            this.stats.putAll(STATS_CODEC.parse(dynamic.get("stats").orElseEmptyMap()).resultOrPartial(string -> LOGGER.error("Failed to parse statistics for {}: {}", (Object)this.file, string)).orElse(Map.of()));
        }
        catch (JsonParseException var5) {
            LOGGER.error("Unable to parse Stat data from {}", (Object)this.file, (Object)var5);
        }
    }

    protected String toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("stats", (JsonElement)STATS_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.stats).getOrThrow());
        jsonObject.addProperty("DataVersion", (Number)SharedConstants.getCurrentVersion().dataVersion().version());
        return jsonObject.toString();
    }

    public void markAllDirty() {
        this.dirty.addAll((Collection<Stat<?>>)this.stats.keySet());
    }

    public void sendStats(ServerPlayer player) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (Stat<?> stat : this.getDirty()) {
            map.put(stat, this.getValue(stat));
        }
        player.connection.send(new ClientboundAwardStatsPacket((Object2IntMap<Stat<?>>)map));
    }
}

