/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.function.Function;

public interface BoundedFloatFunction<C> {
    public static final BoundedFloatFunction<Float> IDENTITY = BoundedFloatFunction.createUnlimited(f -> f);

    public float apply(C var1);

    public float minValue();

    public float maxValue();

    public static BoundedFloatFunction<Float> createUnlimited(final Float2FloatFunction operation) {
        return new BoundedFloatFunction<Float>(){

            @Override
            public float apply(Float value) {
                return ((Float)operation.apply((Object)value)).floatValue();
            }

            @Override
            public float minValue() {
                return Float.NEGATIVE_INFINITY;
            }

            @Override
            public float maxValue() {
                return Float.POSITIVE_INFINITY;
            }
        };
    }

    default public <C2> BoundedFloatFunction<C2> comap(final Function<C2, C> mapper) {
        final BoundedFloatFunction boundedFloatFunction = this;
        return new BoundedFloatFunction<C2>(){

            @Override
            public float apply(C2 value) {
                return boundedFloatFunction.apply(mapper.apply(value));
            }

            @Override
            public float minValue() {
                return boundedFloatFunction.minValue();
            }

            @Override
            public float maxValue() {
                return boundedFloatFunction.maxValue();
            }
        };
    }
}

