/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.fixes.DataComponentRemainderFix;

public class LockComponentPredicateFix
extends DataComponentRemainderFix {
    public static final Escaper ESCAPER = Escapers.builder().addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();

    public LockComponentPredicateFix(Schema outputSchema) {
        super(outputSchema, "LockComponentPredicateFix", "minecraft:lock");
    }

    @Override
    @Nullable
    protected <T> Dynamic<T> fixComponent(Dynamic<T> component) {
        return LockComponentPredicateFix.fixLock(component);
    }

    @Nullable
    public static <T> Dynamic<T> fixLock(Dynamic<T> tag) {
        Optional optional = tag.asString().result();
        if (optional.isEmpty()) {
            return null;
        }
        if (((String)optional.get()).isEmpty()) {
            return null;
        }
        Dynamic dynamic = tag.createString("\"" + ESCAPER.escape((String)optional.get()) + "\"");
        Dynamic dynamic1 = tag.emptyMap().set("minecraft:custom_name", dynamic);
        return tag.emptyMap().set("components", dynamic1);
    }
}

