/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.util.parsing.packrat.ErrorEntry;
import net.minecraft.util.parsing.packrat.SuggestionSupplier;

public interface ErrorCollector<S> {
    public void store(int var1, SuggestionSupplier<S> var2, Object var3);

    default public void store(int cursor, Object reason) {
        this.store(cursor, SuggestionSupplier.empty(), reason);
    }

    public void finish(int var1);

    public static class Nop<S>
    implements ErrorCollector<S> {
        @Override
        public void store(int cursor, SuggestionSupplier<S> suggestions, Object reason) {
        }

        @Override
        public void finish(int cursor) {
        }
    }

    public static class LongestOnly<S>
    implements ErrorCollector<S> {
        private MutableErrorEntry<S>[] entries = new MutableErrorEntry[16];
        private int nextErrorEntry;
        private int lastCursor = -1;

        private void discardErrorsFromShorterParse(int cursor) {
            if (cursor > this.lastCursor) {
                this.lastCursor = cursor;
                this.nextErrorEntry = 0;
            }
        }

        @Override
        public void finish(int cursor) {
            this.discardErrorsFromShorterParse(cursor);
        }

        @Override
        public void store(int cursor, SuggestionSupplier<S> suggestions, Object reason) {
            this.discardErrorsFromShorterParse(cursor);
            if (cursor == this.lastCursor) {
                this.addErrorEntry(suggestions, reason);
            }
        }

        private void addErrorEntry(SuggestionSupplier<S> suggestions, Object reason) {
            MutableErrorEntry<S> mutableErrorEntry;
            int i1;
            int i = this.entries.length;
            if (this.nextErrorEntry >= i) {
                i1 = Util.growByHalf(i, this.nextErrorEntry + 1);
                MutableErrorEntry[] mutableErrorEntrys = new MutableErrorEntry[i1];
                System.arraycopy(this.entries, 0, mutableErrorEntrys, 0, i);
                this.entries = mutableErrorEntrys;
            }
            if ((mutableErrorEntry = this.entries[i1 = this.nextErrorEntry++]) == null) {
                this.entries[i1] = mutableErrorEntry = new MutableErrorEntry();
            }
            mutableErrorEntry.suggestions = suggestions;
            mutableErrorEntry.reason = reason;
        }

        public List<ErrorEntry<S>> entries() {
            int i = this.nextErrorEntry;
            if (i == 0) {
                return List.of();
            }
            ArrayList<ErrorEntry<S>> list = new ArrayList<ErrorEntry<S>>(i);
            for (int i1 = 0; i1 < i; ++i1) {
                MutableErrorEntry<S> mutableErrorEntry = this.entries[i1];
                list.add(new ErrorEntry(this.lastCursor, mutableErrorEntry.suggestions, mutableErrorEntry.reason));
            }
            return list;
        }

        public int cursor() {
            return this.lastCursor;
        }

        static class MutableErrorEntry<S> {
            SuggestionSupplier<S> suggestions = SuggestionSupplier.empty();
            Object reason = "empty";

            MutableErrorEntry() {
            }
        }
    }
}

