/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import javax.annotation.Nullable;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;

public interface Rule<S, T> {
    @Nullable
    public T parse(ParseState<S> var1);

    public static <S, T> Rule<S, T> fromTerm(Term<S> child, RuleAction<S, T> action) {
        return new WrappedTerm<S, T>(action, child);
    }

    public static <S, T> Rule<S, T> fromTerm(Term<S> child, SimpleRuleAction<S, T> action) {
        return new WrappedTerm<S, T>(action, child);
    }

    public record WrappedTerm<S, T>(RuleAction<S, T> action, Term<S> child) implements Rule<S, T>
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T parse(ParseState<S> parseState) {
            T var3;
            Scope scope = parseState.scope();
            scope.pushFrame();
            try {
                if (!this.child.parse(parseState, scope, Control.UNBOUND)) {
                    T t = null;
                    return t;
                }
                var3 = this.action.run(parseState);
            }
            finally {
                scope.popFrame();
            }
            return var3;
        }
    }

    @FunctionalInterface
    public static interface RuleAction<S, T> {
        @Nullable
        public T run(ParseState<S> var1);
    }

    @FunctionalInterface
    public static interface SimpleRuleAction<S, T>
    extends RuleAction<S, T> {
        public T run(Scope var1);

        @Override
        default public T run(ParseState<S> parseState) {
            return this.run(parseState.scope());
        }
    }
}

