/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;

public sealed interface InteractionResult {
    public static final Success SUCCESS = new Success(SwingSource.CLIENT, ItemContext.DEFAULT);
    public static final Success SUCCESS_SERVER = new Success(SwingSource.SERVER, ItemContext.DEFAULT);
    public static final Success CONSUME = new Success(SwingSource.NONE, ItemContext.DEFAULT);
    public static final Fail FAIL = new Fail();
    public static final Pass PASS = new Pass();
    public static final TryEmptyHandInteraction TRY_WITH_EMPTY_HAND = new TryEmptyHandInteraction();

    default public boolean consumesAction() {
        return false;
    }

    public record Success(SwingSource swingSource, ItemContext itemContext, PaperSuccessContext paperSuccessContext) implements InteractionResult
    {
        public Success(SwingSource swingSource, ItemContext itemContext) {
            this(swingSource, itemContext, PaperSuccessContext.DEFAULT);
        }

        public Success configurePaper(UnaryOperator<PaperSuccessContext> edit) {
            return new Success(this.swingSource, this.itemContext, (PaperSuccessContext)edit.apply(this.paperSuccessContext));
        }

        @Override
        public boolean consumesAction() {
            return true;
        }

        public Success heldItemTransformedTo(ItemStack stack) {
            return new Success(this.swingSource, new ItemContext(true, stack), this.paperSuccessContext);
        }

        public Success withoutItem() {
            return new Success(this.swingSource, ItemContext.NONE, this.paperSuccessContext);
        }

        public boolean wasItemInteraction() {
            return this.itemContext.wasItemInteraction;
        }

        @Nullable
        public ItemStack heldItemTransformedTo() {
            return this.itemContext.heldItemTransformedTo;
        }
    }

    public static enum SwingSource {
        NONE,
        CLIENT,
        SERVER;

    }

    public record ItemContext(boolean wasItemInteraction, @Nullable ItemStack heldItemTransformedTo) {
        static ItemContext NONE = new ItemContext(false, null);
        static ItemContext DEFAULT = new ItemContext(true, null);
    }

    public record Fail() implements InteractionResult
    {
    }

    public record Pass() implements InteractionResult
    {
    }

    public record TryEmptyHandInteraction() implements InteractionResult
    {
    }

    public record PaperSuccessContext(@Nullable BlockPos placedBlockPosition) {
        static PaperSuccessContext DEFAULT = new PaperSuccessContext(null);

        public PaperSuccessContext placedBlockAt(BlockPos blockPos) {
            return new PaperSuccessContext(blockPos);
        }
    }
}

