/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class CombatRules {
    public static final float MAX_ARMOR = 20.0f;
    public static final float ARMOR_PROTECTION_DIVIDER = 25.0f;
    public static final float BASE_ARMOR_TOUGHNESS = 2.0f;
    public static final float MIN_ARMOR_RATIO = 0.2f;
    private static final int NUM_ARMOR_ITEMS = 4;

    public static float getDamageAfterAbsorb(LivingEntity entity, float damageAmount, DamageSource damageSource, float armorValue, float armorToughness) {
        float f3;
        Level level;
        float f = 2.0f + armorToughness / 4.0f;
        float f1 = Mth.clamp(armorValue - damageAmount / f, armorValue * 0.2f, 20.0f);
        float f2 = f1 / 25.0f;
        ItemStack weaponItem = damageSource.getWeaponItem();
        if (weaponItem != null && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            f3 = Mth.clamp(EnchantmentHelper.modifyArmorEffectiveness(serverLevel, weaponItem, entity, damageSource, f2), 0.0f, 1.0f);
        } else {
            f3 = f2;
        }
        float f4 = 1.0f - f3;
        return damageAmount * f4;
    }

    public static float getDamageAfterMagicAbsorb(float damageAmount, float enchantModifiers) {
        float f = Mth.clamp(enchantModifiers, 0.0f, 20.0f);
        return damageAmount * (1.0f - f / 25.0f);
    }
}

