/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ElytraAnimationState {
    private static final float DEFAULT_X_ROT = 0.2617994f;
    private static final float DEFAULT_Z_ROT = -0.2617994f;
    private float rotX;
    private float rotY;
    private float rotZ;
    private float rotXOld;
    private float rotYOld;
    private float rotZOld;
    private final LivingEntity entity;

    public ElytraAnimationState(LivingEntity entity) {
        this.entity = entity;
    }

    public void tick() {
        float f3;
        float f2;
        float f1;
        this.rotXOld = this.rotX;
        this.rotYOld = this.rotY;
        this.rotZOld = this.rotZ;
        if (this.entity.isFallFlying()) {
            float f = 1.0f;
            Vec3 deltaMovement = this.entity.getDeltaMovement();
            if (deltaMovement.y < 0.0) {
                Vec3 vec3 = deltaMovement.normalize();
                f = 1.0f - (float)Math.pow(-vec3.y, 1.5);
            }
            f1 = Mth.lerp(f, 0.2617994f, 0.34906584f);
            f2 = Mth.lerp(f, -0.2617994f, -1.5707964f);
            f3 = 0.0f;
        } else if (this.entity.isCrouching()) {
            f1 = 0.6981317f;
            f2 = -0.7853982f;
            f3 = 0.08726646f;
        } else {
            f1 = 0.2617994f;
            f2 = -0.2617994f;
            f3 = 0.0f;
        }
        this.rotX += (f1 - this.rotX) * 0.3f;
        this.rotY += (f3 - this.rotY) * 0.3f;
        this.rotZ += (f2 - this.rotZ) * 0.3f;
    }

    public float getRotX(float partialTick) {
        return Mth.lerp(partialTick, this.rotXOld, this.rotX);
    }

    public float getRotY(float partialTick) {
        return Mth.lerp(partialTick, this.rotYOld, this.rotY);
    }

    public float getRotZ(float partialTick) {
        return Mth.lerp(partialTick, this.rotZOld, this.rotZ);
    }
}

