/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;

public class SetEntityLookTarget {
    public static BehaviorControl<LivingEntity> create(MobCategory category, float maxDist) {
        return SetEntityLookTarget.create((LivingEntity entity) -> category.equals(entity.getType().getCategory()), maxDist);
    }

    public static OneShot<LivingEntity> create(EntityType<?> entityType, float maxDist) {
        return SetEntityLookTarget.create((LivingEntity entity) -> entityType.equals(entity.getType()), maxDist);
    }

    public static OneShot<LivingEntity> create(float maxDist) {
        return SetEntityLookTarget.create((LivingEntity entity) -> true, maxDist);
    }

    public static OneShot<LivingEntity> create(Predicate<LivingEntity> canLootAtTarget, float maxDist) {
        float f = maxDist * maxDist;
        return BehaviorBuilder.create(instance -> instance.group(instance.absent(MemoryModuleType.LOOK_TARGET), instance.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)instance, (lookTarget, nearestVisibleLivingEntities) -> (level, entity, gameTime) -> {
            Optional<LivingEntity> optional = ((NearestVisibleLivingEntities)instance.get(nearestVisibleLivingEntities)).findClosest(canLootAtTarget.and(target -> target.distanceToSqr(entity) <= (double)f && !entity.hasPassenger((Entity)target)));
            if (optional.isEmpty()) {
                return false;
            }
            lookTarget.set(new EntityTracker(optional.get(), true));
            return true;
        }));
    }
}

