/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.apache.commons.lang3.mutable.MutableInt;

public class SetHiddenState {
    private static final int HIDE_TIMEOUT = 300;

    public static BehaviorControl<LivingEntity> create(int stayHiddenSeconds, int closeEnoughDist) {
        int i = stayHiddenSeconds * 20;
        MutableInt mutableInt = new MutableInt(0);
        return BehaviorBuilder.create(instance -> instance.group(instance.present(MemoryModuleType.HIDING_PLACE), instance.present(MemoryModuleType.HEARD_BELL_TIME)).apply((Applicative)instance, (hidingPlace, heardBellTime) -> (level, entity, gameTime) -> {
            boolean flag;
            long l = (Long)instance.get(heardBellTime);
            boolean bl = flag = l + 300L <= gameTime;
            if (mutableInt.getValue() <= i && !flag) {
                BlockPos blockPos = ((GlobalPos)instance.get(hidingPlace)).pos();
                if (blockPos.closerThan(entity.blockPosition(), closeEnoughDist)) {
                    mutableInt.increment();
                }
                return true;
            }
            heardBellTime.erase();
            hidingPlace.erase();
            entity.getBrain().updateActivityFromSchedule(level.getDayTime(), level.getGameTime());
            mutableInt.setValue(0);
            return true;
        }));
    }
}

