/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.Vec3;

public class SetWalkTargetFromBlockMemory {
    public static OneShot<Villager> create(MemoryModuleType<GlobalPos> blockTargetMemory, float speedModifier, int closeEnoughDist, int tooFarDistance, int tooLongUnreachableDuration) {
        return BehaviorBuilder.create(instance -> instance.group(instance.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE), instance.absent(MemoryModuleType.WALK_TARGET), instance.present(blockTargetMemory)).apply((Applicative)instance, (cantReachWalkTargetSince, walkTarget, blockTarget) -> (level, villager, gameTime) -> {
            GlobalPos globalPos = (GlobalPos)instance.get(blockTarget);
            Optional optional = instance.tryGet(cantReachWalkTargetSince);
            if (!(globalPos.dimension() != level.dimension() || optional.isPresent() && level.getGameTime() - (Long)optional.get() > (long)tooLongUnreachableDuration)) {
                if (globalPos.pos().distManhattan(villager.blockPosition()) > tooFarDistance) {
                    Vec3 vec3 = null;
                    int i = 0;
                    int i1 = 1000;
                    while (vec3 == null || BlockPos.containing(vec3).distManhattan(villager.blockPosition()) > tooFarDistance) {
                        vec3 = DefaultRandomPos.getPosTowards(villager, 15, 7, Vec3.atBottomCenterOf(globalPos.pos()), 1.5707963705062866);
                        if (++i != 1000) continue;
                        villager.releasePoi(blockTargetMemory);
                        blockTarget.erase();
                        cantReachWalkTargetSince.set(gameTime);
                        return true;
                    }
                    walkTarget.set(new WalkTarget(vec3, speedModifier, closeEnoughDist));
                } else if (globalPos.pos().distManhattan(villager.blockPosition()) > closeEnoughDist) {
                    walkTarget.set(new WalkTarget(globalPos.pos(), speedModifier, closeEnoughDist));
                }
            } else {
                villager.releasePoi(blockTargetMemory);
                blockTarget.erase();
                cantReachWalkTargetSince.set(gameTime);
            }
            return true;
        }));
    }
}

