/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.warden.Warden;
import org.bukkit.event.entity.EntityRemoveEvent;

public class Digging<E extends Warden>
extends Behavior<E> {
    public Digging(int duration) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), duration);
    }

    @Override
    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        return ((Entity)entity).getRemovalReason() == null;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        return ((Entity)owner).onGround() || ((Entity)owner).isInWater() || ((Entity)owner).isInLava();
    }

    @Override
    protected void start(ServerLevel level, E entity, long gameTime) {
        if (((Entity)entity).onGround()) {
            ((Entity)entity).setPose(Pose.DIGGING);
            ((Entity)entity).playSound(SoundEvents.WARDEN_DIG, 5.0f, 1.0f);
        } else {
            ((Entity)entity).playSound(SoundEvents.WARDEN_AGITATED, 5.0f, 1.0f);
            this.stop(level, entity, gameTime);
        }
    }

    @Override
    protected void stop(ServerLevel level, E entity, long gameTime) {
        if (((Entity)entity).getRemovalReason() == null) {
            ((LivingEntity)entity).remove(Entity.RemovalReason.DISCARDED, EntityRemoveEvent.Cause.DESPAWN);
        }
    }
}

