/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import ca.spottedleaf.moonrise.common.set.OptimizedSmallEnumSet;
import com.destroystokyo.paper.entity.ai.PaperGoal;
import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.bukkit.entity.Mob;

public abstract class Goal {
    private final OptimizedSmallEnumSet<Flag> goalTypes = new OptimizedSmallEnumSet<Flag>(Flag.class);
    private PaperGoal<?> paperGoal;

    protected Goal() {
        if (this.goalTypes.size() == 0) {
            this.goalTypes.addUnchecked(Flag.UNKNOWN_BEHAVIOR);
        }
    }

    public abstract boolean canUse();

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public boolean isInterruptable() {
        return true;
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean requiresUpdateEveryTick() {
        return false;
    }

    public void tick() {
    }

    public void setFlags(EnumSet<Flag> flagSet) {
        this.goalTypes.clear();
        this.goalTypes.addAllUnchecked(flagSet);
        if (this.goalTypes.size() == 0) {
            this.goalTypes.addUnchecked(Flag.UNKNOWN_BEHAVIOR);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public OptimizedSmallEnumSet<Flag> getFlags() {
        return this.goalTypes;
    }

    public boolean hasFlag(Flag flag) {
        return this.goalTypes.hasElement(flag);
    }

    public void addFlag(Flag flag) {
        this.goalTypes.addUnchecked(flag);
    }

    protected int adjustedTickDelay(int adjustment) {
        return this.requiresUpdateEveryTick() ? adjustment : Goal.reducedTickDelay(adjustment);
    }

    protected static int reducedTickDelay(int reduction) {
        return Mth.positiveCeilDiv(reduction, 2);
    }

    protected static ServerLevel getServerLevel(Entity entity) {
        return (ServerLevel)entity.level();
    }

    protected static ServerLevel getServerLevel(Level level) {
        return (ServerLevel)level;
    }

    public <T extends Mob> com.destroystokyo.paper.entity.ai.Goal<T> asPaperGoal() {
        if (this.paperGoal == null) {
            this.paperGoal = new PaperGoal(this);
        }
        return this.paperGoal;
    }

    public static enum Flag {
        UNKNOWN_BEHAVIOR,
        MOVE,
        LOOK,
        JUMP,
        TARGET;

    }
}

