/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class MobSensor<T extends LivingEntity>
extends Sensor<T> {
    private final BiPredicate<T, LivingEntity> mobTest;
    private final Predicate<T> readyTest;
    private final MemoryModuleType<Boolean> toSet;
    private final int memoryTimeToLive;

    public MobSensor(int scanRate, BiPredicate<T, LivingEntity> mobTest, Predicate<T> readyTest, MemoryModuleType<Boolean> toSet, int memoryTimeToLive) {
        super(scanRate);
        this.mobTest = mobTest;
        this.readyTest = readyTest;
        this.toSet = toSet;
        this.memoryTimeToLive = memoryTimeToLive;
    }

    @Override
    protected void doTick(ServerLevel level, T entity) {
        if (!this.readyTest.test(entity)) {
            this.clearMemory(entity);
        } else {
            this.checkForMobsNearby(entity);
        }
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return Set.of(MemoryModuleType.NEAREST_LIVING_ENTITIES);
    }

    public void checkForMobsNearby(T sensingEntity) {
        boolean flag;
        Optional<List<LivingEntity>> memory = ((LivingEntity)sensingEntity).getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES);
        if (!memory.isEmpty() && (flag = memory.get().stream().anyMatch(livingEntity -> this.mobTest.test((LivingEntity)sensingEntity, (LivingEntity)livingEntity)))) {
            this.mobDetected(sensingEntity);
        }
    }

    public void mobDetected(T sensingEntity) {
        ((LivingEntity)sensingEntity).getBrain().setMemoryWithExpiry(this.toSet, true, this.memoryTimeToLive);
    }

    public void clearMemory(T sensingEntity) {
        ((LivingEntity)sensingEntity).getBrain().eraseMemory(this.toSet);
    }
}

