/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.Vec3;

public class LandRandomPos {
    @Nullable
    public static Vec3 getPos(PathfinderMob mob, int radius, int verticalRange) {
        return LandRandomPos.getPos(mob, radius, verticalRange, mob::getWalkTargetValue);
    }

    @Nullable
    public static Vec3 getPos(PathfinderMob mob, int radius, int yRange, ToDoubleFunction<BlockPos> toDoubleFunction) {
        boolean flag = GoalUtils.mobRestricted(mob, radius);
        return RandomPos.generateRandomPos(() -> {
            BlockPos blockPos = RandomPos.generateRandomDirection(mob.getRandom(), radius, yRange);
            BlockPos blockPos1 = LandRandomPos.generateRandomPosTowardDirection(mob, radius, flag, blockPos);
            return blockPos1 == null ? null : LandRandomPos.movePosUpOutOfSolid(mob, blockPos1);
        }, toDoubleFunction);
    }

    @Nullable
    public static Vec3 getPosTowards(PathfinderMob mob, int radius, int yRange, Vec3 vectorPosition) {
        Vec3 vec3 = vectorPosition.subtract(mob.getX(), mob.getY(), mob.getZ());
        boolean flag = GoalUtils.mobRestricted(mob, radius);
        return LandRandomPos.getPosInDirection(mob, radius, yRange, vec3, flag);
    }

    @Nullable
    public static Vec3 getPosAway(PathfinderMob mob, int radius, int yRange, Vec3 vectorPosition) {
        Vec3 vec3 = mob.position().subtract(vectorPosition);
        boolean flag = GoalUtils.mobRestricted(mob, radius);
        return LandRandomPos.getPosInDirection(mob, radius, yRange, vec3, flag);
    }

    @Nullable
    private static Vec3 getPosInDirection(PathfinderMob mob, int radius, int yRange, Vec3 vectorPosition, boolean isRestricted) {
        return RandomPos.generateRandomPos(mob, () -> {
            BlockPos blockPos = RandomPos.generateRandomDirectionWithinRadians(mob.getRandom(), radius, yRange, 0, vectorPosition.x, vectorPosition.z, 1.5707963705062866);
            if (blockPos == null) {
                return null;
            }
            BlockPos blockPos1 = LandRandomPos.generateRandomPosTowardDirection(mob, radius, isRestricted, blockPos);
            return blockPos1 == null ? null : LandRandomPos.movePosUpOutOfSolid(mob, blockPos1);
        });
    }

    @Nullable
    public static BlockPos movePosUpOutOfSolid(PathfinderMob mob, BlockPos pos) {
        return !GoalUtils.isWater(mob, pos = RandomPos.moveUpOutOfSolid(pos, mob.level().getMaxY(), pos1 -> GoalUtils.isSolid(mob, pos1))) && !GoalUtils.hasMalus(mob, pos) ? pos : null;
    }

    @Nullable
    public static BlockPos generateRandomPosTowardDirection(PathfinderMob mob, int radius, boolean isRestricted, BlockPos pos) {
        BlockPos blockPos = RandomPos.generateRandomPosTowardDirection(mob, radius, mob.getRandom(), pos);
        return !GoalUtils.isOutsideLimits(blockPos, mob) && !GoalUtils.isRestricted(isRestricted, mob, blockPos) && !GoalUtils.isNotStable(mob.getNavigation(), blockPos) ? blockPos : null;
    }
}

