/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class MinecartTNT
extends AbstractMinecart {
    private static final byte EVENT_PRIME = 10;
    private static final String TAG_EXPLOSION_POWER = "explosion_power";
    private static final String TAG_EXPLOSION_SPEED_FACTOR = "explosion_speed_factor";
    private static final String TAG_FUSE = "fuse";
    private static final float DEFAULT_EXPLOSION_POWER_BASE = 4.0f;
    private static final float DEFAULT_EXPLOSION_SPEED_FACTOR = 1.0f;
    private static final int NO_FUSE = -1;
    @Nullable
    private DamageSource ignitionSource;
    public int fuse = -1;
    public float explosionPowerBase = 4.0f;
    public float explosionSpeedFactor = 1.0f;
    public boolean isIncendiary = false;

    public MinecartTNT(EntityType<? extends MinecartTNT> type, Level level) {
        super(type, level);
    }

    @Override
    public BlockState getDefaultDisplayBlockState() {
        return Blocks.TNT.defaultBlockState();
    }

    @Override
    public void tick() {
        double d;
        super.tick();
        if (this.fuse > 0) {
            if (this.level().paperConfig().fixes.tntEntityHeightNerf.test(v -> this.getY() > (double)v)) {
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            --this.fuse;
            this.level().addParticle(ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        } else if (this.fuse == 0) {
            this.explode(this.ignitionSource, this.getDeltaMovement().horizontalDistanceSqr());
        }
        if (this.horizontalCollision && (d = this.getDeltaMovement().horizontalDistanceSqr()) >= (double)0.01f) {
            this.explode(this.ignitionSource, d);
        }
    }

    @Override
    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        AbstractArrow abstractArrow;
        Entity entity = damageSource.getDirectEntity();
        if (entity instanceof AbstractArrow && (abstractArrow = (AbstractArrow)entity).isOnFire()) {
            DamageSource damageSource1 = this.damageSources().explosion(this, damageSource.getEntity());
            this.explode(damageSource1, abstractArrow.getDeltaMovement().lengthSqr());
        }
        return super.hurtServer(level, damageSource, amount);
    }

    @Override
    public void destroy(ServerLevel level, DamageSource damageSource) {
        double d = this.getDeltaMovement().horizontalDistanceSqr();
        if (!MinecartTNT.damageSourceIgnitesTnt(damageSource) && !(d >= (double)0.01f)) {
            this.destroy(level, this.getDropItem());
        } else if (this.fuse < 0) {
            this.primeFuse(damageSource);
            this.fuse = this.random.nextInt(20) + this.random.nextInt(20);
        }
    }

    @Override
    public Item getDropItem() {
        return Items.TNT_MINECART;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.TNT_MINECART);
    }

    public void explode(@Nullable DamageSource damageSource, double radiusModifier) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.getGameRules().getBoolean(GameRules.RULE_TNT_EXPLODES)) {
                double min = Math.min(Math.sqrt(radiusModifier), 5.0);
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)((double)this.explosionPowerBase + (double)this.explosionSpeedFactor * this.random.nextDouble() * 1.5 * min), this.isIncendiary);
                if (!event.callEvent()) {
                    this.fuse = -1;
                    return;
                }
                serverLevel.explode(this, damageSource, null, this.getX(), this.getY(), this.getZ(), event.getRadius(), event.getFire(), Level.ExplosionInteraction.TNT);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else if (this.isPrimed()) {
                this.discard(null);
            }
        }
    }

    @Override
    public boolean causeFallDamage(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (fallDistance >= 3.0) {
            double d = fallDistance / 10.0;
            this.explode(this.ignitionSource, d * d);
        }
        return super.causeFallDamage(fallDistance, damageMultiplier, damageSource);
    }

    @Override
    public void activateMinecart(int x, int y, int z, boolean receivingPower) {
        if (receivingPower && this.fuse < 0) {
            this.primeFuse(null);
        }
    }

    @Override
    public void handleEntityEvent(byte id) {
        if (id == 10) {
            this.primeFuse(null);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void primeFuse(@Nullable DamageSource damageSource) {
        ServerLevel serverLevel;
        Level level = this.level();
        if (!(level instanceof ServerLevel) || (serverLevel = (ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_TNT_EXPLODES)) {
            this.fuse = 80;
            if (!this.level().isClientSide()) {
                if (damageSource != null && this.ignitionSource == null) {
                    this.ignitionSource = this.damageSources().explosion(this, damageSource.getEntity());
                }
                this.level().broadcastEntityEvent(this, (byte)10);
                if (!this.isSilent()) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean isPrimed() {
        return this.fuse > -1;
    }

    @Override
    public float getBlockExplosionResistance(Explosion explosion, BlockGetter level, BlockPos pos, BlockState state, FluidState fluidState, float explosionPower) {
        return !this.isPrimed() || !state.is(BlockTags.RAILS) && !level.getBlockState(pos.above()).is(BlockTags.RAILS) ? super.getBlockExplosionResistance(explosion, level, pos, state, fluidState, explosionPower) : 0.0f;
    }

    @Override
    public boolean shouldBlockExplode(Explosion explosion, BlockGetter level, BlockPos pos, BlockState state, float explosionPower) {
        return (!this.isPrimed() || !state.is(BlockTags.RAILS) && !level.getBlockState(pos.above()).is(BlockTags.RAILS)) && super.shouldBlockExplode(explosion, level, pos, state, explosionPower);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.fuse = input.getIntOr(TAG_FUSE, -1);
        this.explosionPowerBase = Mth.clamp(input.getFloatOr(TAG_EXPLOSION_POWER, 4.0f), 0.0f, 128.0f);
        this.explosionSpeedFactor = Mth.clamp(input.getFloatOr(TAG_EXPLOSION_SPEED_FACTOR, 1.0f), 0.0f, 128.0f);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putInt(TAG_FUSE, this.fuse);
        if (this.explosionPowerBase != 4.0f) {
            output.putFloat(TAG_EXPLOSION_POWER, this.explosionPowerBase);
        }
        if (this.explosionSpeedFactor != 1.0f) {
            output.putFloat(TAG_EXPLOSION_SPEED_FACTOR, this.explosionSpeedFactor);
        }
    }

    @Override
    boolean shouldSourceDestroy(DamageSource damageSource) {
        return MinecartTNT.damageSourceIgnitesTnt(damageSource);
    }

    private static boolean damageSourceIgnitesTnt(DamageSource damageSource) {
        boolean bl;
        Entity entity = damageSource.getDirectEntity();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            bl = projectile.isOnFire();
        } else {
            bl = damageSource.is(DamageTypeTags.IS_FIRE) || damageSource.is(DamageTypeTags.IS_EXPLOSION);
        }
        return bl;
    }
}

