/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnchantingTableBlock;
import org.bukkit.Location;
import org.bukkit.craftbukkit.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.view.CraftEnchantmentView;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.view.EnchantmentView;

public class EnchantmentMenu
extends AbstractContainerMenu {
    static final ResourceLocation EMPTY_SLOT_LAPIS_LAZULI = ResourceLocation.withDefaultNamespace("container/slot/lapis_lazuli");
    private final Container enchantSlots;
    private final ContainerLevelAccess access;
    private final RandomSource random = RandomSource.create();
    private final DataSlot enchantmentSeed = DataSlot.standalone();
    public final int[] costs = new int[3];
    public final int[] enchantClue = new int[]{-1, -1, -1};
    public final int[] levelClue = new int[]{-1, -1, -1};
    @Nullable
    private CraftEnchantmentView view = null;
    private final org.bukkit.entity.Player player;

    public EnchantmentMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public EnchantmentMenu(int containerId, Inventory playerInventory, final ContainerLevelAccess access) {
        super(MenuType.ENCHANTMENT, containerId);
        this.enchantSlots = new SimpleContainer(this.createBlockHolder(access), 2){

            @Override
            public void setChanged() {
                super.setChanged();
                EnchantmentMenu.this.slotsChanged(this);
            }

            @Override
            public Location getLocation() {
                return access.getLocation();
            }
        };
        this.access = access;
        this.addSlot(new Slot(this, this.enchantSlots, 0, 15, 47){

            @Override
            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot(this, this.enchantSlots, 1, 35, 47){

            @Override
            public boolean mayPlace(net.minecraft.world.item.ItemStack stack) {
                return stack.is(Items.LAPIS_LAZULI);
            }

            @Override
            public ResourceLocation getNoItemIcon() {
                return EMPTY_SLOT_LAPIS_LAZULI;
            }
        });
        this.addStandardInventorySlots(playerInventory, 8, 84);
        this.addDataSlot(DataSlot.shared(this.costs, 0));
        this.addDataSlot(DataSlot.shared(this.costs, 1));
        this.addDataSlot(DataSlot.shared(this.costs, 2));
        this.addDataSlot(this.enchantmentSeed).set(playerInventory.player.getEnchantmentSeed());
        this.addDataSlot(DataSlot.shared(this.enchantClue, 0));
        this.addDataSlot(DataSlot.shared(this.enchantClue, 1));
        this.addDataSlot(DataSlot.shared(this.enchantClue, 2));
        this.addDataSlot(DataSlot.shared(this.levelClue, 0));
        this.addDataSlot(DataSlot.shared(this.levelClue, 1));
        this.addDataSlot(DataSlot.shared(this.levelClue, 2));
        this.player = (org.bukkit.entity.Player)playerInventory.player.getBukkitEntity();
    }

    @Override
    public void slotsChanged(Container inventory) {
        if (inventory == this.enchantSlots) {
            net.minecraft.world.item.ItemStack item = inventory.getItem(0);
            if (!item.isEmpty()) {
                this.access.execute((level, pos) -> {
                    IdMap<Holder<Holder<Enchantment>>> holderIdMap = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
                    int i1 = 0;
                    for (BlockPos blockPos : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
                        if (!EnchantingTableBlock.isValidBookShelf(level, pos, blockPos)) continue;
                        ++i1;
                    }
                    this.random.setSeed(this.enchantmentSeed.get());
                    for (int i2 = 0; i2 < 3; ++i2) {
                        this.costs[i2] = EnchantmentHelper.getEnchantmentCost(this.random, i2, i1, item);
                        this.enchantClue[i2] = -1;
                        this.levelClue[i2] = -1;
                        if (this.costs[i2] >= i2 + 1) continue;
                        this.costs[i2] = 0;
                    }
                    for (int i2x = 0; i2x < 3; ++i2x) {
                        List<EnchantmentInstance> enchantmentList;
                        if (this.costs[i2x] <= 0 || (enchantmentList = this.getEnchantmentList(level.registryAccess(), item, i2x, this.costs[i2x])) == null || enchantmentList.isEmpty()) continue;
                        EnchantmentInstance enchantmentInstance = enchantmentList.get(this.random.nextInt(enchantmentList.size()));
                        this.enchantClue[i2x] = holderIdMap.getId(enchantmentInstance.enchantment());
                        this.levelClue[i2x] = enchantmentInstance.level();
                    }
                    CraftItemStack craftItemStack = CraftItemStack.asCraftMirror(item);
                    EnchantmentOffer[] offers = new EnchantmentOffer[3];
                    for (int j = 0; j < 3; ++j) {
                        org.bukkit.enchantments.Enchantment enchantment = this.enchantClue[j] >= 0 ? CraftEnchantment.minecraftHolderToBukkit(holderIdMap.byId(this.enchantClue[j])) : null;
                        offers[j] = enchantment != null ? new EnchantmentOffer(enchantment, this.levelClue[j], this.costs[j]) : null;
                    }
                    PrepareItemEnchantEvent event = new PrepareItemEnchantEvent(this.player, (EnchantmentView)this.getBukkitView(), this.access.getLocation().getBlock(), (ItemStack)craftItemStack, offers, i1);
                    event.setCancelled(!item.isEnchantable());
                    level.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        for (int j = 0; j < 3; ++j) {
                            this.costs[j] = 0;
                            this.enchantClue[j] = -1;
                            this.levelClue[j] = -1;
                        }
                        return;
                    }
                    for (int j = 0; j < 3; ++j) {
                        EnchantmentOffer offer = event.getOffers()[j];
                        if (offer != null) {
                            this.costs[j] = offer.getCost();
                            this.enchantClue[j] = holderIdMap.getId(CraftEnchantment.bukkitToMinecraftHolder(offer.getEnchantment()));
                            this.levelClue[j] = offer.getEnchantmentLevel();
                            continue;
                        }
                        if (this.enchantClue[j] != -1) {
                            this.costs[j] = 0;
                        }
                        this.enchantClue[j] = -1;
                        this.levelClue[j] = -1;
                    }
                    this.broadcastChanges();
                });
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.costs[i] = 0;
                    this.enchantClue[i] = -1;
                    this.levelClue[i] = -1;
                }
            }
        }
    }

    @Override
    public boolean clickMenuButton(Player player, int id) {
        if (id >= 0 && id < this.costs.length) {
            net.minecraft.world.item.ItemStack item = this.enchantSlots.getItem(0);
            net.minecraft.world.item.ItemStack item1 = this.enchantSlots.getItem(1);
            int i = id + 1;
            if ((item1.isEmpty() || item1.getCount() < i) && !player.hasInfiniteMaterials()) {
                return false;
            }
            if (this.costs[id] <= 0 || item.isEmpty() || (player.experienceLevel < i || player.experienceLevel < this.costs[id]) && !player.hasInfiniteMaterials()) {
                return false;
            }
            this.access.execute((level, pos) -> {
                net.minecraft.world.item.ItemStack itemStack = item;
                List<EnchantmentInstance> enchantmentList = this.getEnchantmentList(level.registryAccess(), item, id, this.costs[id]);
                IdMap registry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
                HashMap<org.bukkit.enchantments.Enchantment, Integer> enchants = new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
                for (EnchantmentInstance instance : enchantmentList) {
                    enchants.put(CraftEnchantment.minecraftHolderToBukkit(instance.enchantment()), instance.level());
                }
                CraftItemStack craftItemStack = CraftItemStack.asCraftMirror(itemStack);
                Holder<Enchantment> holder = registry.byId(this.enchantClue[id]);
                if (holder == null) {
                    return;
                }
                org.bukkit.enchantments.Enchantment hintedEnchantment = CraftEnchantment.minecraftHolderToBukkit(holder);
                int hintedEnchantmentLevel = this.levelClue[id];
                EnchantItemEvent event = new EnchantItemEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (InventoryView)this.getBukkitView(), this.access.getLocation().getBlock(), (ItemStack)craftItemStack, this.costs[id], enchants, hintedEnchantment, hintedEnchantmentLevel, id);
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                int itemLevel = event.getExpLevelCost();
                if (event.isCancelled() || itemLevel > player.experienceLevel && !player.getAbilities().instabuild || event.getEnchantsToAdd().isEmpty()) {
                    return;
                }
                itemStack = CraftItemStack.getOrCloneOnMutation(craftItemStack, event.getItem());
                if (itemStack != item) {
                    this.enchantSlots.setItem(0, itemStack);
                }
                if (itemStack.is(Items.BOOK)) {
                    itemStack = itemStack.transmuteCopy(Items.ENCHANTED_BOOK);
                    this.enchantSlots.setItem(0, itemStack);
                }
                for (Map.Entry entry : event.getEnchantsToAdd().entrySet()) {
                    Holder<Enchantment> enchant = CraftEnchantment.bukkitToMinecraftHolder((org.bukkit.enchantments.Enchantment)entry.getKey());
                    if (enchant == null) continue;
                    itemStack.enchant(enchant, (Integer)entry.getValue());
                }
                player.onEnchantmentPerformed(item, i);
                item1.consume(i, player);
                if (item1.isEmpty()) {
                    this.enchantSlots.setItem(1, net.minecraft.world.item.ItemStack.EMPTY);
                }
                player.awardStat(Stats.ENCHANT_ITEM);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.ENCHANTED_ITEM.trigger((ServerPlayer)player, itemStack, i);
                }
                this.enchantSlots.setChanged();
                this.enchantmentSeed.set(player.getEnchantmentSeed());
                this.slotsChanged(this.enchantSlots);
                level.playSound(null, (BlockPos)pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
            });
            return true;
        }
        Util.logAndPauseIfInIde(player.getPlainTextName() + " pressed invalid button id: " + id);
        return false;
    }

    private List<EnchantmentInstance> getEnchantmentList(RegistryAccess registryAccess, net.minecraft.world.item.ItemStack stack, int slot, int cost) {
        this.random.setSeed(this.enchantmentSeed.get() + slot);
        Optional optional = registryAccess.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.IN_ENCHANTING_TABLE);
        if (optional.isEmpty()) {
            return List.of();
        }
        List<EnchantmentInstance> list = EnchantmentHelper.selectEnchantment(this.random, stack, cost, ((HolderSet.Named)optional.get()).stream());
        if (stack.is(Items.BOOK) && list.size() > 1) {
            list.remove(this.random.nextInt(list.size()));
        }
        return list;
    }

    public int getGoldCount() {
        net.minecraft.world.item.ItemStack item = this.enchantSlots.getItem(1);
        return item.isEmpty() ? 0 : item.getCount();
    }

    public void setEnchantmentSeed(int seed) {
        this.enchantmentSeed.set(seed);
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed.get();
    }

    @Override
    public void removed(Player player) {
        super.removed(player);
        this.access.execute((level, pos) -> this.clearContainer(player, this.enchantSlots));
    }

    @Override
    public boolean stillValid(Player player) {
        if (!this.checkReachable) {
            return true;
        }
        return EnchantmentMenu.stillValid(this.access, player, Blocks.ENCHANTING_TABLE);
    }

    @Override
    public net.minecraft.world.item.ItemStack quickMoveStack(Player player, int slotIndex) {
        net.minecraft.world.item.ItemStack itemStack = net.minecraft.world.item.ItemStack.EMPTY;
        Slot slot = this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            net.minecraft.world.item.ItemStack item = slot.getItem();
            itemStack = item.copy();
            if (slotIndex == 0) {
                if (!this.moveItemStackTo(item, 2, 38, true)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
            } else if (slotIndex == 1) {
                if (!this.moveItemStackTo(item, 2, 38, true)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
            } else if (item.is(Items.LAPIS_LAZULI)) {
                if (!this.moveItemStackTo(item, 1, 2, true)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
            } else {
                if (this.slots.get(0).hasItem() || !this.slots.get(0).mayPlace(item)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
                net.minecraft.world.item.ItemStack itemStack1 = item.copyWithCount(1);
                item.shrink(1);
                this.slots.get(0).setByPlayer(itemStack1);
            }
            if (item.isEmpty()) {
                slot.setByPlayer(net.minecraft.world.item.ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (item.getCount() == itemStack.getCount()) {
                return net.minecraft.world.item.ItemStack.EMPTY;
            }
            slot.onTake(player, item);
        }
        return itemStack;
    }

    @Override
    public CraftEnchantmentView getBukkitView() {
        if (this.view != null) {
            return this.view;
        }
        CraftInventoryEnchanting inventory = new CraftInventoryEnchanting(this.enchantSlots);
        this.view = new CraftEnchantmentView((HumanEntity)this.player, inventory, this);
        return this.view;
    }
}

