/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.inventory.CraftInventoryView;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class HorseInventoryMenu
extends AbstractContainerMenu {
    private static final ResourceLocation SADDLE_SLOT_SPRITE = ResourceLocation.withDefaultNamespace("container/slot/saddle");
    private static final ResourceLocation LLAMA_ARMOR_SLOT_SPRITE = ResourceLocation.withDefaultNamespace("container/slot/llama_armor");
    private static final ResourceLocation ARMOR_SLOT_SPRITE = ResourceLocation.withDefaultNamespace("container/slot/horse_armor");
    private final Container horseContainer;
    public final AbstractHorse horse;
    public static final int SLOT_SADDLE = 0;
    public static final int SLOT_BODY_ARMOR = 1;
    public static final int SLOT_HORSE_INVENTORY_START = 2;
    @Nullable
    private CraftInventoryView view;
    private final net.minecraft.world.entity.player.Inventory inventory;

    @Override
    public InventoryView getBukkitView() {
        if (this.view != null) {
            return this.view;
        }
        this.view = new CraftInventoryView<HorseInventoryMenu, Inventory>(this.inventory.player.getBukkitEntity(), this.horseContainer.getOwner().getInventory(), this);
        return this.view;
    }

    public HorseInventoryMenu(int containerId, net.minecraft.world.entity.player.Inventory inventory, Container horseContainer, final AbstractHorse horse, int columns) {
        super(null, containerId);
        this.inventory = inventory;
        this.horseContainer = horseContainer;
        this.horse = horse;
        horseContainer.startOpen(inventory.player);
        Container container = horse.createEquipmentSlotContainer(EquipmentSlot.SADDLE);
        this.addSlot(new ArmorSlot(this, container, horse, EquipmentSlot.SADDLE, 0, 8, 18, SADDLE_SLOT_SPRITE){

            @Override
            public boolean isActive() {
                return horse.canUseSlot(EquipmentSlot.SADDLE) && horse.getType().is(EntityTypeTags.CAN_EQUIP_SADDLE);
            }
        });
        final boolean flag = horse instanceof Llama;
        ResourceLocation resourceLocation = flag ? LLAMA_ARMOR_SLOT_SPRITE : ARMOR_SLOT_SPRITE;
        Container container1 = horse.createEquipmentSlotContainer(EquipmentSlot.BODY);
        this.addSlot(new ArmorSlot(this, container1, horse, EquipmentSlot.BODY, 0, 8, 36, resourceLocation){

            @Override
            public boolean isActive() {
                return horse.canUseSlot(EquipmentSlot.BODY) && (horse.getType().is(EntityTypeTags.CAN_WEAR_HORSE_ARMOR) || flag);
            }
        });
        if (columns > 0) {
            for (int i = 0; i < 3; ++i) {
                for (int i1 = 0; i1 < columns; ++i1) {
                    this.addSlot(new Slot(horseContainer, i1 + i * columns, 80 + i1 * 18, 18 + i * 18));
                }
            }
        }
        this.addStandardInventorySlots(inventory, 8, 84);
    }

    @Override
    public boolean stillValid(Player player) {
        return !this.horse.hasInventoryChanged(this.horseContainer) && this.horseContainer.stillValid(player) && this.horse.isAlive() && player.canInteractWithEntity(this.horse, 4.0);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack item = slot.getItem();
            itemStack = item.copy();
            int i = 2 + this.horseContainer.getContainerSize();
            if (slotIndex < i) {
                if (!this.moveItemStackTo(item, i, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace(item) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo(item, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(item) && !this.getSlot(0).hasItem()) {
                if (!this.moveItemStackTo(item, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.horseContainer.getContainerSize() == 0 || !this.moveItemStackTo(item, 2, i, false)) {
                int i1 = i + 27;
                int i3 = i1 + 9;
                if (slotIndex >= i1 && slotIndex < i3 ? !this.moveItemStackTo(item, i, i1, false) : (slotIndex >= i && slotIndex < i1 ? !this.moveItemStackTo(item, i1, i3, false) : !this.moveItemStackTo(item, i1, i1, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (item.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    @Override
    public void removed(Player player) {
        super.removed(player);
        this.horseContainer.stopOpen(player);
    }
}

