/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.GameRules;

public interface RecipeCraftingHolder {
    public void setRecipeUsed(@Nullable RecipeHolder<?> var1);

    @Nullable
    public RecipeHolder<?> getRecipeUsed();

    default public void awardUsedRecipes(Player player, List<ItemStack> items) {
        RecipeHolder<?> recipeUsed = this.getRecipeUsed();
        if (recipeUsed != null) {
            player.triggerRecipeCrafted(recipeUsed, items);
            if (!recipeUsed.value().isSpecial()) {
                player.awardRecipes(Collections.singleton(recipeUsed));
                this.setRecipeUsed(null);
            }
        }
    }

    default public boolean setRecipeUsed(ServerPlayer player, RecipeHolder<?> recipe) {
        if (!recipe.value().isSpecial() && player.level().getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING) && !player.getRecipeBook().contains(recipe.id())) {
            return false;
        }
        this.setRecipeUsed(recipe);
        return true;
    }
}

