/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;

public abstract class ProjectileWeaponItem
extends Item {
    public static final Predicate<ItemStack> ARROW_ONLY = stack -> stack.is(ItemTags.ARROWS);
    public static final Predicate<ItemStack> ARROW_OR_FIREWORK = ARROW_ONLY.or(stack -> stack.is(Items.FIREWORK_ROCKET));

    public ProjectileWeaponItem(Item.Properties properties) {
        super(properties);
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return this.getAllSupportedProjectiles();
    }

    public abstract Predicate<ItemStack> getAllSupportedProjectiles();

    public static ItemStack getHeldProjectile(LivingEntity shooter, Predicate<ItemStack> isAmmo) {
        if (isAmmo.test(shooter.getItemInHand(InteractionHand.OFF_HAND))) {
            return shooter.getItemInHand(InteractionHand.OFF_HAND);
        }
        return isAmmo.test(shooter.getItemInHand(InteractionHand.MAIN_HAND)) ? shooter.getItemInHand(InteractionHand.MAIN_HAND) : ItemStack.EMPTY;
    }

    public abstract int getDefaultProjectileRange();

    protected void shoot(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable LivingEntity target, float drawStrength) {
        float f = EnchantmentHelper.processProjectileSpread(level, weapon, shooter, 0.0f);
        float f1 = projectileItems.size() == 1 ? 0.0f : 2.0f * f / (float)(projectileItems.size() - 1);
        float f2 = (float)((projectileItems.size() - 1) % 2) * f1 / 2.0f;
        float f3 = 1.0f;
        for (int i = 0; i < projectileItems.size(); ++i) {
            ItemStack itemStack = projectileItems.get(i);
            if (itemStack.isEmpty()) continue;
            float f4 = f2 + f3 * (float)((i + 1) / 2) * f1;
            f3 = -f3;
            int i1 = i;
            Projectile projectile = this.createProjectile(level, shooter, weapon, itemStack, isCrit);
            this.shootProjectile(shooter, projectile, i1, velocity, inaccuracy, f4, target);
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(shooter, weapon, itemStack, projectile, hand, drawStrength, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            if (event.getProjectile() == projectile.getBukkitEntity() && Projectile.spawnProjectile(projectile, level, itemStack).isRemoved()) {
                return;
            }
            weapon.hurtAndBreak(this.getDurabilityUse(itemStack), shooter, hand.asEquipmentSlot());
            if (weapon.isEmpty()) break;
        }
    }

    protected int getDurabilityUse(ItemStack stack) {
        return 1;
    }

    protected abstract void shootProjectile(LivingEntity var1, Projectile var2, int var3, float var4, float var5, float var6, @Nullable LivingEntity var7);

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        ArrowItem arrowItem;
        Item item = ammo.getItem();
        ArrowItem arrowItem1 = item instanceof ArrowItem ? (arrowItem = (ArrowItem)item) : (ArrowItem)Items.ARROW;
        AbstractArrow abstractArrow = arrowItem1.createArrow(level, ammo, shooter, weapon);
        if (isCrit) {
            abstractArrow.setCritArrow(true);
        }
        return abstractArrow;
    }

    protected static List<ItemStack> draw(ItemStack weapon, ItemStack ammo, LivingEntity shooter) {
        return ProjectileWeaponItem.draw(weapon, ammo, shooter, true);
    }

    protected static List<ItemStack> draw(ItemStack weapon, ItemStack ammo, LivingEntity shooter, boolean consume) {
        int n;
        if (ammo.isEmpty()) {
            return List.of();
        }
        Level level = shooter.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            n = EnchantmentHelper.processProjectileCount(serverLevel, weapon, shooter, 1);
        } else {
            n = 1;
        }
        int i = n;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(i);
        ItemStack itemStack = ammo.copy();
        for (int i1 = 0; i1 < i; ++i1) {
            ItemStack itemStack1 = ProjectileWeaponItem.useAmmo(weapon, i1 == 0 ? ammo : itemStack, shooter, i1 > 0 || !consume);
            if (itemStack1.isEmpty()) continue;
            list.add(itemStack1);
        }
        return list;
    }

    protected static ItemStack useAmmo(ItemStack weapon, ItemStack ammo, LivingEntity shooter, boolean intangible) {
        ItemStack itemStack;
        int i;
        Level level;
        if (!intangible && !shooter.hasInfiniteMaterials() && (level = shooter.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            v0 = EnchantmentHelper.processAmmoUse(serverLevel, weapon, ammo, 1);
        } else {
            v0 = i = 0;
        }
        if (i > ammo.getCount()) {
            return ItemStack.EMPTY;
        }
        if (i == 0) {
            itemStack = ammo.copyWithCount(1);
            itemStack.set(DataComponents.INTANGIBLE_PROJECTILE, Unit.INSTANCE);
            return itemStack;
        }
        itemStack = ammo.split(i);
        if (ammo.isEmpty() && shooter instanceof Player) {
            Player player = (Player)shooter;
            player.getInventory().removeItem(ammo);
        }
        return itemStack;
    }
}

