/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import io.papermc.paper.event.player.PlayerItemCooldownEvent;
import io.papermc.paper.event.player.PlayerItemGroupCooldownEvent;
import net.minecraft.network.protocol.game.ClientboundCooldownPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.Player;

public class ServerItemCooldowns
extends ItemCooldowns {
    private final ServerPlayer player;

    public ServerItemCooldowns(ServerPlayer player) {
        this.player = player;
    }

    private int getCurrentCooldown(ResourceLocation groupId) {
        ItemCooldowns.CooldownInstance cooldownInstance = this.cooldowns.get(groupId);
        if (cooldownInstance == null) {
            return 0;
        }
        return Math.max(0, cooldownInstance.endTime() - this.tickCount);
    }

    @Override
    public void addCooldown(ItemStack item, int duration) {
        ResourceLocation cooldownGroup = this.getCooldownGroup(item);
        PlayerItemCooldownEvent event = new PlayerItemCooldownEvent((Player)this.player.getBukkitEntity(), CraftItemType.minecraftToBukkit(item.getItem()), CraftNamespacedKey.fromMinecraft(cooldownGroup), duration);
        if (event.callEvent()) {
            this.addCooldown(cooldownGroup, event.getCooldown(), false);
        } else {
            this.player.connection.send(new ClientboundCooldownPacket(cooldownGroup, this.getCurrentCooldown(cooldownGroup)));
        }
    }

    @Override
    public void addCooldown(ResourceLocation groupId, int duration, boolean callEvent) {
        if (callEvent) {
            PlayerItemGroupCooldownEvent event = new PlayerItemGroupCooldownEvent((Player)this.player.getBukkitEntity(), CraftNamespacedKey.fromMinecraft(groupId), duration);
            if (!event.callEvent()) {
                this.player.connection.send(new ClientboundCooldownPacket(groupId, this.getCurrentCooldown(groupId)));
                return;
            }
            duration = event.getCooldown();
        }
        super.addCooldown(groupId, duration, false);
    }

    @Override
    protected void onCooldownStarted(ResourceLocation group, int cooldown) {
        super.onCooldownStarted(group, cooldown);
        this.player.connection.send(new ClientboundCooldownPacket(group, cooldown));
    }

    @Override
    protected void onCooldownEnded(ResourceLocation group) {
        super.onCooldownEnded(group);
        this.player.connection.send(new ClientboundCooldownPacket(group, 0));
    }
}

