/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public abstract sealed class ResolvableProfile
implements TooltipProvider {
    private static final Codec<ResolvableProfile> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapEither(ExtraCodecs.STORED_GAME_PROFILE, Partial.MAP_CODEC).forGetter(ResolvableProfile::unpack), (App)PlayerSkin.Patch.MAP_CODEC.forGetter(ResolvableProfile::skinPatch)).apply((Applicative)instance, ResolvableProfile::create));
    public static final Codec<ResolvableProfile> CODEC = Codec.withAlternative(FULL_CODEC, ExtraCodecs.PLAYER_NAME, ResolvableProfile::createUnresolved);
    public static final StreamCodec<ByteBuf, ResolvableProfile> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.either(ByteBufCodecs.GAME_PROFILE, Partial.STREAM_CODEC), ResolvableProfile::unpack, PlayerSkin.Patch.STREAM_CODEC, ResolvableProfile::skinPatch, ResolvableProfile::create);
    protected final GameProfile partialProfile;
    protected final PlayerSkin.Patch skinPatch;

    private static ResolvableProfile create(Either<GameProfile, Partial> contents, PlayerSkin.Patch skinPatch) {
        return contents.map(gameProfile -> new Static(Either.left(gameProfile), skinPatch), partial -> partial.properties.isEmpty() && partial.id.isPresent() != partial.name.isPresent() ? partial.name.map(string -> new Dynamic(Either.left(string), skinPatch)).orElseGet(() -> new Dynamic(Either.right(partial.id.get()), skinPatch)) : new Static(Either.right(partial), skinPatch));
    }

    public static ResolvableProfile createResolved(GameProfile profile) {
        return new Static(Either.left(profile), PlayerSkin.Patch.EMPTY);
    }

    public static ResolvableProfile createUnresolved(String name) {
        return new Dynamic(Either.left(name), PlayerSkin.Patch.EMPTY);
    }

    public static ResolvableProfile createUnresolved(UUID id) {
        return new Dynamic(Either.right(id), PlayerSkin.Patch.EMPTY);
    }

    public abstract Either<GameProfile, Partial> unpack();

    protected ResolvableProfile(GameProfile partialProfile, PlayerSkin.Patch skinPatch) {
        this.partialProfile = partialProfile;
        this.skinPatch = skinPatch;
    }

    public abstract CompletableFuture<GameProfile> resolveProfile(ProfileResolver var1);

    public GameProfile partialProfile() {
        return this.partialProfile;
    }

    public PlayerSkin.Patch skinPatch() {
        return this.skinPatch;
    }

    static GameProfile createPartialProfile(Optional<String> name, Optional<UUID> id, PropertyMap properties) {
        String string = name.orElse("");
        UUID uuid = id.orElseGet(() -> name.map(UUIDUtil::createOfflinePlayerUUID).orElse(Util.NIL_UUID));
        return new GameProfile(uuid, string, properties);
    }

    public abstract Optional<String> name();

    public static final class Static
    extends ResolvableProfile {
        public static final Static EMPTY = new Static(Either.right(Partial.EMPTY), PlayerSkin.Patch.EMPTY);
        private final Either<GameProfile, Partial> contents;

        public Static(Either<GameProfile, Partial> contents, PlayerSkin.Patch skinPatch) {
            super(contents.map(gameProfile -> gameProfile, Partial::createProfile), skinPatch);
            this.contents = contents;
        }

        @Override
        public CompletableFuture<GameProfile> resolveProfile(ProfileResolver resolver) {
            return CompletableFuture.completedFuture(this.partialProfile);
        }

        @Override
        public Either<GameProfile, Partial> unpack() {
            return this.contents;
        }

        @Override
        public Optional<String> name() {
            return this.contents.map(gameProfile -> Optional.of(gameProfile.name()), partial -> partial.name);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof Static)) return false;
            Static _static = (Static)other;
            if (!this.contents.equals(_static.contents)) return false;
            if (!this.skinPatch.equals(_static.skinPatch)) return false;
            return true;
        }

        public int hashCode() {
            int i = 31 + this.contents.hashCode();
            return 31 * i + this.skinPatch.hashCode();
        }

        @Override
        public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        }
    }

    public static final class Dynamic
    extends ResolvableProfile {
        private static final Component DYNAMIC_TOOLTIP = Component.translatable("component.profile.dynamic").withStyle(ChatFormatting.GRAY);
        private final Either<String, UUID> nameOrId;

        public Dynamic(Either<String, UUID> nameOrId, PlayerSkin.Patch skinPatch) {
            super(ResolvableProfile.createPartialProfile(nameOrId.left(), nameOrId.right(), PropertyMap.EMPTY), skinPatch);
            this.nameOrId = nameOrId;
        }

        @Override
        public Optional<String> name() {
            return this.nameOrId.left();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof Dynamic)) return false;
            Dynamic dynamic = (Dynamic)other;
            if (!this.nameOrId.equals(dynamic.nameOrId)) return false;
            if (!this.skinPatch.equals(dynamic.skinPatch)) return false;
            return true;
        }

        public int hashCode() {
            int i = 31 + this.nameOrId.hashCode();
            return 31 * i + this.skinPatch.hashCode();
        }

        @Override
        public Either<GameProfile, Partial> unpack() {
            return Either.right(new Partial(this.nameOrId.left(), this.nameOrId.right(), PropertyMap.EMPTY));
        }

        @Override
        public CompletableFuture<GameProfile> resolveProfile(ProfileResolver resolver) {
            return CompletableFuture.supplyAsync(() -> resolver.fetchByNameOrId(this.nameOrId).orElse(this.partialProfile), Util.nonCriticalIoPool());
        }

        @Override
        public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
            tooltipAdder.accept(DYNAMIC_TOOLTIP);
        }
    }

    public record Partial(Optional<String> name, Optional<UUID> id, PropertyMap properties) {
        public static final Partial EMPTY = new Partial(Optional.empty(), Optional.empty(), PropertyMap.EMPTY);
        public static final MapCodec<Partial> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.PLAYER_NAME.optionalFieldOf("name").forGetter(Partial::name), (App)UUIDUtil.CODEC.optionalFieldOf("id").forGetter(Partial::id), (App)UUIDUtil.STRING_CODEC.lenientOptionalFieldOf("Id").forGetter($ -> Optional.empty()), (App)ExtraCodecs.PROPERTY_MAP.optionalFieldOf("properties", (Object)PropertyMap.EMPTY).forGetter(Partial::properties)).apply((Applicative)instance, (name, uuid, uuid2, propertyMap) -> new Partial((Optional<String>)name, uuid2.or(() -> uuid), (PropertyMap)propertyMap)));
        public static final StreamCodec<ByteBuf, Partial> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.PLAYER_NAME.apply(ByteBufCodecs::optional), Partial::name, UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs::optional), Partial::id, ByteBufCodecs.GAME_PROFILE_PROPERTIES, Partial::properties, Partial::new);

        private GameProfile createProfile() {
            return ResolvableProfile.createPartialProfile(this.name, this.id, this.properties);
        }
    }
}

