/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public record TargetedConditionalEffect<T>(EnchantmentTarget enchanted, EnchantmentTarget affected, T effect, Optional<LootItemCondition> requirements) {
    public static <S> Codec<TargetedConditionalEffect<S>> codec(Codec<S> codec, ContextKeySet contextKeySet) {
        return RecordCodecBuilder.create(instance -> instance.group((App)EnchantmentTarget.CODEC.fieldOf("enchanted").forGetter(TargetedConditionalEffect::enchanted), (App)EnchantmentTarget.CODEC.fieldOf("affected").forGetter(TargetedConditionalEffect::affected), (App)codec.fieldOf("effect").forGetter(TargetedConditionalEffect::effect), (App)ConditionalEffect.conditionCodec(contextKeySet).optionalFieldOf("requirements").forGetter(TargetedConditionalEffect::requirements)).apply((Applicative)instance, TargetedConditionalEffect::new));
    }

    public static <S> Codec<TargetedConditionalEffect<S>> equipmentDropsCodec(Codec<S> codec, ContextKeySet contextKeySet) {
        return RecordCodecBuilder.create(instance -> instance.group((App)EnchantmentTarget.CODEC.validate(target -> target != EnchantmentTarget.DAMAGING_ENTITY ? DataResult.success((Object)target) : DataResult.error(() -> "enchanted must be attacker or victim")).fieldOf("enchanted").forGetter(TargetedConditionalEffect::enchanted), (App)codec.fieldOf("effect").forGetter(TargetedConditionalEffect::effect), (App)ConditionalEffect.conditionCodec(contextKeySet).optionalFieldOf("requirements").forGetter(TargetedConditionalEffect::requirements)).apply((Applicative)instance, (enchanted, effect, requirements) -> new TargetedConditionalEffect<Object>((EnchantmentTarget)enchanted, EnchantmentTarget.VICTIM, effect, (Optional<LootItemCondition>)requirements)));
    }

    public boolean matches(LootContext context) {
        return this.requirements.isEmpty() || this.requirements.get().test(context);
    }
}

