/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemEntityGetter;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.entity.HumanEntity;

public interface EntityGetter
extends ChunkSystemEntityGetter {
    public List<Entity> getEntities(@Nullable Entity var1, AABB var2, Predicate<? super Entity> var3);

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> var1, AABB var2, Predicate<? super T> var3);

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> entityClass, AABB area, Predicate<? super T> filter) {
        return this.getEntities(EntityTypeTest.forClass(entityClass), area, filter);
    }

    public List<? extends Player> players();

    default public List<Entity> getEntities(@Nullable Entity entity, AABB area) {
        return this.getEntities(entity, area, EntitySelector.NO_SPECTATORS);
    }

    @Override
    default public List<Entity> moonrise$getHardCollidingEntities(Entity entity, AABB box, Predicate<? super Entity> predicate) {
        return this.getEntities(entity, box, predicate);
    }

    default public boolean isUnobstructed(@Nullable Entity entity, VoxelShape voxel) {
        if (voxel.isEmpty()) {
            return true;
        }
        AABB singleAABB = voxel.moonrise$getSingleAABBRepresentation();
        List<Entity> entities = this.getEntities(entity, singleAABB == null ? voxel.bounds() : singleAABB.inflate(-1.0E-7, -1.0E-7, -1.0E-7));
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            AABB entityBB;
            Entity otherEntity = entities.get(i);
            if (otherEntity.isRemoved() || !otherEntity.blocksBuilding || entity != null && otherEntity.isPassengerOfSameVehicle(entity) || singleAABB == null && (CollisionUtil.isEmpty(entityBB = otherEntity.getBoundingBox()) || !CollisionUtil.voxelShapeIntersectNoEmpty(voxel, entityBB))) continue;
            return false;
        }
        return true;
    }

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> entityClass, AABB area) {
        return this.getEntitiesOfClass(entityClass, area, EntitySelector.NO_SPECTATORS);
    }

    default public List<VoxelShape> getEntityCollisions(@Nullable Entity entity, AABB collisionBox) {
        if (CollisionUtil.isEmpty(collisionBox)) {
            return new ArrayList<VoxelShape>();
        }
        collisionBox = collisionBox.inflate(-1.0E-7, -1.0E-7, -1.0E-7);
        List<Entity> entities = entity != null && entity.moonrise$isHardColliding() ? this.getEntities(entity, collisionBox, null) : this.moonrise$getHardCollidingEntities(entity, collisionBox, null);
        ArrayList<VoxelShape> ret = new ArrayList<VoxelShape>(Math.min(25, entities.size()));
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            Entity otherEntity = entities.get(i);
            if (otherEntity.isSpectator() || (entity != null || !otherEntity.canBeCollidedWith(entity)) && (entity == null || !entity.canCollideWith(otherEntity))) continue;
            ret.add(Shapes.create(otherEntity.getBoundingBox()));
        }
        return ret;
    }

    @Nullable
    default public Player findNearbyPlayer(Entity entity, double maxDistance, @Nullable Predicate<Entity> predicate) {
        return this.getNearestPlayer(entity.getX(), entity.getY(), entity.getZ(), maxDistance, predicate);
    }

    @Nullable
    default public Player getNearestPlayer(double x, double y, double z, double distance, @Nullable Predicate<Entity> predicate) {
        double d = -1.0;
        Player player = null;
        for (Player player2 : this.players()) {
            if (predicate != null && !predicate.test(player2)) continue;
            double d1 = player2.distanceToSqr(x, y, z);
            if (!(distance < 0.0) && !(d1 < distance * distance) || d != -1.0 && !(d1 < d)) continue;
            d = d1;
            player = player2;
        }
        return player;
    }

    default public List<HumanEntity> findNearbyBukkitPlayers(double x, double y, double z, double radius, boolean notSpectator) {
        return this.findNearbyBukkitPlayers(x, y, z, radius, notSpectator ? EntitySelector.NO_SPECTATORS : EntitySelector.NO_CREATIVE_OR_SPECTATOR);
    }

    default public List<HumanEntity> findNearbyBukkitPlayers(double x, double y, double z, double radius, @Nullable Predicate<Entity> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Player player : this.players()) {
            if (predicate != null && !predicate.test(player)) continue;
            double distanceSquared = player.distanceToSqr(x, y, z);
            if (!(radius < 0.0) && !(distanceSquared < radius * radius)) continue;
            builder.add((Object)player.getBukkitEntity());
        }
        return builder.build();
    }

    @Nullable
    default public Player getNearestPlayer(Entity entity, double distance) {
        return this.getNearestPlayer(entity.getX(), entity.getY(), entity.getZ(), distance, false);
    }

    @Nullable
    default public Player getNearestPlayer(double x, double y, double z, double distance, boolean creativePlayers) {
        Predicate<Entity> predicate = creativePlayers ? EntitySelector.NO_CREATIVE_OR_SPECTATOR : EntitySelector.NO_SPECTATORS;
        return this.getNearestPlayer(x, y, z, distance, predicate);
    }

    default public boolean hasNearbyAlivePlayerThatAffectsSpawning(double x, double y, double z, double range) {
        for (Player player : this.players()) {
            if (!EntitySelector.PLAYER_AFFECTS_SPAWNING.test(player)) continue;
            double distanceSqr = player.distanceToSqr(x, y, z);
            if (!(range < 0.0) && !(distanceSqr < range * range)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasNearbyAlivePlayer(double x, double y, double z, double distance) {
        for (Player player : this.players()) {
            if (!EntitySelector.NO_SPECTATORS.test(player) || !EntitySelector.LIVING_ENTITY_STILL_ALIVE.test(player)) continue;
            double d = player.distanceToSqr(x, y, z);
            if (!(distance < 0.0) && !(d < distance * distance)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public Player getPlayerByUUID(UUID uniqueId) {
        for (int i = 0; i < this.players().size(); ++i) {
            Player player = this.players().get(i);
            if (!uniqueId.equals(player.getUUID())) continue;
            return player;
        }
        return null;
    }

    @Nullable
    default public Player getGlobalPlayerByUUID(UUID uuid) {
        return this.getPlayerByUUID(uuid);
    }
}

