/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicLike;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import org.bukkit.GameRule;
import org.slf4j.Logger;

public class GameRules {
    private static final boolean DISABLE_LIMITS = Boolean.getBoolean("paper.disableGameRuleLimits");
    public static final int DEFAULT_RANDOM_TICK_SPEED = 3;
    static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<Key<?>, Type<?>> GAME_RULE_TYPES = Maps.newTreeMap(Comparator.comparing(entry -> entry.id));
    public static final Key<BooleanValue> RULE_DOFIRETICK = GameRules.register("doFireTick", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_ALLOWFIRETICKAWAYFROMPLAYERS = GameRules.register("allowFireTicksAwayFromPlayer", Category.UPDATES, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_MOBGRIEFING = GameRules.register("mobGriefing", Category.MOBS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_KEEPINVENTORY = GameRules.register("keepInventory", Category.PLAYER, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DOMOBSPAWNING = GameRules.register("doMobSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOMOBLOOT = GameRules.register("doMobLoot", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_PROJECTILESCANBREAKBLOCKS = GameRules.register("projectilesCanBreakBlocks", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOBLOCKDROPS = GameRules.register("doTileDrops", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOENTITYDROPS = GameRules.register("doEntityDrops", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_COMMANDBLOCKOUTPUT = GameRules.register("commandBlockOutput", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_NATURAL_REGENERATION = GameRules.register("naturalRegeneration", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DAYLIGHT = GameRules.register("doDaylightCycle", Category.UPDATES, BooleanValue.create(!SharedConstants.DEBUG_WORLD_RECREATE));
    public static final Key<BooleanValue> RULE_LOGADMINCOMMANDS = GameRules.register("logAdminCommands", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_SHOWDEATHMESSAGES = GameRules.register("showDeathMessages", Category.CHAT, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_RANDOMTICKING = GameRules.register("randomTickSpeed", Category.UPDATES, IntegerValue.create(3));
    public static final Key<BooleanValue> RULE_SENDCOMMANDFEEDBACK = GameRules.register("sendCommandFeedback", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_REDUCEDDEBUGINFO = GameRules.register("reducedDebugInfo", Category.MISC, BooleanValue.create(false, (level, value) -> {
        byte b = value.get() ? (byte)22 : (byte)23;
        for (ServerPlayer serverPlayer : level.players()) {
            serverPlayer.connection.send(new ClientboundEntityEventPacket(serverPlayer, b));
        }
    }));
    public static final Key<BooleanValue> RULE_SPECTATORSGENERATECHUNKS = GameRules.register("spectatorsGenerateChunks", Category.PLAYER, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_SPAWN_RADIUS = GameRules.register("spawnRadius", Category.PLAYER, IntegerValue.create(10));
    public static final Key<BooleanValue> RULE_DISABLE_PLAYER_MOVEMENT_CHECK = GameRules.register("disablePlayerMovementCheck", Category.PLAYER, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DISABLE_ELYTRA_MOVEMENT_CHECK = GameRules.register("disableElytraMovementCheck", Category.PLAYER, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_MAX_ENTITY_CRAMMING = GameRules.register("maxEntityCramming", Category.MOBS, IntegerValue.create(24));
    public static final Key<BooleanValue> RULE_WEATHER_CYCLE = GameRules.register("doWeatherCycle", Category.UPDATES, BooleanValue.create(!SharedConstants.DEBUG_WORLD_RECREATE));
    public static final Key<BooleanValue> RULE_LIMITED_CRAFTING = GameRules.register("doLimitedCrafting", Category.PLAYER, BooleanValue.create(false, (level, value) -> {
        for (ServerPlayer serverPlayer : level.players()) {
            serverPlayer.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.LIMITED_CRAFTING, value.get() ? 1.0f : 0.0f));
        }
    }));
    public static final Key<IntegerValue> RULE_MAX_COMMAND_CHAIN_LENGTH = GameRules.register("maxCommandChainLength", Category.MISC, IntegerValue.create(65536));
    public static final Key<IntegerValue> RULE_MAX_COMMAND_FORK_COUNT = GameRules.register("maxCommandForkCount", Category.MISC, IntegerValue.create(65536));
    public static final Key<IntegerValue> RULE_COMMAND_MODIFICATION_BLOCK_LIMIT = GameRules.register("commandModificationBlockLimit", Category.MISC, IntegerValue.create(32768));
    public static final Key<BooleanValue> RULE_ANNOUNCE_ADVANCEMENTS = GameRules.register("announceAdvancements", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DISABLE_RAIDS = GameRules.register("disableRaids", Category.MOBS, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DOINSOMNIA = GameRules.register("doInsomnia", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_IMMEDIATE_RESPAWN = GameRules.register("doImmediateRespawn", Category.PLAYER, BooleanValue.create(false, (level, value) -> {
        for (ServerPlayer serverPlayer : level.players()) {
            serverPlayer.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.IMMEDIATE_RESPAWN, value.get() ? 1.0f : 0.0f));
        }
    }));
    public static final Key<IntegerValue> RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY = GameRules.register("playersNetherPortalDefaultDelay", Category.PLAYER, IntegerValue.create(80));
    public static final Key<IntegerValue> RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY = GameRules.register("playersNetherPortalCreativeDelay", Category.PLAYER, IntegerValue.create(0));
    public static final Key<BooleanValue> RULE_DROWNING_DAMAGE = GameRules.register("drowningDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FALL_DAMAGE = GameRules.register("fallDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FIRE_DAMAGE = GameRules.register("fireDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FREEZE_DAMAGE = GameRules.register("freezeDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_PATROL_SPAWNING = GameRules.register("doPatrolSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_TRADER_SPAWNING = GameRules.register("doTraderSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_WARDEN_SPAWNING = GameRules.register("doWardenSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FORGIVE_DEAD_PLAYERS = GameRules.register("forgiveDeadPlayers", Category.MOBS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_UNIVERSAL_ANGER = GameRules.register("universalAnger", Category.MOBS, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_PLAYERS_SLEEPING_PERCENTAGE = GameRules.register("playersSleepingPercentage", Category.PLAYER, IntegerValue.create(100));
    public static final Key<BooleanValue> RULE_BLOCK_EXPLOSION_DROP_DECAY = GameRules.register("blockExplosionDropDecay", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_MOB_EXPLOSION_DROP_DECAY = GameRules.register("mobExplosionDropDecay", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_TNT_EXPLOSION_DROP_DECAY = GameRules.register("tntExplosionDropDecay", Category.DROPS, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_SNOW_ACCUMULATION_HEIGHT = GameRules.register("snowAccumulationHeight", Category.UPDATES, IntegerValue.create(1));
    public static final Key<BooleanValue> RULE_WATER_SOURCE_CONVERSION = GameRules.register("waterSourceConversion", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_LAVA_SOURCE_CONVERSION = GameRules.register("lavaSourceConversion", Category.UPDATES, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_GLOBAL_SOUND_EVENTS = GameRules.register("globalSoundEvents", Category.MISC, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_VINES_SPREAD = GameRules.register("doVinesSpread", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_ENDER_PEARLS_VANISH_ON_DEATH = GameRules.register("enderPearlsVanishOnDeath", Category.PLAYER, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_MINECART_MAX_SPEED = GameRules.register("minecartMaxSpeed", Category.MISC, IntegerValue.create(8, 1, GameRules.limit(1000, Integer.MAX_VALUE), FeatureFlagSet.of(FeatureFlags.MINECART_IMPROVEMENTS), (server, value) -> {}));
    public static final Key<BooleanValue> RULE_TNT_EXPLODES = GameRules.register("tntExplodes", Category.MISC, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_LOCATOR_BAR = GameRules.register("locatorBar", Category.PLAYER, BooleanValue.create(true, (minecraftServer, value) -> Optional.of(minecraftServer).ifPresent(level -> {
        ServerWaypointManager waypointManager = level.getWaypointManager();
        if (value.get()) {
            level.players().forEach(waypointManager::updatePlayer);
        } else {
            waypointManager.breakAllConnections();
        }
    })));
    public static final Key<BooleanValue> RULE_PVP = GameRules.register("pvp", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_ALLOW_NETHER = GameRules.register("allowEnteringNetherUsingPortals", Category.MISC, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_SPAWN_MONSTERS = GameRules.register("spawnMonsters", Category.SPAWNING, BooleanValue.create(true, (level, value) -> level.setSpawnSettings(level.serverLevelData.getDifficulty() != Difficulty.PEACEFUL && level.getGameRules().getBoolean(RULE_SPAWN_MONSTERS))));
    public static final Key<BooleanValue> RULE_COMMAND_BLOCKS_ENABLED = GameRules.register("commandBlocksEnabled", Category.MISC, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_SPAWNER_BLOCKS_ENABLED = GameRules.register("spawnerBlocksEnabled", Category.MISC, BooleanValue.create(true));
    private final Map<Key<?>, Value<?>> rules;
    private final FeatureFlagSet enabledFeatures;
    private final Value<?>[] gameruleArray;

    private static int limit(int limit, int unlimited) {
        return DISABLE_LIMITS ? unlimited : limit;
    }

    public static <T extends Value<T>> Type<T> getType(Key<T> key) {
        return GAME_RULE_TYPES.get(key);
    }

    public static <T extends Value<T>> Codec<Key<T>> keyCodec(Class<T> clazz) {
        return Codec.STRING.comapFlatMap(string -> GAME_RULE_TYPES.entrySet().stream().filter(entry -> ((Type)entry.getValue()).valueClass == clazz).map(Map.Entry::getKey).filter(key -> key.getId().equals(string)).map(key -> key).findFirst().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Invalid game rule ID for type: " + string)), Key::getId);
    }

    private static <T extends Value<T>> Key<T> register(String name, Category category, Type<T> type) {
        Key key = new Key(name, category);
        Type<T> type1 = GAME_RULE_TYPES.put(key, type);
        if (type1 != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + name);
        }
        return key;
    }

    public GameRules(FeatureFlagSet enabledFeatures, DynamicLike<?> tag) {
        this(enabledFeatures);
        this.loadFromTag(tag);
    }

    public GameRules(FeatureFlagSet enabledFeatures) {
        this((Map)GameRules.availableRules(enabledFeatures).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Type)entry.getValue()).createRule())), enabledFeatures);
    }

    public static Stream<Map.Entry<Key<?>, Type<?>>> availableRules(FeatureFlagSet enabledFeatures) {
        return GAME_RULE_TYPES.entrySet().stream().filter(entry -> ((Type)entry.getValue()).requiredFeatures.isSubsetOf(enabledFeatures));
    }

    private GameRules(Map<Key<?>, Value<?>> rules, FeatureFlagSet enabledFeatures) {
        this.rules = rules;
        this.enabledFeatures = enabledFeatures;
        int arraySize = Key.lastGameRuleIndex + 1;
        Value[] values = new Value[arraySize];
        for (Map.Entry<Key<?>, Value<?>> entry : rules.entrySet()) {
            values[entry.getKey().gameRuleIndex] = entry.getValue();
        }
        this.gameruleArray = values;
    }

    public <T extends Value<T>> T getRule(Key<T> key) {
        Value<?> value;
        Value<?> value2 = value = key == null ? null : this.gameruleArray[key.gameRuleIndex];
        if (value == null) {
            throw new IllegalArgumentException("Tried to access invalid game rule");
        }
        return (T)value;
    }

    public CompoundTag createTag() {
        CompoundTag compoundTag = new CompoundTag();
        this.rules.forEach((key, value) -> compoundTag.putString(key.id, value.serialize()));
        return compoundTag;
    }

    private void loadFromTag(DynamicLike<?> dynamic) {
        this.rules.forEach((key, value) -> dynamic.get(key.id).asString().ifSuccess(value::deserialize));
    }

    public GameRules copy(FeatureFlagSet enabledFeatures) {
        return new GameRules((Map)GameRules.availableRules(enabledFeatures).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.rules.containsKey(entry.getKey()) ? this.rules.get(entry.getKey()).copy() : ((Type)entry.getValue()).createRule())), enabledFeatures);
    }

    public void visitGameRuleTypes(GameRuleTypeVisitor visitor) {
        GAME_RULE_TYPES.forEach((key, type) -> this.callVisitorCap(visitor, (Key<?>)key, (Type<?>)type));
    }

    private <T extends Value<T>> void callVisitorCap(GameRuleTypeVisitor visitor, Key<?> key, Type<?> type) {
        if (type.requiredFeatures.isSubsetOf(this.enabledFeatures)) {
            visitor.visit(key, type);
            type.callVisitor(visitor, key);
        }
    }

    public void assignFrom(GameRules rules, @Nullable ServerLevel level) {
        rules.rules.keySet().forEach(key -> this.assignCap((Key)key, rules, level));
    }

    private <T extends Value<T>> void assignCap(Key<T> key, GameRules rules, @Nullable ServerLevel level) {
        T rule = rules.getRule(key);
        ((Value)this.getRule(key)).setFrom(rule, level);
    }

    public boolean getBoolean(Key<BooleanValue> key) {
        return this.getRule(key).get();
    }

    public int getInt(Key<IntegerValue> key) {
        return this.getRule(key).get();
    }

    public static class Type<T extends Value<T>> {
        final Supplier<ArgumentType<?>> argument;
        private final Function<Type<T>, T> constructor;
        final BiConsumer<ServerLevel, T> callback;
        private final VisitorCaller<T> visitorCaller;
        final Class<T> valueClass;
        final FeatureFlagSet requiredFeatures;

        Type(Supplier<ArgumentType<?>> argument, Function<Type<T>, T> constructor, BiConsumer<ServerLevel, T> callback, VisitorCaller<T> visitorCaller, Class<T> valueClass, FeatureFlagSet requiredFeatures) {
            this.argument = argument;
            this.constructor = constructor;
            this.callback = callback;
            this.visitorCaller = visitorCaller;
            this.valueClass = valueClass;
            this.requiredFeatures = requiredFeatures;
        }

        public RequiredArgumentBuilder<CommandSourceStack, ?> createArgument(String name) {
            return Commands.argument(name, this.argument.get());
        }

        public T createRule() {
            return (T)((Value)this.constructor.apply(this));
        }

        public void callVisitor(GameRuleTypeVisitor visitor, Key<T> key) {
            this.visitorCaller.call(visitor, key, this);
        }

        public FeatureFlagSet requiredFeatures() {
            return this.requiredFeatures;
        }

        public FeatureElement asFeatureElement() {
            return this::requiredFeatures;
        }
    }

    public static final class Key<T extends Value<T>> {
        public static int lastGameRuleIndex = 0;
        public final int gameRuleIndex = lastGameRuleIndex++;
        final String id;
        private final Category category;

        public Key(String id, Category category) {
            this.id = id;
            this.category = category;
        }

        public String toString() {
            return this.id;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Key && ((Key)other).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String getId() {
            return this.id;
        }

        public String getDescriptionId() {
            return "gamerule." + this.id;
        }

        public Category getCategory() {
            return this.category;
        }
    }

    public static enum Category {
        PLAYER("gamerule.category.player"),
        MOBS("gamerule.category.mobs"),
        SPAWNING("gamerule.category.spawning"),
        DROPS("gamerule.category.drops"),
        UPDATES("gamerule.category.updates"),
        CHAT("gamerule.category.chat"),
        MISC("gamerule.category.misc");

        private final String descriptionId;

        private Category(String descriptionId) {
            this.descriptionId = descriptionId;
        }

        public String getDescriptionId() {
            return this.descriptionId;
        }
    }

    public static abstract class Value<T extends Value<T>> {
        protected final Type<T> type;

        public Value(Type<T> type) {
            this.type = type;
        }

        protected abstract void updateFromArgument(CommandContext<CommandSourceStack> var1, String var2, Key<T> var3);

        public void setFromArgument(CommandContext<CommandSourceStack> context, String paramName, Key<T> gameRuleKey) {
            this.updateFromArgument(context, paramName, gameRuleKey);
            this.onChanged(((CommandSourceStack)context.getSource()).getLevel());
        }

        public void onChanged(@Nullable ServerLevel level) {
            if (level != null) {
                this.type.callback.accept(level, (ServerLevel)this.getSelf());
            }
        }

        public abstract void deserialize(String var1);

        public abstract String serialize();

        public String toString() {
            return this.serialize();
        }

        public abstract int getCommandResult();

        protected abstract T getSelf();

        protected abstract T copy();

        public abstract void setFrom(T var1, @Nullable ServerLevel var2);
    }

    public static interface GameRuleTypeVisitor {
        default public <T extends Value<T>> void visit(Key<T> key, Type<T> type) {
        }

        default public void visitBoolean(Key<BooleanValue> key, Type<BooleanValue> type) {
        }

        default public void visitInteger(Key<IntegerValue> key, Type<IntegerValue> type) {
        }
    }

    public static class BooleanValue
    extends Value<BooleanValue> {
        private boolean value;

        private static Type<BooleanValue> create(boolean defaultValue, BiConsumer<ServerLevel, BooleanValue> changeListener, FeatureFlagSet requiredFeatures) {
            return new Type<BooleanValue>(BoolArgumentType::bool, type -> new BooleanValue((Type<BooleanValue>)type, defaultValue), changeListener, GameRuleTypeVisitor::visitBoolean, BooleanValue.class, requiredFeatures);
        }

        static Type<BooleanValue> create(boolean defaultValue, BiConsumer<ServerLevel, BooleanValue> changeListener) {
            return new Type<BooleanValue>(BoolArgumentType::bool, type -> new BooleanValue((Type<BooleanValue>)type, defaultValue), changeListener, GameRuleTypeVisitor::visitBoolean, BooleanValue.class, FeatureFlagSet.of());
        }

        public static Type<BooleanValue> create(boolean defaultValue) {
            return BooleanValue.create(defaultValue, (minecraftServer, booleanValue) -> {});
        }

        public BooleanValue(Type<BooleanValue> type, boolean value) {
            super(type);
            this.value = value;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandSourceStack> context, String paramName, Key<BooleanValue> gameRuleKey) {
            WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent(((CommandSourceStack)context.getSource()).getBukkitWorld(), ((CommandSourceStack)context.getSource()).getBukkitSender(), GameRule.getByName((String)gameRuleKey.toString()), String.valueOf(BoolArgumentType.getBool(context, (String)paramName)));
            if (!event.callEvent()) {
                return;
            }
            this.value = Boolean.parseBoolean(event.getValue());
        }

        public boolean get() {
            return this.value;
        }

        public void set(boolean value, @Nullable ServerLevel level) {
            this.value = value;
            this.onChanged(level);
        }

        @Override
        public String serialize() {
            return Boolean.toString(this.value);
        }

        @Override
        public void deserialize(String value) {
            this.value = Boolean.parseBoolean(value);
        }

        @Override
        public int getCommandResult() {
            return this.value ? 1 : 0;
        }

        @Override
        protected BooleanValue getSelf() {
            return this;
        }

        @Override
        protected BooleanValue copy() {
            return new BooleanValue(this.type, this.value);
        }

        @Override
        public void setFrom(BooleanValue value, @Nullable ServerLevel level) {
            this.value = value.value;
            this.onChanged(level);
        }
    }

    public static class IntegerValue
    extends Value<IntegerValue> {
        private int value;

        private static Type<IntegerValue> create(int defaultValue, BiConsumer<ServerLevel, IntegerValue> changeListener) {
            return new Type<IntegerValue>(IntegerArgumentType::integer, type -> new IntegerValue((Type<IntegerValue>)type, defaultValue), changeListener, GameRuleTypeVisitor::visitInteger, IntegerValue.class, FeatureFlagSet.of());
        }

        static Type<IntegerValue> create(int defaultValue, int min, int max, FeatureFlagSet requiredFeatures, BiConsumer<ServerLevel, IntegerValue> changeListener) {
            return new Type<IntegerValue>(() -> IntegerArgumentType.integer((int)min, (int)max), type -> new IntegerValue((Type<IntegerValue>)type, defaultValue), changeListener, GameRuleTypeVisitor::visitInteger, IntegerValue.class, requiredFeatures);
        }

        public static Type<IntegerValue> create(int defaultValue) {
            return IntegerValue.create(defaultValue, (server, value) -> {});
        }

        public IntegerValue(Type<IntegerValue> type, int value) {
            super(type);
            this.value = value;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandSourceStack> context, String paramName, Key<IntegerValue> gameRuleKey) {
            WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent(((CommandSourceStack)context.getSource()).getBukkitWorld(), ((CommandSourceStack)context.getSource()).getBukkitSender(), GameRule.getByName((String)gameRuleKey.toString()), String.valueOf(IntegerArgumentType.getInteger(context, (String)paramName)));
            if (!event.callEvent()) {
                return;
            }
            this.value = Integer.parseInt(event.getValue());
        }

        public int get() {
            return this.value;
        }

        public void set(int value, @Nullable ServerLevel level) {
            this.value = value;
            this.onChanged(level);
        }

        @Override
        public String serialize() {
            return Integer.toString(this.value);
        }

        @Override
        public void deserialize(String value) {
            this.value = IntegerValue.safeParse(value);
        }

        public boolean tryDeserialize(String name) {
            try {
                StringReader stringReader = new StringReader(name);
                this.value = (Integer)this.type.argument.get().parse(stringReader);
                return !stringReader.canRead();
            }
            catch (CommandSyntaxException var3) {
                return false;
            }
        }

        private static int safeParse(String value) {
            if (!value.isEmpty()) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException var2) {
                    LOGGER.warn("Failed to parse integer {}", (Object)value);
                }
            }
            return 0;
        }

        @Override
        public int getCommandResult() {
            return this.value;
        }

        @Override
        protected IntegerValue getSelf() {
            return this;
        }

        @Override
        protected IntegerValue copy() {
            return new IntegerValue(this.type, this.value);
        }

        @Override
        public void setFrom(IntegerValue value, @Nullable ServerLevel level) {
            this.value = value.value;
            this.onChanged(level);
        }
    }

    static interface VisitorCaller<T extends Value<T>> {
        public void call(GameRuleTypeVisitor var1, Key<T> var2, Type<T> var3);
    }
}

