/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.references.Items;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BarrierBlock;
import net.minecraft.world.level.block.BaseCoralFanBlock;
import net.minecraft.world.level.block.BaseCoralPlantBlock;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableFeaturePlacerBlock;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CactusFlowerBlock;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CalibratedSculkSensorBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.CartographyTableBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.ConduitBlock;
import net.minecraft.world.level.block.CopperBulbBlock;
import net.minecraft.world.level.block.CopperChestBlock;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.CoralFanBlock;
import net.minecraft.world.level.block.CoralPlantBlock;
import net.minecraft.world.level.block.CoralWallFanBlock;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.CryingObsidianBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DragonEggBlock;
import net.minecraft.world.level.block.DriedGhastBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.DryVegetationBlock;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.EndGatewayBlock;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.EyeblossomBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FireflyBushBlock;
import net.minecraft.world.level.block.FlowerBedBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.FrogspawnBlock;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.HangingRootsBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.HeavyCoreBlock;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.InfestedRotatedPillarBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LavaCauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LeafLitterBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LoomBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.MangroveLeavesBlock;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.MudBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.NetherSproutsBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.NetherrackBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.NyliumBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.PiglinWallSkullBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.PlayerHeadBlock;
import net.minecraft.world.level.block.PlayerWallHeadBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.PoweredBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.RootedDirtBlock;
import net.minecraft.world.level.block.RootsBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.SculkBlock;
import net.minecraft.world.level.block.SculkCatalystBlock;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.ShelfBlock;
import net.minecraft.world.level.block.ShortDryGrassBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.SmithingTableBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.SnifferEggBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.SoulSandBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.SpongeBlock;
import net.minecraft.world.level.block.SporeBlossomBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.StructureVoidBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallDryGrassBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.TestBlock;
import net.minecraft.world.level.block.TestInstanceBlock;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.TintedParticleLeavesBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.TwistingVinesBlock;
import net.minecraft.world.level.block.TwistingVinesPlantBlock;
import net.minecraft.world.level.block.UntintedParticleLeavesBlock;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.WaterloggedTransparentBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.WeatheringCopperBarsBlock;
import net.minecraft.world.level.block.WeatheringCopperBlocks;
import net.minecraft.world.level.block.WeatheringCopperBulbBlock;
import net.minecraft.world.level.block.WeatheringCopperChainBlock;
import net.minecraft.world.level.block.WeatheringCopperChestBlock;
import net.minecraft.world.level.block.WeatheringCopperDoorBlock;
import net.minecraft.world.level.block.WeatheringCopperFullBlock;
import net.minecraft.world.level.block.WeatheringCopperGolemStatueBlock;
import net.minecraft.world.level.block.WeatheringCopperGrateBlock;
import net.minecraft.world.level.block.WeatheringCopperSlabBlock;
import net.minecraft.world.level.block.WeatheringCopperStairBlock;
import net.minecraft.world.level.block.WeatheringCopperTrapDoorBlock;
import net.minecraft.world.level.block.WeatheringLanternBlock;
import net.minecraft.world.level.block.WeatheringLightningRodBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.WeepingVinesBlock;
import net.minecraft.world.level.block.WeepingVinesPlantBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.WetSpongeBlock;
import net.minecraft.world.level.block.WitherRoseBlock;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.WitherWallSkullBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.apache.commons.lang3.function.TriFunction;

public class Blocks {
    private static final BlockBehaviour.StatePredicate NOT_CLOSED_SHULKER = (state, level, pos) -> {
        ShulkerBoxBlockEntity shulkerBoxBlockEntity;
        BlockEntity patt0$temp = level.getBlockEntity(pos);
        return !(patt0$temp instanceof ShulkerBoxBlockEntity) || (shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)patt0$temp).isClosed();
    };
    private static final BlockBehaviour.StatePredicate NOT_EXTENDED_PISTON = (state, level, pos) -> state.getValue(PistonBaseBlock.EXTENDED) == false;
    public static final Block AIR = Blocks.register("air", AirBlock::new, BlockBehaviour.Properties.of().replaceable().noCollision().noLootTable().air());
    public static final Block STONE = Blocks.register("stone", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block GRANITE = Blocks.register("granite", BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block POLISHED_GRANITE = Blocks.register("polished_granite", BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DIORITE = Blocks.register("diorite", BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block POLISHED_DIORITE = Blocks.register("polished_diorite", BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block ANDESITE = Blocks.register("andesite", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block POLISHED_ANDESITE = Blocks.register("polished_andesite", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block GRASS_BLOCK = Blocks.register("grass_block", GrassBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).randomTicks().strength(0.6f).sound(SoundType.GRASS));
    public static final Block DIRT = Blocks.register("dirt", BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(0.5f).sound(SoundType.GRAVEL));
    public static final Block COARSE_DIRT = Blocks.register("coarse_dirt", BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(0.5f).sound(SoundType.GRAVEL));
    public static final Block PODZOL = Blocks.register("podzol", SnowyDirtBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).strength(0.5f).sound(SoundType.GRAVEL));
    public static final Block COBBLESTONE = Blocks.register("cobblestone", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block OAK_PLANKS = Blocks.register("oak_planks", BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block SPRUCE_PLANKS = Blocks.register("spruce_planks", BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BIRCH_PLANKS = Blocks.register("birch_planks", BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block JUNGLE_PLANKS = Blocks.register("jungle_planks", BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block ACACIA_PLANKS = Blocks.register("acacia_planks", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block CHERRY_PLANKS = Blocks.register("cherry_planks", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD).ignitedByLava());
    public static final Block DARK_OAK_PLANKS = Blocks.register("dark_oak_planks", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block PALE_OAK_WOOD = Blocks.register("pale_oak_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block PALE_OAK_PLANKS = Blocks.register("pale_oak_planks", BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block MANGROVE_PLANKS = Blocks.register("mangrove_planks", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BAMBOO_PLANKS = Blocks.register("bamboo_planks", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.BAMBOO_WOOD).ignitedByLava());
    public static final Block BAMBOO_MOSAIC = Blocks.register("bamboo_mosaic", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.BAMBOO_WOOD).ignitedByLava());
    public static final Block OAK_SAPLING = Blocks.register("oak_sapling", (BlockBehaviour.Properties properties) -> new SaplingBlock(TreeGrower.OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block SPRUCE_SAPLING = Blocks.register("spruce_sapling", (BlockBehaviour.Properties properties) -> new SaplingBlock(TreeGrower.SPRUCE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block BIRCH_SAPLING = Blocks.register("birch_sapling", (BlockBehaviour.Properties properties) -> new SaplingBlock(TreeGrower.BIRCH, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block JUNGLE_SAPLING = Blocks.register("jungle_sapling", (BlockBehaviour.Properties properties) -> new SaplingBlock(TreeGrower.JUNGLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block ACACIA_SAPLING = Blocks.register("acacia_sapling", (BlockBehaviour.Properties properties) -> new SaplingBlock(TreeGrower.ACACIA, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block CHERRY_SAPLING = Blocks.register("cherry_sapling", (BlockBehaviour.Properties properties) -> new SaplingBlock(TreeGrower.CHERRY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).noCollision().randomTicks().instabreak().sound(SoundType.CHERRY_SAPLING).pushReaction(PushReaction.DESTROY));
    public static final Block DARK_OAK_SAPLING = Blocks.register("dark_oak_sapling", (BlockBehaviour.Properties properties) -> new SaplingBlock(TreeGrower.DARK_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block PALE_OAK_SAPLING = Blocks.register("pale_oak_sapling", (BlockBehaviour.Properties properties) -> new SaplingBlock(TreeGrower.PALE_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block MANGROVE_PROPAGULE = Blocks.register("mangrove_propagule", (BlockBehaviour.Properties properties) -> new MangrovePropaguleBlock(TreeGrower.MANGROVE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block BEDROCK = Blocks.register("bedrock", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(-1.0f, 3600000.0f).noLootTable().isValidSpawn(Blocks::never));
    public static final Block WATER = Blocks.register("water", (BlockBehaviour.Properties properties) -> new LiquidBlock(Fluids.WATER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WATER).replaceable().noCollision().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().liquid().sound(SoundType.EMPTY));
    public static final Block LAVA = Blocks.register("lava", (BlockBehaviour.Properties properties) -> new LiquidBlock(Fluids.LAVA, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.FIRE).replaceable().noCollision().randomTicks().strength(100.0f).lightLevel(blockState1 -> 15).pushReaction(PushReaction.DESTROY).noLootTable().liquid().sound(SoundType.EMPTY));
    public static final Block SAND = Blocks.register("sand", (BlockBehaviour.Properties properties) -> new SandBlock(new ColorRGBA(14406560), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block SUSPICIOUS_SAND = Blocks.register("suspicious_sand", (BlockBehaviour.Properties properties) -> new BrushableBlock(SAND, SoundEvents.BRUSH_SAND, SoundEvents.BRUSH_SAND, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.SNARE).strength(0.25f).sound(SoundType.SUSPICIOUS_SAND).pushReaction(PushReaction.DESTROY));
    public static final Block RED_SAND = Blocks.register("red_sand", (BlockBehaviour.Properties properties) -> new SandBlock(new ColorRGBA(11098145), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block GRAVEL = Blocks.register("gravel", (BlockBehaviour.Properties properties) -> new ColoredFallingBlock(new ColorRGBA(-8356741), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.SNARE).strength(0.6f).sound(SoundType.GRAVEL));
    public static final Block SUSPICIOUS_GRAVEL = Blocks.register("suspicious_gravel", (BlockBehaviour.Properties properties) -> new BrushableBlock(GRAVEL, SoundEvents.BRUSH_GRAVEL, SoundEvents.BRUSH_GRAVEL, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.SNARE).strength(0.25f).sound(SoundType.SUSPICIOUS_GRAVEL).pushReaction(PushReaction.DESTROY));
    public static final Block GOLD_ORE = Blocks.register("gold_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(ConstantInt.of(0), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_GOLD_ORE = Blocks.register("deepslate_gold_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(ConstantInt.of(0), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(GOLD_ORE).mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE));
    public static final Block IRON_ORE = Blocks.register("iron_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(ConstantInt.of(0), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_IRON_ORE = Blocks.register("deepslate_iron_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(ConstantInt.of(0), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(IRON_ORE).mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE));
    public static final Block COAL_ORE = Blocks.register("coal_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(UniformInt.of(0, 2), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_COAL_ORE = Blocks.register("deepslate_coal_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(UniformInt.of(0, 2), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(COAL_ORE).mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE));
    public static final Block NETHER_GOLD_ORE = Blocks.register("nether_gold_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(UniformInt.of(0, 1), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f).sound(SoundType.NETHER_GOLD_ORE));
    public static final Block OAK_LOG = Blocks.register("oak_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.WOOD, MapColor.PODZOL, SoundType.WOOD));
    public static final Block SPRUCE_LOG = Blocks.register("spruce_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.PODZOL, MapColor.COLOR_BROWN, SoundType.WOOD));
    public static final Block BIRCH_LOG = Blocks.register("birch_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.SAND, MapColor.QUARTZ, SoundType.WOOD));
    public static final Block JUNGLE_LOG = Blocks.register("jungle_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.DIRT, MapColor.PODZOL, SoundType.WOOD));
    public static final Block ACACIA_LOG = Blocks.register("acacia_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.COLOR_ORANGE, MapColor.STONE, SoundType.WOOD));
    public static final Block CHERRY_LOG = Blocks.register("cherry_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.TERRACOTTA_WHITE, MapColor.TERRACOTTA_GRAY, SoundType.CHERRY_WOOD));
    public static final Block DARK_OAK_LOG = Blocks.register("dark_oak_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.COLOR_BROWN, MapColor.COLOR_BROWN, SoundType.WOOD));
    public static final Block PALE_OAK_LOG = Blocks.register("pale_oak_log", RotatedPillarBlock::new, Blocks.logProperties(PALE_OAK_PLANKS.defaultMapColor(), PALE_OAK_WOOD.defaultMapColor(), SoundType.WOOD));
    public static final Block MANGROVE_LOG = Blocks.register("mangrove_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.COLOR_RED, MapColor.PODZOL, SoundType.WOOD));
    public static final Block MANGROVE_ROOTS = Blocks.register("mangrove_roots", MangroveRootsBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(0.7f).sound(SoundType.MANGROVE_ROOTS).noOcclusion().isSuffocating(Blocks::never).isViewBlocking(Blocks::never).noOcclusion().ignitedByLava());
    public static final Block MUDDY_MANGROVE_ROOTS = Blocks.register("muddy_mangrove_roots", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).strength(0.7f).sound(SoundType.MUDDY_MANGROVE_ROOTS));
    public static final Block BAMBOO_BLOCK = Blocks.register("bamboo_block", RotatedPillarBlock::new, Blocks.logProperties(MapColor.COLOR_YELLOW, MapColor.PLANT, SoundType.BAMBOO_WOOD));
    public static final Block STRIPPED_SPRUCE_LOG = Blocks.register("stripped_spruce_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.PODZOL, MapColor.PODZOL, SoundType.WOOD));
    public static final Block STRIPPED_BIRCH_LOG = Blocks.register("stripped_birch_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.SAND, MapColor.SAND, SoundType.WOOD));
    public static final Block STRIPPED_JUNGLE_LOG = Blocks.register("stripped_jungle_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.DIRT, MapColor.DIRT, SoundType.WOOD));
    public static final Block STRIPPED_ACACIA_LOG = Blocks.register("stripped_acacia_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.COLOR_ORANGE, MapColor.COLOR_ORANGE, SoundType.WOOD));
    public static final Block STRIPPED_CHERRY_LOG = Blocks.register("stripped_cherry_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.TERRACOTTA_WHITE, MapColor.TERRACOTTA_PINK, SoundType.CHERRY_WOOD));
    public static final Block STRIPPED_DARK_OAK_LOG = Blocks.register("stripped_dark_oak_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.COLOR_BROWN, MapColor.COLOR_BROWN, SoundType.WOOD));
    public static final Block STRIPPED_PALE_OAK_LOG = Blocks.register("stripped_pale_oak_log", RotatedPillarBlock::new, Blocks.logProperties(PALE_OAK_PLANKS.defaultMapColor(), PALE_OAK_PLANKS.defaultMapColor(), SoundType.WOOD));
    public static final Block STRIPPED_OAK_LOG = Blocks.register("stripped_oak_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.WOOD, MapColor.WOOD, SoundType.WOOD));
    public static final Block STRIPPED_MANGROVE_LOG = Blocks.register("stripped_mangrove_log", RotatedPillarBlock::new, Blocks.logProperties(MapColor.COLOR_RED, MapColor.COLOR_RED, SoundType.WOOD));
    public static final Block STRIPPED_BAMBOO_BLOCK = Blocks.register("stripped_bamboo_block", RotatedPillarBlock::new, Blocks.logProperties(MapColor.COLOR_YELLOW, MapColor.COLOR_YELLOW, SoundType.BAMBOO_WOOD));
    public static final Block OAK_WOOD = Blocks.register("oak_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block SPRUCE_WOOD = Blocks.register("spruce_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BIRCH_WOOD = Blocks.register("birch_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block JUNGLE_WOOD = Blocks.register("jungle_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block ACACIA_WOOD = Blocks.register("acacia_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block CHERRY_WOOD = Blocks.register("cherry_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_GRAY).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.CHERRY_WOOD).ignitedByLava());
    public static final Block DARK_OAK_WOOD = Blocks.register("dark_oak_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block MANGROVE_WOOD = Blocks.register("mangrove_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block STRIPPED_OAK_WOOD = Blocks.register("stripped_oak_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block STRIPPED_SPRUCE_WOOD = Blocks.register("stripped_spruce_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block STRIPPED_BIRCH_WOOD = Blocks.register("stripped_birch_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block STRIPPED_JUNGLE_WOOD = Blocks.register("stripped_jungle_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block STRIPPED_ACACIA_WOOD = Blocks.register("stripped_acacia_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block STRIPPED_CHERRY_WOOD = Blocks.register("stripped_cherry_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PINK).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.CHERRY_WOOD).ignitedByLava());
    public static final Block STRIPPED_DARK_OAK_WOOD = Blocks.register("stripped_dark_oak_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block STRIPPED_PALE_OAK_WOOD = Blocks.register("stripped_pale_oak_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block STRIPPED_MANGROVE_WOOD = Blocks.register("stripped_mangrove_wood", RotatedPillarBlock::new, Blocks.logProperties(MapColor.COLOR_RED, MapColor.COLOR_RED, SoundType.WOOD));
    public static final Block OAK_LEAVES = Blocks.register("oak_leaves", (BlockBehaviour.Properties properties) -> new TintedParticleLeavesBlock(0.01f, (BlockBehaviour.Properties)properties), Blocks.leavesProperties(SoundType.GRASS));
    public static final Block SPRUCE_LEAVES = Blocks.register("spruce_leaves", (BlockBehaviour.Properties properties) -> new TintedParticleLeavesBlock(0.01f, (BlockBehaviour.Properties)properties), Blocks.leavesProperties(SoundType.GRASS));
    public static final Block BIRCH_LEAVES = Blocks.register("birch_leaves", (BlockBehaviour.Properties properties) -> new TintedParticleLeavesBlock(0.01f, (BlockBehaviour.Properties)properties), Blocks.leavesProperties(SoundType.GRASS));
    public static final Block JUNGLE_LEAVES = Blocks.register("jungle_leaves", (BlockBehaviour.Properties properties) -> new TintedParticleLeavesBlock(0.01f, (BlockBehaviour.Properties)properties), Blocks.leavesProperties(SoundType.GRASS));
    public static final Block ACACIA_LEAVES = Blocks.register("acacia_leaves", (BlockBehaviour.Properties properties) -> new TintedParticleLeavesBlock(0.01f, (BlockBehaviour.Properties)properties), Blocks.leavesProperties(SoundType.GRASS));
    public static final Block CHERRY_LEAVES = Blocks.register("cherry_leaves", (BlockBehaviour.Properties properties) -> new UntintedParticleLeavesBlock(0.1f, ParticleTypes.CHERRY_LEAVES, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).strength(0.2f).randomTicks().sound(SoundType.CHERRY_LEAVES).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating(Blocks::never).isViewBlocking(Blocks::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(Blocks::never));
    public static final Block DARK_OAK_LEAVES = Blocks.register("dark_oak_leaves", (BlockBehaviour.Properties properties) -> new TintedParticleLeavesBlock(0.01f, (BlockBehaviour.Properties)properties), Blocks.leavesProperties(SoundType.GRASS));
    public static final Block PALE_OAK_LEAVES = Blocks.register("pale_oak_leaves", (BlockBehaviour.Properties properties) -> new UntintedParticleLeavesBlock(0.02f, ParticleTypes.PALE_OAK_LEAVES, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating(Blocks::never).isViewBlocking(Blocks::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(Blocks::never));
    public static final Block MANGROVE_LEAVES = Blocks.register("mangrove_leaves", (BlockBehaviour.Properties properties) -> new MangroveLeavesBlock(0.01f, (BlockBehaviour.Properties)properties), Blocks.leavesProperties(SoundType.GRASS));
    public static final Block AZALEA_LEAVES = Blocks.register("azalea_leaves", (BlockBehaviour.Properties properties) -> new UntintedParticleLeavesBlock(0.01f, ColorParticleOption.create(ParticleTypes.TINTED_LEAVES, -9399763), (BlockBehaviour.Properties)properties), Blocks.leavesProperties(SoundType.AZALEA_LEAVES));
    public static final Block FLOWERING_AZALEA_LEAVES = Blocks.register("flowering_azalea_leaves", (BlockBehaviour.Properties properties) -> new UntintedParticleLeavesBlock(0.01f, ColorParticleOption.create(ParticleTypes.TINTED_LEAVES, -9399763), (BlockBehaviour.Properties)properties), Blocks.leavesProperties(SoundType.AZALEA_LEAVES));
    public static final Block SPONGE = Blocks.register("sponge", SpongeBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(0.6f).sound(SoundType.SPONGE));
    public static final Block WET_SPONGE = Blocks.register("wet_sponge", WetSpongeBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(0.6f).sound(SoundType.WET_SPONGE));
    public static final Block GLASS = Blocks.register("glass", TransparentBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn(Blocks::never).isRedstoneConductor(Blocks::never).isSuffocating(Blocks::never).isViewBlocking(Blocks::never));
    public static final Block LAPIS_ORE = Blocks.register("lapis_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(UniformInt.of(2, 5), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_LAPIS_ORE = Blocks.register("deepslate_lapis_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(UniformInt.of(2, 5), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(LAPIS_ORE).mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE));
    public static final Block LAPIS_BLOCK = Blocks.register("lapis_block", BlockBehaviour.Properties.of().mapColor(MapColor.LAPIS).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DISPENSER = Blocks.register("dispenser", DispenserBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f));
    public static final Block SANDSTONE = Blocks.register("sandstone", BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block CHISELED_SANDSTONE = Blocks.register("chiseled_sandstone", BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block CUT_SANDSTONE = Blocks.register("cut_sandstone", BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block NOTE_BLOCK = Blocks.register("note_block", NoteBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.WOOD).strength(0.8f).ignitedByLava());
    public static final Block WHITE_BED = Blocks.registerBed("white_bed", DyeColor.WHITE);
    public static final Block ORANGE_BED = Blocks.registerBed("orange_bed", DyeColor.ORANGE);
    public static final Block MAGENTA_BED = Blocks.registerBed("magenta_bed", DyeColor.MAGENTA);
    public static final Block LIGHT_BLUE_BED = Blocks.registerBed("light_blue_bed", DyeColor.LIGHT_BLUE);
    public static final Block YELLOW_BED = Blocks.registerBed("yellow_bed", DyeColor.YELLOW);
    public static final Block LIME_BED = Blocks.registerBed("lime_bed", DyeColor.LIME);
    public static final Block PINK_BED = Blocks.registerBed("pink_bed", DyeColor.PINK);
    public static final Block GRAY_BED = Blocks.registerBed("gray_bed", DyeColor.GRAY);
    public static final Block LIGHT_GRAY_BED = Blocks.registerBed("light_gray_bed", DyeColor.LIGHT_GRAY);
    public static final Block CYAN_BED = Blocks.registerBed("cyan_bed", DyeColor.CYAN);
    public static final Block PURPLE_BED = Blocks.registerBed("purple_bed", DyeColor.PURPLE);
    public static final Block BLUE_BED = Blocks.registerBed("blue_bed", DyeColor.BLUE);
    public static final Block BROWN_BED = Blocks.registerBed("brown_bed", DyeColor.BROWN);
    public static final Block GREEN_BED = Blocks.registerBed("green_bed", DyeColor.GREEN);
    public static final Block RED_BED = Blocks.registerBed("red_bed", DyeColor.RED);
    public static final Block BLACK_BED = Blocks.registerBed("black_bed", DyeColor.BLACK);
    public static final Block POWERED_RAIL = Blocks.register("powered_rail", PoweredRailBlock::new, BlockBehaviour.Properties.of().noCollision().strength(0.7f).sound(SoundType.METAL));
    public static final Block DETECTOR_RAIL = Blocks.register("detector_rail", DetectorRailBlock::new, BlockBehaviour.Properties.of().noCollision().strength(0.7f).sound(SoundType.METAL));
    public static final Block STICKY_PISTON = Blocks.register("sticky_piston", (BlockBehaviour.Properties properties) -> new PistonBaseBlock(true, (BlockBehaviour.Properties)properties), Blocks.pistonProperties());
    public static final Block COBWEB = Blocks.register("cobweb", WebBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).sound(SoundType.COBWEB).forceSolidOn().noCollision().requiresCorrectToolForDrops().strength(4.0f).pushReaction(PushReaction.DESTROY));
    public static final Block SHORT_GRASS = Blocks.register("short_grass", TallGrassBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).replaceable().noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XYZ).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block FERN = Blocks.register("fern", TallGrassBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).replaceable().noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XYZ).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block DEAD_BUSH = Blocks.register("dead_bush", DryVegetationBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).replaceable().noCollision().instabreak().sound(SoundType.GRASS).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block BUSH = Blocks.register("bush", BushBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).replaceable().noCollision().instabreak().sound(SoundType.GRASS).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block SHORT_DRY_GRASS = Blocks.register("short_dry_grass", ShortDryGrassBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).replaceable().noCollision().instabreak().sound(SoundType.GRASS).ignitedByLava().offsetType(BlockBehaviour.OffsetType.XYZ).pushReaction(PushReaction.DESTROY));
    public static final Block TALL_DRY_GRASS = Blocks.register("tall_dry_grass", TallDryGrassBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).replaceable().noCollision().instabreak().sound(SoundType.GRASS).ignitedByLava().offsetType(BlockBehaviour.OffsetType.XYZ).pushReaction(PushReaction.DESTROY));
    public static final Block SEAGRASS = Blocks.register("seagrass", SeagrassBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WATER).replaceable().noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block TALL_SEAGRASS = Blocks.register("tall_seagrass", TallSeagrassBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WATER).replaceable().noCollision().instabreak().sound(SoundType.WET_GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block PISTON = Blocks.register("piston", (BlockBehaviour.Properties properties) -> new PistonBaseBlock(false, (BlockBehaviour.Properties)properties), Blocks.pistonProperties());
    public static final Block PISTON_HEAD = Blocks.register("piston_head", PistonHeadBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(1.5f).noLootTable().pushReaction(PushReaction.BLOCK));
    public static final Block WHITE_WOOL = Blocks.register("white_wool", BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block ORANGE_WOOL = Blocks.register("orange_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block MAGENTA_WOOL = Blocks.register("magenta_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_MAGENTA).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block LIGHT_BLUE_WOOL = Blocks.register("light_blue_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block YELLOW_WOOL = Blocks.register("yellow_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block LIME_WOOL = Blocks.register("lime_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block PINK_WOOL = Blocks.register("pink_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block GRAY_WOOL = Blocks.register("gray_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block LIGHT_GRAY_WOOL = Blocks.register("light_gray_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block CYAN_WOOL = Blocks.register("cyan_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block PURPLE_WOOL = Blocks.register("purple_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block BLUE_WOOL = Blocks.register("blue_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block BROWN_WOOL = Blocks.register("brown_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block GREEN_WOOL = Blocks.register("green_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block RED_WOOL = Blocks.register("red_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block BLACK_WOOL = Blocks.register("black_wool", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.GUITAR).strength(0.8f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block MOVING_PISTON = Blocks.register("moving_piston", MovingPistonBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).forceSolidOn().strength(-1.0f).dynamicShape().noLootTable().noOcclusion().isRedstoneConductor(Blocks::never).isSuffocating(Blocks::never).isViewBlocking(Blocks::never).pushReaction(PushReaction.BLOCK));
    public static final Block DANDELION = Blocks.register("dandelion", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.SATURATION, 0.35f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block TORCHFLOWER = Blocks.register("torchflower", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.NIGHT_VISION, 5.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block POPPY = Blocks.register("poppy", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.NIGHT_VISION, 5.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block BLUE_ORCHID = Blocks.register("blue_orchid", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.SATURATION, 0.35f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block ALLIUM = Blocks.register("allium", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.FIRE_RESISTANCE, 3.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block AZURE_BLUET = Blocks.register("azure_bluet", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.BLINDNESS, 11.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block RED_TULIP = Blocks.register("red_tulip", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.WEAKNESS, 7.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block ORANGE_TULIP = Blocks.register("orange_tulip", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.WEAKNESS, 7.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block WHITE_TULIP = Blocks.register("white_tulip", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.WEAKNESS, 7.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block PINK_TULIP = Blocks.register("pink_tulip", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.WEAKNESS, 7.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block OXEYE_DAISY = Blocks.register("oxeye_daisy", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.REGENERATION, 7.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block CORNFLOWER = Blocks.register("cornflower", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.JUMP_BOOST, 5.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block WITHER_ROSE = Blocks.register("wither_rose", (BlockBehaviour.Properties properties) -> new WitherRoseBlock(MobEffects.WITHER, 7.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block LILY_OF_THE_VALLEY = Blocks.register("lily_of_the_valley", (BlockBehaviour.Properties properties) -> new FlowerBlock(MobEffects.POISON, 11.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block BROWN_MUSHROOM = Blocks.register("brown_mushroom", (BlockBehaviour.Properties properties) -> new MushroomBlock(TreeFeatures.HUGE_BROWN_MUSHROOM, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).lightLevel(blockState1 -> 1).hasPostProcess(Blocks::always).pushReaction(PushReaction.DESTROY));
    public static final Block RED_MUSHROOM = Blocks.register("red_mushroom", (BlockBehaviour.Properties properties) -> new MushroomBlock(TreeFeatures.HUGE_RED_MUSHROOM, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).hasPostProcess(Blocks::always).pushReaction(PushReaction.DESTROY));
    public static final Block GOLD_BLOCK = Blocks.register("gold_block", BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).instrument(NoteBlockInstrument.BELL).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundType.METAL));
    public static final Block IRON_BLOCK = Blocks.register("iron_block", BlockBehaviour.Properties.of().mapColor(MapColor.METAL).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.IRON));
    public static final Block BRICKS = Blocks.register("bricks", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block TNT = Blocks.register("tnt", TntBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.FIRE).instabreak().sound(SoundType.GRASS).ignitedByLava().isRedstoneConductor(Blocks::never));
    public static final Block BOOKSHELF = Blocks.register("bookshelf", BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(1.5f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block CHISELED_BOOKSHELF = Blocks.register("chiseled_bookshelf", ChiseledBookShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(1.5f).sound(SoundType.CHISELED_BOOKSHELF).ignitedByLava());
    public static final Block ACACIA_SHELF = Blocks.register("acacia_shelf", ShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block BAMBOO_SHELF = Blocks.register("bamboo_shelf", ShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block BIRCH_SHELF = Blocks.register("birch_shelf", ShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block CHERRY_SHELF = Blocks.register("cherry_shelf", ShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block CRIMSON_SHELF = Blocks.register("crimson_shelf", ShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block DARK_OAK_SHELF = Blocks.register("dark_oak_shelf", ShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block JUNGLE_SHELF = Blocks.register("jungle_shelf", ShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block MANGROVE_SHELF = Blocks.register("mangrove_shelf", ShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block OAK_SHELF = Blocks.register("oak_shelf", ShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block PALE_OAK_SHELF = Blocks.register("pale_oak_shelf", ShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block SPRUCE_SHELF = Blocks.register("spruce_shelf", ShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block WARPED_SHELF = Blocks.register("warped_shelf", ShelfBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).sound(SoundType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block MOSSY_COBBLESTONE = Blocks.register("mossy_cobblestone", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block OBSIDIAN = Blocks.register("obsidian", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(50.0f, 1200.0f));
    public static final Block TORCH = Blocks.register("torch", (BlockBehaviour.Properties properties) -> new TorchBlock(ParticleTypes.FLAME, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().noCollision().instabreak().lightLevel(blockState1 -> 14).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block WALL_TORCH = Blocks.register("wall_torch", (BlockBehaviour.Properties properties) -> new WallTorchBlock(ParticleTypes.FLAME, (BlockBehaviour.Properties)properties), Blocks.wallVariant(TORCH, true).noCollision().instabreak().lightLevel(blockState1 -> 14).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block FIRE = Blocks.register("fire", FireBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.FIRE).replaceable().noCollision().instabreak().lightLevel(blockState1 -> 15).sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY));
    public static final Block SOUL_FIRE = Blocks.register("soul_fire", SoulFireBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).replaceable().noCollision().instabreak().lightLevel(blockState1 -> 10).sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY));
    public static final Block SPAWNER = Blocks.register("spawner", SpawnerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(5.0f).sound(SoundType.SPAWNER).noOcclusion());
    public static final Block CREAKING_HEART = Blocks.register("creaking_heart", CreakingHeartBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).strength(10.0f).sound(SoundType.CREAKING_HEART));
    public static final Block OAK_STAIRS = Blocks.registerLegacyStair("oak_stairs", OAK_PLANKS);
    public static final Block CHEST = Blocks.register("chest", (BlockBehaviour.Properties properties) -> new ChestBlock(() -> BlockEntityType.CHEST, SoundEvents.CHEST_OPEN, SoundEvents.CHEST_CLOSE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block REDSTONE_WIRE = Blocks.register("redstone_wire", RedStoneWireBlock::new, BlockBehaviour.Properties.of().noCollision().instabreak().pushReaction(PushReaction.DESTROY));
    public static final Block DIAMOND_ORE = Blocks.register("diamond_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(UniformInt.of(3, 7), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_DIAMOND_ORE = Blocks.register("deepslate_diamond_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(UniformInt.of(3, 7), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(DIAMOND_ORE).mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE));
    public static final Block DIAMOND_BLOCK = Blocks.register("diamond_block", BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL));
    public static final Block CRAFTING_TABLE = Blocks.register("crafting_table", CraftingTableBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block WHEAT = Blocks.register("wheat", CropBlock::new, BlockBehaviour.Properties.of().mapColor(blockState1 -> blockState1.getValue(CropBlock.AGE) >= 6 ? MapColor.COLOR_YELLOW : MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY));
    public static final Block FARMLAND = Blocks.register("farmland", FarmBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).randomTicks().strength(0.6f).sound(SoundType.GRAVEL).isViewBlocking(Blocks::always).isSuffocating(Blocks::always));
    public static final Block FURNACE = Blocks.register("furnace", FurnaceBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f).lightLevel(Blocks.litBlockEmission(13)));
    public static final Block OAK_SIGN = Blocks.register("oak_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(WoodType.OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block SPRUCE_SIGN = Blocks.register("spruce_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(WoodType.SPRUCE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(SPRUCE_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BIRCH_SIGN = Blocks.register("birch_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(WoodType.BIRCH, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.SAND).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block ACACIA_SIGN = Blocks.register("acacia_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(WoodType.ACACIA, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block CHERRY_SIGN = Blocks.register("cherry_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(WoodType.CHERRY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(CHERRY_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block JUNGLE_SIGN = Blocks.register("jungle_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(WoodType.JUNGLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(JUNGLE_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block DARK_OAK_SIGN = Blocks.register("dark_oak_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(WoodType.DARK_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DARK_OAK_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block PALE_OAK_SIGN = Blocks.register("pale_oak_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(WoodType.PALE_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block MANGROVE_SIGN = Blocks.register("mangrove_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(WoodType.MANGROVE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MANGROVE_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BAMBOO_SIGN = Blocks.register("bamboo_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(WoodType.BAMBOO, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(BAMBOO_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block OAK_DOOR = Blocks.register("oak_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(OAK_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block LADDER = Blocks.register("ladder", LadderBlock::new, BlockBehaviour.Properties.of().forceSolidOff().strength(0.4f).sound(SoundType.LADDER).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block RAIL = Blocks.register("rail", RailBlock::new, BlockBehaviour.Properties.of().noCollision().strength(0.7f).sound(SoundType.METAL));
    public static final Block COBBLESTONE_STAIRS = Blocks.registerLegacyStair("cobblestone_stairs", COBBLESTONE);
    public static final Block OAK_WALL_SIGN = Blocks.register("oak_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(WoodType.OAK, (BlockBehaviour.Properties)properties), Blocks.wallVariant(OAK_SIGN, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block SPRUCE_WALL_SIGN = Blocks.register("spruce_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(WoodType.SPRUCE, (BlockBehaviour.Properties)properties), Blocks.wallVariant(SPRUCE_SIGN, true).mapColor(SPRUCE_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BIRCH_WALL_SIGN = Blocks.register("birch_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(WoodType.BIRCH, (BlockBehaviour.Properties)properties), Blocks.wallVariant(BIRCH_SIGN, true).mapColor(MapColor.SAND).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block ACACIA_WALL_SIGN = Blocks.register("acacia_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(WoodType.ACACIA, (BlockBehaviour.Properties)properties), Blocks.wallVariant(ACACIA_SIGN, true).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block CHERRY_WALL_SIGN = Blocks.register("cherry_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(WoodType.CHERRY, (BlockBehaviour.Properties)properties), Blocks.wallVariant(CHERRY_SIGN, true).mapColor(CHERRY_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block JUNGLE_WALL_SIGN = Blocks.register("jungle_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(WoodType.JUNGLE, (BlockBehaviour.Properties)properties), Blocks.wallVariant(JUNGLE_SIGN, true).mapColor(JUNGLE_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block DARK_OAK_WALL_SIGN = Blocks.register("dark_oak_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(WoodType.DARK_OAK, (BlockBehaviour.Properties)properties), Blocks.wallVariant(DARK_OAK_SIGN, true).mapColor(DARK_OAK_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block PALE_OAK_WALL_SIGN = Blocks.register("pale_oak_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(WoodType.PALE_OAK, (BlockBehaviour.Properties)properties), Blocks.wallVariant(PALE_OAK_SIGN, true).mapColor(PALE_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block MANGROVE_WALL_SIGN = Blocks.register("mangrove_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(WoodType.MANGROVE, (BlockBehaviour.Properties)properties), Blocks.wallVariant(MANGROVE_SIGN, true).mapColor(MANGROVE_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BAMBOO_WALL_SIGN = Blocks.register("bamboo_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(WoodType.BAMBOO, (BlockBehaviour.Properties)properties), Blocks.wallVariant(BAMBOO_SIGN, true).mapColor(BAMBOO_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block OAK_HANGING_SIGN = Blocks.register("oak_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(WoodType.OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(OAK_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block SPRUCE_HANGING_SIGN = Blocks.register("spruce_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(WoodType.SPRUCE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(SPRUCE_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BIRCH_HANGING_SIGN = Blocks.register("birch_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(WoodType.BIRCH, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.SAND).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block ACACIA_HANGING_SIGN = Blocks.register("acacia_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(WoodType.ACACIA, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block CHERRY_HANGING_SIGN = Blocks.register("cherry_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(WoodType.CHERRY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PINK).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block JUNGLE_HANGING_SIGN = Blocks.register("jungle_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(WoodType.JUNGLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(JUNGLE_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block DARK_OAK_HANGING_SIGN = Blocks.register("dark_oak_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(WoodType.DARK_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DARK_OAK_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block PALE_OAK_HANGING_SIGN = Blocks.register("pale_oak_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(WoodType.PALE_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block CRIMSON_HANGING_SIGN = Blocks.register("crimson_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(WoodType.CRIMSON, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_STEM).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f));
    public static final Block WARPED_HANGING_SIGN = Blocks.register("warped_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(WoodType.WARPED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_STEM).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f));
    public static final Block MANGROVE_HANGING_SIGN = Blocks.register("mangrove_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(WoodType.MANGROVE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MANGROVE_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BAMBOO_HANGING_SIGN = Blocks.register("bamboo_hanging_sign", (BlockBehaviour.Properties properties) -> new CeilingHangingSignBlock(WoodType.BAMBOO, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block OAK_WALL_HANGING_SIGN = Blocks.register("oak_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(WoodType.OAK, (BlockBehaviour.Properties)properties), Blocks.wallVariant(OAK_HANGING_SIGN, true).mapColor(OAK_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block SPRUCE_WALL_HANGING_SIGN = Blocks.register("spruce_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(WoodType.SPRUCE, (BlockBehaviour.Properties)properties), Blocks.wallVariant(SPRUCE_HANGING_SIGN, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BIRCH_WALL_HANGING_SIGN = Blocks.register("birch_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(WoodType.BIRCH, (BlockBehaviour.Properties)properties), Blocks.wallVariant(BIRCH_HANGING_SIGN, true).mapColor(MapColor.SAND).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block ACACIA_WALL_HANGING_SIGN = Blocks.register("acacia_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(WoodType.ACACIA, (BlockBehaviour.Properties)properties), Blocks.wallVariant(ACACIA_HANGING_SIGN, true).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block CHERRY_WALL_HANGING_SIGN = Blocks.register("cherry_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(WoodType.CHERRY, (BlockBehaviour.Properties)properties), Blocks.wallVariant(CHERRY_HANGING_SIGN, true).mapColor(MapColor.TERRACOTTA_PINK).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block JUNGLE_WALL_HANGING_SIGN = Blocks.register("jungle_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(WoodType.JUNGLE, (BlockBehaviour.Properties)properties), Blocks.wallVariant(JUNGLE_HANGING_SIGN, true).mapColor(JUNGLE_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block DARK_OAK_WALL_HANGING_SIGN = Blocks.register("dark_oak_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(WoodType.DARK_OAK, (BlockBehaviour.Properties)properties), Blocks.wallVariant(DARK_OAK_HANGING_SIGN, true).mapColor(DARK_OAK_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block PALE_OAK_WALL_HANGING_SIGN = Blocks.register("pale_oak_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(WoodType.PALE_OAK, (BlockBehaviour.Properties)properties), Blocks.wallVariant(PALE_OAK_HANGING_SIGN, true).mapColor(PALE_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block MANGROVE_WALL_HANGING_SIGN = Blocks.register("mangrove_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(WoodType.MANGROVE, (BlockBehaviour.Properties)properties), Blocks.wallVariant(MANGROVE_HANGING_SIGN, true).mapColor(MANGROVE_LOG.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block CRIMSON_WALL_HANGING_SIGN = Blocks.register("crimson_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(WoodType.CRIMSON, (BlockBehaviour.Properties)properties), Blocks.wallVariant(CRIMSON_HANGING_SIGN, true).mapColor(MapColor.CRIMSON_STEM).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f));
    public static final Block WARPED_WALL_HANGING_SIGN = Blocks.register("warped_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(WoodType.WARPED, (BlockBehaviour.Properties)properties), Blocks.wallVariant(WARPED_HANGING_SIGN, true).mapColor(MapColor.WARPED_STEM).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f));
    public static final Block BAMBOO_WALL_HANGING_SIGN = Blocks.register("bamboo_wall_hanging_sign", (BlockBehaviour.Properties properties) -> new WallHangingSignBlock(WoodType.BAMBOO, (BlockBehaviour.Properties)properties), Blocks.wallVariant(BAMBOO_HANGING_SIGN, true).mapColor(MapColor.COLOR_YELLOW).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block LEVER = Blocks.register("lever", LeverBlock::new, BlockBehaviour.Properties.of().noCollision().strength(0.5f).sound(SoundType.STONE).pushReaction(PushReaction.DESTROY));
    public static final Block STONE_PRESSURE_PLATE = Blocks.register("stone_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.STONE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).noCollision().strength(0.5f).pushReaction(PushReaction.DESTROY));
    public static final Block IRON_DOOR = Blocks.register("iron_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.IRON, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block OAK_PRESSURE_PLATE = Blocks.register("oak_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block SPRUCE_PRESSURE_PLATE = Blocks.register("spruce_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.SPRUCE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(SPRUCE_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block BIRCH_PRESSURE_PLATE = Blocks.register("birch_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.BIRCH, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(BIRCH_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block JUNGLE_PRESSURE_PLATE = Blocks.register("jungle_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.JUNGLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(JUNGLE_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block ACACIA_PRESSURE_PLATE = Blocks.register("acacia_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.ACACIA, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(ACACIA_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block CHERRY_PRESSURE_PLATE = Blocks.register("cherry_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.CHERRY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(CHERRY_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block DARK_OAK_PRESSURE_PLATE = Blocks.register("dark_oak_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.DARK_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DARK_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block PALE_OAK_PRESSURE_PLATE = Blocks.register("pale_oak_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.PALE_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block MANGROVE_PRESSURE_PLATE = Blocks.register("mangrove_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.MANGROVE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MANGROVE_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block BAMBOO_PRESSURE_PLATE = Blocks.register("bamboo_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.BAMBOO, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(BAMBOO_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block REDSTONE_ORE = Blocks.register("redstone_ore", RedStoneOreBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().randomTicks().lightLevel(Blocks.litBlockEmission(9)).strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_REDSTONE_ORE = Blocks.register("deepslate_redstone_ore", RedStoneOreBlock::new, BlockBehaviour.Properties.ofLegacyCopy(REDSTONE_ORE).mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE));
    public static final Block REDSTONE_TORCH = Blocks.register("redstone_torch", RedstoneTorchBlock::new, BlockBehaviour.Properties.of().noCollision().instabreak().lightLevel(Blocks.litBlockEmission(7)).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block REDSTONE_WALL_TORCH = Blocks.register("redstone_wall_torch", RedstoneWallTorchBlock::new, Blocks.wallVariant(REDSTONE_TORCH, true).noCollision().instabreak().lightLevel(Blocks.litBlockEmission(7)).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block STONE_BUTTON = Blocks.register("stone_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.STONE, 20, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block SNOW = Blocks.register("snow", SnowLayerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).replaceable().forceSolidOff().randomTicks().strength(0.1f).requiresCorrectToolForDrops().sound(SoundType.SNOW).isViewBlocking((state, level, pos) -> state.getValue(SnowLayerBlock.LAYERS) >= 8).pushReaction(PushReaction.DESTROY));
    public static final Block ICE = Blocks.register("ice", IceBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.ICE).friction(0.98f).randomTicks().strength(0.5f).sound(SoundType.GLASS).noOcclusion().isValidSpawn((state, level, pos, value) -> value == EntityType.POLAR_BEAR).isRedstoneConductor(Blocks::never));
    public static final Block SNOW_BLOCK = Blocks.register("snow_block", BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).requiresCorrectToolForDrops().strength(0.2f).sound(SoundType.SNOW));
    public static final Block CACTUS = Blocks.register("cactus", CactusBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().strength(0.4f).sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY));
    public static final Block CACTUS_FLOWER = Blocks.register("cactus_flower", CactusFlowerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).noCollision().instabreak().ignitedByLava().sound(SoundType.CACTUS_FLOWER).pushReaction(PushReaction.DESTROY));
    public static final Block CLAY = Blocks.register("clay", BlockBehaviour.Properties.of().mapColor(MapColor.CLAY).instrument(NoteBlockInstrument.FLUTE).strength(0.6f).sound(SoundType.GRAVEL));
    public static final Block SUGAR_CANE = Blocks.register("sugar_cane", SugarCaneBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block JUKEBOX = Blocks.register("jukebox", JukeboxBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).instrument(NoteBlockInstrument.BASS).strength(2.0f, 6.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block OAK_FENCE = Blocks.register("oak_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block NETHERRACK = Blocks.register("netherrack", NetherrackBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundType.NETHERRACK));
    public static final Block SOUL_SAND = Blocks.register("soul_sand", SoulSandBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.COW_BELL).strength(0.5f).speedFactor(0.4f).sound(SoundType.SOUL_SAND).isValidSpawn(Blocks::always).isRedstoneConductor(Blocks::always).isViewBlocking(Blocks::always).isSuffocating(Blocks::always));
    public static final Block SOUL_SOIL = Blocks.register("soul_soil", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(0.5f).sound(SoundType.SOUL_SOIL));
    public static final Block BASALT = Blocks.register("basalt", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f).sound(SoundType.BASALT));
    public static final Block POLISHED_BASALT = Blocks.register("polished_basalt", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f).sound(SoundType.BASALT));
    public static final Block SOUL_TORCH = Blocks.register("soul_torch", (BlockBehaviour.Properties properties) -> new TorchBlock(ParticleTypes.SOUL_FIRE_FLAME, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().noCollision().instabreak().lightLevel(blockState1 -> 10).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block SOUL_WALL_TORCH = Blocks.register("soul_wall_torch", (BlockBehaviour.Properties properties) -> new WallTorchBlock(ParticleTypes.SOUL_FIRE_FLAME, (BlockBehaviour.Properties)properties), Blocks.wallVariant(SOUL_TORCH, true).noCollision().instabreak().lightLevel(blockState1 -> 10).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block COPPER_TORCH = Blocks.register("copper_torch", (BlockBehaviour.Properties properties) -> new TorchBlock(ParticleTypes.COPPER_FIRE_FLAME, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().noCollision().instabreak().lightLevel(blockState1 -> 14).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block COPPER_WALL_TORCH = Blocks.register("copper_wall_torch", (BlockBehaviour.Properties properties) -> new WallTorchBlock(ParticleTypes.COPPER_FIRE_FLAME, (BlockBehaviour.Properties)properties), Blocks.wallVariant(COPPER_TORCH, true).noCollision().instabreak().lightLevel(blockState1 -> 14).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block GLOWSTONE = Blocks.register("glowstone", BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.PLING).strength(0.3f).sound(SoundType.GLASS).lightLevel(blockState1 -> 15).isRedstoneConductor(Blocks::never));
    public static final Block NETHER_PORTAL = Blocks.register("nether_portal", NetherPortalBlock::new, BlockBehaviour.Properties.of().noCollision().randomTicks().strength(-1.0f).sound(SoundType.GLASS).lightLevel(blockState1 -> 11).pushReaction(PushReaction.BLOCK));
    public static final Block CARVED_PUMPKIN = Blocks.register("carved_pumpkin", CarvedPumpkinBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(1.0f).sound(SoundType.WOOD).isValidSpawn(Blocks::always).pushReaction(PushReaction.DESTROY));
    public static final Block JACK_O_LANTERN = Blocks.register("jack_o_lantern", CarvedPumpkinBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(1.0f).sound(SoundType.WOOD).lightLevel(blockState1 -> 15).isValidSpawn(Blocks::always).pushReaction(PushReaction.DESTROY));
    public static final Block CAKE = Blocks.register("cake", CakeBlock::new, BlockBehaviour.Properties.of().forceSolidOn().strength(0.5f).sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY));
    public static final Block REPEATER = Blocks.register("repeater", RepeaterBlock::new, BlockBehaviour.Properties.of().instabreak().sound(SoundType.STONE).pushReaction(PushReaction.DESTROY));
    public static final Block WHITE_STAINED_GLASS = Blocks.registerStainedGlass("white_stained_glass", DyeColor.WHITE);
    public static final Block ORANGE_STAINED_GLASS = Blocks.registerStainedGlass("orange_stained_glass", DyeColor.ORANGE);
    public static final Block MAGENTA_STAINED_GLASS = Blocks.registerStainedGlass("magenta_stained_glass", DyeColor.MAGENTA);
    public static final Block LIGHT_BLUE_STAINED_GLASS = Blocks.registerStainedGlass("light_blue_stained_glass", DyeColor.LIGHT_BLUE);
    public static final Block YELLOW_STAINED_GLASS = Blocks.registerStainedGlass("yellow_stained_glass", DyeColor.YELLOW);
    public static final Block LIME_STAINED_GLASS = Blocks.registerStainedGlass("lime_stained_glass", DyeColor.LIME);
    public static final Block PINK_STAINED_GLASS = Blocks.registerStainedGlass("pink_stained_glass", DyeColor.PINK);
    public static final Block GRAY_STAINED_GLASS = Blocks.registerStainedGlass("gray_stained_glass", DyeColor.GRAY);
    public static final Block LIGHT_GRAY_STAINED_GLASS = Blocks.registerStainedGlass("light_gray_stained_glass", DyeColor.LIGHT_GRAY);
    public static final Block CYAN_STAINED_GLASS = Blocks.registerStainedGlass("cyan_stained_glass", DyeColor.CYAN);
    public static final Block PURPLE_STAINED_GLASS = Blocks.registerStainedGlass("purple_stained_glass", DyeColor.PURPLE);
    public static final Block BLUE_STAINED_GLASS = Blocks.registerStainedGlass("blue_stained_glass", DyeColor.BLUE);
    public static final Block BROWN_STAINED_GLASS = Blocks.registerStainedGlass("brown_stained_glass", DyeColor.BROWN);
    public static final Block GREEN_STAINED_GLASS = Blocks.registerStainedGlass("green_stained_glass", DyeColor.GREEN);
    public static final Block RED_STAINED_GLASS = Blocks.registerStainedGlass("red_stained_glass", DyeColor.RED);
    public static final Block BLACK_STAINED_GLASS = Blocks.registerStainedGlass("black_stained_glass", DyeColor.BLACK);
    public static final Block OAK_TRAPDOOR = Blocks.register("oak_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block SPRUCE_TRAPDOOR = Blocks.register("spruce_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.SPRUCE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block BIRCH_TRAPDOOR = Blocks.register("birch_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.BIRCH, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block JUNGLE_TRAPDOOR = Blocks.register("jungle_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.JUNGLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block ACACIA_TRAPDOOR = Blocks.register("acacia_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.ACACIA, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block CHERRY_TRAPDOOR = Blocks.register("cherry_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.CHERRY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block DARK_OAK_TRAPDOOR = Blocks.register("dark_oak_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.DARK_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block PALE_OAK_TRAPDOOR = Blocks.register("pale_oak_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.PALE_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block MANGROVE_TRAPDOOR = Blocks.register("mangrove_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.MANGROVE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block BAMBOO_TRAPDOOR = Blocks.register("bamboo_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.BAMBOO, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block STONE_BRICKS = Blocks.register("stone_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block MOSSY_STONE_BRICKS = Blocks.register("mossy_stone_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block CRACKED_STONE_BRICKS = Blocks.register("cracked_stone_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block CHISELED_STONE_BRICKS = Blocks.register("chiseled_stone_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block PACKED_MUD = Blocks.register("packed_mud", BlockBehaviour.Properties.ofLegacyCopy(DIRT).strength(1.0f, 3.0f).sound(SoundType.PACKED_MUD));
    public static final Block MUD_BRICKS = Blocks.register("mud_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 3.0f).sound(SoundType.MUD_BRICKS));
    public static final Block INFESTED_STONE = Blocks.register("infested_stone", (BlockBehaviour.Properties properties) -> new InfestedBlock(STONE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.CLAY));
    public static final Block INFESTED_COBBLESTONE = Blocks.register("infested_cobblestone", (BlockBehaviour.Properties properties) -> new InfestedBlock(COBBLESTONE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.CLAY));
    public static final Block INFESTED_STONE_BRICKS = Blocks.register("infested_stone_bricks", (BlockBehaviour.Properties properties) -> new InfestedBlock(STONE_BRICKS, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.CLAY));
    public static final Block INFESTED_MOSSY_STONE_BRICKS = Blocks.register("infested_mossy_stone_bricks", (BlockBehaviour.Properties properties) -> new InfestedBlock(MOSSY_STONE_BRICKS, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.CLAY));
    public static final Block INFESTED_CRACKED_STONE_BRICKS = Blocks.register("infested_cracked_stone_bricks", (BlockBehaviour.Properties properties) -> new InfestedBlock(CRACKED_STONE_BRICKS, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.CLAY));
    public static final Block INFESTED_CHISELED_STONE_BRICKS = Blocks.register("infested_chiseled_stone_bricks", (BlockBehaviour.Properties properties) -> new InfestedBlock(CHISELED_STONE_BRICKS, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.CLAY));
    public static final Block BROWN_MUSHROOM_BLOCK = Blocks.register("brown_mushroom_block", HugeMushroomBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).instrument(NoteBlockInstrument.BASS).strength(0.2f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block RED_MUSHROOM_BLOCK = Blocks.register("red_mushroom_block", HugeMushroomBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASS).strength(0.2f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block MUSHROOM_STEM = Blocks.register("mushroom_stem", HugeMushroomBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).instrument(NoteBlockInstrument.BASS).strength(0.2f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block IRON_BARS = Blocks.register("iron_bars", IronBarsBlock::new, BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.IRON).noOcclusion());
    public static final WeatheringCopperBlocks COPPER_BARS = WeatheringCopperBlocks.create("copper_bars", (TriFunction<String, Function<BlockBehaviour.Properties, Block>, BlockBehaviour.Properties, Block>)((TriFunction)Blocks::register), IronBarsBlock::new, WeatheringCopperBarsBlock::new, weatherState -> BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.COPPER).noOcclusion());
    public static final Block IRON_CHAIN = Blocks.register("iron_chain", ChainBlock::new, BlockBehaviour.Properties.of().forceSolidOn().requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.CHAIN).noOcclusion());
    public static final WeatheringCopperBlocks COPPER_CHAIN = WeatheringCopperBlocks.create("copper_chain", (TriFunction<String, Function<BlockBehaviour.Properties, Block>, BlockBehaviour.Properties, Block>)((TriFunction)Blocks::register), ChainBlock::new, WeatheringCopperChainBlock::new, weatherState -> BlockBehaviour.Properties.of().forceSolidOn().requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.CHAIN).noOcclusion());
    public static final Block GLASS_PANE = Blocks.register("glass_pane", IronBarsBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block PUMPKIN = Blocks.register(net.minecraft.references.Blocks.PUMPKIN, PumpkinBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.DIDGERIDOO).strength(1.0f).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block MELON = Blocks.register(net.minecraft.references.Blocks.MELON, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).strength(1.0f).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block ATTACHED_PUMPKIN_STEM = Blocks.register(net.minecraft.references.Blocks.ATTACHED_PUMPKIN_STEM, (BlockBehaviour.Properties properties) -> new AttachedStemBlock(net.minecraft.references.Blocks.PUMPKIN_STEM, net.minecraft.references.Blocks.PUMPKIN, Items.PUMPKIN_SEEDS, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block ATTACHED_MELON_STEM = Blocks.register(net.minecraft.references.Blocks.ATTACHED_MELON_STEM, (BlockBehaviour.Properties properties) -> new AttachedStemBlock(net.minecraft.references.Blocks.MELON_STEM, net.minecraft.references.Blocks.MELON, Items.MELON_SEEDS, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block PUMPKIN_STEM = Blocks.register(net.minecraft.references.Blocks.PUMPKIN_STEM, (BlockBehaviour.Properties properties) -> new StemBlock(net.minecraft.references.Blocks.PUMPKIN, net.minecraft.references.Blocks.ATTACHED_PUMPKIN_STEM, Items.PUMPKIN_SEEDS, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.HARD_CROP).pushReaction(PushReaction.DESTROY));
    public static final Block MELON_STEM = Blocks.register(net.minecraft.references.Blocks.MELON_STEM, (BlockBehaviour.Properties properties) -> new StemBlock(net.minecraft.references.Blocks.MELON, net.minecraft.references.Blocks.ATTACHED_MELON_STEM, Items.MELON_SEEDS, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.HARD_CROP).pushReaction(PushReaction.DESTROY));
    public static final Block VINE = Blocks.register("vine", VineBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).replaceable().noCollision().randomTicks().strength(0.2f).sound(SoundType.VINE).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block GLOW_LICHEN = Blocks.register("glow_lichen", GlowLichenBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.GLOW_LICHEN).replaceable().noCollision().strength(0.2f).sound(SoundType.GLOW_LICHEN).lightLevel(GlowLichenBlock.emission(7)).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block RESIN_CLUMP = Blocks.register("resin_clump", MultifaceBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).replaceable().noCollision().sound(SoundType.RESIN).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block OAK_FENCE_GATE = Blocks.register("oak_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(WoodType.OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block BRICK_STAIRS = Blocks.registerLegacyStair("brick_stairs", BRICKS);
    public static final Block STONE_BRICK_STAIRS = Blocks.registerLegacyStair("stone_brick_stairs", STONE_BRICKS);
    public static final Block MUD_BRICK_STAIRS = Blocks.registerLegacyStair("mud_brick_stairs", MUD_BRICKS);
    public static final Block MYCELIUM = Blocks.register("mycelium", MyceliumBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).randomTicks().strength(0.6f).sound(SoundType.GRASS));
    public static final Block LILY_PAD = Blocks.register("lily_pad", WaterlilyBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).instabreak().sound(SoundType.LILY_PAD).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block RESIN_BLOCK = Blocks.register("resin_block", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.RESIN));
    public static final Block RESIN_BRICKS = Blocks.register("resin_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundType.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Block RESIN_BRICK_STAIRS = Blocks.registerLegacyStair("resin_brick_stairs", RESIN_BRICKS);
    public static final Block RESIN_BRICK_SLAB = Blocks.register("resin_brick_slab", (BlockBehaviour.Properties properties) -> new SlabBlock((BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundType.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Block RESIN_BRICK_WALL = Blocks.register("resin_brick_wall", (BlockBehaviour.Properties properties) -> new WallBlock((BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundType.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Block CHISELED_RESIN_BRICKS = Blocks.register("chiseled_resin_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundType.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Block NETHER_BRICKS = Blocks.register("nether_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundType.NETHER_BRICKS));
    public static final Block NETHER_BRICK_FENCE = Blocks.register("nether_brick_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundType.NETHER_BRICKS));
    public static final Block NETHER_BRICK_STAIRS = Blocks.registerLegacyStair("nether_brick_stairs", NETHER_BRICKS);
    public static final Block NETHER_WART = Blocks.register("nether_wart", NetherWartBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).noCollision().randomTicks().sound(SoundType.NETHER_WART).pushReaction(PushReaction.DESTROY));
    public static final Block ENCHANTING_TABLE = Blocks.register("enchanting_table", EnchantingTableBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().lightLevel(blockState1 -> 7).strength(5.0f, 1200.0f));
    public static final Block BREWING_STAND = Blocks.register("brewing_stand", BrewingStandBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(0.5f).lightLevel(blockState1 -> 1).noOcclusion());
    public static final Block CAULDRON = Blocks.register("cauldron", CauldronBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).requiresCorrectToolForDrops().strength(2.0f).noOcclusion());
    public static final Block WATER_CAULDRON = Blocks.register("water_cauldron", (BlockBehaviour.Properties properties) -> new LayeredCauldronBlock(Biome.Precipitation.RAIN, CauldronInteraction.WATER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CAULDRON));
    public static final Block LAVA_CAULDRON = Blocks.register("lava_cauldron", LavaCauldronBlock::new, BlockBehaviour.Properties.ofLegacyCopy(CAULDRON).lightLevel(blockState1 -> 15));
    public static final Block POWDER_SNOW_CAULDRON = Blocks.register("powder_snow_cauldron", (BlockBehaviour.Properties properties) -> new LayeredCauldronBlock(Biome.Precipitation.SNOW, CauldronInteraction.POWDER_SNOW, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CAULDRON));
    public static final Block END_PORTAL = Blocks.register("end_portal", EndPortalBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).noCollision().lightLevel(blockState1 -> 15).strength(-1.0f, 3600000.0f).noLootTable().pushReaction(PushReaction.BLOCK));
    public static final Block END_PORTAL_FRAME = Blocks.register("end_portal_frame", EndPortalFrameBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.GLASS).lightLevel(blockState1 -> 1).strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block END_STONE = Blocks.register("end_stone", BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 9.0f));
    public static final Block DRAGON_EGG = Blocks.register("dragon_egg", DragonEggBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).lightLevel(blockState1 -> 1).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block REDSTONE_LAMP = Blocks.register("redstone_lamp", RedstoneLampBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).lightLevel(Blocks.litBlockEmission(15)).strength(0.3f).sound(SoundType.GLASS).isValidSpawn(Blocks::always));
    public static final Block COCOA = Blocks.register("cocoa", CocoaBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().strength(0.2f, 3.0f).sound(SoundType.WOOD).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block SANDSTONE_STAIRS = Blocks.registerLegacyStair("sandstone_stairs", SANDSTONE);
    public static final Block EMERALD_ORE = Blocks.register("emerald_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(UniformInt.of(3, 7), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_EMERALD_ORE = Blocks.register("deepslate_emerald_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(UniformInt.of(3, 7), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(EMERALD_ORE).mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE));
    public static final Block ENDER_CHEST = Blocks.register("ender_chest", EnderChestBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(22.5f, 600.0f).lightLevel(blockState1 -> 7));
    public static final Block TRIPWIRE_HOOK = Blocks.register("tripwire_hook", TripWireHookBlock::new, BlockBehaviour.Properties.of().noCollision().sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final Block TRIPWIRE = Blocks.register("tripwire", (BlockBehaviour.Properties properties) -> new TripWireBlock(TRIPWIRE_HOOK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().noCollision().pushReaction(PushReaction.DESTROY));
    public static final Block EMERALD_BLOCK = Blocks.register("emerald_block", BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).instrument(NoteBlockInstrument.BIT).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL));
    public static final Block SPRUCE_STAIRS = Blocks.registerLegacyStair("spruce_stairs", SPRUCE_PLANKS);
    public static final Block BIRCH_STAIRS = Blocks.registerLegacyStair("birch_stairs", BIRCH_PLANKS);
    public static final Block JUNGLE_STAIRS = Blocks.registerLegacyStair("jungle_stairs", JUNGLE_PLANKS);
    public static final Block COMMAND_BLOCK = Blocks.register("command_block", (BlockBehaviour.Properties properties) -> new CommandBlock(false, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).requiresCorrectToolForDrops().strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block BEACON = Blocks.register("beacon", BeaconBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).instrument(NoteBlockInstrument.HAT).strength(3.0f).lightLevel(blockState1 -> 15).noOcclusion().isRedstoneConductor(Blocks::never));
    public static final Block COBBLESTONE_WALL = Blocks.register("cobblestone_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(COBBLESTONE).forceSolidOn());
    public static final Block MOSSY_COBBLESTONE_WALL = Blocks.register("mossy_cobblestone_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(COBBLESTONE).forceSolidOn());
    public static final Block FLOWER_POT = Blocks.register("flower_pot", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(AIR, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_TORCHFLOWER = Blocks.register("potted_torchflower", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(TORCHFLOWER, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_OAK_SAPLING = Blocks.register("potted_oak_sapling", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(OAK_SAPLING, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_SPRUCE_SAPLING = Blocks.register("potted_spruce_sapling", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(SPRUCE_SAPLING, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_BIRCH_SAPLING = Blocks.register("potted_birch_sapling", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(BIRCH_SAPLING, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_JUNGLE_SAPLING = Blocks.register("potted_jungle_sapling", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(JUNGLE_SAPLING, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_ACACIA_SAPLING = Blocks.register("potted_acacia_sapling", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(ACACIA_SAPLING, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_CHERRY_SAPLING = Blocks.register("potted_cherry_sapling", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(CHERRY_SAPLING, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_DARK_OAK_SAPLING = Blocks.register("potted_dark_oak_sapling", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(DARK_OAK_SAPLING, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_PALE_OAK_SAPLING = Blocks.register("potted_pale_oak_sapling", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(PALE_OAK_SAPLING, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_MANGROVE_PROPAGULE = Blocks.register("potted_mangrove_propagule", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(MANGROVE_PROPAGULE, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_FERN = Blocks.register("potted_fern", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(FERN, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_DANDELION = Blocks.register("potted_dandelion", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(DANDELION, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_POPPY = Blocks.register("potted_poppy", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(POPPY, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_BLUE_ORCHID = Blocks.register("potted_blue_orchid", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(BLUE_ORCHID, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_ALLIUM = Blocks.register("potted_allium", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(ALLIUM, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_AZURE_BLUET = Blocks.register("potted_azure_bluet", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(AZURE_BLUET, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_RED_TULIP = Blocks.register("potted_red_tulip", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(RED_TULIP, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_ORANGE_TULIP = Blocks.register("potted_orange_tulip", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(ORANGE_TULIP, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_WHITE_TULIP = Blocks.register("potted_white_tulip", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(WHITE_TULIP, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_PINK_TULIP = Blocks.register("potted_pink_tulip", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(PINK_TULIP, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_OXEYE_DAISY = Blocks.register("potted_oxeye_daisy", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(OXEYE_DAISY, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_CORNFLOWER = Blocks.register("potted_cornflower", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(CORNFLOWER, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_LILY_OF_THE_VALLEY = Blocks.register("potted_lily_of_the_valley", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(LILY_OF_THE_VALLEY, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_WITHER_ROSE = Blocks.register("potted_wither_rose", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(WITHER_ROSE, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_RED_MUSHROOM = Blocks.register("potted_red_mushroom", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(RED_MUSHROOM, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_BROWN_MUSHROOM = Blocks.register("potted_brown_mushroom", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(BROWN_MUSHROOM, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_DEAD_BUSH = Blocks.register("potted_dead_bush", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(DEAD_BUSH, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_CACTUS = Blocks.register("potted_cactus", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(CACTUS, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block CARROTS = Blocks.register("carrots", CarrotBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY));
    public static final Block POTATOES = Blocks.register("potatoes", PotatoBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY));
    public static final Block OAK_BUTTON = Blocks.register("oak_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.OAK, 30, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block SPRUCE_BUTTON = Blocks.register("spruce_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.SPRUCE, 30, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block BIRCH_BUTTON = Blocks.register("birch_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.BIRCH, 30, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block JUNGLE_BUTTON = Blocks.register("jungle_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.JUNGLE, 30, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block ACACIA_BUTTON = Blocks.register("acacia_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.ACACIA, 30, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block CHERRY_BUTTON = Blocks.register("cherry_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.CHERRY, 30, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block DARK_OAK_BUTTON = Blocks.register("dark_oak_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.DARK_OAK, 30, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block PALE_OAK_BUTTON = Blocks.register("pale_oak_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.PALE_OAK, 30, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block MANGROVE_BUTTON = Blocks.register("mangrove_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.MANGROVE, 30, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block BAMBOO_BUTTON = Blocks.register("bamboo_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.BAMBOO, 30, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block SKELETON_SKULL = Blocks.register("skeleton_skull", (BlockBehaviour.Properties properties) -> new SkullBlock(SkullBlock.Types.SKELETON, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block SKELETON_WALL_SKULL = Blocks.register("skeleton_wall_skull", (BlockBehaviour.Properties properties) -> new WallSkullBlock(SkullBlock.Types.SKELETON, (BlockBehaviour.Properties)properties), Blocks.wallVariant(SKELETON_SKULL, true).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block WITHER_SKELETON_SKULL = Blocks.register("wither_skeleton_skull", WitherSkullBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.WITHER_SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block WITHER_SKELETON_WALL_SKULL = Blocks.register("wither_skeleton_wall_skull", WitherWallSkullBlock::new, Blocks.wallVariant(WITHER_SKELETON_SKULL, true).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block ZOMBIE_HEAD = Blocks.register("zombie_head", (BlockBehaviour.Properties properties) -> new SkullBlock(SkullBlock.Types.ZOMBIE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.ZOMBIE).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block ZOMBIE_WALL_HEAD = Blocks.register("zombie_wall_head", (BlockBehaviour.Properties properties) -> new WallSkullBlock(SkullBlock.Types.ZOMBIE, (BlockBehaviour.Properties)properties), Blocks.wallVariant(ZOMBIE_HEAD, true).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block PLAYER_HEAD = Blocks.register("player_head", PlayerHeadBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.CUSTOM_HEAD).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block PLAYER_WALL_HEAD = Blocks.register("player_wall_head", PlayerWallHeadBlock::new, Blocks.wallVariant(PLAYER_HEAD, true).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block CREEPER_HEAD = Blocks.register("creeper_head", (BlockBehaviour.Properties properties) -> new SkullBlock(SkullBlock.Types.CREEPER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.CREEPER).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block CREEPER_WALL_HEAD = Blocks.register("creeper_wall_head", (BlockBehaviour.Properties properties) -> new WallSkullBlock(SkullBlock.Types.CREEPER, (BlockBehaviour.Properties)properties), Blocks.wallVariant(CREEPER_HEAD, true).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block DRAGON_HEAD = Blocks.register("dragon_head", (BlockBehaviour.Properties properties) -> new SkullBlock(SkullBlock.Types.DRAGON, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.DRAGON).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block DRAGON_WALL_HEAD = Blocks.register("dragon_wall_head", (BlockBehaviour.Properties properties) -> new WallSkullBlock(SkullBlock.Types.DRAGON, (BlockBehaviour.Properties)properties), Blocks.wallVariant(DRAGON_HEAD, true).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block PIGLIN_HEAD = Blocks.register("piglin_head", (BlockBehaviour.Properties properties) -> new SkullBlock(SkullBlock.Types.PIGLIN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.PIGLIN).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block PIGLIN_WALL_HEAD = Blocks.register("piglin_wall_head", PiglinWallSkullBlock::new, Blocks.wallVariant(PIGLIN_HEAD, true).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Block ANVIL = Blocks.register("anvil", AnvilBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(5.0f, 1200.0f).sound(SoundType.ANVIL).pushReaction(PushReaction.BLOCK));
    public static final Block CHIPPED_ANVIL = Blocks.register("chipped_anvil", AnvilBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(5.0f, 1200.0f).sound(SoundType.ANVIL).pushReaction(PushReaction.BLOCK));
    public static final Block DAMAGED_ANVIL = Blocks.register("damaged_anvil", AnvilBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(5.0f, 1200.0f).sound(SoundType.ANVIL).pushReaction(PushReaction.BLOCK));
    public static final Block TRAPPED_CHEST = Blocks.register("trapped_chest", TrappedChestBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block LIGHT_WEIGHTED_PRESSURE_PLATE = Blocks.register("light_weighted_pressure_plate", (BlockBehaviour.Properties properties) -> new WeightedPressurePlateBlock(15, BlockSetType.GOLD, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).forceSolidOn().noCollision().strength(0.5f).pushReaction(PushReaction.DESTROY));
    public static final Block HEAVY_WEIGHTED_PRESSURE_PLATE = Blocks.register("heavy_weighted_pressure_plate", (BlockBehaviour.Properties properties) -> new WeightedPressurePlateBlock(150, BlockSetType.IRON, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().noCollision().strength(0.5f).pushReaction(PushReaction.DESTROY));
    public static final Block COMPARATOR = Blocks.register("comparator", ComparatorBlock::new, BlockBehaviour.Properties.of().instabreak().sound(SoundType.STONE).pushReaction(PushReaction.DESTROY));
    public static final Block DAYLIGHT_DETECTOR = Blocks.register("daylight_detector", DaylightDetectorBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(0.2f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block REDSTONE_BLOCK = Blocks.register("redstone_block", PoweredBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.FIRE).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL).isRedstoneConductor(Blocks::never));
    public static final Block NETHER_QUARTZ_ORE = Blocks.register("nether_quartz_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(UniformInt.of(2, 5), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f).sound(SoundType.NETHER_ORE));
    public static final Block HOPPER = Blocks.register("hopper", HopperBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).requiresCorrectToolForDrops().strength(3.0f, 4.8f).sound(SoundType.METAL).noOcclusion());
    public static final Block QUARTZ_BLOCK = Blocks.register("quartz_block", BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block CHISELED_QUARTZ_BLOCK = Blocks.register("chiseled_quartz_block", BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block QUARTZ_PILLAR = Blocks.register("quartz_pillar", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block QUARTZ_STAIRS = Blocks.registerLegacyStair("quartz_stairs", QUARTZ_BLOCK);
    public static final Block ACTIVATOR_RAIL = Blocks.register("activator_rail", PoweredRailBlock::new, BlockBehaviour.Properties.of().noCollision().strength(0.7f).sound(SoundType.METAL));
    public static final Block DROPPER = Blocks.register("dropper", DropperBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f));
    public static final Block WHITE_TERRACOTTA = Blocks.register("white_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block ORANGE_TERRACOTTA = Blocks.register("orange_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block MAGENTA_TERRACOTTA = Blocks.register("magenta_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_MAGENTA).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block LIGHT_BLUE_TERRACOTTA = Blocks.register("light_blue_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_BLUE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block YELLOW_TERRACOTTA = Blocks.register("yellow_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block LIME_TERRACOTTA = Blocks.register("lime_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_GREEN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block PINK_TERRACOTTA = Blocks.register("pink_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PINK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block GRAY_TERRACOTTA = Blocks.register("gray_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block LIGHT_GRAY_TERRACOTTA = Blocks.register("light_gray_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block CYAN_TERRACOTTA = Blocks.register("cyan_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_CYAN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block PURPLE_TERRACOTTA = Blocks.register("purple_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PURPLE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block BLUE_TERRACOTTA = Blocks.register("blue_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BLUE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block BROWN_TERRACOTTA = Blocks.register("brown_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BROWN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block GREEN_TERRACOTTA = Blocks.register("green_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_GREEN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block RED_TERRACOTTA = Blocks.register("red_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_RED).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block BLACK_TERRACOTTA = Blocks.register("black_terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block WHITE_STAINED_GLASS_PANE = Blocks.register("white_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.WHITE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block ORANGE_STAINED_GLASS_PANE = Blocks.register("orange_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.ORANGE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block MAGENTA_STAINED_GLASS_PANE = Blocks.register("magenta_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.MAGENTA, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block LIGHT_BLUE_STAINED_GLASS_PANE = Blocks.register("light_blue_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.LIGHT_BLUE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block YELLOW_STAINED_GLASS_PANE = Blocks.register("yellow_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.YELLOW, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block LIME_STAINED_GLASS_PANE = Blocks.register("lime_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.LIME, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block PINK_STAINED_GLASS_PANE = Blocks.register("pink_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.PINK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block GRAY_STAINED_GLASS_PANE = Blocks.register("gray_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.GRAY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block LIGHT_GRAY_STAINED_GLASS_PANE = Blocks.register("light_gray_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.LIGHT_GRAY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block CYAN_STAINED_GLASS_PANE = Blocks.register("cyan_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.CYAN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block PURPLE_STAINED_GLASS_PANE = Blocks.register("purple_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.PURPLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block BLUE_STAINED_GLASS_PANE = Blocks.register("blue_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.BLUE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block BROWN_STAINED_GLASS_PANE = Blocks.register("brown_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.BROWN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block GREEN_STAINED_GLASS_PANE = Blocks.register("green_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.GREEN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block RED_STAINED_GLASS_PANE = Blocks.register("red_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.RED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block BLACK_STAINED_GLASS_PANE = Blocks.register("black_stained_glass_pane", (BlockBehaviour.Properties properties) -> new StainedGlassPaneBlock(DyeColor.BLACK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion());
    public static final Block ACACIA_STAIRS = Blocks.registerLegacyStair("acacia_stairs", ACACIA_PLANKS);
    public static final Block CHERRY_STAIRS = Blocks.registerLegacyStair("cherry_stairs", CHERRY_PLANKS);
    public static final Block DARK_OAK_STAIRS = Blocks.registerLegacyStair("dark_oak_stairs", DARK_OAK_PLANKS);
    public static final Block PALE_OAK_STAIRS = Blocks.registerLegacyStair("pale_oak_stairs", PALE_OAK_PLANKS);
    public static final Block MANGROVE_STAIRS = Blocks.registerLegacyStair("mangrove_stairs", MANGROVE_PLANKS);
    public static final Block BAMBOO_STAIRS = Blocks.registerLegacyStair("bamboo_stairs", BAMBOO_PLANKS);
    public static final Block BAMBOO_MOSAIC_STAIRS = Blocks.registerLegacyStair("bamboo_mosaic_stairs", BAMBOO_MOSAIC);
    public static final Block SLIME_BLOCK = Blocks.register("slime_block", SlimeBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).friction(0.8f).sound(SoundType.SLIME_BLOCK).noOcclusion());
    public static final Block BARRIER = Blocks.register("barrier", BarrierBlock::new, BlockBehaviour.Properties.of().strength(-1.0f, 3600000.8f).mapColor(Blocks.waterloggedMapColor(MapColor.NONE)).noLootTable().noOcclusion().isValidSpawn(Blocks::never).noTerrainParticles().pushReaction(PushReaction.BLOCK));
    public static final Block LIGHT = Blocks.register("light", LightBlock::new, BlockBehaviour.Properties.of().replaceable().strength(-1.0f, 3600000.8f).mapColor(Blocks.waterloggedMapColor(MapColor.NONE)).noLootTable().noOcclusion().lightLevel(LightBlock.LIGHT_EMISSION));
    public static final Block IRON_TRAPDOOR = Blocks.register("iron_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.IRON, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(5.0f).noOcclusion().isValidSpawn(Blocks::never));
    public static final Block PRISMARINE = Blocks.register("prismarine", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block PRISMARINE_BRICKS = Blocks.register("prismarine_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DARK_PRISMARINE = Blocks.register("dark_prismarine", BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block PRISMARINE_STAIRS = Blocks.registerLegacyStair("prismarine_stairs", PRISMARINE);
    public static final Block PRISMARINE_BRICK_STAIRS = Blocks.registerLegacyStair("prismarine_brick_stairs", PRISMARINE_BRICKS);
    public static final Block DARK_PRISMARINE_STAIRS = Blocks.registerLegacyStair("dark_prismarine_stairs", DARK_PRISMARINE);
    public static final Block PRISMARINE_SLAB = Blocks.register("prismarine_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block PRISMARINE_BRICK_SLAB = Blocks.register("prismarine_brick_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DARK_PRISMARINE_SLAB = Blocks.register("dark_prismarine_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block SEA_LANTERN = Blocks.register("sea_lantern", BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).lightLevel(blockState1 -> 15).isRedstoneConductor(Blocks::never));
    public static final Block HAY_BLOCK = Blocks.register("hay_block", HayBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BANJO).strength(0.5f).sound(SoundType.GRASS));
    public static final Block WHITE_CARPET = Blocks.register("white_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.WHITE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block ORANGE_CARPET = Blocks.register("orange_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.ORANGE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block MAGENTA_CARPET = Blocks.register("magenta_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.MAGENTA, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_MAGENTA).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block LIGHT_BLUE_CARPET = Blocks.register("light_blue_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.LIGHT_BLUE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block YELLOW_CARPET = Blocks.register("yellow_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.YELLOW, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block LIME_CARPET = Blocks.register("lime_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.LIME, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block PINK_CARPET = Blocks.register("pink_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.PINK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block GRAY_CARPET = Blocks.register("gray_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.GRAY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block LIGHT_GRAY_CARPET = Blocks.register("light_gray_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.LIGHT_GRAY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block CYAN_CARPET = Blocks.register("cyan_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.CYAN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block PURPLE_CARPET = Blocks.register("purple_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.PURPLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block BLUE_CARPET = Blocks.register("blue_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.BLUE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block BROWN_CARPET = Blocks.register("brown_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.BROWN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block GREEN_CARPET = Blocks.register("green_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.GREEN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block RED_CARPET = Blocks.register("red_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.RED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block BLACK_CARPET = Blocks.register("black_carpet", (BlockBehaviour.Properties properties) -> new WoolCarpetBlock(DyeColor.BLACK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(0.1f).sound(SoundType.WOOL).ignitedByLava());
    public static final Block TERRACOTTA = Blocks.register("terracotta", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block COAL_BLOCK = Blocks.register("coal_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(5.0f, 6.0f));
    public static final Block PACKED_ICE = Blocks.register("packed_ice", BlockBehaviour.Properties.of().mapColor(MapColor.ICE).instrument(NoteBlockInstrument.CHIME).friction(0.98f).strength(0.5f).sound(SoundType.GLASS));
    public static final Block SUNFLOWER = Blocks.register("sunflower", TallFlowerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block LILAC = Blocks.register("lilac", TallFlowerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block ROSE_BUSH = Blocks.register("rose_bush", TallFlowerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block PEONY = Blocks.register("peony", TallFlowerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block TALL_GRASS = Blocks.register("tall_grass", DoublePlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).replaceable().noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block LARGE_FERN = Blocks.register("large_fern", DoublePlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).replaceable().noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block WHITE_BANNER = Blocks.register("white_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.WHITE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block ORANGE_BANNER = Blocks.register("orange_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.ORANGE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block MAGENTA_BANNER = Blocks.register("magenta_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.MAGENTA, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block LIGHT_BLUE_BANNER = Blocks.register("light_blue_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.LIGHT_BLUE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block YELLOW_BANNER = Blocks.register("yellow_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.YELLOW, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block LIME_BANNER = Blocks.register("lime_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.LIME, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block PINK_BANNER = Blocks.register("pink_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.PINK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block GRAY_BANNER = Blocks.register("gray_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.GRAY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block LIGHT_GRAY_BANNER = Blocks.register("light_gray_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.LIGHT_GRAY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block CYAN_BANNER = Blocks.register("cyan_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.CYAN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block PURPLE_BANNER = Blocks.register("purple_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.PURPLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BLUE_BANNER = Blocks.register("blue_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.BLUE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BROWN_BANNER = Blocks.register("brown_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.BROWN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block GREEN_BANNER = Blocks.register("green_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.GREEN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block RED_BANNER = Blocks.register("red_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.RED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BLACK_BANNER = Blocks.register("black_banner", (BlockBehaviour.Properties properties) -> new BannerBlock(DyeColor.BLACK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block WHITE_WALL_BANNER = Blocks.register("white_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.WHITE, (BlockBehaviour.Properties)properties), Blocks.wallVariant(WHITE_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block ORANGE_WALL_BANNER = Blocks.register("orange_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.ORANGE, (BlockBehaviour.Properties)properties), Blocks.wallVariant(ORANGE_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block MAGENTA_WALL_BANNER = Blocks.register("magenta_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.MAGENTA, (BlockBehaviour.Properties)properties), Blocks.wallVariant(MAGENTA_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block LIGHT_BLUE_WALL_BANNER = Blocks.register("light_blue_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.LIGHT_BLUE, (BlockBehaviour.Properties)properties), Blocks.wallVariant(LIGHT_BLUE_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block YELLOW_WALL_BANNER = Blocks.register("yellow_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.YELLOW, (BlockBehaviour.Properties)properties), Blocks.wallVariant(YELLOW_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block LIME_WALL_BANNER = Blocks.register("lime_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.LIME, (BlockBehaviour.Properties)properties), Blocks.wallVariant(LIME_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block PINK_WALL_BANNER = Blocks.register("pink_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.PINK, (BlockBehaviour.Properties)properties), Blocks.wallVariant(PINK_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block GRAY_WALL_BANNER = Blocks.register("gray_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.GRAY, (BlockBehaviour.Properties)properties), Blocks.wallVariant(GRAY_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block LIGHT_GRAY_WALL_BANNER = Blocks.register("light_gray_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.LIGHT_GRAY, (BlockBehaviour.Properties)properties), Blocks.wallVariant(LIGHT_GRAY_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block CYAN_WALL_BANNER = Blocks.register("cyan_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.CYAN, (BlockBehaviour.Properties)properties), Blocks.wallVariant(CYAN_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block PURPLE_WALL_BANNER = Blocks.register("purple_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.PURPLE, (BlockBehaviour.Properties)properties), Blocks.wallVariant(PURPLE_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BLUE_WALL_BANNER = Blocks.register("blue_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.BLUE, (BlockBehaviour.Properties)properties), Blocks.wallVariant(BLUE_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BROWN_WALL_BANNER = Blocks.register("brown_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.BROWN, (BlockBehaviour.Properties)properties), Blocks.wallVariant(BROWN_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block GREEN_WALL_BANNER = Blocks.register("green_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.GREEN, (BlockBehaviour.Properties)properties), Blocks.wallVariant(GREEN_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block RED_WALL_BANNER = Blocks.register("red_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.RED, (BlockBehaviour.Properties)properties), Blocks.wallVariant(RED_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BLACK_WALL_BANNER = Blocks.register("black_wall_banner", (BlockBehaviour.Properties properties) -> new WallBannerBlock(DyeColor.BLACK, (BlockBehaviour.Properties)properties), Blocks.wallVariant(BLACK_BANNER, true).mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block RED_SANDSTONE = Blocks.register("red_sandstone", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block CHISELED_RED_SANDSTONE = Blocks.register("chiseled_red_sandstone", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block CUT_RED_SANDSTONE = Blocks.register("cut_red_sandstone", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block RED_SANDSTONE_STAIRS = Blocks.registerLegacyStair("red_sandstone_stairs", RED_SANDSTONE);
    public static final Block OAK_SLAB = Blocks.register("oak_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block SPRUCE_SLAB = Blocks.register("spruce_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BIRCH_SLAB = Blocks.register("birch_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block JUNGLE_SLAB = Blocks.register("jungle_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block ACACIA_SLAB = Blocks.register("acacia_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block CHERRY_SLAB = Blocks.register("cherry_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD).ignitedByLava());
    public static final Block DARK_OAK_SLAB = Blocks.register("dark_oak_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block PALE_OAK_SLAB = Blocks.register("pale_oak_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block MANGROVE_SLAB = Blocks.register("mangrove_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BAMBOO_SLAB = Blocks.register("bamboo_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.BAMBOO_WOOD).ignitedByLava());
    public static final Block BAMBOO_MOSAIC_SLAB = Blocks.register("bamboo_mosaic_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.BAMBOO_WOOD).ignitedByLava());
    public static final Block STONE_SLAB = Blocks.register("stone_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SMOOTH_STONE_SLAB = Blocks.register("smooth_stone_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SANDSTONE_SLAB = Blocks.register("sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block CUT_SANDSTONE_SLAB = Blocks.register("cut_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block PETRIFIED_OAK_SLAB = Blocks.register("petrified_oak_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block COBBLESTONE_SLAB = Blocks.register("cobblestone_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block BRICK_SLAB = Blocks.register("brick_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block STONE_BRICK_SLAB = Blocks.register("stone_brick_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block MUD_BRICK_SLAB = Blocks.register("mud_brick_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 3.0f).sound(SoundType.MUD_BRICKS));
    public static final Block NETHER_BRICK_SLAB = Blocks.register("nether_brick_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundType.NETHER_BRICKS));
    public static final Block QUARTZ_SLAB = Blocks.register("quartz_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block RED_SANDSTONE_SLAB = Blocks.register("red_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block CUT_RED_SANDSTONE_SLAB = Blocks.register("cut_red_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block PURPUR_SLAB = Blocks.register("purpur_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_MAGENTA).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SMOOTH_STONE = Blocks.register("smooth_stone", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SMOOTH_SANDSTONE = Blocks.register("smooth_sandstone", BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SMOOTH_QUARTZ = Blocks.register("smooth_quartz", BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SMOOTH_RED_SANDSTONE = Blocks.register("smooth_red_sandstone", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SPRUCE_FENCE_GATE = Blocks.register("spruce_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(WoodType.SPRUCE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(SPRUCE_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block BIRCH_FENCE_GATE = Blocks.register("birch_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(WoodType.BIRCH, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(BIRCH_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block JUNGLE_FENCE_GATE = Blocks.register("jungle_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(WoodType.JUNGLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(JUNGLE_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block ACACIA_FENCE_GATE = Blocks.register("acacia_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(WoodType.ACACIA, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(ACACIA_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block CHERRY_FENCE_GATE = Blocks.register("cherry_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(WoodType.CHERRY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(CHERRY_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block DARK_OAK_FENCE_GATE = Blocks.register("dark_oak_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(WoodType.DARK_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DARK_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block PALE_OAK_FENCE_GATE = Blocks.register("pale_oak_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(WoodType.PALE_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block MANGROVE_FENCE_GATE = Blocks.register("mangrove_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(WoodType.MANGROVE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MANGROVE_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block BAMBOO_FENCE_GATE = Blocks.register("bamboo_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(WoodType.BAMBOO, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(BAMBOO_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block SPRUCE_FENCE = Blocks.register("spruce_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(SPRUCE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.WOOD));
    public static final Block BIRCH_FENCE = Blocks.register("birch_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(BIRCH_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.WOOD));
    public static final Block JUNGLE_FENCE = Blocks.register("jungle_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(JUNGLE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.WOOD));
    public static final Block ACACIA_FENCE = Blocks.register("acacia_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(ACACIA_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.WOOD));
    public static final Block CHERRY_FENCE = Blocks.register("cherry_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(CHERRY_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.CHERRY_WOOD));
    public static final Block DARK_OAK_FENCE = Blocks.register("dark_oak_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(DARK_OAK_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.WOOD));
    public static final Block PALE_OAK_FENCE = Blocks.register("pale_oak_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.WOOD));
    public static final Block MANGROVE_FENCE = Blocks.register("mangrove_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(MANGROVE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.WOOD));
    public static final Block BAMBOO_FENCE = Blocks.register("bamboo_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(BAMBOO_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.BAMBOO_WOOD).ignitedByLava());
    public static final Block SPRUCE_DOOR = Blocks.register("spruce_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.SPRUCE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(SPRUCE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block BIRCH_DOOR = Blocks.register("birch_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.BIRCH, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(BIRCH_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block JUNGLE_DOOR = Blocks.register("jungle_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.JUNGLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(JUNGLE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block ACACIA_DOOR = Blocks.register("acacia_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.ACACIA, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(ACACIA_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block CHERRY_DOOR = Blocks.register("cherry_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.CHERRY, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(CHERRY_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block DARK_OAK_DOOR = Blocks.register("dark_oak_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.DARK_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DARK_OAK_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block PALE_OAK_DOOR = Blocks.register("pale_oak_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.PALE_OAK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block MANGROVE_DOOR = Blocks.register("mangrove_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.MANGROVE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MANGROVE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block BAMBOO_DOOR = Blocks.register("bamboo_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.BAMBOO, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(BAMBOO_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block END_ROD = Blocks.register("end_rod", EndRodBlock::new, BlockBehaviour.Properties.of().forceSolidOff().instabreak().lightLevel(blockState1 -> 14).sound(SoundType.WOOD).noOcclusion());
    public static final Block CHORUS_PLANT = Blocks.register("chorus_plant", ChorusPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).forceSolidOff().strength(0.4f).sound(SoundType.WOOD).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block CHORUS_FLOWER = Blocks.register("chorus_flower", (BlockBehaviour.Properties properties) -> new ChorusFlowerBlock(CHORUS_PLANT, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).forceSolidOff().randomTicks().strength(0.4f).sound(SoundType.WOOD).noOcclusion().isValidSpawn(Blocks::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(Blocks::never));
    public static final Block PURPUR_BLOCK = Blocks.register("purpur_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_MAGENTA).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block PURPUR_PILLAR = Blocks.register("purpur_pillar", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_MAGENTA).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block PURPUR_STAIRS = Blocks.registerLegacyStair("purpur_stairs", PURPUR_BLOCK);
    public static final Block END_STONE_BRICKS = Blocks.register("end_stone_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 9.0f));
    public static final Block TORCHFLOWER_CROP = Blocks.register("torchflower_crop", TorchflowerCropBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY));
    public static final Block PITCHER_CROP = Blocks.register("pitcher_crop", PitcherCropBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY));
    public static final Block PITCHER_PLANT = Blocks.register("pitcher_plant", DoublePlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.CROP).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block BEETROOTS = Blocks.register("beetroots", BeetrootBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY));
    public static final Block DIRT_PATH = Blocks.register("dirt_path", DirtPathBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(0.65f).sound(SoundType.GRASS).isViewBlocking(Blocks::always).isSuffocating(Blocks::always));
    public static final Block END_GATEWAY = Blocks.register("end_gateway", EndGatewayBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).noCollision().lightLevel(blockState1 -> 15).strength(-1.0f, 3600000.0f).noLootTable().pushReaction(PushReaction.BLOCK));
    public static final Block REPEATING_COMMAND_BLOCK = Blocks.register("repeating_command_block", (BlockBehaviour.Properties properties) -> new CommandBlock(false, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block CHAIN_COMMAND_BLOCK = Blocks.register("chain_command_block", (BlockBehaviour.Properties properties) -> new CommandBlock(true, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).requiresCorrectToolForDrops().strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block FROSTED_ICE = Blocks.register("frosted_ice", FrostedIceBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.ICE).friction(0.98f).strength(0.5f).sound(SoundType.GLASS).noOcclusion().isValidSpawn((state, level, pos, value) -> value == EntityType.POLAR_BEAR).isRedstoneConductor(Blocks::never));
    public static final Block MAGMA_BLOCK = Blocks.register("magma_block", MagmaBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().lightLevel(blockState1 -> 3).strength(0.5f).isValidSpawn((state, level, pos, value) -> value.fireImmune()).hasPostProcess(Blocks::always).emissiveRendering(Blocks::always));
    public static final Block NETHER_WART_BLOCK = Blocks.register("nether_wart_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).strength(1.0f).sound(SoundType.WART_BLOCK));
    public static final Block RED_NETHER_BRICKS = Blocks.register("red_nether_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundType.NETHER_BRICKS));
    public static final Block BONE_BLOCK = Blocks.register("bone_block", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.XYLOPHONE).requiresCorrectToolForDrops().strength(2.0f).sound(SoundType.BONE_BLOCK));
    public static final Block STRUCTURE_VOID = Blocks.register("structure_void", StructureVoidBlock::new, BlockBehaviour.Properties.of().replaceable().noCollision().noLootTable().noTerrainParticles().pushReaction(PushReaction.DESTROY));
    public static final Block OBSERVER = Blocks.register("observer", ObserverBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(3.0f).requiresCorrectToolForDrops().isRedstoneConductor(Blocks::never));
    public static final Block SHULKER_BOX = Blocks.register("shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(null, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_PURPLE));
    public static final Block WHITE_SHULKER_BOX = Blocks.register("white_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.WHITE, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.SNOW));
    public static final Block ORANGE_SHULKER_BOX = Blocks.register("orange_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.ORANGE, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_ORANGE));
    public static final Block MAGENTA_SHULKER_BOX = Blocks.register("magenta_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.MAGENTA, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_MAGENTA));
    public static final Block LIGHT_BLUE_SHULKER_BOX = Blocks.register("light_blue_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.LIGHT_BLUE, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_LIGHT_BLUE));
    public static final Block YELLOW_SHULKER_BOX = Blocks.register("yellow_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.YELLOW, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_YELLOW));
    public static final Block LIME_SHULKER_BOX = Blocks.register("lime_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.LIME, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_LIGHT_GREEN));
    public static final Block PINK_SHULKER_BOX = Blocks.register("pink_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.PINK, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_PINK));
    public static final Block GRAY_SHULKER_BOX = Blocks.register("gray_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.GRAY, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_GRAY));
    public static final Block LIGHT_GRAY_SHULKER_BOX = Blocks.register("light_gray_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.LIGHT_GRAY, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_LIGHT_GRAY));
    public static final Block CYAN_SHULKER_BOX = Blocks.register("cyan_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.CYAN, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_CYAN));
    public static final Block PURPLE_SHULKER_BOX = Blocks.register("purple_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.PURPLE, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.TERRACOTTA_PURPLE));
    public static final Block BLUE_SHULKER_BOX = Blocks.register("blue_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.BLUE, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_BLUE));
    public static final Block BROWN_SHULKER_BOX = Blocks.register("brown_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.BROWN, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_BROWN));
    public static final Block GREEN_SHULKER_BOX = Blocks.register("green_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.GREEN, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_GREEN));
    public static final Block RED_SHULKER_BOX = Blocks.register("red_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.RED, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_RED));
    public static final Block BLACK_SHULKER_BOX = Blocks.register("black_shulker_box", (BlockBehaviour.Properties properties) -> new ShulkerBoxBlock(DyeColor.BLACK, (BlockBehaviour.Properties)properties), Blocks.shulkerBoxProperties(MapColor.COLOR_BLACK));
    public static final Block WHITE_GLAZED_TERRACOTTA = Blocks.register("white_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.WHITE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block ORANGE_GLAZED_TERRACOTTA = Blocks.register("orange_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block MAGENTA_GLAZED_TERRACOTTA = Blocks.register("magenta_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.MAGENTA).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block LIGHT_BLUE_GLAZED_TERRACOTTA = Blocks.register("light_blue_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.LIGHT_BLUE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block YELLOW_GLAZED_TERRACOTTA = Blocks.register("yellow_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.YELLOW).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block LIME_GLAZED_TERRACOTTA = Blocks.register("lime_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.LIME).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block PINK_GLAZED_TERRACOTTA = Blocks.register("pink_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.PINK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block GRAY_GLAZED_TERRACOTTA = Blocks.register("gray_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block LIGHT_GRAY_GLAZED_TERRACOTTA = Blocks.register("light_gray_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.LIGHT_GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block CYAN_GLAZED_TERRACOTTA = Blocks.register("cyan_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block PURPLE_GLAZED_TERRACOTTA = Blocks.register("purple_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block BLUE_GLAZED_TERRACOTTA = Blocks.register("blue_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.BLUE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block BROWN_GLAZED_TERRACOTTA = Blocks.register("brown_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block GREEN_GLAZED_TERRACOTTA = Blocks.register("green_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.GREEN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block RED_GLAZED_TERRACOTTA = Blocks.register("red_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.RED).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block BLACK_GLAZED_TERRACOTTA = Blocks.register("black_glazed_terracotta", GlazedTerracottaBlock::new, BlockBehaviour.Properties.of().mapColor(DyeColor.BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(PushReaction.PUSH_ONLY));
    public static final Block WHITE_CONCRETE = Blocks.register("white_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.WHITE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block ORANGE_CONCRETE = Blocks.register("orange_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block MAGENTA_CONCRETE = Blocks.register("magenta_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.MAGENTA).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block LIGHT_BLUE_CONCRETE = Blocks.register("light_blue_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.LIGHT_BLUE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block YELLOW_CONCRETE = Blocks.register("yellow_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.YELLOW).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block LIME_CONCRETE = Blocks.register("lime_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.LIME).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block PINK_CONCRETE = Blocks.register("pink_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.PINK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block GRAY_CONCRETE = Blocks.register("gray_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block LIGHT_GRAY_CONCRETE = Blocks.register("light_gray_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.LIGHT_GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block CYAN_CONCRETE = Blocks.register("cyan_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block PURPLE_CONCRETE = Blocks.register("purple_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block BLUE_CONCRETE = Blocks.register("blue_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.BLUE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block BROWN_CONCRETE = Blocks.register("brown_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block GREEN_CONCRETE = Blocks.register("green_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.GREEN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block RED_CONCRETE = Blocks.register("red_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.RED).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block BLACK_CONCRETE = Blocks.register("black_concrete", BlockBehaviour.Properties.of().mapColor(DyeColor.BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block WHITE_CONCRETE_POWDER = Blocks.register("white_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(WHITE_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.WHITE).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block ORANGE_CONCRETE_POWDER = Blocks.register("orange_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(ORANGE_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.ORANGE).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block MAGENTA_CONCRETE_POWDER = Blocks.register("magenta_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(MAGENTA_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.MAGENTA).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block LIGHT_BLUE_CONCRETE_POWDER = Blocks.register("light_blue_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(LIGHT_BLUE_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.LIGHT_BLUE).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block YELLOW_CONCRETE_POWDER = Blocks.register("yellow_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(YELLOW_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.YELLOW).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block LIME_CONCRETE_POWDER = Blocks.register("lime_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(LIME_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.LIME).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block PINK_CONCRETE_POWDER = Blocks.register("pink_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(PINK_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.PINK).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block GRAY_CONCRETE_POWDER = Blocks.register("gray_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(GRAY_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block LIGHT_GRAY_CONCRETE_POWDER = Blocks.register("light_gray_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(LIGHT_GRAY_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.LIGHT_GRAY).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block CYAN_CONCRETE_POWDER = Blocks.register("cyan_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(CYAN_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block PURPLE_CONCRETE_POWDER = Blocks.register("purple_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(PURPLE_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block BLUE_CONCRETE_POWDER = Blocks.register("blue_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(BLUE_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.BLUE).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block BROWN_CONCRETE_POWDER = Blocks.register("brown_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(BROWN_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block GREEN_CONCRETE_POWDER = Blocks.register("green_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(GREEN_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.GREEN).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block RED_CONCRETE_POWDER = Blocks.register("red_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(RED_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.RED).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block BLACK_CONCRETE_POWDER = Blocks.register("black_concrete_powder", (BlockBehaviour.Properties properties) -> new ConcretePowderBlock(BLACK_CONCRETE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(DyeColor.BLACK).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final Block KELP = Blocks.register("kelp", KelpBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WATER).noCollision().randomTicks().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block KELP_PLANT = Blocks.register("kelp_plant", KelpPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WATER).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block DRIED_KELP_BLOCK = Blocks.register("dried_kelp_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(0.5f, 2.5f).sound(SoundType.GRASS));
    public static final Block TURTLE_EGG = Blocks.register("turtle_egg", TurtleEggBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).forceSolidOn().strength(0.5f).sound(SoundType.METAL).randomTicks().noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block SNIFFER_EGG = Blocks.register("sniffer_egg", SnifferEggBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).strength(0.5f).sound(SoundType.METAL).noOcclusion());
    public static final Block DRIED_GHAST = Blocks.register("dried_ghast", DriedGhastBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instabreak().sound(SoundType.DRIED_GHAST).noOcclusion().randomTicks());
    public static final Block DEAD_TUBE_CORAL_BLOCK = Blocks.register("dead_tube_coral_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DEAD_BRAIN_CORAL_BLOCK = Blocks.register("dead_brain_coral_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DEAD_BUBBLE_CORAL_BLOCK = Blocks.register("dead_bubble_coral_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DEAD_FIRE_CORAL_BLOCK = Blocks.register("dead_fire_coral_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DEAD_HORN_CORAL_BLOCK = Blocks.register("dead_horn_coral_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block TUBE_CORAL_BLOCK = Blocks.register("tube_coral_block", (BlockBehaviour.Properties properties) -> new CoralBlock(DEAD_TUBE_CORAL_BLOCK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundType.CORAL_BLOCK));
    public static final Block BRAIN_CORAL_BLOCK = Blocks.register("brain_coral_block", (BlockBehaviour.Properties properties) -> new CoralBlock(DEAD_BRAIN_CORAL_BLOCK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundType.CORAL_BLOCK));
    public static final Block BUBBLE_CORAL_BLOCK = Blocks.register("bubble_coral_block", (BlockBehaviour.Properties properties) -> new CoralBlock(DEAD_BUBBLE_CORAL_BLOCK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundType.CORAL_BLOCK));
    public static final Block FIRE_CORAL_BLOCK = Blocks.register("fire_coral_block", (BlockBehaviour.Properties properties) -> new CoralBlock(DEAD_FIRE_CORAL_BLOCK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundType.CORAL_BLOCK));
    public static final Block HORN_CORAL_BLOCK = Blocks.register("horn_coral_block", (BlockBehaviour.Properties properties) -> new CoralBlock(DEAD_HORN_CORAL_BLOCK, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundType.CORAL_BLOCK));
    public static final Block DEAD_TUBE_CORAL = Blocks.register("dead_tube_coral", BaseCoralPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_BRAIN_CORAL = Blocks.register("dead_brain_coral", BaseCoralPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_BUBBLE_CORAL = Blocks.register("dead_bubble_coral", BaseCoralPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_FIRE_CORAL = Blocks.register("dead_fire_coral", BaseCoralPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_HORN_CORAL = Blocks.register("dead_horn_coral", BaseCoralPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block TUBE_CORAL = Blocks.register("tube_coral", (BlockBehaviour.Properties properties) -> new CoralPlantBlock(DEAD_TUBE_CORAL, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block BRAIN_CORAL = Blocks.register("brain_coral", (BlockBehaviour.Properties properties) -> new CoralPlantBlock(DEAD_BRAIN_CORAL, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block BUBBLE_CORAL = Blocks.register("bubble_coral", (BlockBehaviour.Properties properties) -> new CoralPlantBlock(DEAD_BUBBLE_CORAL, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block FIRE_CORAL = Blocks.register("fire_coral", (BlockBehaviour.Properties properties) -> new CoralPlantBlock(DEAD_FIRE_CORAL, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block HORN_CORAL = Blocks.register("horn_coral", (BlockBehaviour.Properties properties) -> new CoralPlantBlock(DEAD_HORN_CORAL, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block DEAD_TUBE_CORAL_FAN = Blocks.register("dead_tube_coral_fan", BaseCoralFanBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_BRAIN_CORAL_FAN = Blocks.register("dead_brain_coral_fan", BaseCoralFanBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_BUBBLE_CORAL_FAN = Blocks.register("dead_bubble_coral_fan", BaseCoralFanBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_FIRE_CORAL_FAN = Blocks.register("dead_fire_coral_fan", BaseCoralFanBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_HORN_CORAL_FAN = Blocks.register("dead_horn_coral_fan", BaseCoralFanBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block TUBE_CORAL_FAN = Blocks.register("tube_coral_fan", (BlockBehaviour.Properties properties) -> new CoralFanBlock(DEAD_TUBE_CORAL_FAN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block BRAIN_CORAL_FAN = Blocks.register("brain_coral_fan", (BlockBehaviour.Properties properties) -> new CoralFanBlock(DEAD_BRAIN_CORAL_FAN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block BUBBLE_CORAL_FAN = Blocks.register("bubble_coral_fan", (BlockBehaviour.Properties properties) -> new CoralFanBlock(DEAD_BUBBLE_CORAL_FAN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block FIRE_CORAL_FAN = Blocks.register("fire_coral_fan", (BlockBehaviour.Properties properties) -> new CoralFanBlock(DEAD_FIRE_CORAL_FAN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block HORN_CORAL_FAN = Blocks.register("horn_coral_fan", (BlockBehaviour.Properties properties) -> new CoralFanBlock(DEAD_HORN_CORAL_FAN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block DEAD_TUBE_CORAL_WALL_FAN = Blocks.register("dead_tube_coral_wall_fan", BaseCoralWallFanBlock::new, Blocks.wallVariant(DEAD_TUBE_CORAL_FAN, false).mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_BRAIN_CORAL_WALL_FAN = Blocks.register("dead_brain_coral_wall_fan", BaseCoralWallFanBlock::new, Blocks.wallVariant(DEAD_BRAIN_CORAL_FAN, false).mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_BUBBLE_CORAL_WALL_FAN = Blocks.register("dead_bubble_coral_wall_fan", BaseCoralWallFanBlock::new, Blocks.wallVariant(DEAD_BUBBLE_CORAL_FAN, false).mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_FIRE_CORAL_WALL_FAN = Blocks.register("dead_fire_coral_wall_fan", BaseCoralWallFanBlock::new, Blocks.wallVariant(DEAD_FIRE_CORAL_FAN, false).mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_HORN_CORAL_WALL_FAN = Blocks.register("dead_horn_coral_wall_fan", BaseCoralWallFanBlock::new, Blocks.wallVariant(DEAD_HORN_CORAL_FAN, false).mapColor(MapColor.COLOR_GRAY).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block TUBE_CORAL_WALL_FAN = Blocks.register("tube_coral_wall_fan", (BlockBehaviour.Properties properties) -> new CoralWallFanBlock(DEAD_TUBE_CORAL_WALL_FAN, (BlockBehaviour.Properties)properties), Blocks.wallVariant(TUBE_CORAL_FAN, false).mapColor(MapColor.COLOR_BLUE).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block BRAIN_CORAL_WALL_FAN = Blocks.register("brain_coral_wall_fan", (BlockBehaviour.Properties properties) -> new CoralWallFanBlock(DEAD_BRAIN_CORAL_WALL_FAN, (BlockBehaviour.Properties)properties), Blocks.wallVariant(BRAIN_CORAL_FAN, false).mapColor(MapColor.COLOR_PINK).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block BUBBLE_CORAL_WALL_FAN = Blocks.register("bubble_coral_wall_fan", (BlockBehaviour.Properties properties) -> new CoralWallFanBlock(DEAD_BUBBLE_CORAL_WALL_FAN, (BlockBehaviour.Properties)properties), Blocks.wallVariant(BUBBLE_CORAL_FAN, false).mapColor(MapColor.COLOR_PURPLE).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block FIRE_CORAL_WALL_FAN = Blocks.register("fire_coral_wall_fan", (BlockBehaviour.Properties properties) -> new CoralWallFanBlock(DEAD_FIRE_CORAL_WALL_FAN, (BlockBehaviour.Properties)properties), Blocks.wallVariant(FIRE_CORAL_FAN, false).mapColor(MapColor.COLOR_RED).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block HORN_CORAL_WALL_FAN = Blocks.register("horn_coral_wall_fan", (BlockBehaviour.Properties properties) -> new CoralWallFanBlock(DEAD_HORN_CORAL_WALL_FAN, (BlockBehaviour.Properties)properties), Blocks.wallVariant(HORN_CORAL_FAN, false).mapColor(MapColor.COLOR_YELLOW).noCollision().instabreak().sound(SoundType.WET_GRASS).pushReaction(PushReaction.DESTROY));
    public static final Block SEA_PICKLE = Blocks.register("sea_pickle", SeaPickleBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).lightLevel(blockState1 -> SeaPickleBlock.isDead(blockState1) ? 0 : 3 + 3 * blockState1.getValue(SeaPickleBlock.PICKLES)).sound(SoundType.SLIME_BLOCK).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block BLUE_ICE = Blocks.register("blue_ice", HalfTransparentBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.ICE).strength(2.8f).friction(0.989f).sound(SoundType.GLASS));
    public static final Block CONDUIT = Blocks.register("conduit", ConduitBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).forceSolidOn().instrument(NoteBlockInstrument.HAT).strength(3.0f).lightLevel(blockState1 -> 15).noOcclusion());
    public static final Block BAMBOO_SAPLING = Blocks.register("bamboo_sapling", BambooSaplingBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().randomTicks().instabreak().noCollision().strength(1.0f).sound(SoundType.BAMBOO_SAPLING).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block BAMBOO = Blocks.register("bamboo", BambooStalkBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).forceSolidOn().randomTicks().instabreak().strength(1.0f).sound(SoundType.BAMBOO).noOcclusion().dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(Blocks::never));
    public static final Block POTTED_BAMBOO = Blocks.register("potted_bamboo", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(BAMBOO, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block VOID_AIR = Blocks.register("void_air", AirBlock::new, BlockBehaviour.Properties.of().replaceable().noCollision().noLootTable().air());
    public static final Block CAVE_AIR = Blocks.register("cave_air", AirBlock::new, BlockBehaviour.Properties.of().replaceable().noCollision().noLootTable().air());
    public static final Block BUBBLE_COLUMN = Blocks.register("bubble_column", BubbleColumnBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WATER).replaceable().noCollision().noLootTable().pushReaction(PushReaction.DESTROY).liquid().sound(SoundType.EMPTY));
    public static final Block POLISHED_GRANITE_STAIRS = Blocks.registerLegacyStair("polished_granite_stairs", POLISHED_GRANITE);
    public static final Block SMOOTH_RED_SANDSTONE_STAIRS = Blocks.registerLegacyStair("smooth_red_sandstone_stairs", SMOOTH_RED_SANDSTONE);
    public static final Block MOSSY_STONE_BRICK_STAIRS = Blocks.registerLegacyStair("mossy_stone_brick_stairs", MOSSY_STONE_BRICKS);
    public static final Block POLISHED_DIORITE_STAIRS = Blocks.registerLegacyStair("polished_diorite_stairs", POLISHED_DIORITE);
    public static final Block MOSSY_COBBLESTONE_STAIRS = Blocks.registerLegacyStair("mossy_cobblestone_stairs", MOSSY_COBBLESTONE);
    public static final Block END_STONE_BRICK_STAIRS = Blocks.registerLegacyStair("end_stone_brick_stairs", END_STONE_BRICKS);
    public static final Block STONE_STAIRS = Blocks.registerLegacyStair("stone_stairs", STONE);
    public static final Block SMOOTH_SANDSTONE_STAIRS = Blocks.registerLegacyStair("smooth_sandstone_stairs", SMOOTH_SANDSTONE);
    public static final Block SMOOTH_QUARTZ_STAIRS = Blocks.registerLegacyStair("smooth_quartz_stairs", SMOOTH_QUARTZ);
    public static final Block GRANITE_STAIRS = Blocks.registerLegacyStair("granite_stairs", GRANITE);
    public static final Block ANDESITE_STAIRS = Blocks.registerLegacyStair("andesite_stairs", ANDESITE);
    public static final Block RED_NETHER_BRICK_STAIRS = Blocks.registerLegacyStair("red_nether_brick_stairs", RED_NETHER_BRICKS);
    public static final Block POLISHED_ANDESITE_STAIRS = Blocks.registerLegacyStair("polished_andesite_stairs", POLISHED_ANDESITE);
    public static final Block DIORITE_STAIRS = Blocks.registerLegacyStair("diorite_stairs", DIORITE);
    public static final Block POLISHED_GRANITE_SLAB = Blocks.register("polished_granite_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(POLISHED_GRANITE));
    public static final Block SMOOTH_RED_SANDSTONE_SLAB = Blocks.register("smooth_red_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(SMOOTH_RED_SANDSTONE));
    public static final Block MOSSY_STONE_BRICK_SLAB = Blocks.register("mossy_stone_brick_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(MOSSY_STONE_BRICKS));
    public static final Block POLISHED_DIORITE_SLAB = Blocks.register("polished_diorite_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(POLISHED_DIORITE));
    public static final Block MOSSY_COBBLESTONE_SLAB = Blocks.register("mossy_cobblestone_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(MOSSY_COBBLESTONE));
    public static final Block END_STONE_BRICK_SLAB = Blocks.register("end_stone_brick_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(END_STONE_BRICKS));
    public static final Block SMOOTH_SANDSTONE_SLAB = Blocks.register("smooth_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(SMOOTH_SANDSTONE));
    public static final Block SMOOTH_QUARTZ_SLAB = Blocks.register("smooth_quartz_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(SMOOTH_QUARTZ));
    public static final Block GRANITE_SLAB = Blocks.register("granite_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(GRANITE));
    public static final Block ANDESITE_SLAB = Blocks.register("andesite_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(ANDESITE));
    public static final Block RED_NETHER_BRICK_SLAB = Blocks.register("red_nether_brick_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(RED_NETHER_BRICKS));
    public static final Block POLISHED_ANDESITE_SLAB = Blocks.register("polished_andesite_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(POLISHED_ANDESITE));
    public static final Block DIORITE_SLAB = Blocks.register("diorite_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(DIORITE));
    public static final Block BRICK_WALL = Blocks.register("brick_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(BRICKS).forceSolidOn());
    public static final Block PRISMARINE_WALL = Blocks.register("prismarine_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(PRISMARINE).forceSolidOn());
    public static final Block RED_SANDSTONE_WALL = Blocks.register("red_sandstone_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(RED_SANDSTONE).forceSolidOn());
    public static final Block MOSSY_STONE_BRICK_WALL = Blocks.register("mossy_stone_brick_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(MOSSY_STONE_BRICKS).forceSolidOn());
    public static final Block GRANITE_WALL = Blocks.register("granite_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(GRANITE).forceSolidOn());
    public static final Block STONE_BRICK_WALL = Blocks.register("stone_brick_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(STONE_BRICKS).forceSolidOn());
    public static final Block MUD_BRICK_WALL = Blocks.register("mud_brick_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(MUD_BRICKS).forceSolidOn());
    public static final Block NETHER_BRICK_WALL = Blocks.register("nether_brick_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(NETHER_BRICKS).forceSolidOn());
    public static final Block ANDESITE_WALL = Blocks.register("andesite_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(ANDESITE).forceSolidOn());
    public static final Block RED_NETHER_BRICK_WALL = Blocks.register("red_nether_brick_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(RED_NETHER_BRICKS).forceSolidOn());
    public static final Block SANDSTONE_WALL = Blocks.register("sandstone_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(SANDSTONE).forceSolidOn());
    public static final Block END_STONE_BRICK_WALL = Blocks.register("end_stone_brick_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(END_STONE_BRICKS).forceSolidOn());
    public static final Block DIORITE_WALL = Blocks.register("diorite_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(DIORITE).forceSolidOn());
    public static final Block SCAFFOLDING = Blocks.register("scaffolding", ScaffoldingBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).noCollision().sound(SoundType.SCAFFOLDING).dynamicShape().isValidSpawn(Blocks::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(Blocks::never));
    public static final Block LOOM = Blocks.register("loom", LoomBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BARREL = Blocks.register("barrel", BarrelBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block SMOKER = Blocks.register("smoker", SmokerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f).lightLevel(Blocks.litBlockEmission(13)));
    public static final Block BLAST_FURNACE = Blocks.register("blast_furnace", BlastFurnaceBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f).lightLevel(Blocks.litBlockEmission(13)));
    public static final Block CARTOGRAPHY_TABLE = Blocks.register("cartography_table", CartographyTableBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block FLETCHING_TABLE = Blocks.register("fletching_table", BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block GRINDSTONE = Blocks.register("grindstone", GrindstoneBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundType.STONE).pushReaction(PushReaction.BLOCK));
    public static final Block LECTERN = Blocks.register("lectern", LecternBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block SMITHING_TABLE = Blocks.register("smithing_table", SmithingTableBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block STONECUTTER = Blocks.register("stonecutter", StonecutterBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f));
    public static final Block BELL = Blocks.register("bell", BellBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).forceSolidOn().strength(5.0f).sound(SoundType.ANVIL).pushReaction(PushReaction.DESTROY));
    public static final Block LANTERN = Blocks.register("lantern", LanternBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundType.LANTERN).lightLevel(blockState1 -> 15).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block SOUL_LANTERN = Blocks.register("soul_lantern", LanternBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundType.LANTERN).lightLevel(blockState1 -> 10).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final WeatheringCopperBlocks COPPER_LANTERN = WeatheringCopperBlocks.create("copper_lantern", (TriFunction<String, Function<BlockBehaviour.Properties, Block>, BlockBehaviour.Properties, Block>)((TriFunction)Blocks::register), LanternBlock::new, WeatheringLanternBlock::new, weatherState -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundType.LANTERN).lightLevel(blockState1 -> 15).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block CAMPFIRE = Blocks.register("campfire", (BlockBehaviour.Properties properties) -> new CampfireBlock(true, 1, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(Blocks.litBlockEmission(15)).noOcclusion().ignitedByLava());
    public static final Block SOUL_CAMPFIRE = Blocks.register("soul_campfire", (BlockBehaviour.Properties properties) -> new CampfireBlock(false, 2, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(Blocks.litBlockEmission(10)).noOcclusion().ignitedByLava());
    public static final Block SWEET_BERRY_BUSH = Blocks.register("sweet_berry_bush", SweetBerryBushBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().noCollision().sound(SoundType.SWEET_BERRY_BUSH).pushReaction(PushReaction.DESTROY));
    public static final Block WARPED_STEM = Blocks.register("warped_stem", RotatedPillarBlock::new, Blocks.netherStemProperties(MapColor.WARPED_STEM));
    public static final Block STRIPPED_WARPED_STEM = Blocks.register("stripped_warped_stem", RotatedPillarBlock::new, Blocks.netherStemProperties(MapColor.WARPED_STEM));
    public static final Block WARPED_HYPHAE = Blocks.register("warped_hyphae", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_HYPHAE).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.STEM));
    public static final Block STRIPPED_WARPED_HYPHAE = Blocks.register("stripped_warped_hyphae", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_HYPHAE).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.STEM));
    public static final Block WARPED_NYLIUM = Blocks.register("warped_nylium", NyliumBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_NYLIUM).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundType.NYLIUM).randomTicks());
    public static final Block WARPED_FUNGUS = Blocks.register("warped_fungus", (BlockBehaviour.Properties properties) -> new FungusBlock(TreeFeatures.WARPED_FUNGUS_PLANTED, WARPED_NYLIUM, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).instabreak().noCollision().sound(SoundType.FUNGUS).pushReaction(PushReaction.DESTROY));
    public static final Block WARPED_WART_BLOCK = Blocks.register("warped_wart_block", BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_WART_BLOCK).strength(1.0f).sound(SoundType.WART_BLOCK));
    public static final Block WARPED_ROOTS = Blocks.register("warped_roots", RootsBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).replaceable().noCollision().instabreak().sound(SoundType.ROOTS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block NETHER_SPROUTS = Blocks.register("nether_sprouts", NetherSproutsBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).replaceable().noCollision().instabreak().sound(SoundType.NETHER_SPROUTS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block CRIMSON_STEM = Blocks.register("crimson_stem", RotatedPillarBlock::new, Blocks.netherStemProperties(MapColor.CRIMSON_STEM));
    public static final Block STRIPPED_CRIMSON_STEM = Blocks.register("stripped_crimson_stem", RotatedPillarBlock::new, Blocks.netherStemProperties(MapColor.CRIMSON_STEM));
    public static final Block CRIMSON_HYPHAE = Blocks.register("crimson_hyphae", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_HYPHAE).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.STEM));
    public static final Block STRIPPED_CRIMSON_HYPHAE = Blocks.register("stripped_crimson_hyphae", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_HYPHAE).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.STEM));
    public static final Block CRIMSON_NYLIUM = Blocks.register("crimson_nylium", NyliumBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_NYLIUM).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundType.NYLIUM).randomTicks());
    public static final Block CRIMSON_FUNGUS = Blocks.register("crimson_fungus", (BlockBehaviour.Properties properties) -> new FungusBlock(TreeFeatures.CRIMSON_FUNGUS_PLANTED, CRIMSON_NYLIUM, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instabreak().noCollision().sound(SoundType.FUNGUS).pushReaction(PushReaction.DESTROY));
    public static final Block SHROOMLIGHT = Blocks.register("shroomlight", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).strength(1.0f).sound(SoundType.SHROOMLIGHT).lightLevel(blockState1 -> 15));
    public static final Block WEEPING_VINES = Blocks.register("weeping_vines", WeepingVinesBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).randomTicks().noCollision().instabreak().sound(SoundType.WEEPING_VINES).pushReaction(PushReaction.DESTROY));
    public static final Block WEEPING_VINES_PLANT = Blocks.register("weeping_vines_plant", WeepingVinesPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).noCollision().instabreak().sound(SoundType.WEEPING_VINES).pushReaction(PushReaction.DESTROY));
    public static final Block TWISTING_VINES = Blocks.register("twisting_vines", TwistingVinesBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).randomTicks().noCollision().instabreak().sound(SoundType.WEEPING_VINES).pushReaction(PushReaction.DESTROY));
    public static final Block TWISTING_VINES_PLANT = Blocks.register("twisting_vines_plant", TwistingVinesPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).noCollision().instabreak().sound(SoundType.WEEPING_VINES).pushReaction(PushReaction.DESTROY));
    public static final Block CRIMSON_ROOTS = Blocks.register("crimson_roots", RootsBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).replaceable().noCollision().instabreak().sound(SoundType.ROOTS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    public static final Block CRIMSON_PLANKS = Blocks.register("crimson_planks", BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_STEM).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
    public static final Block WARPED_PLANKS = Blocks.register("warped_planks", BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_STEM).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
    public static final Block CRIMSON_SLAB = Blocks.register("crimson_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
    public static final Block WARPED_SLAB = Blocks.register("warped_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(WARPED_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
    public static final Block CRIMSON_PRESSURE_PLATE = Blocks.register("crimson_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.CRIMSON, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).pushReaction(PushReaction.DESTROY));
    public static final Block WARPED_PRESSURE_PLATE = Blocks.register("warped_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.WARPED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(WARPED_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).pushReaction(PushReaction.DESTROY));
    public static final Block CRIMSON_FENCE = Blocks.register("crimson_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
    public static final Block WARPED_FENCE = Blocks.register("warped_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(WARPED_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
    public static final Block CRIMSON_TRAPDOOR = Blocks.register("crimson_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.CRIMSON, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never));
    public static final Block WARPED_TRAPDOOR = Blocks.register("warped_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.WARPED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(WARPED_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never));
    public static final Block CRIMSON_FENCE_GATE = Blocks.register("crimson_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(WoodType.CRIMSON, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f));
    public static final Block WARPED_FENCE_GATE = Blocks.register("warped_fence_gate", (BlockBehaviour.Properties properties) -> new FenceGateBlock(WoodType.WARPED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(WARPED_PLANKS.defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f));
    public static final Block CRIMSON_STAIRS = Blocks.registerLegacyStair("crimson_stairs", CRIMSON_PLANKS);
    public static final Block WARPED_STAIRS = Blocks.registerLegacyStair("warped_stairs", WARPED_PLANKS);
    public static final Block CRIMSON_BUTTON = Blocks.register("crimson_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.CRIMSON, 30, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block WARPED_BUTTON = Blocks.register("warped_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.WARPED, 30, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block CRIMSON_DOOR = Blocks.register("crimson_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.CRIMSON, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block WARPED_DOOR = Blocks.register("warped_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.WARPED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(WARPED_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block CRIMSON_SIGN = Blocks.register("crimson_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(WoodType.CRIMSON, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).forceSolidOn().noCollision().strength(1.0f));
    public static final Block WARPED_SIGN = Blocks.register("warped_sign", (BlockBehaviour.Properties properties) -> new StandingSignBlock(WoodType.WARPED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(WARPED_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).forceSolidOn().noCollision().strength(1.0f));
    public static final Block CRIMSON_WALL_SIGN = Blocks.register("crimson_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(WoodType.CRIMSON, (BlockBehaviour.Properties)properties), Blocks.wallVariant(CRIMSON_SIGN, true).mapColor(CRIMSON_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).forceSolidOn().noCollision().strength(1.0f));
    public static final Block WARPED_WALL_SIGN = Blocks.register("warped_wall_sign", (BlockBehaviour.Properties properties) -> new WallSignBlock(WoodType.WARPED, (BlockBehaviour.Properties)properties), Blocks.wallVariant(WARPED_SIGN, true).mapColor(WARPED_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).forceSolidOn().noCollision().strength(1.0f));
    public static final Block STRUCTURE_BLOCK = Blocks.register("structure_block", StructureBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).requiresCorrectToolForDrops().strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block JIGSAW = Blocks.register("jigsaw", JigsawBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).requiresCorrectToolForDrops().strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block TEST_BLOCK = Blocks.register("test_block", TestBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block TEST_INSTANCE_BLOCK = Blocks.register("test_instance_block", TestInstanceBlock::new, BlockBehaviour.Properties.of().noOcclusion().strength(-1.0f, 3600000.0f).noLootTable().isViewBlocking(Blocks::never));
    public static final Block COMPOSTER = Blocks.register("composter", ComposterBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(0.6f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block TARGET = Blocks.register("target", TargetBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).strength(0.5f).sound(SoundType.GRASS));
    public static final Block BEE_NEST = Blocks.register("bee_nest", BeehiveBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BASS).strength(0.3f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block BEEHIVE = Blocks.register("beehive", BeehiveBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(0.6f).sound(SoundType.WOOD).ignitedByLava());
    public static final Block HONEY_BLOCK = Blocks.register("honey_block", HoneyBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).speedFactor(0.4f).jumpFactor(0.5f).noOcclusion().sound(SoundType.HONEY_BLOCK));
    public static final Block HONEYCOMB_BLOCK = Blocks.register("honeycomb_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(0.6f).sound(SoundType.CORAL_BLOCK));
    public static final Block NETHERITE_BLOCK = Blocks.register("netherite_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(50.0f, 1200.0f).sound(SoundType.NETHERITE_BLOCK));
    public static final Block ANCIENT_DEBRIS = Blocks.register("ancient_debris", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(30.0f, 1200.0f).sound(SoundType.ANCIENT_DEBRIS));
    public static final Block CRYING_OBSIDIAN = Blocks.register("crying_obsidian", CryingObsidianBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(50.0f, 1200.0f).lightLevel(blockState1 -> 10));
    public static final Block RESPAWN_ANCHOR = Blocks.register("respawn_anchor", RespawnAnchorBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(50.0f, 1200.0f).lightLevel(blockState1 -> RespawnAnchorBlock.getScaledChargeLevel(blockState1, 15)));
    public static final Block POTTED_CRIMSON_FUNGUS = Blocks.register("potted_crimson_fungus", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(CRIMSON_FUNGUS, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_WARPED_FUNGUS = Blocks.register("potted_warped_fungus", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(WARPED_FUNGUS, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_CRIMSON_ROOTS = Blocks.register("potted_crimson_roots", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(CRIMSON_ROOTS, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_WARPED_ROOTS = Blocks.register("potted_warped_roots", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(WARPED_ROOTS, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block LODESTONE = Blocks.register("lodestone", BlockBehaviour.Properties.of().mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(3.5f).sound(SoundType.LODESTONE).pushReaction(PushReaction.BLOCK));
    public static final Block BLACKSTONE = Blocks.register("blackstone", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block BLACKSTONE_STAIRS = Blocks.registerLegacyStair("blackstone_stairs", BLACKSTONE);
    public static final Block BLACKSTONE_WALL = Blocks.register("blackstone_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(BLACKSTONE).forceSolidOn());
    public static final Block BLACKSTONE_SLAB = Blocks.register("blackstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(BLACKSTONE).strength(2.0f, 6.0f));
    public static final Block POLISHED_BLACKSTONE = Blocks.register("polished_blackstone", BlockBehaviour.Properties.ofLegacyCopy(BLACKSTONE).strength(2.0f, 6.0f));
    public static final Block POLISHED_BLACKSTONE_BRICKS = Blocks.register("polished_blackstone_bricks", BlockBehaviour.Properties.ofLegacyCopy(POLISHED_BLACKSTONE).strength(1.5f, 6.0f));
    public static final Block CRACKED_POLISHED_BLACKSTONE_BRICKS = Blocks.register("cracked_polished_blackstone_bricks", BlockBehaviour.Properties.ofLegacyCopy(POLISHED_BLACKSTONE_BRICKS));
    public static final Block CHISELED_POLISHED_BLACKSTONE = Blocks.register("chiseled_polished_blackstone", BlockBehaviour.Properties.ofLegacyCopy(POLISHED_BLACKSTONE).strength(1.5f, 6.0f));
    public static final Block POLISHED_BLACKSTONE_BRICK_SLAB = Blocks.register("polished_blackstone_brick_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(POLISHED_BLACKSTONE_BRICKS).strength(2.0f, 6.0f));
    public static final Block POLISHED_BLACKSTONE_BRICK_STAIRS = Blocks.registerLegacyStair("polished_blackstone_brick_stairs", POLISHED_BLACKSTONE_BRICKS);
    public static final Block POLISHED_BLACKSTONE_BRICK_WALL = Blocks.register("polished_blackstone_brick_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(POLISHED_BLACKSTONE_BRICKS).forceSolidOn());
    public static final Block GILDED_BLACKSTONE = Blocks.register("gilded_blackstone", BlockBehaviour.Properties.ofLegacyCopy(BLACKSTONE).sound(SoundType.GILDED_BLACKSTONE));
    public static final Block POLISHED_BLACKSTONE_STAIRS = Blocks.registerLegacyStair("polished_blackstone_stairs", POLISHED_BLACKSTONE);
    public static final Block POLISHED_BLACKSTONE_SLAB = Blocks.register("polished_blackstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(POLISHED_BLACKSTONE));
    public static final Block POLISHED_BLACKSTONE_PRESSURE_PLATE = Blocks.register("polished_blackstone_pressure_plate", (BlockBehaviour.Properties properties) -> new PressurePlateBlock(BlockSetType.POLISHED_BLACKSTONE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).noCollision().strength(0.5f).pushReaction(PushReaction.DESTROY));
    public static final Block POLISHED_BLACKSTONE_BUTTON = Blocks.register("polished_blackstone_button", (BlockBehaviour.Properties properties) -> new ButtonBlock(BlockSetType.STONE, 20, (BlockBehaviour.Properties)properties), Blocks.buttonProperties());
    public static final Block POLISHED_BLACKSTONE_WALL = Blocks.register("polished_blackstone_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(POLISHED_BLACKSTONE).forceSolidOn());
    public static final Block CHISELED_NETHER_BRICKS = Blocks.register("chiseled_nether_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundType.NETHER_BRICKS));
    public static final Block CRACKED_NETHER_BRICKS = Blocks.register("cracked_nether_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundType.NETHER_BRICKS));
    public static final Block QUARTZ_BRICKS = Blocks.register("quartz_bricks", BlockBehaviour.Properties.ofLegacyCopy(QUARTZ_BLOCK));
    public static final Block CANDLE = Blocks.register("candle", CandleBlock::new, Blocks.candleProperties(MapColor.SAND));
    public static final Block WHITE_CANDLE = Blocks.register("white_candle", CandleBlock::new, Blocks.candleProperties(MapColor.WOOL));
    public static final Block ORANGE_CANDLE = Blocks.register("orange_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_ORANGE));
    public static final Block MAGENTA_CANDLE = Blocks.register("magenta_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_MAGENTA));
    public static final Block LIGHT_BLUE_CANDLE = Blocks.register("light_blue_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_LIGHT_BLUE));
    public static final Block YELLOW_CANDLE = Blocks.register("yellow_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_YELLOW));
    public static final Block LIME_CANDLE = Blocks.register("lime_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_LIGHT_GREEN));
    public static final Block PINK_CANDLE = Blocks.register("pink_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_PINK));
    public static final Block GRAY_CANDLE = Blocks.register("gray_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_GRAY));
    public static final Block LIGHT_GRAY_CANDLE = Blocks.register("light_gray_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_LIGHT_GRAY));
    public static final Block CYAN_CANDLE = Blocks.register("cyan_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_CYAN));
    public static final Block PURPLE_CANDLE = Blocks.register("purple_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_PURPLE));
    public static final Block BLUE_CANDLE = Blocks.register("blue_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_BLUE));
    public static final Block BROWN_CANDLE = Blocks.register("brown_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_BROWN));
    public static final Block GREEN_CANDLE = Blocks.register("green_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_GREEN));
    public static final Block RED_CANDLE = Blocks.register("red_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_RED));
    public static final Block BLACK_CANDLE = Blocks.register("black_candle", CandleBlock::new, Blocks.candleProperties(MapColor.COLOR_BLACK));
    public static final Block CANDLE_CAKE = Blocks.register("candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CAKE).lightLevel(Blocks.litBlockEmission(3)));
    public static final Block WHITE_CANDLE_CAKE = Blocks.register("white_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(WHITE_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block ORANGE_CANDLE_CAKE = Blocks.register("orange_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(ORANGE_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block MAGENTA_CANDLE_CAKE = Blocks.register("magenta_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(MAGENTA_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block LIGHT_BLUE_CANDLE_CAKE = Blocks.register("light_blue_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(LIGHT_BLUE_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block YELLOW_CANDLE_CAKE = Blocks.register("yellow_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(YELLOW_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block LIME_CANDLE_CAKE = Blocks.register("lime_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(LIME_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block PINK_CANDLE_CAKE = Blocks.register("pink_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(PINK_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block GRAY_CANDLE_CAKE = Blocks.register("gray_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(GRAY_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block LIGHT_GRAY_CANDLE_CAKE = Blocks.register("light_gray_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(LIGHT_GRAY_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block CYAN_CANDLE_CAKE = Blocks.register("cyan_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(CYAN_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block PURPLE_CANDLE_CAKE = Blocks.register("purple_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(PURPLE_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block BLUE_CANDLE_CAKE = Blocks.register("blue_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(BLUE_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block BROWN_CANDLE_CAKE = Blocks.register("brown_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(BROWN_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block GREEN_CANDLE_CAKE = Blocks.register("green_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(GREEN_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block RED_CANDLE_CAKE = Blocks.register("red_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(RED_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block BLACK_CANDLE_CAKE = Blocks.register("black_candle_cake", (BlockBehaviour.Properties properties) -> new CandleCakeBlock(BLACK_CANDLE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(CANDLE_CAKE));
    public static final Block AMETHYST_BLOCK = Blocks.register("amethyst_block", AmethystBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(1.5f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops());
    public static final Block BUDDING_AMETHYST = Blocks.register("budding_amethyst", BuddingAmethystBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).randomTicks().strength(1.5f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY));
    public static final Block AMETHYST_CLUSTER = Blocks.register("amethyst_cluster", (BlockBehaviour.Properties properties) -> new AmethystClusterBlock(7.0f, 10.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).forceSolidOn().noOcclusion().sound(SoundType.AMETHYST_CLUSTER).strength(1.5f).lightLevel(blockState1 -> 5).pushReaction(PushReaction.DESTROY));
    public static final Block LARGE_AMETHYST_BUD = Blocks.register("large_amethyst_bud", (BlockBehaviour.Properties properties) -> new AmethystClusterBlock(5.0f, 10.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(AMETHYST_CLUSTER).sound(SoundType.MEDIUM_AMETHYST_BUD).lightLevel(blockState1 -> 4));
    public static final Block MEDIUM_AMETHYST_BUD = Blocks.register("medium_amethyst_bud", (BlockBehaviour.Properties properties) -> new AmethystClusterBlock(4.0f, 10.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(AMETHYST_CLUSTER).sound(SoundType.LARGE_AMETHYST_BUD).lightLevel(blockState1 -> 2));
    public static final Block SMALL_AMETHYST_BUD = Blocks.register("small_amethyst_bud", (BlockBehaviour.Properties properties) -> new AmethystClusterBlock(3.0f, 8.0f, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(AMETHYST_CLUSTER).sound(SoundType.SMALL_AMETHYST_BUD).lightLevel(blockState1 -> 1));
    public static final Block TUFF = Blocks.register("tuff", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_GRAY).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.TUFF).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block TUFF_SLAB = Blocks.register("tuff_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(TUFF));
    public static final Block TUFF_STAIRS = Blocks.register("tuff_stairs", (BlockBehaviour.Properties properties) -> new StairBlock(TUFF.defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(TUFF));
    public static final Block TUFF_WALL = Blocks.register("tuff_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(TUFF).forceSolidOn());
    public static final Block POLISHED_TUFF = Blocks.register("polished_tuff", BlockBehaviour.Properties.ofLegacyCopy(TUFF).sound(SoundType.POLISHED_TUFF));
    public static final Block POLISHED_TUFF_SLAB = Blocks.register("polished_tuff_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(POLISHED_TUFF));
    public static final Block POLISHED_TUFF_STAIRS = Blocks.register("polished_tuff_stairs", (BlockBehaviour.Properties properties) -> new StairBlock(POLISHED_TUFF.defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(POLISHED_TUFF));
    public static final Block POLISHED_TUFF_WALL = Blocks.register("polished_tuff_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(POLISHED_TUFF).forceSolidOn());
    public static final Block CHISELED_TUFF = Blocks.register("chiseled_tuff", BlockBehaviour.Properties.ofLegacyCopy(TUFF));
    public static final Block TUFF_BRICKS = Blocks.register("tuff_bricks", BlockBehaviour.Properties.ofLegacyCopy(TUFF).sound(SoundType.TUFF_BRICKS));
    public static final Block TUFF_BRICK_SLAB = Blocks.register("tuff_brick_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(TUFF_BRICKS));
    public static final Block TUFF_BRICK_STAIRS = Blocks.register("tuff_brick_stairs", (BlockBehaviour.Properties properties) -> new StairBlock(TUFF_BRICKS.defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(TUFF_BRICKS));
    public static final Block TUFF_BRICK_WALL = Blocks.register("tuff_brick_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(TUFF_BRICKS).forceSolidOn());
    public static final Block CHISELED_TUFF_BRICKS = Blocks.register("chiseled_tuff_bricks", BlockBehaviour.Properties.ofLegacyCopy(TUFF_BRICKS));
    public static final Block CALCITE = Blocks.register("calcite", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.CALCITE).requiresCorrectToolForDrops().strength(0.75f));
    public static final Block TINTED_GLASS = Blocks.register("tinted_glass", TintedGlassBlock::new, BlockBehaviour.Properties.ofLegacyCopy(GLASS).mapColor(MapColor.COLOR_GRAY).noOcclusion().isValidSpawn(Blocks::never).isRedstoneConductor(Blocks::never).isSuffocating(Blocks::never).isViewBlocking(Blocks::never));
    public static final Block POWDER_SNOW = Blocks.register("powder_snow", PowderSnowBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).strength(0.25f).sound(SoundType.POWDER_SNOW).dynamicShape().noOcclusion().isRedstoneConductor(Blocks::never));
    public static final Block SCULK_SENSOR = Blocks.register("sculk_sensor", SculkSensorBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.5f).sound(SoundType.SCULK_SENSOR).lightLevel(blockState1 -> 1).emissiveRendering((state, level, pos) -> SculkSensorBlock.getPhase(state) == SculkSensorPhase.ACTIVE));
    public static final Block CALIBRATED_SCULK_SENSOR = Blocks.register("calibrated_sculk_sensor", CalibratedSculkSensorBlock::new, BlockBehaviour.Properties.ofLegacyCopy(SCULK_SENSOR));
    public static final Block SCULK = Blocks.register("sculk", SculkBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(0.2f).sound(SoundType.SCULK));
    public static final Block SCULK_VEIN = Blocks.register("sculk_vein", SculkVeinBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).forceSolidOn().noCollision().strength(0.2f).sound(SoundType.SCULK_VEIN).pushReaction(PushReaction.DESTROY));
    public static final Block SCULK_CATALYST = Blocks.register("sculk_catalyst", SculkCatalystBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 3.0f).sound(SoundType.SCULK_CATALYST).lightLevel(blockState1 -> 6));
    public static final Block SCULK_SHRIEKER = Blocks.register("sculk_shrieker", SculkShriekerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 3.0f).sound(SoundType.SCULK_SHRIEKER));
    public static final Block COPPER_BLOCK = Blocks.register("copper_block", (BlockBehaviour.Properties properties) -> new WeatheringCopperFullBlock(WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundType.COPPER));
    public static final Block EXPOSED_COPPER = Blocks.register("exposed_copper", (BlockBehaviour.Properties properties) -> new WeatheringCopperFullBlock(WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_BLOCK).mapColor(MapColor.TERRACOTTA_LIGHT_GRAY));
    public static final Block WEATHERED_COPPER = Blocks.register("weathered_copper", (BlockBehaviour.Properties properties) -> new WeatheringCopperFullBlock(WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_BLOCK).mapColor(MapColor.WARPED_STEM));
    public static final Block OXIDIZED_COPPER = Blocks.register("oxidized_copper", (BlockBehaviour.Properties properties) -> new WeatheringCopperFullBlock(WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_BLOCK).mapColor(MapColor.WARPED_NYLIUM));
    public static final Block COPPER_ORE = Blocks.register("copper_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(ConstantInt.of(0), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(IRON_ORE));
    public static final Block DEEPSLATE_COPPER_ORE = Blocks.register("deepslate_copper_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock(ConstantInt.of(0), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(COPPER_ORE).mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE));
    public static final Block OXIDIZED_CUT_COPPER = Blocks.register("oxidized_cut_copper", (BlockBehaviour.Properties properties) -> new WeatheringCopperFullBlock(WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(OXIDIZED_COPPER));
    public static final Block WEATHERED_CUT_COPPER = Blocks.register("weathered_cut_copper", (BlockBehaviour.Properties properties) -> new WeatheringCopperFullBlock(WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(WEATHERED_COPPER));
    public static final Block EXPOSED_CUT_COPPER = Blocks.register("exposed_cut_copper", (BlockBehaviour.Properties properties) -> new WeatheringCopperFullBlock(WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(EXPOSED_COPPER));
    public static final Block CUT_COPPER = Blocks.register("cut_copper", (BlockBehaviour.Properties properties) -> new WeatheringCopperFullBlock(WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_BLOCK));
    public static final Block OXIDIZED_CHISELED_COPPER = Blocks.register("oxidized_chiseled_copper", (BlockBehaviour.Properties properties) -> new WeatheringCopperFullBlock(WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(OXIDIZED_COPPER));
    public static final Block WEATHERED_CHISELED_COPPER = Blocks.register("weathered_chiseled_copper", (BlockBehaviour.Properties properties) -> new WeatheringCopperFullBlock(WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(WEATHERED_COPPER));
    public static final Block EXPOSED_CHISELED_COPPER = Blocks.register("exposed_chiseled_copper", (BlockBehaviour.Properties properties) -> new WeatheringCopperFullBlock(WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(EXPOSED_COPPER));
    public static final Block CHISELED_COPPER = Blocks.register("chiseled_copper", (BlockBehaviour.Properties properties) -> new WeatheringCopperFullBlock(WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_BLOCK));
    public static final Block WAXED_OXIDIZED_CHISELED_COPPER = Blocks.register("waxed_oxidized_chiseled_copper", BlockBehaviour.Properties.ofFullCopy(OXIDIZED_CHISELED_COPPER));
    public static final Block WAXED_WEATHERED_CHISELED_COPPER = Blocks.register("waxed_weathered_chiseled_copper", BlockBehaviour.Properties.ofFullCopy(WEATHERED_CHISELED_COPPER));
    public static final Block WAXED_EXPOSED_CHISELED_COPPER = Blocks.register("waxed_exposed_chiseled_copper", BlockBehaviour.Properties.ofFullCopy(EXPOSED_CHISELED_COPPER));
    public static final Block WAXED_CHISELED_COPPER = Blocks.register("waxed_chiseled_copper", BlockBehaviour.Properties.ofFullCopy(CHISELED_COPPER));
    public static final Block OXIDIZED_CUT_COPPER_STAIRS = Blocks.register("oxidized_cut_copper_stairs", (BlockBehaviour.Properties properties) -> new WeatheringCopperStairBlock(WeatheringCopper.WeatherState.OXIDIZED, OXIDIZED_CUT_COPPER.defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(OXIDIZED_CUT_COPPER));
    public static final Block WEATHERED_CUT_COPPER_STAIRS = Blocks.register("weathered_cut_copper_stairs", (BlockBehaviour.Properties properties) -> new WeatheringCopperStairBlock(WeatheringCopper.WeatherState.WEATHERED, WEATHERED_CUT_COPPER.defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(WEATHERED_COPPER));
    public static final Block EXPOSED_CUT_COPPER_STAIRS = Blocks.register("exposed_cut_copper_stairs", (BlockBehaviour.Properties properties) -> new WeatheringCopperStairBlock(WeatheringCopper.WeatherState.EXPOSED, EXPOSED_CUT_COPPER.defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(EXPOSED_COPPER));
    public static final Block CUT_COPPER_STAIRS = Blocks.register("cut_copper_stairs", (BlockBehaviour.Properties properties) -> new WeatheringCopperStairBlock(WeatheringCopper.WeatherState.UNAFFECTED, CUT_COPPER.defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_BLOCK));
    public static final Block OXIDIZED_CUT_COPPER_SLAB = Blocks.register("oxidized_cut_copper_slab", (BlockBehaviour.Properties properties) -> new WeatheringCopperSlabBlock(WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(OXIDIZED_CUT_COPPER));
    public static final Block WEATHERED_CUT_COPPER_SLAB = Blocks.register("weathered_cut_copper_slab", (BlockBehaviour.Properties properties) -> new WeatheringCopperSlabBlock(WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(WEATHERED_CUT_COPPER));
    public static final Block EXPOSED_CUT_COPPER_SLAB = Blocks.register("exposed_cut_copper_slab", (BlockBehaviour.Properties properties) -> new WeatheringCopperSlabBlock(WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(EXPOSED_CUT_COPPER));
    public static final Block CUT_COPPER_SLAB = Blocks.register("cut_copper_slab", (BlockBehaviour.Properties properties) -> new WeatheringCopperSlabBlock(WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(CUT_COPPER));
    public static final Block WAXED_COPPER_BLOCK = Blocks.register("waxed_copper_block", BlockBehaviour.Properties.ofFullCopy(COPPER_BLOCK));
    public static final Block WAXED_WEATHERED_COPPER = Blocks.register("waxed_weathered_copper", BlockBehaviour.Properties.ofFullCopy(WEATHERED_COPPER));
    public static final Block WAXED_EXPOSED_COPPER = Blocks.register("waxed_exposed_copper", BlockBehaviour.Properties.ofFullCopy(EXPOSED_COPPER));
    public static final Block WAXED_OXIDIZED_COPPER = Blocks.register("waxed_oxidized_copper", BlockBehaviour.Properties.ofFullCopy(OXIDIZED_COPPER));
    public static final Block WAXED_OXIDIZED_CUT_COPPER = Blocks.register("waxed_oxidized_cut_copper", BlockBehaviour.Properties.ofFullCopy(OXIDIZED_COPPER));
    public static final Block WAXED_WEATHERED_CUT_COPPER = Blocks.register("waxed_weathered_cut_copper", BlockBehaviour.Properties.ofFullCopy(WEATHERED_COPPER));
    public static final Block WAXED_EXPOSED_CUT_COPPER = Blocks.register("waxed_exposed_cut_copper", BlockBehaviour.Properties.ofFullCopy(EXPOSED_COPPER));
    public static final Block WAXED_CUT_COPPER = Blocks.register("waxed_cut_copper", BlockBehaviour.Properties.ofFullCopy(COPPER_BLOCK));
    public static final Block WAXED_OXIDIZED_CUT_COPPER_STAIRS = Blocks.registerStair("waxed_oxidized_cut_copper_stairs", WAXED_OXIDIZED_CUT_COPPER);
    public static final Block WAXED_WEATHERED_CUT_COPPER_STAIRS = Blocks.registerStair("waxed_weathered_cut_copper_stairs", WAXED_WEATHERED_CUT_COPPER);
    public static final Block WAXED_EXPOSED_CUT_COPPER_STAIRS = Blocks.registerStair("waxed_exposed_cut_copper_stairs", WAXED_EXPOSED_CUT_COPPER);
    public static final Block WAXED_CUT_COPPER_STAIRS = Blocks.registerStair("waxed_cut_copper_stairs", WAXED_CUT_COPPER);
    public static final Block WAXED_OXIDIZED_CUT_COPPER_SLAB = Blocks.register("waxed_oxidized_cut_copper_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy(WAXED_OXIDIZED_CUT_COPPER).requiresCorrectToolForDrops());
    public static final Block WAXED_WEATHERED_CUT_COPPER_SLAB = Blocks.register("waxed_weathered_cut_copper_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy(WAXED_WEATHERED_CUT_COPPER).requiresCorrectToolForDrops());
    public static final Block WAXED_EXPOSED_CUT_COPPER_SLAB = Blocks.register("waxed_exposed_cut_copper_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy(WAXED_EXPOSED_CUT_COPPER).requiresCorrectToolForDrops());
    public static final Block WAXED_CUT_COPPER_SLAB = Blocks.register("waxed_cut_copper_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy(WAXED_CUT_COPPER).requiresCorrectToolForDrops());
    public static final Block COPPER_DOOR = Blocks.register("copper_door", (BlockBehaviour.Properties properties) -> new WeatheringCopperDoorBlock(BlockSetType.COPPER, WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(COPPER_BLOCK.defaultMapColor()).strength(3.0f, 6.0f).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block EXPOSED_COPPER_DOOR = Blocks.register("exposed_copper_door", (BlockBehaviour.Properties properties) -> new WeatheringCopperDoorBlock(BlockSetType.COPPER, WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_DOOR).mapColor(EXPOSED_COPPER.defaultMapColor()));
    public static final Block OXIDIZED_COPPER_DOOR = Blocks.register("oxidized_copper_door", (BlockBehaviour.Properties properties) -> new WeatheringCopperDoorBlock(BlockSetType.COPPER, WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_DOOR).mapColor(OXIDIZED_COPPER.defaultMapColor()));
    public static final Block WEATHERED_COPPER_DOOR = Blocks.register("weathered_copper_door", (BlockBehaviour.Properties properties) -> new WeatheringCopperDoorBlock(BlockSetType.COPPER, WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_DOOR).mapColor(WEATHERED_COPPER.defaultMapColor()));
    public static final Block WAXED_COPPER_DOOR = Blocks.register("waxed_copper_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.COPPER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_DOOR));
    public static final Block WAXED_EXPOSED_COPPER_DOOR = Blocks.register("waxed_exposed_copper_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.COPPER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(EXPOSED_COPPER_DOOR));
    public static final Block WAXED_OXIDIZED_COPPER_DOOR = Blocks.register("waxed_oxidized_copper_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.COPPER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(OXIDIZED_COPPER_DOOR));
    public static final Block WAXED_WEATHERED_COPPER_DOOR = Blocks.register("waxed_weathered_copper_door", (BlockBehaviour.Properties properties) -> new DoorBlock(BlockSetType.COPPER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(WEATHERED_COPPER_DOOR));
    public static final Block COPPER_TRAPDOOR = Blocks.register("copper_trapdoor", (BlockBehaviour.Properties properties) -> new WeatheringCopperTrapDoorBlock(BlockSetType.COPPER, WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(COPPER_BLOCK.defaultMapColor()).strength(3.0f, 6.0f).requiresCorrectToolForDrops().noOcclusion().isValidSpawn(Blocks::never));
    public static final Block EXPOSED_COPPER_TRAPDOOR = Blocks.register("exposed_copper_trapdoor", (BlockBehaviour.Properties properties) -> new WeatheringCopperTrapDoorBlock(BlockSetType.COPPER, WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_TRAPDOOR).mapColor(EXPOSED_COPPER.defaultMapColor()));
    public static final Block OXIDIZED_COPPER_TRAPDOOR = Blocks.register("oxidized_copper_trapdoor", (BlockBehaviour.Properties properties) -> new WeatheringCopperTrapDoorBlock(BlockSetType.COPPER, WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_TRAPDOOR).mapColor(OXIDIZED_COPPER.defaultMapColor()));
    public static final Block WEATHERED_COPPER_TRAPDOOR = Blocks.register("weathered_copper_trapdoor", (BlockBehaviour.Properties properties) -> new WeatheringCopperTrapDoorBlock(BlockSetType.COPPER, WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_TRAPDOOR).mapColor(WEATHERED_COPPER.defaultMapColor()));
    public static final Block WAXED_COPPER_TRAPDOOR = Blocks.register("waxed_copper_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.COPPER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_TRAPDOOR));
    public static final Block WAXED_EXPOSED_COPPER_TRAPDOOR = Blocks.register("waxed_exposed_copper_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.COPPER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(EXPOSED_COPPER_TRAPDOOR));
    public static final Block WAXED_OXIDIZED_COPPER_TRAPDOOR = Blocks.register("waxed_oxidized_copper_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.COPPER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(OXIDIZED_COPPER_TRAPDOOR));
    public static final Block WAXED_WEATHERED_COPPER_TRAPDOOR = Blocks.register("waxed_weathered_copper_trapdoor", (BlockBehaviour.Properties properties) -> new TrapDoorBlock(BlockSetType.COPPER, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(WEATHERED_COPPER_TRAPDOOR));
    public static final Block COPPER_GRATE = Blocks.register("copper_grate", (BlockBehaviour.Properties properties) -> new WeatheringCopperGrateBlock(WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().strength(3.0f, 6.0f).sound(SoundType.COPPER_GRATE).mapColor(MapColor.COLOR_ORANGE).noOcclusion().requiresCorrectToolForDrops().isValidSpawn(Blocks::never).isRedstoneConductor(Blocks::never).isSuffocating(Blocks::never).isViewBlocking(Blocks::never));
    public static final Block EXPOSED_COPPER_GRATE = Blocks.register("exposed_copper_grate", (BlockBehaviour.Properties properties) -> new WeatheringCopperGrateBlock(WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_GRATE).mapColor(MapColor.TERRACOTTA_LIGHT_GRAY));
    public static final Block WEATHERED_COPPER_GRATE = Blocks.register("weathered_copper_grate", (BlockBehaviour.Properties properties) -> new WeatheringCopperGrateBlock(WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_GRATE).mapColor(MapColor.WARPED_STEM));
    public static final Block OXIDIZED_COPPER_GRATE = Blocks.register("oxidized_copper_grate", (BlockBehaviour.Properties properties) -> new WeatheringCopperGrateBlock(WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_GRATE).mapColor(MapColor.WARPED_NYLIUM));
    public static final Block WAXED_COPPER_GRATE = Blocks.register("waxed_copper_grate", WaterloggedTransparentBlock::new, BlockBehaviour.Properties.ofFullCopy(COPPER_GRATE));
    public static final Block WAXED_EXPOSED_COPPER_GRATE = Blocks.register("waxed_exposed_copper_grate", WaterloggedTransparentBlock::new, BlockBehaviour.Properties.ofFullCopy(EXPOSED_COPPER_GRATE));
    public static final Block WAXED_WEATHERED_COPPER_GRATE = Blocks.register("waxed_weathered_copper_grate", WaterloggedTransparentBlock::new, BlockBehaviour.Properties.ofFullCopy(WEATHERED_COPPER_GRATE));
    public static final Block WAXED_OXIDIZED_COPPER_GRATE = Blocks.register("waxed_oxidized_copper_grate", WaterloggedTransparentBlock::new, BlockBehaviour.Properties.ofFullCopy(OXIDIZED_COPPER_GRATE));
    public static final Block COPPER_BULB = Blocks.register("copper_bulb", (BlockBehaviour.Properties properties) -> new WeatheringCopperBulbBlock(WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(COPPER_BLOCK.defaultMapColor()).strength(3.0f, 6.0f).sound(SoundType.COPPER_BULB).requiresCorrectToolForDrops().isRedstoneConductor(Blocks::never).lightLevel(Blocks.litBlockEmission(15)));
    public static final Block EXPOSED_COPPER_BULB = Blocks.register("exposed_copper_bulb", (BlockBehaviour.Properties properties) -> new WeatheringCopperBulbBlock(WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_BULB).mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).lightLevel(Blocks.litBlockEmission(12)));
    public static final Block WEATHERED_COPPER_BULB = Blocks.register("weathered_copper_bulb", (BlockBehaviour.Properties properties) -> new WeatheringCopperBulbBlock(WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_BULB).mapColor(MapColor.WARPED_STEM).lightLevel(Blocks.litBlockEmission(8)));
    public static final Block OXIDIZED_COPPER_BULB = Blocks.register("oxidized_copper_bulb", (BlockBehaviour.Properties properties) -> new WeatheringCopperBulbBlock(WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_BULB).mapColor(MapColor.WARPED_NYLIUM).lightLevel(Blocks.litBlockEmission(4)));
    public static final Block WAXED_COPPER_BULB = Blocks.register("waxed_copper_bulb", CopperBulbBlock::new, BlockBehaviour.Properties.ofFullCopy(COPPER_BULB));
    public static final Block WAXED_EXPOSED_COPPER_BULB = Blocks.register("waxed_exposed_copper_bulb", CopperBulbBlock::new, BlockBehaviour.Properties.ofFullCopy(EXPOSED_COPPER_BULB));
    public static final Block WAXED_WEATHERED_COPPER_BULB = Blocks.register("waxed_weathered_copper_bulb", CopperBulbBlock::new, BlockBehaviour.Properties.ofFullCopy(WEATHERED_COPPER_BULB));
    public static final Block WAXED_OXIDIZED_COPPER_BULB = Blocks.register("waxed_oxidized_copper_bulb", CopperBulbBlock::new, BlockBehaviour.Properties.ofFullCopy(OXIDIZED_COPPER_BULB));
    public static final Block COPPER_CHEST = Blocks.register("copper_chest", (BlockBehaviour.Properties properties) -> new WeatheringCopperChestBlock(WeatheringCopper.WeatherState.UNAFFECTED, SoundEvents.COPPER_CHEST_OPEN, SoundEvents.COPPER_CHEST_CLOSE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(COPPER_BLOCK.defaultMapColor()).strength(3.0f, 6.0f).sound(SoundType.COPPER).requiresCorrectToolForDrops());
    public static final Block EXPOSED_COPPER_CHEST = Blocks.register("exposed_copper_chest", (BlockBehaviour.Properties properties) -> new WeatheringCopperChestBlock(WeatheringCopper.WeatherState.EXPOSED, SoundEvents.COPPER_CHEST_OPEN, SoundEvents.COPPER_CHEST_CLOSE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_CHEST).mapColor(MapColor.TERRACOTTA_LIGHT_GRAY));
    public static final Block WEATHERED_COPPER_CHEST = Blocks.register("weathered_copper_chest", (BlockBehaviour.Properties properties) -> new WeatheringCopperChestBlock(WeatheringCopper.WeatherState.WEATHERED, SoundEvents.COPPER_CHEST_WEATHERED_OPEN, SoundEvents.COPPER_CHEST_WEATHERED_CLOSE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_CHEST).mapColor(MapColor.WARPED_STEM));
    public static final Block OXIDIZED_COPPER_CHEST = Blocks.register("oxidized_copper_chest", (BlockBehaviour.Properties properties) -> new WeatheringCopperChestBlock(WeatheringCopper.WeatherState.OXIDIZED, SoundEvents.COPPER_CHEST_OXIDIZED_OPEN, SoundEvents.COPPER_CHEST_OXIDIZED_CLOSE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_CHEST).mapColor(MapColor.WARPED_NYLIUM));
    public static final Block WAXED_COPPER_CHEST = Blocks.register("waxed_copper_chest", (BlockBehaviour.Properties properties) -> new CopperChestBlock(WeatheringCopper.WeatherState.UNAFFECTED, SoundEvents.COPPER_CHEST_OPEN, SoundEvents.COPPER_CHEST_CLOSE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_CHEST));
    public static final Block WAXED_EXPOSED_COPPER_CHEST = Blocks.register("waxed_exposed_copper_chest", (BlockBehaviour.Properties properties) -> new CopperChestBlock(WeatheringCopper.WeatherState.EXPOSED, SoundEvents.COPPER_CHEST_OPEN, SoundEvents.COPPER_CHEST_CLOSE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(EXPOSED_COPPER_CHEST));
    public static final Block WAXED_WEATHERED_COPPER_CHEST = Blocks.register("waxed_weathered_copper_chest", (BlockBehaviour.Properties properties) -> new CopperChestBlock(WeatheringCopper.WeatherState.WEATHERED, SoundEvents.COPPER_CHEST_WEATHERED_OPEN, SoundEvents.COPPER_CHEST_WEATHERED_CLOSE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(WEATHERED_COPPER_CHEST));
    public static final Block WAXED_OXIDIZED_COPPER_CHEST = Blocks.register("waxed_oxidized_copper_chest", (BlockBehaviour.Properties properties) -> new CopperChestBlock(WeatheringCopper.WeatherState.OXIDIZED, SoundEvents.COPPER_CHEST_OXIDIZED_OPEN, SoundEvents.COPPER_CHEST_OXIDIZED_CLOSE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(OXIDIZED_COPPER_CHEST));
    public static final Block COPPER_GOLEM_STATUE = Blocks.register("copper_golem_statue", (BlockBehaviour.Properties properties) -> new WeatheringCopperGolemStatueBlock(WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(COPPER_BLOCK.defaultMapColor()).strength(3.0f, 6.0f).sound(SoundType.COPPER_GOLEM_STATUE).pushReaction(PushReaction.DESTROY));
    public static final Block EXPOSED_COPPER_GOLEM_STATUE = Blocks.register("exposed_copper_golem_statue", (BlockBehaviour.Properties properties) -> new WeatheringCopperGolemStatueBlock(WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_GOLEM_STATUE).mapColor(MapColor.TERRACOTTA_LIGHT_GRAY));
    public static final Block WEATHERED_COPPER_GOLEM_STATUE = Blocks.register("weathered_copper_golem_statue", (BlockBehaviour.Properties properties) -> new WeatheringCopperGolemStatueBlock(WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_GOLEM_STATUE).mapColor(MapColor.WARPED_STEM));
    public static final Block OXIDIZED_COPPER_GOLEM_STATUE = Blocks.register("oxidized_copper_golem_statue", (BlockBehaviour.Properties properties) -> new WeatheringCopperGolemStatueBlock(WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_GOLEM_STATUE).mapColor(MapColor.WARPED_NYLIUM));
    public static final Block WAXED_COPPER_GOLEM_STATUE = Blocks.register("waxed_copper_golem_statue", (BlockBehaviour.Properties properties) -> new CopperGolemStatueBlock(WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(COPPER_GOLEM_STATUE));
    public static final Block WAXED_EXPOSED_COPPER_GOLEM_STATUE = Blocks.register("waxed_exposed_copper_golem_statue", (BlockBehaviour.Properties properties) -> new CopperGolemStatueBlock(WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(EXPOSED_COPPER_GOLEM_STATUE));
    public static final Block WAXED_WEATHERED_COPPER_GOLEM_STATUE = Blocks.register("waxed_weathered_copper_golem_statue", (BlockBehaviour.Properties properties) -> new CopperGolemStatueBlock(WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(WEATHERED_COPPER_GOLEM_STATUE));
    public static final Block WAXED_OXIDIZED_COPPER_GOLEM_STATUE = Blocks.register("waxed_oxidized_copper_golem_statue", (BlockBehaviour.Properties properties) -> new CopperGolemStatueBlock(WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(OXIDIZED_COPPER_GOLEM_STATUE));
    public static final Block LIGHTNING_ROD = Blocks.register("lightning_rod", (BlockBehaviour.Properties properties) -> new WeatheringLightningRodBlock(WeatheringCopper.WeatherState.UNAFFECTED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).forceSolidOn().requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundType.COPPER).noOcclusion());
    public static final Block EXPOSED_LIGHTNING_ROD = Blocks.register("exposed_lightning_rod", (BlockBehaviour.Properties properties) -> new WeatheringLightningRodBlock(WeatheringCopper.WeatherState.EXPOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(LIGHTNING_ROD).mapColor(MapColor.TERRACOTTA_LIGHT_GRAY));
    public static final Block WEATHERED_LIGHTNING_ROD = Blocks.register("weathered_lightning_rod", (BlockBehaviour.Properties properties) -> new WeatheringLightningRodBlock(WeatheringCopper.WeatherState.WEATHERED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(LIGHTNING_ROD).mapColor(MapColor.WARPED_STEM));
    public static final Block OXIDIZED_LIGHTNING_ROD = Blocks.register("oxidized_lightning_rod", (BlockBehaviour.Properties properties) -> new WeatheringLightningRodBlock(WeatheringCopper.WeatherState.OXIDIZED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(LIGHTNING_ROD).mapColor(MapColor.WARPED_NYLIUM));
    public static final Block WAXED_LIGHTNING_ROD = Blocks.register("waxed_lightning_rod", LightningRodBlock::new, BlockBehaviour.Properties.ofFullCopy(LIGHTNING_ROD));
    public static final Block WAXED_EXPOSED_LIGHTNING_ROD = Blocks.register("waxed_exposed_lightning_rod", LightningRodBlock::new, BlockBehaviour.Properties.ofFullCopy(EXPOSED_LIGHTNING_ROD));
    public static final Block WAXED_WEATHERED_LIGHTNING_ROD = Blocks.register("waxed_weathered_lightning_rod", LightningRodBlock::new, BlockBehaviour.Properties.ofFullCopy(WEATHERED_LIGHTNING_ROD));
    public static final Block WAXED_OXIDIZED_LIGHTNING_ROD = Blocks.register("waxed_oxidized_lightning_rod", LightningRodBlock::new, BlockBehaviour.Properties.ofFullCopy(OXIDIZED_LIGHTNING_ROD));
    public static final Block POINTED_DRIPSTONE = Blocks.register("pointed_dripstone", PointedDripstoneBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BROWN).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).noOcclusion().sound(SoundType.POINTED_DRIPSTONE).randomTicks().strength(1.5f, 3.0f).dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY).isRedstoneConductor(Blocks::never));
    public static final Block DRIPSTONE_BLOCK = Blocks.register("dripstone_block", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BROWN).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.DRIPSTONE_BLOCK).requiresCorrectToolForDrops().strength(1.5f, 1.0f));
    public static final Block CAVE_VINES = Blocks.register("cave_vines", CaveVinesBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().noCollision().lightLevel(CaveVines.emission(14)).instabreak().sound(SoundType.CAVE_VINES).pushReaction(PushReaction.DESTROY));
    public static final Block CAVE_VINES_PLANT = Blocks.register("cave_vines_plant", CaveVinesPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().lightLevel(CaveVines.emission(14)).instabreak().sound(SoundType.CAVE_VINES).pushReaction(PushReaction.DESTROY));
    public static final Block SPORE_BLOSSOM = Blocks.register("spore_blossom", SporeBlossomBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).instabreak().noCollision().sound(SoundType.SPORE_BLOSSOM).pushReaction(PushReaction.DESTROY));
    public static final Block AZALEA = Blocks.register("azalea", AzaleaBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).forceSolidOff().instabreak().sound(SoundType.AZALEA).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block FLOWERING_AZALEA = Blocks.register("flowering_azalea", AzaleaBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).forceSolidOff().instabreak().sound(SoundType.FLOWERING_AZALEA).noOcclusion().pushReaction(PushReaction.DESTROY));
    public static final Block MOSS_CARPET = Blocks.register("moss_carpet", CarpetBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(0.1f).sound(SoundType.MOSS_CARPET).pushReaction(PushReaction.DESTROY));
    public static final Block PINK_PETALS = Blocks.register("pink_petals", FlowerBedBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().sound(SoundType.PINK_PETALS).pushReaction(PushReaction.DESTROY));
    public static final Block WILDFLOWERS = Blocks.register("wildflowers", FlowerBedBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().sound(SoundType.PINK_PETALS).pushReaction(PushReaction.DESTROY));
    public static final Block LEAF_LITTER = Blocks.register("leaf_litter", LeafLitterBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).replaceable().noCollision().sound(SoundType.LEAF_LITTER).pushReaction(PushReaction.DESTROY));
    public static final Block MOSS_BLOCK = Blocks.register("moss_block", (BlockBehaviour.Properties properties) -> new BonemealableFeaturePlacerBlock(CaveFeatures.MOSS_PATCH_BONEMEAL, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(0.1f).sound(SoundType.MOSS).pushReaction(PushReaction.DESTROY));
    public static final Block BIG_DRIPLEAF = Blocks.register("big_dripleaf", BigDripleafBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).forceSolidOff().strength(0.1f).sound(SoundType.BIG_DRIPLEAF).pushReaction(PushReaction.DESTROY));
    public static final Block BIG_DRIPLEAF_STEM = Blocks.register("big_dripleaf_stem", BigDripleafStemBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().strength(0.1f).sound(SoundType.BIG_DRIPLEAF).pushReaction(PushReaction.DESTROY));
    public static final Block SMALL_DRIPLEAF = Blocks.register("small_dripleaf", SmallDripleafBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollision().instabreak().sound(SoundType.SMALL_DRIPLEAF).offsetType(BlockBehaviour.OffsetType.XYZ).pushReaction(PushReaction.DESTROY));
    public static final Block HANGING_ROOTS = Blocks.register("hanging_roots", HangingRootsBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).replaceable().noCollision().instabreak().sound(SoundType.HANGING_ROOTS).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Block ROOTED_DIRT = Blocks.register("rooted_dirt", RootedDirtBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(0.5f).sound(SoundType.ROOTED_DIRT));
    public static final Block MUD = Blocks.register("mud", MudBlock::new, BlockBehaviour.Properties.ofLegacyCopy(DIRT).mapColor(MapColor.TERRACOTTA_CYAN).isValidSpawn(Blocks::always).isRedstoneConductor(Blocks::always).isViewBlocking(Blocks::always).isSuffocating(Blocks::always).sound(SoundType.MUD));
    public static final Block DEEPSLATE = Blocks.register("deepslate", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundType.DEEPSLATE));
    public static final Block COBBLED_DEEPSLATE = Blocks.register("cobbled_deepslate", BlockBehaviour.Properties.ofLegacyCopy(DEEPSLATE).strength(3.5f, 6.0f));
    public static final Block COBBLED_DEEPSLATE_STAIRS = Blocks.registerLegacyStair("cobbled_deepslate_stairs", COBBLED_DEEPSLATE);
    public static final Block COBBLED_DEEPSLATE_SLAB = Blocks.register("cobbled_deepslate_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(COBBLED_DEEPSLATE));
    public static final Block COBBLED_DEEPSLATE_WALL = Blocks.register("cobbled_deepslate_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(COBBLED_DEEPSLATE).forceSolidOn());
    public static final Block POLISHED_DEEPSLATE = Blocks.register("polished_deepslate", BlockBehaviour.Properties.ofLegacyCopy(COBBLED_DEEPSLATE).sound(SoundType.POLISHED_DEEPSLATE));
    public static final Block POLISHED_DEEPSLATE_STAIRS = Blocks.registerLegacyStair("polished_deepslate_stairs", POLISHED_DEEPSLATE);
    public static final Block POLISHED_DEEPSLATE_SLAB = Blocks.register("polished_deepslate_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(POLISHED_DEEPSLATE));
    public static final Block POLISHED_DEEPSLATE_WALL = Blocks.register("polished_deepslate_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(POLISHED_DEEPSLATE).forceSolidOn());
    public static final Block DEEPSLATE_TILES = Blocks.register("deepslate_tiles", BlockBehaviour.Properties.ofLegacyCopy(COBBLED_DEEPSLATE).sound(SoundType.DEEPSLATE_TILES));
    public static final Block DEEPSLATE_TILE_STAIRS = Blocks.registerLegacyStair("deepslate_tile_stairs", DEEPSLATE_TILES);
    public static final Block DEEPSLATE_TILE_SLAB = Blocks.register("deepslate_tile_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(DEEPSLATE_TILES));
    public static final Block DEEPSLATE_TILE_WALL = Blocks.register("deepslate_tile_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(DEEPSLATE_TILES).forceSolidOn());
    public static final Block DEEPSLATE_BRICKS = Blocks.register("deepslate_bricks", BlockBehaviour.Properties.ofLegacyCopy(COBBLED_DEEPSLATE).sound(SoundType.DEEPSLATE_BRICKS));
    public static final Block DEEPSLATE_BRICK_STAIRS = Blocks.registerLegacyStair("deepslate_brick_stairs", DEEPSLATE_BRICKS);
    public static final Block DEEPSLATE_BRICK_SLAB = Blocks.register("deepslate_brick_slab", SlabBlock::new, BlockBehaviour.Properties.ofLegacyCopy(DEEPSLATE_BRICKS));
    public static final Block DEEPSLATE_BRICK_WALL = Blocks.register("deepslate_brick_wall", WallBlock::new, BlockBehaviour.Properties.ofLegacyCopy(DEEPSLATE_BRICKS).forceSolidOn());
    public static final Block CHISELED_DEEPSLATE = Blocks.register("chiseled_deepslate", BlockBehaviour.Properties.ofLegacyCopy(COBBLED_DEEPSLATE).sound(SoundType.DEEPSLATE_BRICKS));
    public static final Block CRACKED_DEEPSLATE_BRICKS = Blocks.register("cracked_deepslate_bricks", BlockBehaviour.Properties.ofLegacyCopy(DEEPSLATE_BRICKS));
    public static final Block CRACKED_DEEPSLATE_TILES = Blocks.register("cracked_deepslate_tiles", BlockBehaviour.Properties.ofLegacyCopy(DEEPSLATE_TILES));
    public static final Block INFESTED_DEEPSLATE = Blocks.register("infested_deepslate", (BlockBehaviour.Properties properties) -> new InfestedRotatedPillarBlock(DEEPSLATE, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).sound(SoundType.DEEPSLATE));
    public static final Block SMOOTH_BASALT = Blocks.register("smooth_basalt", BlockBehaviour.Properties.ofLegacyCopy(BASALT));
    public static final Block RAW_IRON_BLOCK = Blocks.register("raw_iron_block", BlockBehaviour.Properties.of().mapColor(MapColor.RAW_IRON).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(5.0f, 6.0f));
    public static final Block RAW_COPPER_BLOCK = Blocks.register("raw_copper_block", BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(5.0f, 6.0f));
    public static final Block RAW_GOLD_BLOCK = Blocks.register("raw_gold_block", BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(5.0f, 6.0f));
    public static final Block POTTED_AZALEA = Blocks.register("potted_azalea_bush", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(AZALEA, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block POTTED_FLOWERING_AZALEA = Blocks.register("potted_flowering_azalea_bush", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(FLOWERING_AZALEA, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties());
    public static final Block OCHRE_FROGLIGHT = Blocks.register("ochre_froglight", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(0.3f).lightLevel(blockState1 -> 15).sound(SoundType.FROGLIGHT));
    public static final Block VERDANT_FROGLIGHT = Blocks.register("verdant_froglight", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.GLOW_LICHEN).strength(0.3f).lightLevel(blockState1 -> 15).sound(SoundType.FROGLIGHT));
    public static final Block PEARLESCENT_FROGLIGHT = Blocks.register("pearlescent_froglight", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).strength(0.3f).lightLevel(blockState1 -> 15).sound(SoundType.FROGLIGHT));
    public static final Block FROGSPAWN = Blocks.register("frogspawn", FrogspawnBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WATER).instabreak().noOcclusion().noCollision().sound(SoundType.FROGSPAWN).pushReaction(PushReaction.DESTROY));
    public static final Block REINFORCED_DEEPSLATE = Blocks.register("reinforced_deepslate", BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.DEEPSLATE).strength(55.0f, 1200.0f));
    public static final Block DECORATED_POT = Blocks.register("decorated_pot", DecoratedPotBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_RED).strength(0.0f, 0.0f).pushReaction(PushReaction.DESTROY).noOcclusion());
    public static final Block CRAFTER = Blocks.register("crafter", CrafterBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(1.5f, 3.5f));
    public static final Block TRIAL_SPAWNER = Blocks.register("trial_spawner", TrialSpawnerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).lightLevel(blockState1 -> blockState1.getValue(TrialSpawnerBlock.STATE).lightLevel()).strength(50.0f).sound(SoundType.TRIAL_SPAWNER).isViewBlocking(Blocks::never).noOcclusion());
    public static final Block VAULT = Blocks.register("vault", VaultBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).noOcclusion().sound(SoundType.VAULT).lightLevel(blockState1 -> blockState1.getValue(VaultBlock.STATE).lightLevel()).strength(50.0f).isViewBlocking(Blocks::never));
    public static final Block HEAVY_CORE = Blocks.register("heavy_core", HeavyCoreBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).instrument(NoteBlockInstrument.SNARE).sound(SoundType.HEAVY_CORE).strength(10.0f).pushReaction(PushReaction.NORMAL).explosionResistance(1200.0f));
    public static final Block PALE_MOSS_BLOCK = Blocks.register("pale_moss_block", (BlockBehaviour.Properties properties) -> new BonemealableFeaturePlacerBlock(VegetationFeatures.PALE_MOSS_PATCH_BONEMEAL, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(0.1f).sound(SoundType.MOSS).pushReaction(PushReaction.DESTROY));
    public static final Block PALE_MOSS_CARPET = Blocks.register("pale_moss_carpet", MossyCarpetBlock::new, BlockBehaviour.Properties.of().ignitedByLava().mapColor(PALE_MOSS_BLOCK.defaultMapColor()).strength(0.1f).sound(SoundType.MOSS_CARPET).pushReaction(PushReaction.DESTROY));
    public static final Block PALE_HANGING_MOSS = Blocks.register("pale_hanging_moss", HangingMossBlock::new, BlockBehaviour.Properties.of().ignitedByLava().mapColor(PALE_MOSS_BLOCK.defaultMapColor()).noCollision().sound(SoundType.MOSS_CARPET).pushReaction(PushReaction.DESTROY));
    public static final Block OPEN_EYEBLOSSOM = Blocks.register("open_eyeblossom", (BlockBehaviour.Properties properties) -> new EyeblossomBlock(EyeblossomBlock.Type.OPEN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(CREAKING_HEART.defaultMapColor()).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY).randomTicks());
    public static final Block CLOSED_EYEBLOSSOM = Blocks.register("closed_eyeblossom", (BlockBehaviour.Properties properties) -> new EyeblossomBlock(EyeblossomBlock.Type.CLOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(PALE_OAK_LEAVES.defaultMapColor()).noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY).randomTicks());
    public static final Block POTTED_OPEN_EYEBLOSSOM = Blocks.register("potted_open_eyeblossom", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(OPEN_EYEBLOSSOM, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties().randomTicks());
    public static final Block POTTED_CLOSED_EYEBLOSSOM = Blocks.register("potted_closed_eyeblossom", (BlockBehaviour.Properties properties) -> new FlowerPotBlock(CLOSED_EYEBLOSSOM, (BlockBehaviour.Properties)properties), Blocks.flowerPotProperties().randomTicks());
    public static final Block FIREFLY_BUSH = Blocks.register("firefly_bush", FireflyBushBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).ignitedByLava().lightLevel(blockState1 -> 2).noCollision().instabreak().sound(SoundType.SWEET_BERRY_BUSH).pushReaction(PushReaction.DESTROY));

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return state -> state.getValue(BlockStateProperties.LIT) != false ? lightValue : 0;
    }

    private static Function<BlockState, MapColor> waterloggedMapColor(MapColor unwaterloggedMapColor) {
        return state -> state.getValue(BlockStateProperties.WATERLOGGED) != false ? MapColor.WATER : unwaterloggedMapColor;
    }

    private static Boolean never(BlockState state, BlockGetter level, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    private static Boolean always(BlockState state, BlockGetter level, BlockPos pos, EntityType<?> entity) {
        return true;
    }

    private static Boolean ocelotOrParrot(BlockState state, BlockGetter level, BlockPos pos, EntityType<?> entity) {
        return entity == EntityType.OCELOT || entity == EntityType.PARROT;
    }

    private static Block registerBed(String name, DyeColor color) {
        return Blocks.register(name, (BlockBehaviour.Properties properties) -> new BedBlock(color, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(blockState -> blockState.getValue(BedBlock.PART) == BedPart.FOOT ? color.getMapColor() : MapColor.WOOL).sound(SoundType.WOOD).strength(0.2f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    }

    private static BlockBehaviour.Properties logProperties(MapColor sideColor, MapColor topColor, SoundType sound) {
        return BlockBehaviour.Properties.of().mapColor(state -> state.getValue(RotatedPillarBlock.AXIS) == Direction.Axis.Y ? sideColor : topColor).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(sound).ignitedByLava();
    }

    private static BlockBehaviour.Properties netherStemProperties(MapColor color) {
        return BlockBehaviour.Properties.of().mapColor(blockState -> color).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.STEM);
    }

    private static boolean always(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    private static boolean never(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    private static Block registerStainedGlass(String name, DyeColor color) {
        return Blocks.register(name, (BlockBehaviour.Properties properties) -> new StainedGlassBlock(color, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(color).instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn(Blocks::never).isRedstoneConductor(Blocks::never).isSuffocating(Blocks::never).isViewBlocking(Blocks::never));
    }

    private static BlockBehaviour.Properties leavesProperties(SoundType sound) {
        return BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(sound).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating(Blocks::never).isViewBlocking(Blocks::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(Blocks::never);
    }

    private static BlockBehaviour.Properties shulkerBoxProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.of().mapColor(mapColor).forceSolidOn().strength(2.0f).dynamicShape().noOcclusion().isSuffocating(NOT_CLOSED_SHULKER).isViewBlocking(NOT_CLOSED_SHULKER).pushReaction(PushReaction.DESTROY);
    }

    private static BlockBehaviour.Properties pistonProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(1.5f).isRedstoneConductor(Blocks::never).isSuffocating(NOT_EXTENDED_PISTON).isViewBlocking(NOT_EXTENDED_PISTON).pushReaction(PushReaction.BLOCK);
    }

    private static BlockBehaviour.Properties buttonProperties() {
        return BlockBehaviour.Properties.of().noCollision().strength(0.5f).pushReaction(PushReaction.DESTROY);
    }

    private static BlockBehaviour.Properties flowerPotProperties() {
        return BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY);
    }

    private static BlockBehaviour.Properties candleProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.of().mapColor(mapColor).noOcclusion().strength(0.1f).sound(SoundType.CANDLE).lightLevel(CandleBlock.LIGHT_EMISSION).pushReaction(PushReaction.DESTROY);
    }

    @Deprecated
    private static Block registerLegacyStair(String name, Block baseBlock) {
        return Blocks.register(name, (BlockBehaviour.Properties properties) -> new StairBlock(baseBlock.defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofLegacyCopy(baseBlock));
    }

    private static Block registerStair(String name, Block baseBlock) {
        return Blocks.register(name, (BlockBehaviour.Properties properties) -> new StairBlock(baseBlock.defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy(baseBlock));
    }

    private static BlockBehaviour.Properties wallVariant(Block baseBlock, boolean overrideDescription) {
        BlockBehaviour.Properties properties = baseBlock.properties();
        BlockBehaviour.Properties properties1 = BlockBehaviour.Properties.of().overrideLootTable(baseBlock.getLootTable());
        if (overrideDescription) {
            properties1 = properties1.overrideDescription(baseBlock.getDescriptionId());
        }
        return properties1;
    }

    private static Block register(ResourceKey<Block> resourceKey, Function<BlockBehaviour.Properties, Block> factory, BlockBehaviour.Properties properties) {
        Block block = factory.apply(properties.setId(resourceKey));
        return Registry.register(BuiltInRegistries.BLOCK, resourceKey, block);
    }

    private static Block register(ResourceKey<Block> resourceKey, BlockBehaviour.Properties properties) {
        return Blocks.register(resourceKey, Block::new, properties);
    }

    private static ResourceKey<Block> vanillaBlockId(String name) {
        return ResourceKey.create(Registries.BLOCK, ResourceLocation.withDefaultNamespace(name));
    }

    private static Block register(String name, Function<BlockBehaviour.Properties, Block> factory, BlockBehaviour.Properties properties) {
        return Blocks.register(Blocks.vanillaBlockId(name), factory, properties);
    }

    private static Block register(String name, BlockBehaviour.Properties properties) {
        return Blocks.register(name, Block::new, properties);
    }

    static {
        for (Block block : BuiltInRegistries.BLOCK) {
            for (BlockState blockState : block.getStateDefinition().getPossibleStates()) {
                Block.BLOCK_STATE_REGISTRY.add(blockState);
                blockState.initCache();
            }
        }
    }
}

