/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SideChainPart;

public interface SideChainPartBlock {
    public SideChainPart getSideChainPart(BlockState var1);

    public BlockState setSideChainPart(BlockState var1, SideChainPart var2);

    public Direction getFacing(BlockState var1);

    public boolean isConnectable(BlockState var1);

    public int getMaxChainLength();

    default public List<BlockPos> getAllBlocksConnectedTo(LevelAccessor level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        if (!this.isConnectable(blockState)) {
            return List.of();
        }
        Neighbors neighbors = this.getNeighbors(level, pos, this.getFacing(blockState));
        LinkedList<BlockPos> list = new LinkedList<BlockPos>();
        list.add(pos);
        this.addBlocksConnectingTowards(neighbors::left, SideChainPart.LEFT, list::addFirst);
        this.addBlocksConnectingTowards(neighbors::right, SideChainPart.RIGHT, list::addLast);
        return list;
    }

    private void addBlocksConnectingTowards(IntFunction<Neighbor> neighborGetter, SideChainPart chainPart, Consumer<BlockPos> output) {
        for (int i = 1; i < this.getMaxChainLength(); ++i) {
            Neighbor neighbor = neighborGetter.apply(i);
            if (neighbor.connectsTowards(chainPart)) {
                output.accept(neighbor.pos());
            }
            if (neighbor.isUnconnectableOrChainEnd()) break;
        }
    }

    default public void updateNeighborsAfterPoweringDown(LevelAccessor level, BlockPos pos, BlockState state) {
        Neighbors neighbors = this.getNeighbors(level, pos, this.getFacing(state));
        neighbors.left().disconnectFromRight();
        neighbors.right().disconnectFromLeft();
    }

    default public void updateSelfAndNeighborsOnPoweringUp(LevelAccessor level, BlockPos pos, BlockState state, BlockState oldState) {
        if (this.isConnectable(state) && !this.isBeingUpdatedByNeighbor(state, oldState)) {
            Neighbors neighbors = this.getNeighbors(level, pos, this.getFacing(state));
            SideChainPart sideChainPart = SideChainPart.UNCONNECTED;
            int i = neighbors.left().isConnectable() ? this.getAllBlocksConnectedTo(level, neighbors.left().pos()).size() : 0;
            int i1 = neighbors.right().isConnectable() ? this.getAllBlocksConnectedTo(level, neighbors.right().pos()).size() : 0;
            int i2 = 1;
            if (this.canConnect(i, i2)) {
                sideChainPart = sideChainPart.whenConnectedToTheLeft();
                neighbors.left().connectToTheRight();
                i2 += i;
            }
            if (this.canConnect(i1, i2)) {
                sideChainPart = sideChainPart.whenConnectedToTheRight();
                neighbors.right().connectToTheLeft();
            }
            this.setPart(level, pos, sideChainPart);
        }
    }

    private boolean canConnect(int segmentLength, int currentChainLength) {
        return segmentLength > 0 && currentChainLength + segmentLength <= this.getMaxChainLength();
    }

    private boolean isBeingUpdatedByNeighbor(BlockState state, BlockState oldState) {
        boolean isConnected = this.getSideChainPart(state).isConnected();
        boolean flag = this.isConnectable(oldState) && this.getSideChainPart(oldState).isConnected();
        return isConnected || flag;
    }

    private Neighbors getNeighbors(LevelAccessor level, BlockPos center, Direction facing) {
        return new Neighbors(this, level, facing, center, new HashMap<BlockPos, Neighbor>());
    }

    default public void setPart(LevelAccessor level, BlockPos pos, SideChainPart chainPart) {
        BlockState blockState = level.getBlockState(pos);
        if (this.getSideChainPart(blockState) != chainPart) {
            level.setBlock(pos, this.setSideChainPart(blockState, chainPart), 3);
        }
    }

    public record Neighbors(SideChainPartBlock block, LevelAccessor level, Direction facing, BlockPos center, Map<BlockPos, Neighbor> cache) {
        private boolean isConnectableToThisBlock(BlockState state) {
            return this.block.isConnectable(state) && this.block.getFacing(state) == this.facing;
        }

        private Neighbor createNewNeighbor(BlockPos pos) {
            BlockState blockState = this.level.getBlockState(pos);
            SideChainPart sideChainPart = this.isConnectableToThisBlock(blockState) ? this.block.getSideChainPart(blockState) : null;
            return (Neighbor)((Object)(sideChainPart == null ? new EmptyNeighbor(pos) : new SideChainNeighbor(this.level, this.block, pos, sideChainPart)));
        }

        private Neighbor getOrCreateNeighbor(Direction direction, Integer distance) {
            return this.cache.computeIfAbsent(this.center.relative(direction, (int)distance), this::createNewNeighbor);
        }

        public Neighbor left(int distance) {
            return this.getOrCreateNeighbor(this.facing.getClockWise(), distance);
        }

        public Neighbor right(int distance) {
            return this.getOrCreateNeighbor(this.facing.getCounterClockWise(), distance);
        }

        public Neighbor left() {
            return this.left(1);
        }

        public Neighbor right() {
            return this.right(1);
        }
    }

    public static sealed interface Neighbor
    permits EmptyNeighbor, SideChainNeighbor {
        public BlockPos pos();

        public boolean isConnectable();

        public boolean isUnconnectableOrChainEnd();

        public boolean connectsTowards(SideChainPart var1);

        default public void connectToTheRight() {
        }

        default public void connectToTheLeft() {
        }

        default public void disconnectFromRight() {
        }

        default public void disconnectFromLeft() {
        }
    }

    public record SideChainNeighbor(LevelAccessor level, SideChainPartBlock block, BlockPos pos, SideChainPart part) implements Neighbor
    {
        @Override
        public boolean isConnectable() {
            return true;
        }

        @Override
        public boolean isUnconnectableOrChainEnd() {
            return this.part.isChainEnd();
        }

        @Override
        public boolean connectsTowards(SideChainPart chainPart) {
            return this.part.isConnectionTowards(chainPart);
        }

        @Override
        public void connectToTheRight() {
            this.block.setPart(this.level, this.pos, this.part.whenConnectedToTheRight());
        }

        @Override
        public void connectToTheLeft() {
            this.block.setPart(this.level, this.pos, this.part.whenConnectedToTheLeft());
        }

        @Override
        public void disconnectFromRight() {
            this.block.setPart(this.level, this.pos, this.part.whenDisconnectedFromTheRight());
        }

        @Override
        public void disconnectFromLeft() {
            this.block.setPart(this.level, this.pos, this.part.whenDisconnectedFromTheLeft());
        }
    }

    public record EmptyNeighbor(BlockPos pos) implements Neighbor
    {
        @Override
        public boolean isConnectable() {
            return false;
        }

        @Override
        public boolean isUnconnectableOrChainEnd() {
            return true;
        }

        @Override
        public boolean connectsTowards(SideChainPart chainPart) {
            return false;
        }
    }
}

