/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.debug.DebugHiveInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityEnterBlockEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.slf4j.Logger;

public class BeehiveBlockEntity
extends BlockEntity {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_FLOWER_POS = "flower_pos";
    private static final String BEES = "bees";
    static final List<String> IGNORED_BEE_TAGS = Arrays.asList("Air", "drop_chances", "equipment", "Brain", "CanPickUpLoot", "DeathTime", "fall_distance", "FallFlying", "Fire", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "sleeping_pos", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "hive_pos", "Passengers", "leash", "UUID");
    public static final int MAX_OCCUPANTS = 3;
    private static final int MIN_TICKS_BEFORE_REENTERING_HIVE = 400;
    private static final int MIN_OCCUPATION_TICKS_NECTAR = 2400;
    public static final int MIN_OCCUPATION_TICKS_NECTARLESS = 600;
    private List<BeeData> stored = Lists.newArrayList();
    @Nullable
    public BlockPos savedFlowerPos;
    public int maxBees = 3;

    public BeehiveBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityType.BEEHIVE, pos, blockState);
    }

    @Override
    public void setChanged() {
        if (this.isFireNearby()) {
            this.emptyAllLivingFromHive(null, this.level.getBlockState(this.getBlockPos()), BeeReleaseStatus.EMERGENCY);
        }
        super.setChanged();
    }

    public boolean isFireNearby() {
        if (this.level == null) {
            return false;
        }
        for (BlockPos blockPos : BlockPos.betweenClosed(this.worldPosition.offset(-1, -1, -1), this.worldPosition.offset(1, 1, 1))) {
            if (!(this.level.getBlockState(blockPos).getBlock() instanceof FireBlock)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFull() {
        return this.stored.size() == this.maxBees;
    }

    public void emptyAllLivingFromHive(@Nullable Player player, BlockState state, BeeReleaseStatus releaseStatus) {
        List<net.minecraft.world.entity.Entity> list = this.releaseAllOccupants(state, releaseStatus);
        if (player != null) {
            for (net.minecraft.world.entity.Entity entity : list) {
                if (!(entity instanceof Bee)) continue;
                Bee bee = (Bee)entity;
                if (!(player.position().distanceToSqr(entity.position()) <= 16.0)) continue;
                if (!this.isSedated()) {
                    bee.setTarget(player, EntityTargetEvent.TargetReason.CLOSEST_PLAYER);
                    continue;
                }
                bee.setStayOutOfHiveCountdown(400);
            }
        }
    }

    private List<net.minecraft.world.entity.Entity> releaseAllOccupants(BlockState state, BeeReleaseStatus releaseStatus) {
        return this.releaseBees(state, releaseStatus, false);
    }

    public List<net.minecraft.world.entity.Entity> releaseBees(BlockState state, BeeReleaseStatus releaseStatus, boolean force) {
        ArrayList list = Lists.newArrayList();
        this.stored.removeIf(data -> BeehiveBlockEntity.releaseOccupant(this.level, this.worldPosition, state, data.toOccupant(), list, releaseStatus, this.savedFlowerPos, force));
        if (!list.isEmpty()) {
            super.setChanged();
        }
        return list;
    }

    @VisibleForDebug
    public int getOccupantCount() {
        return this.stored.size();
    }

    public void clearBees() {
        this.stored.clear();
    }

    public static int getHoneyLevel(BlockState state) {
        return state.getValue(BeehiveBlock.HONEY_LEVEL);
    }

    @VisibleForDebug
    public boolean isSedated() {
        return CampfireBlock.isSmokeyPos(this.level, this.getBlockPos());
    }

    public void addOccupant(Bee bee) {
        if (this.stored.size() < this.maxBees) {
            EntityEnterBlockEvent event;
            if (this.level != null && !(event = new EntityEnterBlockEvent((Entity)bee.getBukkitEntity(), (Block)CraftBlock.at(this.level, this.getBlockPos()))).callEvent()) {
                bee.setStayOutOfHiveCountdown(400);
                return;
            }
            bee.stopRiding();
            bee.ejectPassengers();
            bee.dropLeash();
            this.storeBee(Occupant.of(bee));
            if (this.level != null) {
                if (bee.hasSavedFlowerPos() && (!this.hasSavedFlowerPos() || this.level.random.nextBoolean())) {
                    this.savedFlowerPos = bee.getSavedFlowerPos();
                }
                BlockPos blockPos = this.getBlockPos();
                this.level.playSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.BEEHIVE_ENTER, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.level.gameEvent(GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of(bee, this.getBlockState()));
            }
            bee.discard(EntityRemoveEvent.Cause.ENTER_BLOCK);
            super.setChanged();
        }
    }

    public void storeBee(Occupant occupant) {
        this.stored.add(new BeeData(occupant));
    }

    private static boolean releaseOccupant(Level level, BlockPos pos, BlockState state, Occupant occupant, @Nullable List<net.minecraft.world.entity.Entity> storedInHives, BeeReleaseStatus releaseStatus, @Nullable BlockPos storedFlowerPos) {
        return BeehiveBlockEntity.releaseOccupant(level, pos, state, occupant, storedInHives, releaseStatus, storedFlowerPos, false);
    }

    private static boolean releaseOccupant(Level level, BlockPos pos, BlockState state, Occupant occupant, @Nullable List<net.minecraft.world.entity.Entity> storedInHives, BeeReleaseStatus releaseStatus, @Nullable BlockPos storedFlowerPos, boolean force) {
        boolean flag;
        if (!force && Bee.isNightOrRaining(level) && releaseStatus != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        Direction direction = state.getValue(BeehiveBlock.FACING);
        BlockPos blockPos = pos.relative(direction);
        boolean bl = flag = !level.getBlockState(blockPos).getCollisionShape(level, blockPos).isEmpty();
        if (flag && releaseStatus != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = occupant.createEntity(level, pos);
        if (entity != null) {
            if (entity instanceof Bee) {
                float bbWidth = entity.getBbWidth();
                double d = flag ? 0.0 : 0.55 + (double)(bbWidth / 2.0f);
                double d1 = (double)pos.getX() + 0.5 + d * (double)direction.getStepX();
                double d2 = (double)pos.getY() + 0.5 - (double)(entity.getBbHeight() / 2.0f);
                double d3 = (double)pos.getZ() + 0.5 + d * (double)direction.getStepZ();
                entity.snapTo(d1, d2, d3, entity.getYRot(), entity.getXRot());
            }
            if (!level.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.BEEHIVE)) {
                return false;
            }
            if (entity instanceof Bee) {
                Bee bee = (Bee)entity;
                if (storedFlowerPos != null && !bee.hasSavedFlowerPos() && level.random.nextFloat() < 0.9f) {
                    bee.setSavedFlowerPos(storedFlowerPos);
                }
                if (releaseStatus == BeeReleaseStatus.HONEY_DELIVERED) {
                    int honeyLevel;
                    bee.dropOffNectar();
                    if (state.is(BlockTags.BEEHIVES, blockStateBase -> blockStateBase.hasProperty(BeehiveBlock.HONEY_LEVEL)) && (honeyLevel = BeehiveBlockEntity.getHoneyLevel(state)) < 5) {
                        BlockState newBlockState;
                        int i;
                        int n = i = level.random.nextInt(100) == 0 ? 2 : 1;
                        if (honeyLevel + i > 5) {
                            --i;
                        }
                        if (CraftEventFactory.callEntityChangeBlockEvent(entity, pos, newBlockState = (BlockState)state.setValue(BeehiveBlock.HONEY_LEVEL, honeyLevel + i))) {
                            level.setBlockAndUpdate(pos, newBlockState);
                        }
                    }
                }
                if (storedInHives != null) {
                    storedInHives.add(bee);
                }
            }
            level.playSound(null, pos, SoundEvents.BEEHIVE_EXIT, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of(entity, level.getBlockState(pos)));
            return true;
        }
        return false;
    }

    private boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    private static void tickOccupants(Level level, BlockPos pos, BlockState state, List<BeeData> data, @Nullable BlockPos savedFlowerPos) {
        boolean flag = false;
        Iterator<BeeData> iterator = data.iterator();
        while (iterator.hasNext()) {
            BeeReleaseStatus beeReleaseStatus;
            BeeData beeData = iterator.next();
            if (!beeData.tick()) continue;
            BeeReleaseStatus beeReleaseStatus2 = beeReleaseStatus = beeData.hasNectar() ? BeeReleaseStatus.HONEY_DELIVERED : BeeReleaseStatus.BEE_RELEASED;
            if (BeehiveBlockEntity.releaseOccupant(level, pos, state, beeData.toOccupant(), null, beeReleaseStatus, savedFlowerPos)) {
                flag = true;
                iterator.remove();
                continue;
            }
            if (!level.paperConfig().entities.behavior.cooldownFailedBeehiveReleases) continue;
            beeData.exitTickCounter = beeData.occupant.minTicksInHive / 2;
        }
        if (flag) {
            BeehiveBlockEntity.setChanged(level, pos, state);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BeehiveBlockEntity beehive) {
        BeehiveBlockEntity.tickOccupants(level, pos, state, beehive.stored, beehive.savedFlowerPos);
        if (!beehive.stored.isEmpty() && level.getRandom().nextDouble() < 0.005) {
            double d = (double)pos.getX() + 0.5;
            double d1 = pos.getY();
            double d2 = (double)pos.getZ() + 0.5;
            level.playSound(null, d, d1, d2, SoundEvents.BEEHIVE_WORK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.stored = Lists.newArrayList();
        input.read(BEES, Occupant.LIST_CODEC).orElse(List.of()).forEach(this::storeBee);
        this.savedFlowerPos = input.read(TAG_FLOWER_POS, BlockPos.CODEC).orElse(null);
        this.maxBees = input.getIntOr("Bukkit.MaxEntities", 3);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.store(BEES, Occupant.LIST_CODEC, this.getBees());
        output.storeNullable(TAG_FLOWER_POS, BlockPos.CODEC, this.savedFlowerPos);
        output.putInt("Bukkit.MaxEntities", this.maxBees);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        super.applyImplicitComponents(componentGetter);
        this.stored = Lists.newArrayList();
        List<Occupant> list = componentGetter.getOrDefault(DataComponents.BEES, Bees.EMPTY).bees();
        list.forEach(this::storeBee);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.BEES, new Bees(this.getBees()));
    }

    @Override
    public void removeComponentsFromTag(ValueOutput output) {
        super.removeComponentsFromTag(output);
        output.discard(BEES);
    }

    private List<Occupant> getBees() {
        return this.stored.stream().map(BeeData::toOccupant).toList();
    }

    @Override
    public void registerDebugValues(ServerLevel level, DebugValueSource.Registration registrar) {
        registrar.register(DebugSubscriptions.BEE_HIVES, () -> DebugHiveInfo.pack(this));
    }

    public static enum BeeReleaseStatus {
        HONEY_DELIVERED,
        BEE_RELEASED,
        EMERGENCY;

    }

    public record Occupant(TypedEntityData<EntityType<?>> entityData, int ticksInHive, int minTicksInHive) {
        public static final Codec<Occupant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TypedEntityData.codec(EntityType.CODEC).fieldOf("entity_data").forGetter(Occupant::entityData), (App)Codec.INT.fieldOf("ticks_in_hive").forGetter(Occupant::ticksInHive), (App)Codec.INT.fieldOf("min_ticks_in_hive").forGetter(Occupant::minTicksInHive)).apply((Applicative)instance, Occupant::new));
        public static final Codec<List<Occupant>> LIST_CODEC = CODEC.listOf();
        public static final StreamCodec<RegistryFriendlyByteBuf, Occupant> STREAM_CODEC = StreamCodec.composite(TypedEntityData.streamCodec(EntityType.STREAM_CODEC), Occupant::entityData, ByteBufCodecs.VAR_INT, Occupant::ticksInHive, ByteBufCodecs.VAR_INT, Occupant::minTicksInHive, Occupant::new);

        public static Occupant of(net.minecraft.world.entity.Entity entity) {
            Occupant var5;
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(entity.problemPath(), LOGGER);){
                TagValueOutput tagValueOutput = TagValueOutput.createWithContext(scopedCollector, entity.registryAccess());
                entity.save(tagValueOutput);
                IGNORED_BEE_TAGS.forEach(tagValueOutput::discard);
                CompoundTag compoundTag = tagValueOutput.buildResult();
                boolean booleanOr = compoundTag.getBooleanOr("HasNectar", false);
                var5 = new Occupant(TypedEntityData.of(entity.getType(), compoundTag), 0, booleanOr ? 2400 : 600);
            }
            return var5;
        }

        public static Occupant create(int ticksInHive) {
            return new Occupant(TypedEntityData.of(EntityType.BEE, new CompoundTag()), ticksInHive, 600);
        }

        @Nullable
        public net.minecraft.world.entity.Entity createEntity(Level level, BlockPos pos) {
            CompoundTag compoundTag = this.entityData.copyTagWithoutId();
            IGNORED_BEE_TAGS.forEach(compoundTag::remove);
            net.minecraft.world.entity.Entity entity = EntityType.loadEntityRecursive(this.entityData.type(), compoundTag, level, EntitySpawnReason.LOAD, entity1 -> entity1);
            if (entity != null && entity.getType().is(EntityTypeTags.BEEHIVE_INHABITORS)) {
                entity.setNoGravity(true);
                if (entity instanceof Bee) {
                    Bee bee = (Bee)entity;
                    bee.setHivePos(pos);
                    Occupant.setBeeReleaseData(this.ticksInHive, bee);
                }
                return entity;
            }
            return null;
        }

        private static void setBeeReleaseData(int ticksInHive, Bee bee) {
            if (!bee.ageLocked) {
                int age = bee.getAge();
                if (age < 0) {
                    bee.setAge(Math.min(0, age + ticksInHive));
                } else if (age > 0) {
                    bee.setAge(Math.max(0, age - ticksInHive));
                }
                bee.setInLoveTime(Math.max(0, bee.getInLoveTime() - ticksInHive));
            }
        }
    }

    static class BeeData {
        private final Occupant occupant;
        private int exitTickCounter;
        private int ticksInHive;

        BeeData(Occupant occupant) {
            this.occupant = occupant;
            this.exitTickCounter = this.ticksInHive = occupant.ticksInHive();
        }

        public boolean tick() {
            ++this.ticksInHive;
            return this.exitTickCounter++ > this.occupant.minTicksInHive;
        }

        public Occupant toOccupant() {
            return new Occupant(this.occupant.entityData, this.ticksInHive, this.occupant.minTicksInHive);
        }

        public boolean hasNectar() {
            return this.occupant.entityData.getUnsafe().getBooleanOr("HasNectar", false);
        }
    }
}

