/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CalibratedSculkSensorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.ValueOutput;

public class CalibratedSculkSensorBlockEntity
extends SculkSensorBlockEntity {
    public CalibratedSculkSensorBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityType.CALIBRATED_SCULK_SENSOR, pos, blockState);
    }

    @Override
    public VibrationSystem.User createVibrationUser() {
        return new VibrationUser(this.getBlockPos());
    }

    @Override
    protected void saveRangeOverride(ValueOutput output) {
        if (this.rangeOverride != null && this.rangeOverride != 16) {
            output.putInt("Paper.ListenerRange", this.rangeOverride);
        }
    }

    protected class VibrationUser
    extends SculkSensorBlockEntity.VibrationUser {
        public VibrationUser(BlockPos blockPos1) {
            super(blockPos1);
        }

        @Override
        public int getListenerRadius() {
            if (CalibratedSculkSensorBlockEntity.this.rangeOverride != null) {
                return CalibratedSculkSensorBlockEntity.this.rangeOverride;
            }
            return 16;
        }

        @Override
        public boolean canReceiveVibration(ServerLevel level, BlockPos pos, Holder<GameEvent> gameEvent, @Nullable GameEvent.Context context) {
            int backSignal = this.getBackSignal(level, this.blockPos, CalibratedSculkSensorBlockEntity.this.getBlockState());
            return (backSignal == 0 || VibrationSystem.getGameEventFrequency(gameEvent) == backSignal) && super.canReceiveVibration(level, pos, gameEvent, context);
        }

        private int getBackSignal(Level level, BlockPos pos, BlockState state) {
            Direction opposite = state.getValue(CalibratedSculkSensorBlock.FACING).getOpposite();
            return level.getSignal(pos.relative(opposite), opposite);
        }
    }
}

