/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.patches.fast_palette.FastPaletteData;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.antixray.ChunkPacketInfo;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.BitStorage;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.chunk.Configuration;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.Strategy;
import org.jetbrains.annotations.Nullable;

public class PalettedContainer<T>
implements PaletteResize<T>,
PalettedContainerRO<T> {
    private static final int MIN_PALETTE_BITS = 0;
    public volatile Data<T> data;
    private final Strategy<T> strategy;
    private final T @Nullable [] presetValues;

    public void acquire() {
    }

    public void release() {
    }

    @Deprecated
    @DoNotUse
    public static <T> Codec<PalettedContainer<T>> codecRW(Codec<T> valueCodec, Strategy<T> strategy, T defaultValue) {
        return PalettedContainer.codecRW(valueCodec, strategy, defaultValue, null);
    }

    public static <T> Codec<PalettedContainer<T>> codecRW(Codec<T> valueCodec, Strategy strategy, T defaultValue, T @Nullable [] presetValues) {
        PalettedContainerRO.Unpacker unpacker = (strategy1, packedData) -> PalettedContainer.unpack(strategy1, packedData, defaultValue, presetValues);
        return PalettedContainer.codec(valueCodec, strategy, defaultValue, unpacker);
    }

    public static <T> Codec<PalettedContainerRO<T>> codecRO(Codec<T> valueCodec, Strategy<T> strategy, T defaultValue) {
        PalettedContainerRO.Unpacker unpacker = (strategy1, packedData) -> PalettedContainer.unpack(strategy1, packedData, defaultValue, null).map(container -> container);
        return PalettedContainer.codec(valueCodec, strategy, defaultValue, unpacker);
    }

    private static <T, C extends PalettedContainerRO<T>> Codec<C> codec(Codec<T> valueCodec, Strategy<T> strategy, T defaultValue, PalettedContainerRO.Unpacker<T, C> unpacker) {
        return RecordCodecBuilder.create(instance -> instance.group((App)valueCodec.mapResult(ExtraCodecs.orElsePartial(defaultValue)).listOf().fieldOf("palette").forGetter(PalettedContainerRO.PackedData::paletteEntries), (App)Codec.LONG_STREAM.lenientOptionalFieldOf("data").forGetter(PalettedContainerRO.PackedData::storage)).apply((Applicative)instance, PalettedContainerRO.PackedData::new)).comapFlatMap(packedData -> unpacker.read(strategy, (PalettedContainerRO.PackedData)packedData), container -> container.pack(strategy));
    }

    private void updateData(Data<T> data) {
        if (data != null) {
            ((FastPaletteData)data).moonrise$setPalette(data.palette.moonrise$getRawPalette(data));
        }
    }

    private T readPaletteSlow(Data<T> data, int paletteIdx) {
        return data.palette.valueFor(paletteIdx);
    }

    private T readPalette(Data<T> data, int paletteIdx) {
        T[] palette = ((FastPaletteData)data).moonrise$getPalette();
        if (palette == null) {
            return this.readPaletteSlow(data, paletteIdx);
        }
        Object ret = palette[paletteIdx];
        if (ret == null) {
            throw new IllegalArgumentException("Palette index out of bounds");
        }
        return ret;
    }

    private PalettedContainer(Strategy<T> strategy, Configuration configuration, BitStorage storage, Palette<T> palette, List<T> values, T defaultValue, T @Nullable [] presetValues) {
        Configuration.Simple simpleFactory;
        this.presetValues = presetValues;
        this.strategy = strategy;
        this.data = new Data<T>(configuration, storage, palette);
        if (presetValues != null && (configuration instanceof Configuration.Simple && (simpleFactory = (Configuration.Simple)configuration).factory() == Strategy.SINGLE_VALUE_PALETTE_FACTORY ? this.data.palette.valueFor(0) != defaultValue : !(configuration instanceof Configuration.Global))) {
            int maxSize = 1 << configuration.bitsInMemory();
            for (T presetValue : presetValues) {
                if (this.data.palette.getSize() >= maxSize) {
                    HashSet<T> allValues = new HashSet<T>(values);
                    allValues.addAll(Arrays.asList(presetValues));
                    int newBits = Mth.ceillog2(allValues.size());
                    if (newBits <= configuration.bitsInMemory()) break;
                    this.onResize(newBits, null);
                    break;
                }
                this.data.palette.idFor(presetValue, this);
            }
        }
        this.updateData(this.data);
    }

    private PalettedContainer(PalettedContainer<T> other, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.strategy = other.strategy;
        this.data = other.data.copy();
        this.updateData(this.data);
    }

    @Deprecated
    @DoNotUse
    public PalettedContainer(T defaultValue, Strategy<T> strategy) {
        this(defaultValue, strategy, null);
    }

    public PalettedContainer(T defaultValue, Strategy<T> strategy, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.strategy = strategy;
        this.data = this.createOrReuseData(null, 0);
        this.data.palette.idFor(defaultValue, this);
        this.updateData(this.data);
    }

    private Data<T> createOrReuseData(@javax.annotation.Nullable Data<T> data, int bits) {
        Configuration configurationForBitCount = this.strategy.getConfigurationForBitCount(bits);
        if (data != null && configurationForBitCount.equals(data.configuration())) {
            return data;
        }
        BitStorage bitStorage = configurationForBitCount.bitsInMemory() == 0 ? new ZeroBitStorage(this.strategy.entryCount()) : new SimpleBitStorage(configurationForBitCount.bitsInMemory(), this.strategy.entryCount());
        Palette<T> palette = configurationForBitCount.createPalette(this.strategy, List.of());
        return new Data<T>(configurationForBitCount, bitStorage, palette);
    }

    @Override
    public synchronized int onResize(int bits, T addedValue) {
        Configuration.Simple simpleFactory;
        Configuration configuration;
        Data<T> data = this.data;
        if (this.presetValues != null && addedValue != null && (configuration = data.configuration()) instanceof Configuration.Simple && (simpleFactory = (Configuration.Simple)configuration).factory() == Strategy.SINGLE_VALUE_PALETTE_FACTORY) {
            int duplicates = 0;
            List<T> presetValues = Arrays.asList(this.presetValues);
            duplicates += presetValues.contains(addedValue) ? 1 : 0;
            int n = presetValues.contains(data.palette.valueFor(0)) ? 1 : 0;
            int size = 1 << this.strategy.getConfigurationForBitCount(bits).bitsInMemory();
            bits = Mth.ceillog2(size + presetValues.size() - (duplicates += n));
        }
        Data data1 = this.createOrReuseData(data, bits);
        data1.copyFrom(data.palette, data.storage);
        this.data = data1;
        this.updateData(this.data);
        this.addPresetValues();
        return addedValue == null ? -1 : data1.palette.idFor(addedValue, PaletteResize.noResizeExpected());
    }

    private void addPresetValues() {
        if (this.presetValues != null && !(this.data.configuration() instanceof Configuration.Global)) {
            for (T presetValue : this.presetValues) {
                this.data.palette.idFor(presetValue, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T getAndSet(int x, int y, int z, T state) {
        T var5;
        this.acquire();
        try {
            var5 = this.getAndSet(this.strategy.getIndex(x, y, z), state);
        }
        finally {
            this.release();
        }
        return var5;
    }

    public T getAndSetUnchecked(int x, int y, int z, T state) {
        return this.getAndSet(this.strategy.getIndex(x, y, z), state);
    }

    private T getAndSet(int index, T state) {
        int paletteIdx = this.data.palette.idFor(state, this);
        Data<T> data = this.data;
        int prev = data.storage.getAndSet(index, paletteIdx);
        return this.readPalette(data, prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void set(int x, int y, int z, T state) {
        this.acquire();
        try {
            this.set(this.strategy.getIndex(x, y, z), state);
        }
        finally {
            this.release();
        }
    }

    private void set(int index, T state) {
        int i = this.data.palette.idFor(state, this);
        this.data.storage.set(index, i);
    }

    @Override
    public T get(int x, int y, int z) {
        return this.get(this.strategy.getIndex(x, y, z));
    }

    public T get(int index) {
        Data<T> data = this.data;
        return this.readPalette(data, data.storage.get(index));
    }

    @Override
    public void getAll(Consumer<T> consumer) {
        Palette palette = this.data.palette();
        IntArraySet set = new IntArraySet();
        this.data.storage.getAll(arg_0 -> ((IntSet)set).add(arg_0));
        set.forEach(id -> consumer.accept(palette.valueFor(id)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void read(FriendlyByteBuf buffer) {
        this.acquire();
        try {
            byte _byte = buffer.readByte();
            Data<T> data = this.createOrReuseData(this.data, _byte);
            data.palette.read(buffer, this.strategy.globalMap());
            buffer.readFixedSizeLongArray(data.storage.getRaw());
            this.data = data;
            this.addPresetValues();
            this.updateData(this.data);
        }
        finally {
            this.release();
        }
    }

    @Override
    @Deprecated
    @DoNotUse
    public void write(FriendlyByteBuf buffer) {
        this.write(buffer, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(FriendlyByteBuf buffer, @javax.annotation.Nullable ChunkPacketInfo<T> chunkPacketInfo, int chunkSectionIndex) {
        this.acquire();
        try {
            this.data.write(buffer, this.strategy.globalMap(), chunkPacketInfo, chunkSectionIndex);
            if (chunkPacketInfo != null) {
                chunkPacketInfo.setPresetValues(chunkSectionIndex, this.presetValues);
            }
        }
        finally {
            this.release();
        }
    }

    @VisibleForTesting
    public static <T> DataResult<PalettedContainer<T>> unpack(Strategy<T> strategy, PalettedContainerRO.PackedData<T> packedData, T defaultValue, T @Nullable [] presetValues) {
        BitStorage bitStorage;
        Palette<T> palette;
        List<T> list = packedData.paletteEntries();
        int entryCount = strategy.entryCount();
        Configuration configurationForPaletteSize = strategy.getConfigurationForPaletteSize(list.size());
        int i = configurationForPaletteSize.bitsInStorage();
        if (packedData.bitsPerEntry() != -1 && i != packedData.bitsPerEntry()) {
            return DataResult.error(() -> "Invalid bit count, calculated " + i + ", but container declared " + packedData.bitsPerEntry());
        }
        if (configurationForPaletteSize.bitsInMemory() == 0) {
            palette = configurationForPaletteSize.createPalette(strategy, list);
            bitStorage = new ZeroBitStorage(entryCount);
        } else {
            Optional<LongStream> optional = packedData.storage();
            if (optional.isEmpty()) {
                return DataResult.error(() -> "Missing values for non-zero storage");
            }
            long[] longs = optional.get().toArray();
            try {
                if (!configurationForPaletteSize.alwaysRepack() && configurationForPaletteSize.bitsInMemory() == i) {
                    palette = configurationForPaletteSize.createPalette(strategy, list);
                    bitStorage = new SimpleBitStorage(configurationForPaletteSize.bitsInMemory(), entryCount, longs);
                } else {
                    HashMapPalette<T> palette1 = new HashMapPalette<T>(i, list);
                    SimpleBitStorage simpleBitStorage = new SimpleBitStorage(i, entryCount, longs);
                    Palette<T> palette2 = configurationForPaletteSize.createPalette(strategy, list);
                    int[] ints = PalettedContainer.reencodeContents(simpleBitStorage, palette1, palette2);
                    palette = palette2;
                    bitStorage = new SimpleBitStorage(configurationForPaletteSize.bitsInMemory(), entryCount, ints);
                }
            }
            catch (SimpleBitStorage.InitializationException var14) {
                return DataResult.error(() -> "Failed to read PalettedContainer: " + var14.getMessage());
            }
        }
        return DataResult.success(new PalettedContainer<T>(strategy, configurationForPaletteSize, bitStorage, palette, list, defaultValue, presetValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PalettedContainerRO.PackedData<T> pack(Strategy<T> strategy) {
        PalettedContainerRO.PackedData var14;
        this.acquire();
        try {
            Optional<LongStream> optional;
            BitStorage bitStorage = this.data.storage;
            Palette palette = this.data.palette;
            HashMapPalette hashMapPalette = new HashMapPalette(bitStorage.getBits());
            int entryCount = strategy.entryCount();
            int[] ints = PalettedContainer.reencodeContents(bitStorage, palette, hashMapPalette);
            Configuration configurationForPaletteSize = strategy.getConfigurationForPaletteSize(hashMapPalette.getSize());
            int i = configurationForPaletteSize.bitsInStorage();
            if (i != 0) {
                SimpleBitStorage simpleBitStorage = new SimpleBitStorage(i, entryCount, ints);
                optional = Optional.of(Arrays.stream(simpleBitStorage.getRaw()));
            } else {
                optional = Optional.empty();
            }
            var14 = new PalettedContainerRO.PackedData(hashMapPalette.getEntries(), optional, i);
        }
        finally {
            this.release();
        }
        return var14;
    }

    private static <T> int[] reencodeContents(BitStorage bitStorage, Palette<T> oldPalette, Palette<T> newPalette) {
        int[] ints = new int[bitStorage.getSize()];
        bitStorage.unpack(ints);
        PaletteResize paletteResize = PaletteResize.noResizeExpected();
        int i = -1;
        int i1 = -1;
        for (int i2 = 0; i2 < ints.length; ++i2) {
            int i3 = ints[i2];
            if (i3 != i) {
                i = i3;
                i1 = newPalette.idFor(oldPalette.valueFor(i3), paletteResize);
            }
            ints[i2] = i1;
        }
        return ints;
    }

    @Override
    public int getSerializedSize() {
        return this.data.getSerializedSize(this.strategy.globalMap());
    }

    @Override
    public int bitsPerEntry() {
        return this.data.storage().getBits();
    }

    @Override
    public boolean maybeHas(Predicate<T> predicate) {
        return this.data.palette.maybeHas(predicate);
    }

    @Override
    public PalettedContainer<T> copy() {
        return new PalettedContainer<T>(this, this.presetValues);
    }

    @Override
    public PalettedContainer<T> recreate() {
        return new PalettedContainer(this.data.palette.valueFor(0), this.strategy, this.presetValues);
    }

    @Override
    public void count(CountConsumer<T> countConsumer) {
        if (this.data.palette.getSize() == 1) {
            countConsumer.accept(this.data.palette.valueFor(0), this.data.storage.getSize());
        } else {
            Int2IntOpenHashMap map = new Int2IntOpenHashMap();
            this.data.storage.getAll((int id) -> map.addTo(id, 1));
            map.int2IntEntrySet().forEach(idEntry -> countConsumer.accept(this.data.palette.valueFor(idEntry.getIntKey()), idEntry.getIntValue()));
        }
    }

    public static final class Data<T>
    implements FastPaletteData<T> {
        private final Configuration configuration;
        private final BitStorage storage;
        private final Palette<T> palette;
        private T[] moonrise$palette;

        public Data(Configuration configuration, BitStorage storage, Palette<T> palette) {
            this.configuration = configuration;
            this.storage = storage;
            this.palette = palette;
        }

        public Configuration configuration() {
            return this.configuration;
        }

        public BitStorage storage() {
            return this.storage;
        }

        public Palette<T> palette() {
            return this.palette;
        }

        @Override
        public final T[] moonrise$getPalette() {
            return this.moonrise$palette;
        }

        @Override
        public final void moonrise$setPalette(T[] palette) {
            this.moonrise$palette = palette;
        }

        public void copyFrom(Palette<T> palette, BitStorage bitStorage) {
            PaletteResize paletteResize = PaletteResize.noResizeExpected();
            for (int i = 0; i < bitStorage.getSize(); ++i) {
                T object = palette.valueFor(bitStorage.get(i));
                this.storage.set(i, this.palette.idFor(object, paletteResize));
            }
        }

        public int getSerializedSize(IdMap<T> map) {
            return 1 + this.palette.getSerializedSize(map) + this.storage.getRaw().length * 8;
        }

        public void write(FriendlyByteBuf buffer, IdMap<T> map, @javax.annotation.Nullable ChunkPacketInfo<T> chunkPacketInfo, int chunkSectionIndex) {
            buffer.writeByte(this.storage.getBits());
            this.palette.write(buffer, map);
            if (chunkPacketInfo != null) {
                chunkPacketInfo.setBits(chunkSectionIndex, this.configuration.bitsInMemory());
                chunkPacketInfo.setPalette(chunkSectionIndex, this.palette);
                chunkPacketInfo.setIndex(chunkSectionIndex, buffer.writerIndex());
            }
            buffer.writeFixedSizeLongArray(this.storage.getRaw());
        }

        public Data<T> copy() {
            return new Data<T>(this.configuration, this.storage.copy(), this.palette.copy());
        }
    }

    @FunctionalInterface
    public static interface CountConsumer<T> {
        public void accept(T var1, int var2);
    }
}

