/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.Strategy;

public record PalettedContainerFactory(Strategy<BlockState> blockStatesStrategy, BlockState defaultBlockState, Codec<PalettedContainer<BlockState>> blockStatesContainerCodec, Strategy<Holder<Biome>> biomeStrategy, Holder<Biome> defaultBiome, Codec<PalettedContainerRO<Holder<Biome>>> biomeContainerCodec, Codec<PalettedContainer<Holder<Biome>>> biomeContainerRWCodec) {
    public static PalettedContainerFactory create(RegistryAccess registryAccess) {
        Strategy<BlockState> strategy = Strategy.createForBlockStates(Block.BLOCK_STATE_REGISTRY);
        BlockState blockState = Blocks.AIR.defaultBlockState();
        HolderLookup.RegistryLookup registry = registryAccess.lookupOrThrow(Registries.BIOME);
        Strategy<Holder<Biome>> strategy1 = Strategy.createForBiomes(registry.asHolderIdMap());
        Holder.Reference orThrow = registry.getOrThrow(Biomes.PLAINS);
        return new PalettedContainerFactory(strategy, blockState, PalettedContainer.codecRW(BlockState.CODEC, strategy, blockState, null), strategy1, orThrow, PalettedContainer.codecRO(registry.holderByNameCodec(), strategy1, orThrow), PalettedContainer.codecRW(registry.holderByNameCodec(), strategy1, orThrow, null));
    }

    public PalettedContainer<BlockState> createForBlockStates() {
        return new PalettedContainer<BlockState>(this.defaultBlockState, this.blockStatesStrategy, null);
    }

    public PalettedContainer<BlockState> createForBlockStates(@Nullable Level level, ChunkPos chunkPos, int chunkSectionY) {
        BlockState[] states = null;
        if (level != null && level.chunkPacketBlockController != null) {
            states = level.chunkPacketBlockController.getPresetBlockStates(level, chunkPos, chunkSectionY);
        }
        return new PalettedContainer<BlockState>(this.defaultBlockState, this.blockStatesStrategy, states);
    }

    public PalettedContainer<Holder<Biome>> createForBiomes() {
        return new PalettedContainer<Holder<Biome>>(this.defaultBiome, this.biomeStrategy, null);
    }
}

