/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.SinglePieceStructure;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.bukkit.craftbukkit.CraftLootTable;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.CraftBrushableBlock;
import org.bukkit.craftbukkit.util.TransformerGeneratorAccess;

public class DesertPyramidStructure
extends SinglePieceStructure {
    public static final MapCodec<DesertPyramidStructure> CODEC = DesertPyramidStructure.simpleCodec(DesertPyramidStructure::new);

    public DesertPyramidStructure(Structure.StructureSettings settings) {
        super(DesertPyramidPiece::new, 21, 21, settings);
    }

    @Override
    public void afterPlace(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer pieces) {
        SortedArraySet set = SortedArraySet.create(Vec3i::compareTo);
        for (StructurePiece structurePiece : pieces.pieces()) {
            if (!(structurePiece instanceof DesertPyramidPiece)) continue;
            DesertPyramidPiece desertPyramidPiece = (DesertPyramidPiece)structurePiece;
            set.addAll(desertPyramidPiece.getPotentialSuspiciousSandWorldPositions());
            DesertPyramidStructure.placeSuspiciousSand(boundingBox, level, desertPyramidPiece.getRandomCollapsedRoofPos());
        }
        ObjectArrayList list = new ObjectArrayList(set.stream().toList());
        RandomSource randomSource = RandomSource.create(level.getSeed()).forkPositional().at(pieces.calculateBoundingBox().getCenter());
        Util.shuffle(list, randomSource);
        int min = Math.min(set.size(), randomSource.nextInt(5, 8));
        for (BlockPos blockPos : list) {
            if (min > 0) {
                --min;
                DesertPyramidStructure.placeSuspiciousSand(boundingBox, level, blockPos);
                continue;
            }
            if (!boundingBox.isInside(blockPos)) continue;
            level.setBlock(blockPos, Blocks.SAND.defaultBlockState(), 2);
        }
    }

    private static void placeSuspiciousSand(BoundingBox boundingBox, WorldGenLevel worldGenLevel, BlockPos pos) {
        if (boundingBox.isInside(pos)) {
            TransformerGeneratorAccess transformerAccess;
            if (worldGenLevel instanceof TransformerGeneratorAccess && (transformerAccess = (TransformerGeneratorAccess)worldGenLevel).canTransformBlocks()) {
                CraftBrushableBlock brushableState = (CraftBrushableBlock)CraftBlockStates.getBlockState((LevelReader)worldGenLevel, pos, Blocks.SUSPICIOUS_SAND.defaultBlockState(), null);
                brushableState.setLootTable(CraftLootTable.minecraftToBukkit(BuiltInLootTables.DESERT_PYRAMID_ARCHAEOLOGY));
                brushableState.setSeed(pos.asLong());
                transformerAccess.setCraftBlock(pos, brushableState, 2);
                return;
            }
            worldGenLevel.setBlock(pos, Blocks.SUSPICIOUS_SAND.defaultBlockState(), 2);
            worldGenLevel.getBlockEntity(pos, BlockEntityType.BRUSHABLE_BLOCK).ifPresent(brushableBlockEntity -> brushableBlockEntity.setLootTable(BuiltInLootTables.DESERT_PYRAMID_ARCHAEOLOGY, pos.asLong()));
        }
    }

    @Override
    public StructureType<?> type() {
        return StructureType.DESERT_PYRAMID;
    }
}

