/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import ca.spottedleaf.moonrise.patches.collisions.util.CollisionDirection;
import ca.spottedleaf.moonrise.patches.collisions.util.FluidOcclusionCacheKey;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;

public abstract class FlowingFluid
extends Fluid {
    public static final BooleanProperty FALLING = BlockStateProperties.FALLING;
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL_FLOWING;
    private static final int CACHE_SIZE = 200;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<BlockStatePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<BlockStatePairKey> map = new Object2ByteLinkedOpenHashMap<BlockStatePairKey>(200){

            protected void rehash(int newSize) {
            }
        };
        map.defaultReturnValue((byte)127);
        return map;
    });
    private final Map<FluidState, VoxelShape> shapes = Maps.newIdentityHashMap();
    private FluidState sourceFalling;
    private FluidState sourceNotFalling;
    private static final int TOTAL_FLOWING_STATES = FALLING.getPossibleValues().size() * LEVEL.getPossibleValues().size();
    private static final int MIN_LEVEL = (Integer)LEVEL.getPossibleValues().stream().sorted().findFirst().get();
    private FluidState[] flowingLookUp;
    private volatile boolean init;
    private static final int COLLISION_OCCLUSION_CACHE_SIZE = 2048;
    private static final ThreadLocal<FluidOcclusionCacheKey[]> COLLISION_OCCLUSION_CACHE = ThreadLocal.withInitial(() -> new FluidOcclusionCacheKey[2048]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        FlowingFluid flowingFluid = this;
        synchronized (flowingFluid) {
            if (this.init) {
                return;
            }
            this.flowingLookUp = new FluidState[TOTAL_FLOWING_STATES];
            FluidState defaultFlowState = this.getFlowing().defaultFluidState();
            for (int i = 0; i < TOTAL_FLOWING_STATES; ++i) {
                int falling = i & 1;
                int level = (i >>> 1) + MIN_LEVEL;
                this.flowingLookUp[i] = (FluidState)((FluidState)defaultFlowState.setValue(FALLING, falling == 1 ? Boolean.TRUE : Boolean.FALSE)).setValue(LEVEL, level);
            }
            FluidState defaultFallState = this.getSource().defaultFluidState();
            this.sourceFalling = (FluidState)defaultFallState.setValue(FALLING, Boolean.TRUE);
            this.sourceNotFalling = (FluidState)defaultFallState.setValue(FALLING, Boolean.FALSE);
            this.init = true;
        }
    }

    @Override
    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
        builder.add(FALLING);
    }

    @Override
    public Vec3 getFlow(BlockGetter level, BlockPos pos, FluidState fluidState) {
        double d = 0.0;
        double d1 = 0.0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutableBlockPos.setWithOffset((Vec3i)pos, direction);
            FluidState fluidState1 = level.getFluidState(mutableBlockPos);
            if (!this.affectsFlow(fluidState1)) continue;
            float ownHeight = fluidState1.getOwnHeight();
            float f = 0.0f;
            if (ownHeight == 0.0f) {
                Vec3i blockPos;
                FluidState fluidState2;
                if (!level.getBlockState(mutableBlockPos).blocksMotion() && this.affectsFlow(fluidState2 = level.getFluidState((BlockPos)(blockPos = mutableBlockPos.below()))) && (ownHeight = fluidState2.getOwnHeight()) > 0.0f) {
                    f = fluidState.getOwnHeight() - (ownHeight - 0.8888889f);
                }
            } else if (ownHeight > 0.0f) {
                f = fluidState.getOwnHeight() - ownHeight;
            }
            if (f == 0.0f) continue;
            d += (double)((float)direction.getStepX() * f);
            d1 += (double)((float)direction.getStepZ() * f);
        }
        Vec3 vec3 = new Vec3(d, 0.0, d1);
        if (fluidState.getValue(FALLING).booleanValue()) {
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                mutableBlockPos.setWithOffset((Vec3i)pos, direction1);
                if (!this.isSolidFace(level, mutableBlockPos, direction1) && !this.isSolidFace(level, (BlockPos)mutableBlockPos.above(), direction1)) continue;
                vec3 = vec3.normalize().add(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3.normalize();
    }

    private boolean affectsFlow(FluidState state) {
        return state.isEmpty() || state.getType().isSame(this);
    }

    protected boolean isSolidFace(BlockGetter level, BlockPos neighborPos, Direction side) {
        BlockState blockState = level.getBlockState(neighborPos);
        FluidState fluidState = level.getFluidState(neighborPos);
        return !fluidState.getType().isSame(this) && (side == Direction.UP || !(blockState.getBlock() instanceof IceBlock) && blockState.isFaceSturdy(level, neighborPos, side));
    }

    protected void spread(ServerLevel level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!fluidState.isEmpty()) {
            FluidState newLiquid;
            Fluid type;
            FluidState fluidState1;
            BlockState blockState;
            BlockPos blockPos = pos.below();
            if (this.canMaybePassThrough(level, pos, state, Direction.DOWN, blockPos, blockState = level.getBlockState(blockPos), fluidState1 = blockState.getFluidState()) && fluidState1.canBeReplacedWith(level, blockPos, type = (newLiquid = this.getNewLiquid(level, blockPos, blockState)).getType(), Direction.DOWN) && FlowingFluid.canHoldSpecificFluid(level, blockPos, blockState, type)) {
                CraftBlock source = CraftBlock.at(level, pos);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, BlockFace.DOWN);
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                this.spreadTo(level, blockPos, blockState, Direction.DOWN, newLiquid);
                if (this.sourceNeighborCount(level, pos) >= 3) {
                    this.spreadToSides(level, pos, fluidState, state);
                }
                return;
            }
            if (fluidState.isSource() || !this.isWaterHole(level, pos, state, blockPos, blockState)) {
                this.spreadToSides(level, pos, fluidState, state);
            }
        }
    }

    private void spreadToSides(ServerLevel level, BlockPos pos, FluidState fluidState, BlockState state) {
        int i = fluidState.getAmount() - this.getDropOff(level);
        if (fluidState.getValue(FALLING).booleanValue()) {
            i = 7;
        }
        if (i > 0) {
            Map<Direction, FluidState> spread = this.getSpread(level, pos, state);
            for (Map.Entry<Direction, FluidState> entry : spread.entrySet()) {
                Direction direction = entry.getKey();
                FluidState fluidState1 = entry.getValue();
                BlockPos blockPos = pos.relative(direction);
                BlockState blockStateIfLoaded = level.getBlockStateIfLoaded(blockPos);
                if (blockStateIfLoaded == null) continue;
                CraftBlock source = CraftBlock.at(level, pos);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, CraftBlock.notchToBlockFace(direction));
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                this.spreadTo(level, blockPos, blockStateIfLoaded, direction, fluidState1);
            }
        }
    }

    protected FluidState getNewLiquid(ServerLevel level, BlockPos pos, BlockState state) {
        BlockPos.MutableBlockPos blockPos1;
        BlockState blockState2;
        FluidState fluidState2;
        int i = 0;
        int i1 = 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            FluidState fluidState;
            BlockPos.MutableBlockPos blockPos = mutableBlockPos.setWithOffset((Vec3i)pos, direction);
            BlockState blockState = level.getBlockStateIfLoaded(blockPos);
            if (blockState == null || !(fluidState = blockState.getFluidState()).getType().isSame(this) || !FlowingFluid.canPassThroughWall(direction, level, pos, state, blockPos, blockState)) continue;
            if (fluidState.isSource()) {
                ++i1;
            }
            i = Math.max(i, fluidState.getAmount());
        }
        if (i1 >= 2 && this.canConvertToSource(level)) {
            BlockState blockState1 = level.getBlockState(mutableBlockPos.setWithOffset((Vec3i)pos, Direction.DOWN));
            FluidState fluidState1 = blockState1.getFluidState();
            if (blockState1.isSolid() || this.isSourceBlockOfThisType(fluidState1)) {
                return this.getSource(false);
            }
        }
        if (!(fluidState2 = (blockState2 = level.getBlockState(blockPos1 = mutableBlockPos.setWithOffset((Vec3i)pos, Direction.UP))).getFluidState()).isEmpty() && fluidState2.getType().isSame(this) && FlowingFluid.canPassThroughWall(Direction.UP, level, pos, state, blockPos1, blockState2)) {
            return this.getFlowing(8, true);
        }
        int i2 = i - this.getDropOff(level);
        return i2 <= 0 ? Fluids.EMPTY.defaultFluidState() : this.getFlowing(i2, false);
    }

    private static boolean canPassThroughWall(Direction direction, BlockGetter level, BlockPos fromPos, BlockState fromState, BlockPos toPos, BlockState toState) {
        VoxelShape shape2;
        boolean result;
        FluidOcclusionCacheKey cached;
        if (fromState.moonrise$emptyCollisionShape() & toState.moonrise$emptyCollisionShape()) {
            return true;
        }
        if (fromState.moonrise$occludesFullBlock() | toState.moonrise$occludesFullBlock()) {
            return false;
        }
        FluidOcclusionCacheKey[] cache = fromState.moonrise$hasCache() & toState.moonrise$hasCache() ? COLLISION_OCCLUSION_CACHE.get() : null;
        int keyIndex = (fromState.moonrise$uniqueId1() ^ toState.moonrise$uniqueId2() ^ ((CollisionDirection)direction).moonrise$uniqueId()) & 0x7FF;
        if (cache != null && (cached = cache[keyIndex]) != null && cached.first() == fromState && cached.second() == toState && cached.direction() == direction) {
            return cached.result();
        }
        VoxelShape shape1 = fromState.getCollisionShape(level, fromPos);
        boolean bl = result = !Shapes.mergedFaceOccludes(shape1, shape2 = toState.getCollisionShape(level, toPos), direction);
        if (cache != null) {
            cache[keyIndex] = new FluidOcclusionCacheKey(fromState, toState, direction, result);
        }
        return result;
    }

    public abstract Fluid getFlowing();

    public FluidState getFlowing(int level, boolean falling) {
        int amount = level;
        if (!this.init) {
            this.init();
        }
        int index = (falling ? 1 : 0) | amount - MIN_LEVEL << 1;
        return this.flowingLookUp[index];
    }

    public abstract Fluid getSource();

    public FluidState getSource(boolean falling) {
        if (!this.init) {
            this.init();
        }
        return falling ? this.sourceFalling : this.sourceNotFalling;
    }

    protected abstract boolean canConvertToSource(ServerLevel var1);

    protected void spreadTo(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, FluidState fluidState) {
        Block block = state.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer liquidBlockContainer = (LiquidBlockContainer)((Object)block);
            liquidBlockContainer.placeLiquid(level, pos, state, fluidState);
        } else {
            if (!state.isAir()) {
                this.beforeDestroyingBlock(level, pos, state, pos.relative(direction.getOpposite()));
            }
            level.setBlock(pos, fluidState.createLegacyBlock(), 3);
        }
    }

    protected void beforeDestroyingBlock(LevelAccessor level, BlockPos pos, BlockState state, BlockPos source) {
        this.beforeDestroyingBlock(level, pos, state);
    }

    protected abstract void beforeDestroyingBlock(LevelAccessor var1, BlockPos var2, BlockState var3);

    protected int getSlopeDistance(LevelReader level, BlockPos pos, int depth, Direction direction, BlockState state, SpreadContext spreadContext) {
        int i = 1000;
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            int slopeDistance;
            BlockPos blockPos;
            BlockState blockState;
            if (direction1 == direction || (blockState = spreadContext.getBlockStateIfLoaded(blockPos = pos.relative(direction1))) == null) continue;
            FluidState fluidState = blockState.getFluidState();
            if (!this.canPassThrough(level, this.getFlowing(), pos, state, direction1, blockPos, blockState, fluidState)) continue;
            if (spreadContext.isHole(blockPos)) {
                return depth;
            }
            if (depth >= this.getSlopeFindDistance(level) || (slopeDistance = this.getSlopeDistance(level, blockPos, depth + 1, direction1.getOpposite(), blockState, spreadContext)) >= i) continue;
            i = slopeDistance;
        }
        return i;
    }

    boolean isWaterHole(BlockGetter level, BlockPos pos, BlockState state, BlockPos belowPos, BlockState belowState) {
        return FlowingFluid.canPassThroughWall(Direction.DOWN, level, pos, state, belowPos, belowState) && (belowState.getFluidState().getType().isSame(this) || FlowingFluid.canHoldFluid(level, belowPos, belowState, this.getFlowing()));
    }

    private boolean canPassThrough(BlockGetter level, Fluid fluid, BlockPos pos, BlockState state, Direction direction, BlockPos spreadPos, BlockState spreadState, FluidState fluidState) {
        return this.canMaybePassThrough(level, pos, state, direction, spreadPos, spreadState, fluidState) && FlowingFluid.canHoldSpecificFluid(level, spreadPos, spreadState, fluid);
    }

    private boolean canMaybePassThrough(BlockGetter level, BlockPos pos, BlockState state, Direction direction, BlockPos spreadPos, BlockState spreadState, FluidState fluidState) {
        return !this.isSourceBlockOfThisType(fluidState) && FlowingFluid.canHoldAnyFluid(spreadState) && FlowingFluid.canPassThroughWall(direction, level, pos, state, spreadPos, spreadState);
    }

    private boolean isSourceBlockOfThisType(FluidState state) {
        return state.getType().isSame(this) && state.isSource();
    }

    protected abstract int getSlopeFindDistance(LevelReader var1);

    private int sourceNeighborCount(LevelReader level, BlockPos pos) {
        int i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = pos.relative(direction);
            FluidState fluidState = level.getFluidState(blockPos);
            if (!this.isSourceBlockOfThisType(fluidState)) continue;
            ++i;
        }
        return i;
    }

    protected Map<Direction, FluidState> getSpread(ServerLevel level, BlockPos pos, BlockState state) {
        int i = 1000;
        EnumMap map = Maps.newEnumMap(Direction.class);
        SpreadContext spreadContext = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int i1;
            FluidState newLiquid;
            FluidState fluidState;
            BlockPos blockPos = pos.relative(direction);
            BlockState blockState = level.getBlockStateIfLoaded(blockPos);
            if (blockState == null || !this.canMaybePassThrough(level, pos, state, direction, blockPos, blockState, fluidState = blockState.getFluidState()) || !FlowingFluid.canHoldSpecificFluid(level, blockPos, blockState, (newLiquid = this.getNewLiquid(level, blockPos, blockState)).getType())) continue;
            if (spreadContext == null) {
                spreadContext = new SpreadContext(level, pos);
            }
            if ((i1 = spreadContext.isHole(blockPos) ? 0 : this.getSlopeDistance(level, blockPos, 1, direction.getOpposite(), blockState, spreadContext)) < i) {
                map.clear();
            }
            if (i1 > i) continue;
            if (fluidState.canBeReplacedWith(level, blockPos, newLiquid.getType(), direction)) {
                map.put(direction, newLiquid);
            }
            i = i1;
        }
        return map;
    }

    private static boolean canHoldAnyFluid(BlockState state) {
        Block block = state.getBlock();
        return block instanceof LiquidBlockContainer || !state.blocksMotion() && !(block instanceof DoorBlock) && !state.is(BlockTags.SIGNS) && !state.is(Blocks.LADDER) && !state.is(Blocks.SUGAR_CANE) && !state.is(Blocks.BUBBLE_COLUMN) && !state.is(Blocks.NETHER_PORTAL) && !state.is(Blocks.END_PORTAL) && !state.is(Blocks.END_GATEWAY) && !state.is(Blocks.STRUCTURE_VOID);
    }

    private static boolean canHoldFluid(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return FlowingFluid.canHoldAnyFluid(state) && FlowingFluid.canHoldSpecificFluid(level, pos, state, fluid);
    }

    private static boolean canHoldSpecificFluid(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        LiquidBlockContainer liquidBlockContainer;
        Block block = state.getBlock();
        return !(block instanceof LiquidBlockContainer) || (liquidBlockContainer = (LiquidBlockContainer)((Object)block)).canPlaceLiquid(null, level, pos, state, fluid);
    }

    protected abstract int getDropOff(LevelReader var1);

    protected int getSpreadDelay(Level level, BlockPos pos, FluidState currentState, FluidState newState) {
        return this.getTickDelay(level);
    }

    @Override
    public void tick(ServerLevel level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!fluidState.isSource()) {
            FluidState newLiquid = this.getNewLiquid(level, pos, level.getBlockState(pos));
            int spreadDelay = this.getSpreadDelay(level, pos, fluidState, newLiquid);
            if (newLiquid.isEmpty()) {
                fluidState = newLiquid;
                state = Blocks.AIR.defaultBlockState();
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(level, pos, state);
                if (event.isCancelled()) {
                    return;
                }
                state = ((CraftBlockData)event.getNewData()).getState();
                level.setBlock(pos, state, 3);
            } else if (newLiquid != fluidState) {
                fluidState = newLiquid;
                state = newLiquid.createLegacyBlock();
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(level, pos, state);
                if (event.isCancelled()) {
                    return;
                }
                state = ((CraftBlockData)event.getNewData()).getState();
                level.setBlock(pos, state, 3);
                level.scheduleTick(pos, newLiquid.getType(), spreadDelay);
            }
        }
        this.spread(level, pos, state, fluidState);
    }

    protected static int getLegacyLevel(FluidState state) {
        return state.isSource() ? 0 : 8 - Math.min(state.getAmount(), 8) + (state.getValue(FALLING) != false ? 8 : 0);
    }

    private static boolean hasSameAbove(FluidState fluidState, BlockGetter level, BlockPos pos) {
        return fluidState.getType().isSame(level.getFluidState(pos.above()).getType());
    }

    @Override
    public float getHeight(FluidState state, BlockGetter level, BlockPos pos) {
        return FlowingFluid.hasSameAbove(state, level, pos) ? 1.0f : state.getOwnHeight();
    }

    @Override
    public float getOwnHeight(FluidState state) {
        return (float)state.getAmount() / 9.0f;
    }

    @Override
    public abstract int getAmount(FluidState var1);

    @Override
    public VoxelShape getShape(FluidState state, BlockGetter level, BlockPos pos) {
        return state.getAmount() == 9 && FlowingFluid.hasSameAbove(state, level, pos) ? Shapes.block() : this.shapes.computeIfAbsent(state, fluidState -> Shapes.box(0.0, 0.0, 0.0, 1.0, fluidState.getHeight(level, pos), 1.0));
    }

    protected class SpreadContext {
        private final BlockGetter level;
        private final BlockPos origin;
        private final Short2ObjectMap<BlockState> stateCache = new Short2ObjectOpenHashMap();
        private final Short2BooleanMap holeCache = new Short2BooleanOpenHashMap();

        SpreadContext(BlockGetter level, BlockPos origin) {
            this.level = level;
            this.origin = origin;
        }

        public BlockState getBlockState(BlockPos pos) {
            return this.getBlockState(pos, this.getCacheKey(pos));
        }

        @Nullable
        public BlockState getBlockStateIfLoaded(BlockPos pos) {
            return this.getBlockState(pos, this.getCacheKey(pos), false);
        }

        private BlockState getBlockState(BlockPos pos, short cacheKey) {
            return this.getBlockState(pos, cacheKey, true);
        }

        @Nullable
        private BlockState getBlockState(BlockPos pos, short packed, boolean load) {
            BlockState blockState = (BlockState)this.stateCache.get(packed);
            if (blockState == null) {
                BlockState blockState2 = blockState = load ? this.level.getBlockState(pos) : this.level.getBlockStateIfLoaded(pos);
                if (blockState != null) {
                    this.stateCache.put(packed, (Object)blockState);
                }
            }
            return blockState;
        }

        public boolean isHole(BlockPos pos) {
            return this.holeCache.computeIfAbsent(this.getCacheKey(pos), s -> {
                BlockState blockState = this.getBlockState(pos, s);
                BlockPos blockPos = pos.below();
                BlockState blockState1 = this.level.getBlockState(blockPos);
                return FlowingFluid.this.isWaterHole(this.level, pos, blockState, blockPos, blockState1);
            });
        }

        private short getCacheKey(BlockPos pos) {
            int i = pos.getX() - this.origin.getX();
            int i1 = pos.getZ() - this.origin.getZ();
            return (short)((i + 128 & 0xFF) << 8 | i1 + 128 & 0xFF);
        }
    }

    record BlockStatePairKey(BlockState first, BlockState second, Direction direction) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (!(object instanceof BlockStatePairKey)) return false;
            BlockStatePairKey blockStatePairKey = (BlockStatePairKey)object;
            if (this.first != blockStatePairKey.first) return false;
            if (this.second != blockStatePairKey.second) return false;
            if (this.direction != blockStatePairKey.direction) return false;
            return true;
        }

        @Override
        public int hashCode() {
            int i = System.identityHashCode(this.first);
            i = 31 * i + System.identityHashCode(this.second);
            return 31 * i + this.direction.hashCode();
        }
    }
}

