/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.slf4j.Logger;

public class DimensionDataStorage
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final SavedData.Context context;
    public final Map<SavedDataType<?>, Optional<SavedData>> cache = new HashMap();
    private final DataFixer fixerUpper;
    private final HolderLookup.Provider registries;
    private final Path dataFolder;
    private CompletableFuture<?> pendingWriteFuture = CompletableFuture.completedFuture(null);

    public DimensionDataStorage(SavedData.Context context, Path dataFolder, DataFixer fixerUpper, HolderLookup.Provider registries) {
        this.context = context;
        this.fixerUpper = fixerUpper;
        this.dataFolder = dataFolder;
        this.registries = registries;
    }

    private Path getDataFile(String filename) {
        return this.dataFolder.resolve(filename + ".dat");
    }

    public <T extends SavedData> T computeIfAbsent(SavedDataType<T> type) {
        T savedData = this.get(type);
        if (savedData != null) {
            return savedData;
        }
        SavedData savedData1 = (SavedData)type.constructor().apply(this.context);
        this.set(type, savedData1);
        return (T)savedData1;
    }

    @Nullable
    public <T extends SavedData> T get(SavedDataType<T> type) {
        Optional<SavedData> optional = this.cache.get(type);
        if (optional == null) {
            optional = Optional.ofNullable(this.readSavedData(type));
            this.cache.put(type, optional);
        }
        return (T)((SavedData)optional.orElse(null));
    }

    @Nullable
    private <T extends SavedData> T readSavedData(SavedDataType<T> type) {
        try {
            Path dataFile = this.getDataFile(type.id());
            if (Files.exists(dataFile, new LinkOption[0])) {
                CompoundTag tagFromDisk = this.readTagFromDisk(type.id(), type.dataFixType(), SharedConstants.getCurrentVersion().dataVersion().version());
                RegistryOps<Tag> registryOps = this.registries.createSerializationContext(NbtOps.INSTANCE);
                return (T)((SavedData)type.codec().apply(this.context).parse(registryOps, (Object)tagFromDisk.get("data")).resultOrPartial(string -> LOGGER.error("Failed to parse saved data for '{}': {}", (Object)type, string)).orElse(null));
            }
        }
        catch (Exception var5) {
            LOGGER.error("Error loading saved data: {}", type, (Object)var5);
        }
        return null;
    }

    public <T extends SavedData> void set(SavedDataType<T> type, T value) {
        this.cache.put(type, Optional.of(value));
        value.setDirty();
    }

    public CompoundTag readTagFromDisk(String filename, DataFixTypes dataFixType, int version) throws IOException {
        CompoundTag var8;
        try (InputStream inputStream = Files.newInputStream(this.getDataFile(filename), new OpenOption[0]);
             PushbackInputStream pushbackInputStream = new PushbackInputStream(new FastBufferedInputStream(inputStream), 2);){
            CompoundTag compressed;
            if (this.isGzip(pushbackInputStream)) {
                compressed = NbtIo.readCompressed(pushbackInputStream, NbtAccounter.unlimitedHeap());
            } else {
                try (DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);){
                    compressed = NbtIo.read(dataInputStream);
                }
            }
            int dataVersion = NbtUtils.getDataVersion(compressed, 1343);
            var8 = dataFixType.update(this.fixerUpper, compressed, dataVersion, version);
        }
        return var8;
    }

    private boolean isGzip(PushbackInputStream inputStream) throws IOException {
        int i1;
        byte[] bytes = new byte[2];
        boolean flag = false;
        int i = inputStream.read(bytes, 0, 2);
        if (i == 2 && (i1 = (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF) == 35615) {
            flag = true;
        }
        if (i != 0) {
            inputStream.unread(bytes, 0, i);
        }
        return flag;
    }

    public CompletableFuture<?> scheduleSave() {
        Map<SavedDataType<?>, CompoundTag> map = this.collectDirtyTagsToSave();
        if (map.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        int i = Util.maxAllowedExecutorThreads();
        int size = map.size();
        this.pendingWriteFuture = this.pendingWriteFuture.thenCompose(object -> CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> CompletableFuture.runAsync(() -> this.tryWrite((SavedDataType)entry.getKey(), (CompoundTag)entry.getValue()), Util.DIMENSION_DATA_IO_POOL)).toArray(CompletableFuture[]::new)));
        return this.pendingWriteFuture;
    }

    private Map<SavedDataType<?>, CompoundTag> collectDirtyTagsToSave() {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        RegistryOps<Tag> registryOps = this.registries.createSerializationContext(NbtOps.INSTANCE);
        this.cache.forEach((arg_0, arg_1) -> this.lambda$collectDirtyTagsToSave$9((Map)map, registryOps, arg_0, arg_1));
        return map;
    }

    private <T extends SavedData> CompoundTag encodeUnchecked(SavedDataType<T> type, SavedData data, RegistryOps<Tag> ops) {
        Codec<T> codec = type.codec().apply(this.context);
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("data", (Tag)codec.encodeStart(ops, (Object)data).getOrThrow());
        NbtUtils.addCurrentDataVersion(compoundTag);
        return compoundTag;
    }

    private void tryWrite(SavedDataType<?> type, CompoundTag tag) {
        Path dataFile = this.getDataFile(type.id());
        try {
            NbtIo.writeCompressed(tag, dataFile);
        }
        catch (IOException var5) {
            LOGGER.error("Could not save data to {}", (Object)dataFile.getFileName(), (Object)var5);
        }
    }

    public void saveAndJoin() {
        this.scheduleSave().join();
    }

    @Override
    public void close() {
        this.saveAndJoin();
    }

    private /* synthetic */ void lambda$collectDirtyTagsToSave$9(Map map, RegistryOps registryOps, SavedDataType savedDataType, Optional optional) {
        optional.filter(SavedData::isDirty).ifPresent(savedData -> {
            map.put(savedDataType, this.encodeUnchecked(savedDataType, (SavedData)savedData, registryOps));
            savedData.setDirty(false);
        });
    }

    private /* synthetic */ CompletionStage lambda$scheduleSave$3(int i, int size, Map map, Object object) {
        ArrayList<CompletableFuture<Void>> list = new ArrayList<CompletableFuture<Void>>(i);
        int i1 = Mth.positiveCeilDiv(size, i);
        for (List list1 : Iterables.partition(map.entrySet(), (int)i1)) {
            list.add(CompletableFuture.runAsync(() -> {
                for (Map.Entry entry : list1) {
                    this.tryWrite((SavedDataType)entry.getKey(), (CompoundTag)entry.getValue());
                }
            }, Util.ioPool()));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }
}

