/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;

@FunctionalInterface
interface ComposableEntryContainer {
    public static final ComposableEntryContainer ALWAYS_FALSE = (lootContext, entryConsumer) -> false;
    public static final ComposableEntryContainer ALWAYS_TRUE = (lootContext, entryConsumer) -> true;

    public boolean expand(LootContext var1, Consumer<LootPoolEntry> var2);

    default public ComposableEntryContainer and(ComposableEntryContainer entry) {
        Objects.requireNonNull(entry);
        return (lootContext, entryConsumer) -> this.expand(lootContext, entryConsumer) && entry.expand(lootContext, entryConsumer);
    }

    default public ComposableEntryContainer or(ComposableEntryContainer entry) {
        Objects.requireNonNull(entry);
        return (lootContext, entryConsumer) -> this.expand(lootContext, entryConsumer) || entry.expand(lootContext, entryConsumer);
    }
}

