/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;

public final class CraftEquipmentSlot {
    private static final BiMap<EquipmentSlot, org.bukkit.inventory.EquipmentSlot> BRIDGE = (BiMap)Util.make(EnumBiMap.create(EquipmentSlot.class, org.bukkit.inventory.EquipmentSlot.class), data -> {
        data.put((Object)EquipmentSlot.MAINHAND, (Object)org.bukkit.inventory.EquipmentSlot.HAND);
        data.put((Object)EquipmentSlot.OFFHAND, (Object)org.bukkit.inventory.EquipmentSlot.OFF_HAND);
        data.put((Object)EquipmentSlot.FEET, (Object)org.bukkit.inventory.EquipmentSlot.FEET);
        data.put((Object)EquipmentSlot.LEGS, (Object)org.bukkit.inventory.EquipmentSlot.LEGS);
        data.put((Object)EquipmentSlot.CHEST, (Object)org.bukkit.inventory.EquipmentSlot.CHEST);
        data.put((Object)EquipmentSlot.HEAD, (Object)org.bukkit.inventory.EquipmentSlot.HEAD);
        data.put((Object)EquipmentSlot.BODY, (Object)org.bukkit.inventory.EquipmentSlot.BODY);
        data.put((Object)EquipmentSlot.SADDLE, (Object)org.bukkit.inventory.EquipmentSlot.SADDLE);
    });

    private CraftEquipmentSlot() {
    }

    public static org.bukkit.inventory.EquipmentSlot getSlot(EquipmentSlot slot) {
        return (org.bukkit.inventory.EquipmentSlot)BRIDGE.get((Object)slot);
    }

    public static EquipmentSlotGroup getSlotGroup(net.minecraft.world.entity.EquipmentSlotGroup slotGroup) {
        return EquipmentSlotGroup.getByName((String)slotGroup.getSerializedName());
    }

    public static EquipmentSlot getNMS(org.bukkit.inventory.EquipmentSlot slot) {
        return (EquipmentSlot)BRIDGE.inverse().get((Object)slot);
    }

    public static net.minecraft.world.entity.EquipmentSlotGroup getNMSGroup(EquipmentSlotGroup slot) {
        return net.minecraft.world.entity.EquipmentSlotGroup.valueOf(slot.toString().toUpperCase(Locale.ROOT));
    }

    public static org.bukkit.inventory.EquipmentSlot getHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? org.bukkit.inventory.EquipmentSlot.HAND : org.bukkit.inventory.EquipmentSlot.OFF_HAND;
    }

    public static InteractionHand getHand(org.bukkit.inventory.EquipmentSlot hand) {
        if (hand == org.bukkit.inventory.EquipmentSlot.HAND) {
            return InteractionHand.MAIN_HAND;
        }
        if (hand == org.bukkit.inventory.EquipmentSlot.OFF_HAND) {
            return InteractionHand.OFF_HAND;
        }
        throw new IllegalArgumentException("EquipmentSlot." + String.valueOf(hand) + " is not a hand");
    }
}

