/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import org.bukkit.Location;
import org.bukkit.Raid;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.boss.CraftBossBar;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Raider;
import org.bukkit.persistence.PersistentDataContainer;

public final class CraftRaid
implements Raid {
    private final net.minecraft.world.entity.raid.Raid handle;
    private final Level level;

    public CraftRaid(net.minecraft.world.entity.raid.Raid handle, Level level) {
        this.handle = handle;
        this.level = level;
    }

    public boolean isStarted() {
        return this.handle.isStarted();
    }

    public long getActiveTicks() {
        return this.handle.ticksActive;
    }

    public int getBadOmenLevel() {
        return this.handle.raidOmenLevel;
    }

    public void setBadOmenLevel(int badOmenLevel) {
        int max = this.handle.getMaxRaidOmenLevel();
        Preconditions.checkArgument((0 <= badOmenLevel && badOmenLevel <= max ? 1 : 0) != 0, (String)"Bad Omen level must be between 0 and %s", (int)max);
        this.handle.raidOmenLevel = badOmenLevel;
    }

    public Location getLocation() {
        BlockPos pos = this.handle.getCenter();
        return CraftLocation.toBukkit((Vec3i)pos, this.level);
    }

    public Raid.RaidStatus getStatus() {
        if (this.handle.isStopped()) {
            return Raid.RaidStatus.STOPPED;
        }
        if (this.handle.isVictory()) {
            return Raid.RaidStatus.VICTORY;
        }
        if (this.handle.isLoss()) {
            return Raid.RaidStatus.LOSS;
        }
        return Raid.RaidStatus.ONGOING;
    }

    public int getSpawnedGroups() {
        return this.handle.getGroupsSpawned();
    }

    public int getTotalGroups() {
        return this.handle.numGroups + (this.handle.raidOmenLevel > 1 ? 1 : 0);
    }

    public int getTotalWaves() {
        return this.handle.numGroups;
    }

    public float getTotalHealth() {
        return this.handle.getHealthOfLivingRaiders();
    }

    public Set<UUID> getHeroes() {
        return Collections.unmodifiableSet(this.handle.heroesOfTheVillage);
    }

    public List<Raider> getRaiders() {
        return (List)this.handle.getRaiders().stream().map(new Function<net.minecraft.world.entity.raid.Raider, Raider>(this){

            @Override
            public Raider apply(net.minecraft.world.entity.raid.Raider entityRaider) {
                return (Raider)entityRaider.getBukkitEntity();
            }
        }).collect(ImmutableList.toImmutableList());
    }

    public net.minecraft.world.entity.raid.Raid getHandle() {
        return this.handle;
    }

    public int getId() {
        return this.handle.idOrNegativeOne;
    }

    public BossBar getBossBar() {
        return new CraftBossBar(this.handle.raidEvent);
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.handle.persistentDataContainer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraftRaid craftRaid = (CraftRaid)o;
        return this.handle.equals(craftRaid.handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }
}

