/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import io.papermc.paper.registry.HolderableBase;
import io.papermc.paper.world.flag.PaperFeatureDependent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemType;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CraftBlockType<B extends @NonNull BlockData>
extends HolderableBase<Block>
implements BlockType.Typed<B>,
PaperFeatureDependent<Block> {
    private static final Class<?>[] USE_WITHOUT_ITEM_ARGS = new Class[]{BlockState.class, Level.class, BlockPos.class, Player.class, BlockHitResult.class};
    private static final Class<?>[] USE_ITEM_ON_ARGS = new Class[]{ItemStack.class, BlockState.class, Level.class, BlockPos.class, Player.class, InteractionHand.class, BlockHitResult.class};
    private final Supplier<Class<B>> blockDataClass = Suppliers.memoize(() -> CraftBlockData.fromData(((Block)this.getHandle()).defaultBlockState()).getClass().getInterfaces()[0]);
    private final Supplier<Boolean> interactable = Suppliers.memoize(() -> CraftBlockType.isInteractable((Block)this.getHandle()));

    public static Material minecraftToBukkit(Block block) {
        return CraftMagicNumbers.getMaterial(block);
    }

    public static Block bukkitToMinecraft(Material material) {
        return CraftMagicNumbers.getBlock(material);
    }

    public static BlockType minecraftToBukkitNew(Block minecraft) {
        return (BlockType)CraftRegistry.minecraftToBukkit(minecraft, Registries.BLOCK);
    }

    public static Block bukkitToMinecraftNew(BlockType bukkit) {
        return (Block)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    private static boolean hasMethod(Class<?> clazz, Class<?> ... params) {
        boolean hasMethod = false;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Arrays.equals(method.getParameterTypes(), params)) continue;
            Preconditions.checkArgument((!hasMethod ? 1 : 0) != 0, (String)"More than one matching method for %s, args %s", clazz, (Object)Arrays.toString(params));
            hasMethod = true;
        }
        return hasMethod;
    }

    private static boolean isInteractable(Block block) {
        boolean hasMethod;
        Class<?> clazz = block.getClass();
        boolean bl = hasMethod = CraftBlockType.hasMethod(clazz, USE_WITHOUT_ITEM_ARGS) || CraftBlockType.hasMethod(clazz, USE_ITEM_ON_ARGS);
        if (!hasMethod && clazz.getSuperclass() != BlockBehaviour.class) {
            hasMethod = CraftBlockType.hasMethod(clazz = clazz.getSuperclass(), USE_WITHOUT_ITEM_ARGS) || CraftBlockType.hasMethod(clazz, USE_ITEM_ON_ARGS);
        }
        return hasMethod;
    }

    public CraftBlockType(Holder<Block> holder) {
        super(holder);
    }

    public BlockType.Typed<BlockData> typed() {
        return this.typed(BlockData.class);
    }

    public <Other extends BlockData> BlockType.Typed<Other> typed(Class<Other> blockDataType) {
        if (blockDataType.isAssignableFrom(this.blockDataClass.get())) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type block type " + String.valueOf(this) + " to blockdata type " + blockDataType.getSimpleName());
    }

    public boolean hasItemType() {
        if (this == AIR) {
            return true;
        }
        return ((Block)this.getHandle()).asItem() != Items.AIR;
    }

    public ItemType getItemType() {
        if (this == AIR) {
            return ItemType.AIR;
        }
        Item item = ((Block)this.getHandle()).asItem();
        Preconditions.checkArgument((item != Items.AIR ? 1 : 0) != 0, (String)"The block type %s has no corresponding item type", (Object)this.getKey());
        return CraftItemType.minecraftToBukkitNew(item);
    }

    public Class<B> getBlockDataClass() {
        return this.blockDataClass.get();
    }

    public B createBlockData() {
        return this.createBlockData((String)null);
    }

    public Collection<B> createBlockDataStates() {
        ImmutableList<BlockState> possibleStates = ((Block)this.getHandle()).getStateDefinition().getPossibleStates();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)possibleStates.size());
        for (BlockState possibleState : possibleStates) {
            builder.add((Object)((BlockData)this.blockDataClass.get().cast(possibleState.createCraftBlockData())));
        }
        return builder.build();
    }

    public B createBlockData(@Nullable Consumer<? super B> consumer) {
        B data = this.createBlockData();
        if (consumer != null) {
            consumer.accept(data);
        }
        return data;
    }

    public B createBlockData(@Nullable String data) {
        return (B)CraftBlockData.newData((BlockType)this, data);
    }

    public boolean isSolid() {
        return ((Block)this.getHandle()).defaultBlockState().blocksMotion();
    }

    public boolean isAir() {
        return ((Block)this.getHandle()).defaultBlockState().isAir();
    }

    public boolean isEnabledByFeature(World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null");
        return ((Block)this.getHandle()).isEnabled(((CraftWorld)world).getHandle().enabledFeatures());
    }

    public boolean isFlammable() {
        return ((Block)this.getHandle()).defaultBlockState().ignitedByLava();
    }

    public boolean isBurnable() {
        return ((FireBlock)Blocks.FIRE).igniteOdds.getOrDefault(this.getHandle(), 0) > 0;
    }

    public boolean isOccluding() {
        return ((Block)this.getHandle()).defaultBlockState().isRedstoneConductor(EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
    }

    public boolean hasGravity() {
        return this.getHandle() instanceof Fallable;
    }

    public boolean isInteractable() {
        return this.interactable.get();
    }

    public float getHardness() {
        return ((Block)this.getHandle()).defaultBlockState().destroySpeed;
    }

    public float getBlastResistance() {
        return ((Block)this.getHandle()).getExplosionResistance();
    }

    public float getSlipperiness() {
        return ((Block)this.getHandle()).getFriction();
    }

    public String getTranslationKey() {
        return ((Block)this.getHandle()).getDescriptionId();
    }

    public @Nullable Material asMaterial() {
        return (Material)Registry.MATERIAL.get(this.getKey());
    }

    public String translationKey() {
        return ((Block)this.getHandle()).getDescriptionId();
    }

    public boolean hasCollision() {
        return ((Block)this.getHandle()).hasCollision;
    }
}

