/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftLootTable;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.spawner.PaperSharedSpawnerLogic;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;

public class CraftCreatureSpawner
extends CraftBlockEntityState<SpawnerBlockEntity>
implements CreatureSpawner,
PaperSharedSpawnerLogic {
    public CraftCreatureSpawner(World world, SpawnerBlockEntity blockEntity) {
        super(world, blockEntity);
    }

    protected CraftCreatureSpawner(CraftCreatureSpawner state, Location location) {
        super(state, location);
    }

    public EntityType getSpawnedType() {
        SpawnData spawnData = ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().nextSpawnData;
        if (spawnData == null) {
            return null;
        }
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(() -> "spawner@" + String.valueOf(this.getLocation()), LOGGER);){
            ValueInput valueInput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)this.getRegistryAccess(), spawnData.entityToSpawn());
            Optional<net.minecraft.world.entity.EntityType<?>> type = net.minecraft.world.entity.EntityType.by(valueInput);
            EntityType entityType = type.map(CraftEntityType::minecraftToBukkit).orElse(null);
            return entityType;
        }
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnPotentials = WeightedList.of();
            ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().nextSpawnData = new SpawnData();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        RandomSource rand = this.isPlaced() ? this.getWorldHandle().getRandom() : RandomSource.create();
        ((SpawnerBlockEntity)this.getSnapshot()).setEntityId(CraftEntityType.bukkitToMinecraft(entityType), rand);
    }

    public EntitySnapshot getSpawnedEntity() {
        SpawnData spawnData = ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().nextSpawnData;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.getEntityToSpawn());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CraftCreatureSpawner.setSpawnedEntity(((SpawnerBlockEntity)this.getSnapshot()).getSpawner(), snapshot, null, null);
    }

    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.setSpawnedEntity(((SpawnerBlockEntity)this.getSnapshot()).getSpawner(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public static void setSpawnedEntity(BaseSpawner spawner, EntitySnapshot snapshot, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        spawner.spawnPotentials = WeightedList.of();
        if (snapshot == null) {
            spawner.nextSpawnData = new SpawnData();
            return;
        }
        CompoundTag compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        spawner.nextSpawnData = new SpawnData(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment));
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CraftCreatureSpawner.addPotentialSpawn(((SpawnerBlockEntity)this.getSnapshot()).getSpawner(), snapshot, weight, spawnRule, null);
    }

    public static void addPotentialSpawn(BaseSpawner spawner, EntitySnapshot snapshot, int weight, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"Snapshot cannot be null");
        CompoundTag compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        WeightedList.Builder<SpawnData> builder = WeightedList.builder();
        spawner.spawnPotentials.unwrap().forEach(entry -> builder.add((SpawnData)entry.value(), entry.weight()));
        builder.add(new SpawnData(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment)), weight);
        spawner.spawnPotentials = builder.build();
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        CraftCreatureSpawner.setPotentialSpawns(((SpawnerBlockEntity)this.getSnapshot()).getSpawner(), entries);
    }

    public static void setPotentialSpawns(BaseSpawner spawner, Collection<SpawnerEntry> entries) {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entries cannot be null");
        WeightedList.Builder<SpawnData> builder = WeightedList.builder();
        for (SpawnerEntry spawnerEntry : entries) {
            CompoundTag compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.add(new SpawnData(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnerEntry.getSpawnRule())), CraftCreatureSpawner.getEquipment(spawnerEntry.getEquipment())), spawnerEntry.getSpawnWeight());
        }
        spawner.spawnPotentials = builder.build();
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        return CraftCreatureSpawner.getPotentialSpawns(((SpawnerBlockEntity)this.getSnapshot()).getSpawner());
    }

    public static List<SpawnerEntry> getPotentialSpawns(BaseSpawner spawner) {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (Weighted<SpawnData> entry : spawner.spawnPotentials.unwrap()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(entry.value().getEntityToSpawn());
            if (snapshot == null) continue;
            SpawnRule rule = entry.value().customSpawnRules().map(CraftCreatureSpawner::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry((EntitySnapshot)snapshot, entry.weight(), rule, CraftCreatureSpawner.getEquipment(entry.value().equipment())));
        }
        return entries;
    }

    public static SpawnData.CustomSpawnRules toMinecraftRule(SpawnRule rule) {
        if (rule == null) {
            return null;
        }
        return new SpawnData.CustomSpawnRules(new InclusiveRange<Integer>(rule.getMinBlockLight(), rule.getMaxBlockLight()), new InclusiveRange<Integer>(rule.getMinSkyLight(), rule.getMaxSkyLight()));
    }

    public static SpawnRule fromMinecraftRule(SpawnData.CustomSpawnRules rule) {
        InclusiveRange<Integer> blockLight = rule.blockLightLimit();
        InclusiveRange<Integer> skyLight = rule.skyLightLimit();
        return new SpawnRule(blockLight.maxInclusive().intValue(), blockLight.maxInclusive().intValue(), skyLight.minInclusive().intValue(), skyLight.maxInclusive().intValue());
    }

    public String getCreatureTypeName() {
        SpawnData spawnData = ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().nextSpawnData;
        if (spawnData == null) {
            return null;
        }
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(() -> "spawner@" + String.valueOf(this.getLocation()), LOGGER);){
            ValueInput valueInput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)this.getRegistryAccess(), spawnData.getEntityToSpawn());
            Optional<net.minecraft.world.entity.EntityType<?>> type = net.minecraft.world.entity.EntityType.by(valueInput);
            String string = type.map(CraftEntityType::minecraftToBukkit).map(CraftEntityType::bukkitToString).orElse(null);
            return string;
        }
    }

    public void setCreatureTypeByName(String creatureType) {
        EntityType type = CraftEntityType.stringToBukkit(creatureType);
        if (type == null) {
            this.setSpawnedType(null);
            return;
        }
        this.setSpawnedType(type);
    }

    public int getDelay() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnDelay;
    }

    public void setDelay(int delay) {
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnDelay = delay;
    }

    public int getMinSpawnDelay() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().minSpawnDelay;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().minSpawnDelay = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().maxSpawnDelay;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().maxSpawnDelay = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().maxNearbyEntities;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().maxNearbyEntities = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnCount;
    }

    public void setSpawnCount(int count) {
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnCount = count;
    }

    public int getRequiredPlayerRange() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().requiredPlayerRange;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().requiredPlayerRange = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnRange;
    }

    public void setSpawnRange(int spawnRange) {
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnRange = spawnRange;
    }

    @Override
    public CraftCreatureSpawner copy() {
        return new CraftCreatureSpawner(this, null);
    }

    @Override
    public CraftCreatureSpawner copy(Location location) {
        return new CraftCreatureSpawner(this, location);
    }

    public static Optional<EquipmentTable> getEquipment(SpawnerEntry.Equipment bukkit) {
        if (bukkit == null) {
            return Optional.empty();
        }
        return Optional.of(new EquipmentTable(CraftLootTable.bukkitToMinecraft(bukkit.getEquipmentLootTable()), bukkit.getDropChances().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getNMS((org.bukkit.inventory.EquipmentSlot)entry.getKey()), Map.Entry::getValue))));
    }

    public static SpawnerEntry.Equipment getEquipment(Optional<EquipmentTable> optional) {
        return optional.map(nms -> new SpawnerEntry.Equipment(CraftLootTable.minecraftToBukkit(nms.lootTable()), new HashMap<org.bukkit.inventory.EquipmentSlot, Float>(nms.slotDropChances().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getSlot((EquipmentSlot)entry.getKey()), Map.Entry::getValue))))).orElse(null);
    }

    @Override
    public boolean isActivated() {
        this.requirePlaced();
        return PaperSharedSpawnerLogic.super.isActivated();
    }

    @Override
    public void resetTimer() {
        this.requirePlaced();
        PaperSharedSpawnerLogic.super.resetTimer();
    }

    @Override
    public void setNextSpawnData(SpawnData spawnData) {
        this.getSpawner().setNextSpawnData(this.isPlaced() ? this.getInternalWorld() : null, this.getInternalPosition(), spawnData);
    }

    @Override
    public BaseSpawner getSpawner() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner();
    }

    @Override
    public BlockPos getInternalPosition() {
        return this.getPosition();
    }

    @Override
    public Level getInternalWorld() {
        return this.world.getHandle();
    }
}

