/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Comparator;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftComparator
extends CraftBlockData
implements Comparator {
    private static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final EnumProperty<ComparatorMode> MODE = ComparatorBlock.MODE;
    private static final BooleanProperty POWERED = DiodeBlock.POWERED;

    public CraftComparator(BlockState state) {
        super(state);
    }

    public BlockFace getFacing() {
        return this.get(FACING, BlockFace.class);
    }

    public void setFacing(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace.isCartesian() && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only cartesian horizontal face are allowed for this property!");
        this.set(FACING, blockFace);
    }

    public Set<BlockFace> getFaces() {
        return this.getValues(FACING, BlockFace.class);
    }

    public Comparator.Mode getMode() {
        return this.get(MODE, Comparator.Mode.class);
    }

    public void setMode(Comparator.Mode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"mode cannot be null!");
        this.set(MODE, mode);
    }

    public boolean isPowered() {
        return this.get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.set(POWERED, powered);
    }
}

