/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.command;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.tree.CommandNode;
import io.papermc.paper.commands.FeedbackForwardingSender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.command.CraftRemoteConsoleCommandSender;
import org.bukkit.craftbukkit.command.ProxiedNativeCommandSender;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftMinecartCommand;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.minecart.CommandMinecart;

public class VanillaCommandWrapper
extends BukkitCommand {
    public final CommandNode<CommandSourceStack> vanillaCommand;
    public final String helpCommandNamespace;

    public VanillaCommandWrapper(String name, String description, String usageMessage, List<String> aliases, CommandNode<CommandSourceStack> vanillaCommand, String helpCommandNamespace) {
        super(name, description, usageMessage, aliases);
        this.vanillaCommand = vanillaCommand;
        this.helpCommandNamespace = helpCommandNamespace;
    }

    Commands commands() {
        return MinecraftServer.getServer().getCommands();
    }

    public VanillaCommandWrapper(CommandNode<CommandSourceStack> vanillaCommand) {
        super(vanillaCommand.getName(), "A Mojang provided command.", vanillaCommand.getUsageText(), Collections.emptyList());
        this.vanillaCommand = vanillaCommand;
        this.setPermission(VanillaCommandWrapper.getPermission(vanillaCommand));
        this.helpCommandNamespace = "Minecraft";
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        CommandSourceStack source = VanillaCommandWrapper.getListener(sender);
        this.commands().performPrefixedCommand(source, this.toDispatcher(args, this.getName()));
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"Sender cannot be null");
        Preconditions.checkArgument((args != null ? 1 : 0) != 0, (Object)"Arguments cannot be null");
        Preconditions.checkArgument((alias != null ? 1 : 0) != 0, (Object)"Alias cannot be null");
        CommandSourceStack source = VanillaCommandWrapper.getListener(sender);
        ParseResults<CommandSourceStack> parsed = this.commands().getDispatcher().parse(this.toDispatcher(args, this.getName()), source);
        ArrayList<String> results = new ArrayList<String>();
        this.commands().getDispatcher().getCompletionSuggestions(parsed).thenAccept(suggestions -> suggestions.getList().forEach(s -> results.add(s.getText())));
        return results;
    }

    public static CommandSourceStack getListener(CommandSender sender) {
        if (sender instanceof CraftEntity) {
            CraftEntity entity = (CraftEntity)sender;
            if (sender instanceof CommandMinecart) {
                return ((CraftMinecartCommand)sender).getHandle().getCommandBlock().createCommandSourceStack(((CraftMinecartCommand)sender).getHandle().getCommandBlock().createSource());
            }
            if (sender instanceof CraftPlayer) {
                CraftPlayer player = (CraftPlayer)sender;
                return player.getHandle().createCommandSourceStack();
            }
            return entity.getHandle().createCommandSourceStackForNameResolution((ServerLevel)entity.getHandle().level());
        }
        if (sender instanceof BlockCommandSender) {
            return ((CraftBlockCommandSender)sender).getWrapper();
        }
        if (sender instanceof RemoteConsoleCommandSender) {
            return ((CraftRemoteConsoleCommandSender)sender).getListener().createCommandSourceStack();
        }
        if (sender instanceof ConsoleCommandSender) {
            return ((CraftServer)sender.getServer()).getServer().createCommandSourceStack();
        }
        if (sender instanceof ProxiedCommandSender) {
            return ((ProxiedNativeCommandSender)sender).getHandle();
        }
        if (sender instanceof FeedbackForwardingSender) {
            FeedbackForwardingSender feedback = (FeedbackForwardingSender)sender;
            return feedback.asVanilla();
        }
        throw new IllegalArgumentException("Cannot make " + String.valueOf(sender) + " a vanilla command listener");
    }

    public static String getPermission(CommandNode<CommandSourceStack> vanillaCommand) {
        while (vanillaCommand.getRedirect() != null) {
            vanillaCommand = vanillaCommand.getRedirect();
        }
        String commandName = vanillaCommand.getName();
        return "minecraft.command." + VanillaCommandWrapper.stripDefaultNamespace(commandName);
    }

    private static String stripDefaultNamespace(String maybeNamespaced) {
        String prefix = "minecraft:";
        if (maybeNamespaced.startsWith("minecraft:")) {
            return maybeNamespaced.substring("minecraft:".length());
        }
        return maybeNamespaced;
    }

    private String toDispatcher(String[] args, String name) {
        return name + (String)(args.length > 0 ? " " + Joiner.on((char)' ').join((Object[])args) : "");
    }

    public boolean canBeOverriden() {
        return true;
    }

    public boolean isRegistered() {
        return true;
    }
}

