/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.damage;

import io.papermc.paper.registry.HolderableBase;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.damage.CraftDamageEffect;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DeathMessageType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CraftDamageType
extends HolderableBase<DamageType>
implements org.bukkit.damage.DamageType {
    public CraftDamageType(Holder<DamageType> holder) {
        super(holder);
    }

    public String getTranslationKey() {
        return ((DamageType)this.getHandle()).msgId();
    }

    public org.bukkit.damage.DamageScaling getDamageScaling() {
        return CraftDamageType.damageScalingToBukkit(((DamageType)this.getHandle()).scaling());
    }

    public DamageEffect getDamageEffect() {
        return CraftDamageEffect.toBukkit(((DamageType)this.getHandle()).effects());
    }

    public DeathMessageType getDeathMessageType() {
        return CraftDamageType.deathMessageTypeToBukkit(((DamageType)this.getHandle()).deathMessageType());
    }

    public float getExhaustion() {
        return ((DamageType)this.getHandle()).exhaustion();
    }

    public static DeathMessageType deathMessageTypeToBukkit(net.minecraft.world.damagesource.DeathMessageType deathMessageType) {
        return switch (deathMessageType) {
            default -> throw new MatchException(null, null);
            case net.minecraft.world.damagesource.DeathMessageType.DEFAULT -> DeathMessageType.DEFAULT;
            case net.minecraft.world.damagesource.DeathMessageType.FALL_VARIANTS -> DeathMessageType.FALL_VARIANTS;
            case net.minecraft.world.damagesource.DeathMessageType.INTENTIONAL_GAME_DESIGN -> DeathMessageType.INTENTIONAL_GAME_DESIGN;
        };
    }

    public static net.minecraft.world.damagesource.DeathMessageType deathMessageTypeToNMS(DeathMessageType deathMessageType) {
        return switch (deathMessageType) {
            default -> throw new MatchException(null, null);
            case DeathMessageType.DEFAULT -> net.minecraft.world.damagesource.DeathMessageType.DEFAULT;
            case DeathMessageType.FALL_VARIANTS -> net.minecraft.world.damagesource.DeathMessageType.FALL_VARIANTS;
            case DeathMessageType.INTENTIONAL_GAME_DESIGN -> net.minecraft.world.damagesource.DeathMessageType.INTENTIONAL_GAME_DESIGN;
        };
    }

    public static org.bukkit.damage.DamageScaling damageScalingToBukkit(DamageScaling damageScaling) {
        return switch (damageScaling) {
            default -> throw new MatchException(null, null);
            case DamageScaling.ALWAYS -> org.bukkit.damage.DamageScaling.ALWAYS;
            case DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> org.bukkit.damage.DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
            case DamageScaling.NEVER -> org.bukkit.damage.DamageScaling.NEVER;
        };
    }

    public static DamageScaling damageScalingToNMS(org.bukkit.damage.DamageScaling damageScaling) {
        return switch (damageScaling) {
            default -> throw new MatchException(null, null);
            case org.bukkit.damage.DamageScaling.ALWAYS -> DamageScaling.ALWAYS;
            case org.bukkit.damage.DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
            case org.bukkit.damage.DamageScaling.NEVER -> DamageScaling.NEVER;
        };
    }

    public static org.bukkit.damage.DamageType minecraftHolderToBukkit(Holder<DamageType> minecraftHolder) {
        return (org.bukkit.damage.DamageType)CraftRegistry.minecraftHolderToBukkit(minecraftHolder, Registries.DAMAGE_TYPE);
    }

    public static Holder<DamageType> bukkitToMinecraftHolder(org.bukkit.damage.DamageType bukkitDamageType) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkitDamageType);
    }

    public static DamageType bukkitToMinecraft(org.bukkit.damage.DamageType bukkitDamageType) {
        return (DamageType)CraftRegistry.bukkitToMinecraft(bukkitDamageType);
    }

    public static org.bukkit.damage.DamageType minecraftToBukkit(DamageType minecraftDamageType) {
        return (org.bukkit.damage.DamageType)CraftRegistry.minecraftToBukkit(minecraftDamageType, Registries.DAMAGE_TYPE);
    }
}

