/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.util.OldEnumHolderable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftAnimals;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Frog;

public class CraftFrog
extends CraftAnimals
implements org.bukkit.entity.Frog {
    public CraftFrog(CraftServer server, Frog entity) {
        super(server, entity);
    }

    @Override
    public Frog getHandle() {
        return (Frog)this.entity;
    }

    public Entity getTongueTarget() {
        return this.getHandle().getTongueTarget().map(net.minecraft.world.entity.Entity::getBukkitEntity).orElse(null);
    }

    public void setTongueTarget(Entity target) {
        if (target == null) {
            this.getHandle().eraseTongueTarget();
        } else {
            this.getHandle().setTongueTarget(((CraftEntity)target).getHandle());
        }
    }

    public Frog.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().getVariant());
    }

    public void setVariant(Frog.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant cannot be null");
        this.getHandle().setVariant(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant
    extends OldEnumHolderable<Frog.Variant, FrogVariant>
    implements Frog.Variant {
        private static int count = 0;

        public static Frog.Variant minecraftToBukkit(FrogVariant minecraft) {
            return (Frog.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.FROG_VARIANT);
        }

        public static Frog.Variant minecraftHolderToBukkit(Holder<FrogVariant> minecraft) {
            return (Frog.Variant)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.FROG_VARIANT);
        }

        public static FrogVariant bukkitToMinecraft(Frog.Variant bukkit) {
            return (FrogVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<FrogVariant> bukkitToMinecraftHolder(Frog.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftVariant(Holder<FrogVariant> holder) {
            super(holder, count++);
        }
    }
}

