/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.kyori.adventure.util.TriState;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftVehicle;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.entity.Minecart;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public abstract class CraftMinecart
extends CraftVehicle
implements Minecart {
    public CraftMinecart(CraftServer server, AbstractMinecart entity) {
        super(server, entity);
    }

    @Override
    public AbstractMinecart getHandle() {
        return (AbstractMinecart)this.entity;
    }

    public void setDamage(double damage) {
        this.getHandle().setDamage((float)damage);
    }

    public double getDamage() {
        return this.getHandle().getDamage();
    }

    public double getMaxSpeed() {
        return this.getHandle().getBehavior().getMaxSpeed((ServerLevel)this.getHandle().level());
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public boolean isSlowWhenEmpty() {
        return this.getHandle().slowWhenEmpty;
    }

    public void setSlowWhenEmpty(boolean slow) {
        this.getHandle().slowWhenEmpty = slow;
    }

    public Vector getFlyingVelocityMod() {
        return this.getHandle().getFlyingVelocityMod();
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.getHandle().setFlyingVelocityMod(flying);
    }

    public Vector getDerailedVelocityMod() {
        return this.getHandle().getDerailedVelocityMod();
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.getHandle().setDerailedVelocityMod(derailed);
    }

    public Material getMinecartMaterial() {
        return CraftMagicNumbers.getMaterial(this.getHandle().getDropItem());
    }

    public void setDisplayBlock(MaterialData material) {
        this.getHandle().setCustomDisplayBlockState(Optional.ofNullable(material).map(CraftMagicNumbers::getBlock));
    }

    public void setDisplayBlockData(BlockData blockData) {
        this.getHandle().setCustomDisplayBlockState(Optional.ofNullable(blockData).map(data -> ((CraftBlockData)data).getState()));
    }

    public MaterialData getDisplayBlock() {
        BlockState state = this.getHandle().getDisplayBlockState();
        return CraftMagicNumbers.getMaterial(state);
    }

    public BlockData getDisplayBlockData() {
        BlockState state = this.getHandle().getDisplayBlockState();
        return CraftBlockData.fromData(state);
    }

    public void setDisplayBlockOffset(int offset) {
        this.getHandle().setDisplayOffset(offset);
    }

    public int getDisplayBlockOffset() {
        return this.getHandle().getDisplayOffset();
    }

    @NotNull
    public TriState getFrictionState() {
        return this.getHandle().frictionState;
    }

    public void setFrictionState(@NotNull TriState state) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state may not be null");
        this.getHandle().frictionState = state;
    }
}

