/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import org.bukkit.Material;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftThrownPotion;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.SplashPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.PotionMeta;

public class CraftThrownSplashPotion
extends CraftThrownPotion
implements SplashPotion {
    public CraftThrownSplashPotion(CraftServer server, ThrownSplashPotion entity) {
        super(server, entity);
    }

    @Override
    public ThrownSplashPotion getHandle() {
        return (ThrownSplashPotion)this.entity;
    }

    @Override
    public void setItem(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        PotionMeta meta = item.getType() == Material.SPLASH_POTION ? null : this.getPotionMeta();
        this.getHandle().setItem(CraftItemStack.asNMSCopy(item));
        if (meta != null) {
            this.setPotionMeta(meta);
        }
    }

    public PotionMeta getPotionMeta() {
        return (PotionMeta)CraftItemStack.getItemMeta(this.getHandle().getItem(), (ItemType)ItemType.SPLASH_POTION);
    }
}

