/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.HolderableBase;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftTameableAnimal;
import org.bukkit.entity.Wolf;

public class CraftWolf
extends CraftTameableAnimal
implements Wolf {
    public CraftWolf(CraftServer server, net.minecraft.world.entity.animal.wolf.Wolf wolf) {
        super(server, wolf);
    }

    @Override
    public net.minecraft.world.entity.animal.wolf.Wolf getHandle() {
        return (net.minecraft.world.entity.animal.wolf.Wolf)this.entity;
    }

    public boolean isAngry() {
        return this.getHandle().isAngry();
    }

    public void setAngry(boolean angry) {
        if (angry) {
            this.getHandle().startPersistentAngerTimer();
        } else {
            this.getHandle().stopBeingAngry();
        }
    }

    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)((byte)this.getHandle().getCollarColor().getId()));
    }

    public void setCollarColor(DyeColor color) {
        this.getHandle().setCollarColor(net.minecraft.world.item.DyeColor.byId(color.getWoolData()));
    }

    public boolean isWet() {
        return this.getHandle().isWet;
    }

    public float getTailAngle() {
        return this.getHandle().getTailAngle();
    }

    public boolean isInterested() {
        return this.getHandle().isInterested();
    }

    public void setInterested(boolean interested) {
        this.getHandle().setIsInterested(interested);
    }

    public Wolf.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().getVariant());
    }

    public void setVariant(Wolf.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant cannot be null");
        this.getHandle().setVariant(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public Wolf.SoundVariant getSoundVariant() {
        return CraftSoundVariant.minecraftHolderToBukkit(this.getHandle().getSoundVariant());
    }

    public void setSoundVariant(Wolf.SoundVariant soundVariant) {
        Preconditions.checkArgument((soundVariant != null ? 1 : 0) != 0, (Object)"soundVariant cannot be null");
        this.getHandle().setSoundVariant(CraftSoundVariant.bukkitToMinecraftHolder(soundVariant));
    }

    public static class CraftVariant
    extends HolderableBase<WolfVariant>
    implements Wolf.Variant {
        public static Wolf.Variant minecraftToBukkit(WolfVariant minecraft) {
            return (Wolf.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.WOLF_VARIANT);
        }

        public static Wolf.Variant minecraftHolderToBukkit(Holder<WolfVariant> minecraft) {
            return (Wolf.Variant)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.WOLF_VARIANT);
        }

        public static WolfVariant bukkitToMinecraft(Wolf.Variant bukkit) {
            return (WolfVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<WolfVariant> bukkitToMinecraftHolder(Wolf.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftVariant(Holder<WolfVariant> holder) {
            super(holder);
        }
    }

    public static class CraftSoundVariant
    extends HolderableBase<WolfSoundVariant>
    implements Wolf.SoundVariant {
        public static Wolf.SoundVariant minecraftToBukkit(WolfSoundVariant minecraft) {
            return (Wolf.SoundVariant)CraftRegistry.minecraftToBukkit(minecraft, Registries.WOLF_SOUND_VARIANT);
        }

        public static Wolf.SoundVariant minecraftHolderToBukkit(Holder<WolfSoundVariant> minecraft) {
            return (Wolf.SoundVariant)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.WOLF_SOUND_VARIANT);
        }

        public static WolfSoundVariant bukkitToMinecraft(Wolf.SoundVariant bukkit) {
            return (WolfSoundVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<WolfSoundVariant> bukkitToMinecraftHolder(Wolf.SoundVariant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftSoundVariant(Holder<WolfSoundVariant> holder) {
            super(holder);
        }
    }
}

