/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.profile;

import com.destroystokyo.paper.profile.ProfileProperty;
import com.destroystokyo.paper.profile.SharedPlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.profile.MutablePropertyMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.component.ResolvableProfile;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.configuration.ConfigSerializationUtil;
import org.bukkit.craftbukkit.profile.CraftPlayerTextures;
import org.bukkit.craftbukkit.profile.CraftProfileProperty;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@SerializableAs(value="PlayerProfile")
public final class CraftPlayerProfile
implements PlayerProfile,
SharedPlayerProfile,
com.destroystokyo.paper.profile.PlayerProfile {
    private final @Nullable UUID uniqueId;
    private final @Nullable String name;
    private final PropertyMap properties = new MutablePropertyMap();
    private final CraftPlayerTextures textures = new CraftPlayerTextures(this);

    public static GameProfile validateSkullProfile(GameProfile gameProfile) {
        boolean isValidSkullProfile = gameProfile.name() != null || gameProfile.properties().containsKey((Object)"textures");
        Preconditions.checkArgument((boolean)isValidSkullProfile, (Object)"The skull profile is missing a name or textures!");
        Preconditions.checkArgument((gameProfile.name().length() <= 16 ? 1 : 0) != 0, (Object)"The name of the profile is longer than 16 characters");
        Preconditions.checkArgument((boolean)StringUtil.isValidPlayerName(gameProfile.name()), (String)"The name of the profile contains invalid characters: %s", (Object)gameProfile.name());
        PropertyMap properties = gameProfile.properties();
        Preconditions.checkArgument((properties.size() <= 16 ? 1 : 0) != 0, (Object)"The profile contains more than 16 properties");
        for (Property property : properties.values()) {
            Preconditions.checkArgument((property.name().length() <= 64 ? 1 : 0) != 0, (Object)"The name of a property is longer than 64 characters");
            Preconditions.checkArgument((property.value().length() <= Short.MAX_VALUE ? 1 : 0) != 0, (Object)"The value of a property is longer than 32767 characters");
            Preconditions.checkArgument((property.signature() == null || property.signature().length() <= 1024 ? 1 : 0) != 0, (Object)"The signature of a property is longer than 1024 characters");
        }
        return gameProfile;
    }

    public static @Nullable Property getProperty(GameProfile profile, String propertyName) {
        return (Property)Iterables.getFirst((Iterable)profile.properties().get((Object)propertyName), null);
    }

    private CraftPlayerProfile(@Nullable UUID uniqueId, @Nullable String name, boolean applyPreconditions) {
        if (applyPreconditions) {
            Preconditions.checkArgument((uniqueId != null || !StringUtils.isBlank((CharSequence)name) ? 1 : 0) != 0, (Object)"uniqueId is null or name is blank");
        }
        Preconditions.checkArgument((name == null || name.length() <= 16 ? 1 : 0) != 0, (Object)"The name of the profile is longer than 16 characters");
        Preconditions.checkArgument((name == null || StringUtil.isValidPlayerName(name) ? 1 : 0) != 0, (String)"The name of the profile contains invalid characters: %s", (Object)name);
        this.uniqueId = uniqueId;
        this.name = name;
    }

    public CraftPlayerProfile(@Nullable UUID uniqueId, @Nullable String name) {
        this(uniqueId, name, true);
    }

    @ApiStatus.Internal
    public CraftPlayerProfile(ResolvableProfile resolvableProfile) {
        this(resolvableProfile.unpack().map(GameProfile::id, p -> p.id().orElse(null)), resolvableProfile.unpack().map(GameProfile::name, p -> p.name().orElse(null)), false);
        this.properties.putAll((Multimap)resolvableProfile.partialProfile().properties());
    }

    public CraftPlayerProfile(GameProfile gameProfile) {
        this(gameProfile.id(), gameProfile.name());
        this.properties.putAll((Multimap)gameProfile.properties());
    }

    private CraftPlayerProfile(CraftPlayerProfile other) {
        this(other.uniqueId, other.name);
        this.properties.putAll((Multimap)other.properties);
        this.textures.copyFrom(other.textures);
    }

    @Override
    public @Nullable UUID getUniqueId() {
        return Objects.equals(this.uniqueId, Util.NIL_UUID) ? null : this.uniqueId;
    }

    @Override
    public @Nullable String getName() {
        return StringUtils.isBlank((CharSequence)this.name) ? null : this.name;
    }

    @Override
    public @Nullable Property getProperty(String propertyName) {
        return (Property)Iterables.getFirst((Iterable)this.properties.get((Object)propertyName), null);
    }

    @Override
    public void setProperty(String propertyName, @Nullable Property property) {
        this.removeProperty(propertyName);
        if (property != null) {
            Preconditions.checkArgument((this.properties.size() < 16 ? 1 : 0) != 0, (Object)"The profile contains more than 16 properties");
            this.properties.put((Object)property.name(), (Object)property);
        }
    }

    @Override
    public boolean removeProperty(String propertyName) {
        return !this.properties.removeAll((Object)propertyName).isEmpty();
    }

    void rebuildDirtyProperties() {
        this.textures.rebuildPropertyIfDirty();
    }

    public CraftPlayerTextures getTextures() {
        return this.textures;
    }

    public void setTextures(@Nullable PlayerTextures textures) {
        if (textures == null) {
            this.textures.clear();
        } else {
            this.textures.copyFrom(textures);
        }
    }

    public boolean isComplete() {
        return this.getUniqueId() != null && this.getName() != null && !this.textures.isEmpty();
    }

    public CompletableFuture update() {
        return CompletableFuture.supplyAsync(this::getUpdatedProfile, Util.nonCriticalIoPool());
    }

    private CraftPlayerProfile getUpdatedProfile() {
        ProfileResult newProfile;
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        GameProfile profile = this.buildGameProfile();
        if (profile.id().equals(Util.NIL_UUID)) {
            profile = server.services().nameToIdCache().get(profile.name()).map(NameAndId::toUncompletedGameProfile).orElse(profile);
        }
        if (!profile.id().equals(Util.NIL_UUID) && (newProfile = server.services().sessionService().fetchProfile(profile.id(), true)) != null) {
            profile = newProfile.profile();
        }
        return new CraftPlayerProfile(profile);
    }

    @Override
    public ResolvableProfile buildResolvableProfile() {
        this.rebuildDirtyProperties();
        return this.properties.isEmpty() && this.name == null != (this.uniqueId == null) ? new ResolvableProfile.Dynamic(this.name == null ? Either.right(this.uniqueId) : Either.left(this.name), PlayerSkin.Patch.EMPTY) : ResolvableProfile.createResolved(this.buildGameProfile());
    }

    @Override
    public GameProfile buildGameProfile() {
        this.rebuildDirtyProperties();
        return new GameProfile(this.uniqueId != null ? this.uniqueId : Util.NIL_UUID, this.name != null ? this.name : "", new PropertyMap((Multimap)this.properties));
    }

    public String toString() {
        this.rebuildDirtyProperties();
        StringBuilder builder = new StringBuilder();
        builder.append("CraftPlayerProfile [uniqueId=");
        builder.append(this.getUniqueId());
        builder.append(", name=");
        builder.append(this.getName());
        builder.append(", properties=");
        builder.append(CraftPlayerProfile.toString(this.properties));
        builder.append("]");
        return builder.toString();
    }

    public static String toString(PropertyMap propertyMap) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        propertyMap.asMap().forEach((propertyName, properties) -> {
            builder.append((String)propertyName);
            builder.append("=");
            builder.append(properties.stream().map(CraftProfileProperty::toString).collect(Collectors.joining(",", "[", "]")));
        });
        builder.append("}");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CraftPlayerProfile)) {
            return false;
        }
        CraftPlayerProfile other = (CraftPlayerProfile)obj;
        if (!Objects.equals(this.uniqueId, other.uniqueId)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        this.rebuildDirtyProperties();
        other.rebuildDirtyProperties();
        return CraftPlayerProfile.equals(this.properties, other.properties);
    }

    private static boolean equals(PropertyMap propertyMap, PropertyMap other) {
        if (propertyMap.size() != other.size()) {
            return false;
        }
        Iterator iterator1 = propertyMap.values().iterator();
        Iterator iterator2 = other.values().iterator();
        while (iterator1.hasNext()) {
            Property property2;
            if (!iterator2.hasNext()) {
                return false;
            }
            Property property1 = (Property)iterator1.next();
            if (CraftProfileProperty.equals(property1, property2 = (Property)iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public int hashCode() {
        this.rebuildDirtyProperties();
        int result = 1;
        result = 31 * result + Objects.hashCode(this.uniqueId);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + CraftPlayerProfile.hashCode(this.properties);
        return result;
    }

    private static int hashCode(PropertyMap propertyMap) {
        int result = 1;
        for (Property property : propertyMap.values()) {
            result = 31 * result + CraftProfileProperty.hashCode(property);
        }
        return result;
    }

    public CraftPlayerProfile clone() {
        return new CraftPlayerProfile(this);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.uniqueId != null) {
            map.put("uniqueId", this.uniqueId.toString());
        }
        if (this.name != null) {
            map.put("name", this.getName());
        }
        this.rebuildDirtyProperties();
        if (!this.properties.isEmpty()) {
            ArrayList propertiesData = new ArrayList();
            this.properties.forEach((propertyName, property) -> propertiesData.add(CraftProfileProperty.serialize(property)));
            map.put("properties", propertiesData);
        }
        return map;
    }

    public static CraftPlayerProfile deserialize(Map<String, Object> map) {
        UUID uniqueId = ConfigSerializationUtil.getUuid(map, "uniqueId", true);
        String name = ConfigSerializationUtil.getString(map, "name", true);
        CraftPlayerProfile profile = new CraftPlayerProfile(uniqueId, name);
        if (map.containsKey("properties")) {
            for (Object propertyData : (List)map.get("properties")) {
                Preconditions.checkArgument((boolean)(propertyData instanceof Map), (String)"Property data (%s) is not a valid Map", propertyData);
                Property property = CraftProfileProperty.deserialize((Map)propertyData);
                profile.properties.put((Object)property.name(), (Object)property);
            }
        }
        return profile;
    }

    public String setName(String name) {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }

    public UUID getId() {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }

    public UUID setId(UUID uuid) {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }

    public Set<ProfileProperty> getProperties() {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }

    public boolean hasProperty(String property) {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }

    public void setProperty(ProfileProperty property) {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }

    public void setProperties(Collection<ProfileProperty> properties) {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }

    public void clearProperties() {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }

    public boolean completeFromCache() {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }

    public boolean completeFromCache(boolean onlineMode) {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }

    public boolean completeFromCache(boolean lookupUUID, boolean onlineMode) {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }

    public boolean complete(boolean textures) {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }

    public boolean complete(boolean textures, boolean onlineMode) {
        throw new UnsupportedOperationException("Do not cast to com.destroystokyo.paper.profile.PlayerProfile");
    }
}

